<?php 

/* Search Form Shortcode
 *-------------------------------------- */
 
function wi_search_func( $atts ){
	return '<form role="search" method="get" class="wi-search-form" action="'.home_url( "/" ).'">
			<input type="search" class="wi-search-field" placeholder="'. esc_attr_x( '', "placeholder", 'b-i-g' ) .'" value="'. get_search_query() .'" name="s" title="'. esc_attr_x( 'Search for:', 'label', 'b-i-g' ) .'" />   
            <input type="submit" class="wi-search-submit" value=""/>
		    <i class="fa fa-search wi-search-magnif"></i>
		  </form>'
		  ;
}
add_shortcode( 'wi_search', 'wi_search_func' );
 
/* VC Shortcodes
 *-------------------------------------- */ 
	 		 		 		 		 		 	
global $wi_options;

/**
 * Turn off display posts shortcode 
 * If display full post content, any uses of [display-posts] are disabled
 *
 * @param array $out, returned shortcode values 
 * @param array $pairs, list of supported attributes and their defaults 
 * @param array $atts, original shortcode attributes 
 * @return array $out
 */
function be_display_posts_off( $out, $pairs, $atts ) {
	$out['display_posts_off'] = true;
	return $out;
}

/**
 * Convert string to boolean
 * because (bool) "false" == true
 *
 */
function be_display_posts_bool( $value ) {
	return !empty( $value ) && 'true' == $value ? true : false;
}


/************************************************************************************************************************************************************/
/************************************************************************************************************************************************************/
/************************************************************************************************************************************************************/
/************************************************************************************************************************************************************/
/************************************************************************************************************************************************************/

function vc_team_member_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'image'=> get_template_directory_uri().'/assets/img/no_image.png',
	'name'=> 'Jhon Doe',
	'position'=>'Position In Company',
	'welcome'=>'',
	'fb_url'=>'',
	'tw_url'=>'',
	'bg'=> '#f9f9f9',
	'bg2'=> '#212121',
	'gplus_url'=>'',
	'in_url'=>'',
	'mail_url'=>'',
	), $atts));
	
	 if ($fb_url == ''){$fb ='';} else { $fb = '<a class="" target="_blank" href="'.$fb_url.'"><i class="fa fa-facebook"></i></a>';};
	 if ($tw_url == ''){$tw ='';} else { $tw = '<a class="" target="_blank" href="'.$tw_url.'"><i class="fa fa-twitter"></i></a>';};
	 if ($gplus_url == ''){$gplus ='';} else { $gplus = '<a target="_blank" class="" href="'.$gplus_url.'"><i class="fa fa-google-plus"></i></a>';};
	 if ($in_url == ''){$in ='';} else { $in = '<a class="" target="_blank" href="'.$in_url.'"><i class="fa fa-linkedin"></i></a>';};
	 if ($mail_url == ''){$mail ='';} else { $mail = '<a class="" href="mailto:'.$mail_url.'"><i class="fa fa-envelope"></i></a>';};
	 
 	 if ($welcome == ''){$welcome1 ='';} else { $welcome1 = '<h4><span>'.$welcome.'</span></h4>';};

	 $ulrs = ''.$fb.''.$tw.''.$gplus.''.$in.''.$mail.'';
  	 if (($welcome == '')&& ($ulrs == '')){$main_cont ='';} else { $main_cont = '
	 <div class="wi_mask_holder">
		<div class="wi_mask">
			'.$welcome1.'
			<div class="wi_icons">'.$ulrs.'</div>
		</div>
	</div>';};

	
	 $image_done = wp_get_attachment_image($image,'full vc_team_member_image');
	 
	 
	 $code = '<div class="vc_team_member_holder">
	 			<div class="vc_team_member_image_holder">
					<div class="inner_img_holder">
						'.$image_done.'
					</div>
					'.$main_cont.'
				</div>
				<div class="clearfix"></div>
				<div class="wi_cont_holder" style="background:'.$bg.'">
					<h4 style="color:'.$bg2.'">'.$name.'</h4>
					<h5>'.$position.'</h5>
					<div class="wi_team_cont">'.$content.'</div>
			 	</div>
			 </div>';

	return $code;
}
add_shortcode('vc_team_member', 'vc_team_member_f');


function vc_wi_gallery_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'images'=> array(''),
	), $atts));
	
	 $attachments = explode(',', $images);
	 $code = '<div class="port_slider">
				<ul class="slides">';
	 	 foreach ( $attachments as $attachment_id ) {
			$src = wp_get_attachment_image_src( $attachment_id,'full' );;
			$code .= '<li><img src="'.$src[0].'"></li>';
		}
		
	$code .= '</ul></div>';
	return $code;
}
add_shortcode('vc_wi_gallery', 'vc_wi_gallery_f');


function vc_wi_imac_demo_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'images'            => array(''),
	'link_to_the_demo'  => '',
	'title_after_image' => 'Title of the Demo',
	), $atts));
	
	$attachments = shortcode_atts(array( 
            'image_url' => 'image_url',
        ), $atts);
	$imac = get_template_directory_uri();
	$imac = $imac . '/framework/css/img/iMac-demo.png';
    $img = wp_get_attachment_image_src($attachments['image_url'], 'full');
    $imgSrc = $img[0];
		$code = '
		<div class="wi-imac-demo">
			<div class="wi-imac-demo-wrapper">
			<div class="wi-imac-demo-screen" style="background-image: url(' . $imgSrc . ');"></div>
			<div class="wi-imac-demo-desctop"><a href="' . $link_to_the_demo . '" target="_blank"><img src="' . $imac . '"></a>
		</div>
		</div>
		<h3><a href="' . $link_to_the_demo . '" target="_blank">' . $title_after_image . '</a></h3>
		</div>
		';
	return $code;
}
add_shortcode('vc_wi_imac_demo', 'vc_wi_imac_demo_f');


function vc_price_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'price_spec'=> '0',
	'price_new'=> '0',
	'price_new_title'=> 'NEW',
	'price_title'=> 'Business Plan',
	'price_amount'=> '10',
	'price_cur'=>'$',
	'price_date'=>'per month',
	'price_head_bg'=>'#3f3f3f',
	'price_title_color'=>'#ffffff',
	'text_on_button'=>'Order Now',
	'url_on_button'=>'#',
	), $atts));
	
	if ($price_spec == '1'){ $spec = 'spec';} else{ $spec = '';};
	if ($price_new == '1'){ $price_new_c = '<div class="wi-ribbon-wrapper"><div class="wi-ribbon">'.$price_new_title.'</div></div>';}
	 
	 $code = 
	 '<div class="wi_price_holder '.$spec.'">'.$price_new_c.'
			<div class="wi_price_head_holder" style="background-color:'.$price_head_bg.'">
			<div class="wi_price_head">
				<h3 style="color:'.$price_title_color.' !important">'.$price_title.'</h3>
			</div>
			<div class="wi_price_price">
				<h1 class="page-title" style="color:'.$price_title_color.' !important">'.$price_amount.'<span>'.$price_cur.'</span></h1>
				<h4 style="color:'.$price_title_color.' !important">'.$price_date.'</h4>
			</div>
		</div>
		<div class="unstyled wi_price_ul">
		'.do_shortcode($content).'
		</div>
		<div class="wi_price_order">
			<a class="btn wi_submit wi_reverse_btn" href="'.$url_on_button.'">'.$text_on_button.'</a>
		</div>
	 </div>
	 ';

	return $code;
}
add_shortcode('vc_price', 'vc_price_f');

function vc_box_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'icon_bg' => '#ffd824',
	'bg' => '#f6f6f6',
	'color' => '',
	'icon' => 'http://wwwebinvader.com/!share/share/01-icons/bubble.png',
	'border' => '#ededed',
	'title'=> 'The Box Title',
	), $atts));
	
	
	
	 $code = '<div class="wi_box" style=" background:'.$bg.'; border:1px solid '.$border.'; color:'.$color.' !important;"><div class="icon_holder" style="background:'.$icon_bg.'; "><img class="wi_box_icon" src="'.$icon.'" alt=""></div><h3 clas="small_width" style="color:'.$color.' !important;">'.$title.'</h3>'.do_shortcode($content).'</div>';

	return $code;
}
add_shortcode('vc_box', 'vc_box_f');



function vc_box_ii_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'icon_bg' => '#ffd824',
	'bg' => '#ffffff',
	'color' => '',
	'icon' => 'http://wwwebinvader.com/!share/share/01-icons/bubble.png',
	'border' => '#ededed',
	'title'=> 'The Box Title',
	), $atts));
	
	
	
	 $code = '<div class="wi_box_ii" style=" background:'.$bg.'; border:1px solid '.$border.'; color:'.$color.' !important;"><div class="icon_holder_ii" style="background:'.$icon_bg.'; "><img class="wi_box_icon" src="'.$icon.'" alt=""></div><h3 clas="small_width" style="color:'.$color.' !important;">'.$title.'</h3>'.do_shortcode($content).'</div>';

	return $code;
}
add_shortcode('vc_box_ii', 'vc_box_ii_f');



function vc_box_iii_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'title'=> 'The Box Title',
	'icon' => 'fa-diamond',
	), $atts));
	
	 $code = '<div class="wi_box_iii">
				<div class="icon_area_iii">					
					<i class="fa '.$icon.'"></i>
				</div>
	 			<div class="icon_holder_iii">
					<h3>'.$title.'</h3>
					<div class="clearfix"></div>
					'.do_shortcode($content).'
				</div>
			 </div>';

	return $code;
}
add_shortcode('vc_box_iii', 'vc_box_iii_f');


function vc_box_iv_f($atts, $content = null) {
	extract(shortcode_atts( array(	
	'title'=> 'The Box Title',
	'iconcolor'=> '#fff',
	'bgcolor'=> '#212121',
	'icon' => 'fa-diamond',
	'titlecolor' => '#212121',
	'titlelink' => 'html://wwww.yoursite.com'
	), $atts));
	
	
	
	 $code = '<div class="wi_box_iv">
				<a href="'.$titlelink.'"><div class="icon_holder_iv" style="background:'.$bgcolor.'">
					<span class="wi_box_icon_iv colored fa '.$icon.'" style="color:'.$iconcolor.'"></span>
				</div></a>
				<div class="cont_holder_iv"><a href="'.$titlelink.'"><h4 style="color:'.$titlecolor.'">'.$title.'</h4></a>'.do_shortcode($content).'</div>
			 </div>
			 <div class="clearfix"></div>';

	return $code;
}
add_shortcode('vc_box_iv', 'vc_box_iv_f');


function vc_box_v_f($atts, $content = null) {
	extract(shortcode_atts( array(
	'icon' => 'fa-diamond',
	'icon_bg' => '#ffffff',
	'bg' => '#fcfcfc',
	'color' => '#212121',
	'border' => '#ededed',
	'title'=> 'The Box Title',
	), $atts));
	
	
	
	 $code = '<div class="wi_box_v" style="color:'.$color.' !important;"><div class="wi_box_v_bg" style="background:'.$bg.'; border:1px solid '.$border.'; "></div><div class="icon_holder_v" style="border:3px solid '.$border.';"><i class="fa '.$icon.'"></i><div class="icon_holder_v_bg" style="background:'.$icon_bg.';"></div></div><h3 clas="small_width" style="color:'.$color.' !important;">'.$title.'</h3>'.do_shortcode($content).'</div>';

	return $code;
}
add_shortcode('vc_box_v', 'vc_box_v_f');

add_shortcode('testimonials', 'theme_testimonials');
function theme_testimonials( $atts, $content = null) {
	extract(shortcode_atts(
        array(
			'count' => '1',
    ), $atts));	
	$output ='';
	if($content) { $output .= '<p>'.theme_remove_autop(stripslashes($content)).'</p>'."\n"; }
	$output .= '<ul class="testimonilal_ul">'.theme_testimonials_loop($count, $header, $cat).'</ul>';
	return $output;
}

function theme_testimonials_loop($count, $header, $cat)
{

	$query =  new WP_Query(array('category_name' => $cat, 'post_type' => 'testimonials', 'showposts' => $count, 'order' => 'DESC'));
	$loop_count = 0;
	ob_start();	
	while ($query->have_posts()) { $query->the_post();
			
		$post_id = get_the_id();
		$default_url= get_template_directory_uri();
		$format = get_post_format();
		echo '<li  ';
		post_class('');
		echo ' id="post-'.$post_id.'">'."\n";
		echo ' <div>'."\n";
        echo '<div class="">'."\n";
		get_template_part('framework/post-format/format-testimonials',$format);
		echo '</div>'."\n";
        echo '</div>'."\n";
		echo '</li>'."\n";
	}
	wp_reset_postdata();
	return ob_get_clean();
}




?>