<?php 

/* ------------------------------------------------------------------------ */
/* Notices Post Type.  */
/* ------------------------------------------------------------------------ */

//Create Post Formats
add_action( 'init', 'wi_testimonials' );
function wi_testimonials() {
	register_post_type( 'testimonials',
		array(
			'labels' => array(
				'name' => esc_html__( 'Testimonials', 'b-i-g' ),
				'singular_name' => esc_html__( 'Testimonials', 'b-i-g' ),
				'new_item' => esc_html__( 'Add New testimonial', 'b-i-g' ),
				'add_new_item' => esc_html__( 'Add New testimonial', 'b-i-g' )
			),
			'public' => true,
			'has_archive' => false,
			'supports' => array( 'comments', 'editor', 'excerpt', 'thumbnail', 'title' ),
			'capability_type' => 'post',
			'show_ui' => true,
			'publicly_queryable' => true,
			'rewrite' => array('slug' => 'testimonials'),
		)
	);
}
/* ------------------------------------------------------------------------ */
/* Portfolio Post Type.  */
/* ------------------------------------------------------------------------ */

//Create Post Formats
add_action( 'init', 'wi_portfolio' );
function wi_portfolio() {
	register_post_type( 'portfolio',
		array(
			'labels' => array(
				'name' => esc_html__( 'Portfolio', 'b-i-g' ),
				'singular_name' => esc_html__( 'Portfolio', 'b-i-g' ),
				'new_item' => esc_html__( 'Add New portfolio', 'b-i-g' ),
				'add_new_item' => esc_html__( 'Add New portfolio', 'b-i-g' )
			),
			'public' => true,
			'has_archive' => false,
			'supports' => array( 'comments', 'editor', 'excerpt', 'thumbnail', 'title' ),
			'capability_type' => 'post',
			'show_ui' => true,
			'publicly_queryable' => true,
			'rewrite' => array('slug' => 'portfolio'),
		)
	);
}


function wi_portfolio_taxonomies() {


	// Portfolio Categories	
	
	$labels = array(
		'add_new_item' => 'Add New Category',
		'all_items' => 'All Categories' ,
		'edit_item' => 'Edit Category' , 
		'name' => 'Portfolio Categories', 'taxonomy general name' ,
		'new_item_name' => 'New Genre Category' ,
		'menu_name' => 'Categories' ,
		'parent_item' => 'Parent Category' ,
		'parent_item_colon' => 'Parent Category:',
		'singular_name' => 'Portfolio Category', 'taxonomy singular name' ,
		'search_items' =>  'Search Categories' ,
		'update_item' => 'Update Category' ,
	);
	register_taxonomy( 'portfolio-category', array( 'portfolio' ), array(
		'hierarchical' => true,
		'labels' => $labels,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'portfolio/category' ),
		'show_ui' => true,
	));
	
	
	// Portfolio Tags	
	
	$labels = array(
		'add_new_item' => 'Add New Tag' ,
		'all_items' => 'All Tags' ,
		'edit_item' => 'Edit Tag' , 
		'menu_name' => 'Portfolio Tags' ,
		'name' => 'Portfolio Tags', 'taxonomy general name' ,
		'new_item_name' => 'New Genre Tag' ,
		'parent_item' => 'Parent Tag' ,
		'parent_item_colon' => 'Parent Tag:' ,
		'singular_name' =>  'Portfolio Tag', 'taxonomy singular name' ,
		'search_items' =>   'Search Tags' ,
		'update_item' => 'Update Tag' ,
	);
	register_taxonomy( 'portfolio-tags', array( 'portfolio' ), array(
		'hierarchical' => true,
		'labels' => $labels,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'portfolio/tag' ),
		'show_ui' => true,
	));
	
		
}

add_action( 'init', 'wi_portfolio_taxonomies', 0 );

/* ------------------------------------------------------------------------ */
/* Extension for Redux  */
/* ------------------------------------------------------------------------ */

// Load Redux extensions - MUST be loaded before your options are set
if (file_exists(dirname(__FILE__).'/resources/extensions/extensions-init.php')) {
   // require_once( dirname(__FILE__).'/resources/extensions/extensions-init.php' );
} 