<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

	<!-- Page title bar start //-->
<?php $theme_option=sonex_global(); ?>
    <section class="page-title-bar" <?php if($theme_option['bcimage']['url']!=''){ ?> style="background-image: url('<?php echo esc_url($theme_option['bcimage']['url']); ?>');"
<?php } else { ?> style="background-image: url('<?php echo get_template_directory_uri()?>/images/breadbg.jpg');"<?php } ?>>

		<div class="container">

			<div class="row">

				<div class="col-md-12">
					<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

						<h2><?php woocommerce_page_title(); ?></h2>

					<?php endif; ?>	

					<?php if ($theme_option['breadcrumbs_opt'] != '0') { ?>
			            <?php 
							/**		 
							 *		 
							 * @hooked woocommerce_breadcrumb - 20
							 */
							do_action( 'breadcrumb_before_main_content' );		
						?>
			        <?php }else{} ?>					
				</div>

			</div>
		
		</div>

	</section>

	<!-- Page title bar end //-->	

	<?php
		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>
		<div class="col-md-8">		
			<div class="row">
			<?php if ( have_posts() ) : ?>	
				<div class="col-md-12">

					<?php do_action( 'woocommerce_archive_description' ); ?>

					<div class="sorting margin-bottom-40">

						<?php
							/**
							 * woocommerce_before_shop_loop hook
							 *
							 * @hooked woocommerce_result_count - 20
							 * @hooked woocommerce_catalog_ordering - 30
							 */
							do_action( 'woocommerce_before_shop_loop' );
						?>

					</div>

				</div>

			</div>				

				<?php woocommerce_product_loop_start(); ?>

					<?php woocommerce_product_subcategories(); ?>

					<?php while ( have_posts() ) : the_post(); ?>

						<?php wc_get_template_part( 'content', 'product' ); ?>

					<?php endwhile; // end of the loop. ?>

				<?php woocommerce_product_loop_end(); ?>

				<?php
					/**
					 * woocommerce_after_shop_loop hook
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action( 'woocommerce_after_shop_loop' );
				?>

			<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

				<?php wc_get_template( 'loop/no-products-found.php' ); ?>

			<?php endif; ?>
		</div>

		<div class="col-md-4">
			<?php
				/**
				 * woocommerce_sidebar hook
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>
		</div>

	<?php
		/**
		 * woocommerce_after_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>    

<?php get_footer( 'shop' ); ?>
