<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<?php 
$theme_option=sonex_global();
 ?>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">	
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">	
	<!-- Favicons -->
	<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
	<link rel="icon" href="<?php echo esc_url($theme_option['favicon']['url']); ?>" type="image/x-icon">	
	<?php } ?>
    <?php wp_head();?>	
</head>
<body <?php body_class(); ?>> 

	<?php if ($theme_option['preload_opt'] != '0') { ?>
	<div class="images-preloader" id="images-preloader">

<div id="loader-wrapper">
    <div id="loader"></div>
 
    <div class="loader-section section-left"></div>
    <div class="loader-section section-right"></div>
 
</div>
</div>
	<?php } ?>


	<div id="wrap-all">

	<?php 
    if(isset($theme_option['header_layout']) and $theme_option['header_layout']=="header4" ){
			get_template_part('framework/headers/header4');
		}
		else{  
	?>	

	<!-- Site header start //-->
	<?php 
	if ( is_404() ) { ?>
		<header class="site-header site-header-1" id="site-header">
	<?php }
	else {
	if (( get_post_meta($post->ID,'_cmb_header_style',false))=='value1') { ?>
	<header class="transparent-header site-header site-header-1 head-corporate" id="site-header">
	<?php } 
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value2') { ?>
	<header class="transparent-header site-header site-header-1 head-creative" id="site-header">
	<?php }
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value3') { ?>
	<header class="transparent-header site-header site-header-1 head-construction" id="site-header">
	<?php }  
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value4') { ?>
	<header class="transparent-header site-header site-header-1 head-ecommerce" id="site-header">
	<?php } 
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value5') { ?>
	<header class="transparent-header site-header site-header-1 head-medical" id="site-header">
	<?php }   
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value6') { ?>
	<header class="transparent-header site-header site-header-1 head-agency" id="site-header">
	<?php }  
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value7') { ?>
	<header class="transparent-header site-header site-header-1 head-classic" id="site-header">
	<?php }  
	elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='value8') { ?>
	<header class="transparent-header site-header site-header-1 head-cheesecake" id="site-header">
	<?php }  
    elseif (( get_post_meta($post->ID,'_cmb_header_style',true))=='hide') { ?>
	<header class="transparent-header site-header site-header-1 hidden-header" id="site-header">
    <?php } 
    
    else { ?>
	<header class="transparent-header site-header site-header-1 head-corporate" id="site-header">
    <?php } }?>


		<!-- Top bar start //-->

		<section class="bar-sub">
			<div class="container">

				<div class="row">

					<div class="col-lg-12">

						<div>

							<!-- Links //-->

							<?php $topmenu = array(
									'theme_location'  => 'top',
									'menu'            => 'sub bar menu',
									'container'       => '',
									'container_class' => '',
									'container_id'    => '',
									'menu_class'      => 'links',
									'menu_id'         => '',
									'echo'            => true,
									'fallback_cb'     => 'wp_page_menu',
									'before'          => '',
									'after'           => '',
									'link_before'     => '',
									'link_after'      => '',
									'items_wrap'      => '<ul>%3$s</ul>',
									'depth'           => 0,
									'walker'          => ''
								);
								if ( has_nav_menu( 'top' ) ) {
									wp_nav_menu( $topmenu );
								}
							?>

							<!-- Social media //-->

							<p class="sm-buttons">
								<?php if($theme_option['facebook']!=''){ ?>
								<a target="_blank" href="<?php echo esc_url($theme_option['facebook']); ?>"><i class="fa fa-facebook"></i></a>
								<?php } ?>
								<?php if($theme_option['google']!=''){ ?>
								<a target="_blank" href="<?php echo esc_url($theme_option['google']); ?>"><i class="fa fa-google-plus"></i></a>
								<?php } ?>
								<?php if($theme_option['twitter']!=''){ ?>
								<a target="_blank" href="<?php echo esc_url($theme_option['twitter']); ?>"><i class="fa fa-twitter"></i></a>
								<?php } ?>
								<?php if($theme_option['youtube']!=''){ ?>
								<a target="_blank" href="<?php echo esc_url($theme_option['youtube']); ?>"><i class="fa fa-youtube"></i></a>
								<?php } ?>
								<?php if($theme_option['linkedin']!=''){ ?>
								<a target="_blank" href="<?php echo esc_url($theme_option['linkedin']); ?>"><i class="fa fa-linkedin"></i></a>
								<?php } ?>
							</p>

							<div class="cl d-hide"></div>

							<!-- Contacts //-->
							<div class="hidden-xs hidden-sm">
							<?php if($theme_option['top_info_address']) { ?><p class="contacts"><span><i class="fa fa-globe"></i></span> <?php echo esc_attr($theme_option['top_info_address']); ?></p><?php } ?>
							<?php if($theme_option['top_info_email']) { ?><p class="contacts"><span><i class="fa fa-envelope"></i></span> <?php echo esc_attr($theme_option['top_info_email']); ?></p><?php } ?>
							<?php if($theme_option['top_info_phone']) { ?><p class="contacts"><span><i class="fa fa-phone"></i></span> <?php echo esc_attr($theme_option['top_info_phone']); ?></p><?php } ?>
                            </div>
						</div>

					</div>

				</div>

			</div>

		</section>

		<section class="bar-main" id="stick-this">

			<div class="container">

				<div class="row">
					
					<div class="col-lg-12">

						<div class="relative">

							<!-- Site logo //-->
                            
                            <style type="text/css">
                                <?php if( is_page(4092) ) { ?>
                                .site-logo a { background: url(<?php echo get_stylesheet_directory_uri(); ?>/images/page-4092-logo2.png) no-repeat; }
                                <?php } elseif( is_page(4325) ) { ?>
                                .site-logo a { background: url(<?php echo get_stylesheet_directory_uri(); ?>/images/page-4325-logo3.png) no-repeat; }
                                <?php } ?>
                            </style>
                            
							<div class="site-logo">
								<p class="logo-text">
									<a href="<?php echo esc_url ( home_url("/") ); ?>">
										<?php if($theme_option['logo']['url']!=''){ ?>
										<img src="<?php echo esc_url($theme_option['logo']['url']); ?>" alt="logo"> 
										<?php }  elseif ($theme_option['site_name']!=''){
										echo esc_attr($theme_option['site_name']); 
										} 
										else {
											$blog_title = get_bloginfo( 'name' );
											printf (esc_html__('%s', 'sonex' ),  $blog_title);
										}
										?>
                                        
									</a>
							    </p>
								<div class="clear"></div>
								<?php if($theme_option['tagline']!=''){ ?>
								<p class="description"><?php echo esc_attr($theme_option['tagline']); ?>
								</p>
								<?php } else { ?>
                                <p class="description">
								 <?php printf (esc_html__('%s', 'sonex' ), get_bloginfo ( 'description' ) ); ?>
							    </p>
							    <?php } ?>
							</div>

							<!-- Mobile menu button //-->

                            <div class="sonex-header-m">
	                        <div class="sonex-menu-m">
		                        <a class="m-trigger"><span></span></a>
		                        <?php
			                    wp_nav_menu(
										array(
											'theme_location'  => 'primary',
											'container'       => 'nav',
											'container_class' => 'menu-mobile-wrap',
											'menu_id'         => 'menu-mobile',
											'fallback_cb'     => 'wp_page_menu',
											'before'          => '<a href="#" class="menu-back">Back</a>',
											'after'           => '<span class="sub-open"><i class="fa fa-angle-right"></i></span>',
											'walker'          => new sonexCoreFrontendWalker()
										)
										);
									?>
								</div>
								</div>


							<?php if ($theme_option['search_opt'] != '0') { ?>                 
							<!-- Search //-->
							<div class="search">
								<i class="fa fa-search" id="header-search-btn"></i>
                            <?php get_search_form(); ?>
							</div>
							 <?php }else{} ?> 

							<!-- Shopping cart //-->
							<?php if (class_exists('Woocommerce')) { ?>
							<div class="shopping-cart">													
								<?php global $woocommerce; ?>					
								<a href="<?php echo WC()->cart->get_cart_url(); ?>"><i class="fa fa-shopping-cart" id="header-cart-btn"></i></a>
								<span class="noof-items"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'sonex'), $woocommerce->cart->cart_contents_count);?></span>																
							</div>
							<?php } ?> 


							<nav role="navigation" id="header-navigation" class="sonex-header">
								<?php $primarymenu = array(
										'theme_location'  => 'primary',
										'menu'            => '',
										'container'       => '',
										'container_class' => '',
										'container_id'    => '',
										'menu_class'      => ' sonex-menu ',
										'menu_id'         => 'menu-main',
										'echo'            => true,
										'fallback_cb'     => 'wp_page_menu',
										'before'          => '',
										'after'           => '',
										'link_before'     => '',
										'link_after'      => '',
										'items_wrap'      => '<ul id="menu-main" class="h-element sonex-menu">%3$s</ul>',
										'depth'           => 0,
										'walker'          => new sonexCoreFrontendWalker()
									);
									if ( has_nav_menu( 'primary' ) ) {
										wp_nav_menu( $primarymenu );
									}
								?>

							</nav>
						

					</div>

				</div>

			</div>
			</div>

		</section>

	</header>

	<?php } ?>			
	<main class="site-content" id="content">
	  