<?php 

// Creating the widget 

class sonexcontact_info_widget extends WP_Widget {



function __construct() {

parent::__construct(

// Base ID of your widget

'sonexcontact_info_widget', 



// Widget name will appear in UI

__('sonex Contact Info', 'sonex'), 



// Widget description

array( 'description' => esc_html__( 'sonex Contact Info Widget', 'sonex' ), ) 

);

}



// Creating widget front-end

// This is where the action happens

public function widget( $args, $instance ) {

	// these are the widget options

	 $title = apply_filters( 'widget_title', $instance['title'] );

     $email = esc_attr($instance['email']);

	 $phone = esc_attr($instance['phone']);

     $address = esc_textarea($instance['address']);

	 $content = esc_textarea($instance['content']);

$theme_option=sonex_global();


	 



// before and after widget arguments are defined by themes

echo htmlspecialchars_decode( $args['before_widget'] );
if ( ! empty( $title ) ){
echo htmlspecialchars_decode( $args['before_title'] ) .esc_attr( $title ). htmlspecialchars_decode( $args['after_title'] );
}else{
	echo "<div>";
}
?>
        <p><img src="<?php echo esc_url($theme_option['footlogo']['url']); ?>" alt="footer-logo" width="150"></p>
        <?php 
        if( $content ) {

	      echo '<p class="contacts-content">'.esc_attr( $content ).'</p>';

	   }

		// Check if email is set

	   if( $email ) {

	      echo '<p class="contacts"><i class="fa fa-envelope"></i><a href="mailto:'.esc_attr($email).'">'.esc_attr($email).'</a></p>';

	   }

	   // Check if phone number is set

	   if( $phone ) {

	      echo '<p class="contacts"><i class="fa fa-phone"></i>'.esc_attr($phone).'</p>';

	   }



		// Check if address is set

	   if( $address ) {

	     echo '<p class="contacts"><i class="fa fa-map-marker"></i>'.esc_attr($address).'</p>';

	   }

	?>

	



<?php 



echo htmlspecialchars_decode( $args['after_widget'] );

}

		

// Widget Backend 

public function form( $instance ) {

// Check values

if(isset( $instance[ 'title' ] ) || isset ($instance['content']) || isset($instance['style']) || isset( $instance[ 'email' ] ) || isset( $instance[ 'phone' ] ) || isset( $instance[ 'fax' ] ) || isset( $instance[ 'address' ] ) || isset( $instance[ 'facebook' ] ) || isset( $instance[ 'gplus' ] ) || isset( $instance[ 'twitter' ] ) || isset( $instance[ 'youtube' ] ) || isset( $instance[ 'linkedin' ] ) || isset( $instance[ 'dribbble' ] ) || isset( $instance[ 'skype' ] )) {

     $title = esc_attr($instance['title']);

     $email = esc_attr($instance['email']);

	 $phone = esc_attr($instance['phone']);

	 $fax = esc_attr($instance['fax']);

     $address = esc_textarea($instance['address']);

	 $content = esc_attr($instance['content']);

} else {

     $title = esc_html__( 'About Sonex', 'sonex' );

     $email = '';

	 $phone = '';

	 $fax = '';

     $address = '';

	 $content = '';




}

// Widget admin form

?>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'sonex' ); ?></label> 

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('content') ); ?>"><?php esc_html_e('Content:', 'sonex'); ?></label>

<textarea class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('content') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('content') ); ?>"><?php echo esc_attr( $content ); ?></textarea>

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('email') ); ?>"><?php esc_html_e('Email', 'sonex'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('email') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('email') ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('phone') ); ?>"><?php esc_html_e('Phone Number:', 'sonex'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('phone') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('phone') ); ?>" type="text" value="<?php echo esc_attr( $phone ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('fax') ); ?>"><?php esc_html_e('Fax Number:', 'sonex'); ?></label>

<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('fax') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('fax') ); ?>" type="text" value="<?php echo esc_attr( $fax ); ?>" />

</p>

<p>

<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('address') ); ?>"><?php esc_html_e('Address:', 'sonex'); ?></label>

<textarea class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('address') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('address') ); ?>"><?php echo esc_attr( $address ); ?></textarea>

</p>

<?php 

}

	

// Updating widget replacing old instances with new

public function update( $new_instance, $old_instance ) {

$instance = array();

$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

$instance['content'] = ( ! empty( $new_instance['content'] ) ) ? strip_tags( $new_instance['content'] ) : '';

$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';

$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';

$instance['fax'] = ( ! empty( $new_instance['fax'] ) ) ? strip_tags( $new_instance['fax'] ) : '';

$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';

$instance['style'] = $new_instance['style'];

$instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';

$instance['gplus'] = ( ! empty( $new_instance['gplus'] ) ) ? strip_tags( $new_instance['gplus'] ) : '';

$instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';

$instance['youtube'] = ( ! empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : '';

$instance['linkedin'] = ( ! empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : '';

$instance['dribbble'] = ( ! empty( $new_instance['dribbble'] ) ) ? strip_tags( $new_instance['dribbble'] ) : '';

$instance['skype'] = ( ! empty( $new_instance['skype'] ) ) ? strip_tags( $new_instance['skype'] ) : '';

return $instance;

}

} // Class wpb_widget ends here



// Register and load the widget

function wpb_load_widget() {

	register_widget( 'sonexcontact_info_widget' );

}

add_action( 'widgets_init', 'wpb_load_widget' );

