<?php
/**
 * Categories widget class
 *
 * @since 2.8.0
 */
class sonex_Widget_Categories extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_categories', 'description' => esc_html__( "A list or dropdown of categories.", 'sonex'  ) );
		parent::__construct('categories', esc_html__('sonex Categories', 'sonex' ), $widget_ops);
	}

	public function widget( $args, $instance ) {

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? esc_html__( 'Categories', 'sonex'  ) : $instance['title'], $instance, $this->id_base );

		$c = ! empty( $instance['count'] ) ? '1' : '0';
		$des = ! empty( $instance['description'] ) ? '1' : '0';
		$d = ! empty( $instance['dropdown'] ) ? '1' : '0';

		echo htmlspecialchars_decode( $args['before_widget'] );
		if ( $title ) {
			echo htmlspecialchars_decode( $args['before_title'] ) . esc_attr( $title ) . htmlspecialchars_decode( $args['after_title'] );
		}

		$cat_args1 = array('orderby' => 'name', 'show_count' => $c,);

		if ( $d ) {
			$cat_args1['show_option_none'] = esc_html__('Select Category', 'sonex' );

			/**
			 * Filter the arguments for the Categories widget drop-down.
			 *
			 * @since 2.8.0
			 *
			 * @see wp_dropdown_categories()
			 *
			 * @param array $cat_args1 An array of Categories widget drop-down arguments.
			 */
			wp_dropdown_categories( apply_filters( 'widget_categories_dropdown_args', $cat_args1 ) );
		?>

			<script type='text/javascript'>
			/* <![CDATA[ */
				var dropdown = document.getElementById("cat");
				function onCatChange() {
					if ( dropdown.options[dropdown.selectedIndex].value > 0 ) {
						location.href = "<?php echo esc_url( home_url("/") ); ?>/?cat="+dropdown.options[dropdown.selectedIndex].value;
					}
				}
				dropdown.onchange = onCatChange;
			/* ]]> */
			</script>

		<?php
			} else {
		?>
		
        <div class="sonex-widget-inner">
		<ul>
		<?php
		$args1 = array( 'orderby' => 'slug', 'parent' => 0 ); 
		$categories = get_categories( $args1 ); 
			foreach ( $categories as $category ) { 
				$output = '<li><a href="' . get_category_link( $category->term_id ) . 
				'" rel="bookmark"><i class="fa fa-folder-open-o"></i> ' . 
				'' . $category->name . '</a>';
				if($c) {$output.='<span>'.$category->count.'</span>';}
				$output.='<small>'.wp_html_excerpt($category->description, 45).'</small>';
				$output.='</li>';
				echo $output;

			} 
		?>	    
		</ul>
		</div>
		</div>
	<?php
		}

		echo htmlspecialchars_decode( $args['after_widget'] );
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['count'] = !empty($new_instance['count']) ? 1 : 0;
		$instance['hierarchical'] = !empty($new_instance['hierarchical']) ? 1 : 0;
		$instance['description'] = !empty($new_instance['description']) ? 1 : 0;
		$instance['dropdown'] = !empty($new_instance['dropdown']) ? 1 : 0;

		return $instance;
	}

	public function form( $instance ) {
		//Defaults
		$instance = wp_parse_args( (array) $instance, array( 'title' => '') );
		$title = esc_attr( $instance['title'] );
		$count = isset($instance['count']) ? (bool) $instance['count'] :false;
		$hierarchical = isset($instance['hierarchical']) ? (bool) $instance['hierarchical'] :false;
		$description = isset( $instance['description'] ) ? (bool) $instance['description'] : true;
		$dropdown = isset( $instance['dropdown'] ) ? (bool) $instance['dropdown'] : false;
?>
		<p><label for="<?php echo htmlspecialchars_decode( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title:', 'sonex'  ); ?></label>
		<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('title') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>

		<p><input type="checkbox" class="checkbox" id="<?php echo htmlspecialchars_decode( $this->get_field_id('dropdown') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('dropdown') ); ?>"<?php checked( $dropdown ); ?> />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('dropdown') ); ?>"><?php esc_html_e( 'Display as dropdown', 'sonex'  ); ?></label><br />

		<input type="checkbox" class="checkbox" id="<?php echo htmlspecialchars_decode( $this->get_field_id('count') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('count') ); ?>"<?php checked( $count ); ?> />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('count') ); ?>"><?php esc_html_e( 'Show post counts', 'sonex'  ); ?></label><br />

		<input type="checkbox" class="checkbox" id="<?php echo htmlspecialchars_decode( $this->get_field_id('hierarchical') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('hierarchical') ); ?>"<?php checked( $hierarchical ); ?> />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('hierarchical') ); ?>"><?php esc_html_e( 'Show rss', 'sonex'  ); ?></label><br />		
<?php
	}

}
function sonex_register_cat_widgets() {
    register_widget( 'sonex_Widget_Categories' );
}
add_action( 'widgets_init', 'sonex_register_cat_widgets' );	