<?php
/**
 * Register meta boxes
 *
 * @since 1.0
 *
 * @param array $meta_boxes
 *
 * @return array
 */
function sonex_register_meta_boxes( $meta_boxes ) {

	$prefix = '_cmb_';
	// Post format
	$meta_boxes[] = array(
		'id'       => 'format_detail',
		'title'    => esc_html__( 'Format Details', 'sonex' ),
		'pages'    => array( 'post' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
			array(
				'name'             => esc_html__( 'Image', 'sonex' ),
				'id'               => $prefix . 'image',
				'type'             => 'image_advanced',
				'class'            => 'image',
				'max_file_uploads' => 1,
			),
			array(
				'name'  => esc_html__( 'Gallery', 'sonex' ),
				'id'    => $prefix . 'images',
				'type'  => 'image_advanced',
				'class' => 'gallery',
			),
			array(
				'name'  => esc_html__( 'Quote', 'sonex' ),
				'id'    => $prefix . 'quote',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'quote',
			),
			array(
				'name'  => esc_html__( 'Author', 'sonex' ),
				'id'    => $prefix . 'quote_author',
				'type'  => 'text',
				'class' => 'quote',
			),
			array(
				'name'  => esc_html__( 'Audio', 'sonex' ),
				'id'    => $prefix . 'link_audio',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'audio',
				'desc' => 'Ex: https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/139083759',
			),
			array(
				'name'  => esc_html__( 'Video', 'sonex' ),
				'id'    => $prefix . 'link_video',
				'type'  => 'textarea',
				'cols'  => 20,
				'rows'  => 2,
				'class' => 'video',
				'desc' => 'Example: <b>http://www.youtube.com/embed/0ecv0bT9DEo</b> or <b>http://player.vimeo.com/video/47355798</b>',
			),			
		),
	);



	// Header Styles
	$meta_boxes[] = array(
		'id'       => 'header_style',
		'title'    => esc_html__( 'Header Styles', 'sonex' ),
		'post_types' => array( 'page' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
         
         array(
				'name'        => esc_html__( 'Select', 'sonex' ),
				'id'          => $prefix . 'header_style',
				'type'        => 'select',
				'std'         => 'value1',
				// Array of 'value' => 'Label' pairs for select box
				'options'     => array(
					'value1' => esc_html__( 'Corporate', 'sonex' ),
					'value2' => esc_html__( 'Creative', 'sonex' ),
					'value3' => esc_html__( 'Construction', 'sonex' ),
					'value4' => esc_html__( 'Ecommerce', 'sonex' ),
					'value5' => esc_html__( 'Medical', 'sonex' ),
					'value6' => esc_html__( 'Agency', 'sonex' ),
					'value7' => esc_html__( 'Classic', 'sonex' ),
					'value8' => esc_html__( 'Cheesecake', 'sonex' ),
					'hide' => esc_html__( 'Hide Header', 'sonex' ),
				),

			),		
		),
	);
	//Footer Styles
		$meta_boxes[] = array(
		'id'       => 'footer_style',
		'title'    => esc_html__( 'Footer Styles', 'sonex' ),
		'post_types' => array( 'page' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'std'         => 'value1',
		'fields'   => array(
         
         array(
				'name'        => esc_html__( 'Select', 'sonex' ),
				'id'          => $prefix . 'footer_style',
				'type'        => 'select',
				// Array of 'value' => 'Label' pairs for select box
				'options'     => array(
					'value1' => esc_html__( 'Corporate', 'sonex' ),
					'value2' => esc_html__( 'Creative', 'sonex' ),
					'value3' => esc_html__( 'Construction', 'sonex' ),
					'value4' => esc_html__( 'Ecommerce', 'sonex' ),
					'value5' => esc_html__( 'Medical', 'sonex' ),
					'value6' => esc_html__( 'Agency', 'sonex' ),
					'value7' => esc_html__( 'Classic', 'sonex' ),
					'value8' => esc_html__( 'Cheesecake', 'sonex' ),
					'hide' => esc_html__( 'Hide Footer', 'sonex' ),
				),

			),		
		),
	);

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'sonex_register_meta_boxes' );

/**
 * Enqueue scripts for admin
 *
 * @since  1.0
 */
function sonex_admin_enqueue_scripts( $hook ) {
	// Detect to load un-minify scripts when WP_DEBUG is enable
	$min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	if ( in_array( $hook, array( 'post.php', 'post-new.php' ) ) ) {
		wp_enqueue_script( 'sonex-backend-js', get_template_directory_uri()."/js/admin.js", array( 'jquery' ), '1.0.0', true );
	}
}

add_action( 'admin_enqueue_scripts', 'sonex_admin_enqueue_scripts' );
