<?php
/**
 * Custom Icon List for Mega Menu Sonex 
 *
 * @package Sonex
 * @author  FinsStudio
 * @link	http://www.finsstudio.com
 */

/*--------------------------------------------------------------
	Define icon path
--------------------------------------------------------------*/
function sonex_vc_icon_url() {
	return get_template_directory_uri() . '/framework/icons';
}

/*--------------------------------------------------------------
	Icon init
--------------------------------------------------------------*/
function sonex_vc_icon_init() {
	// Enqueue icon font style
	wp_register_style( 'icon-font-style', sonex_vc_icon_url() . '/css/icon-font-style.css' );

	// Enqueue icon font style back-end
	wp_register_style( 'sonexicon-icon-generator', sonex_vc_icon_url() . '/css/generator.css' );

	// Enqueue icon font script
	wp_register_script( 'sonexicon-icon-generator', sonex_vc_icon_url() . '/js/generator.js', array( 'jquery' ), '', false );

	if ( ! is_admin() ) {
		wp_enqueue_style( 'icon-font-style' );
	} elseif ( is_admin() ) {
		wp_enqueue_style( 'icon-font-style' );
		wp_enqueue_style( 'sonexicon-icon-generator' );	
		wp_enqueue_script( 'sonexicon-icon-generator' );		
	}
}
add_action( 'init', 'sonex_vc_icon_init' );

/*--------------------------------------------------------------
	Generate icon box
--------------------------------------------------------------*/
function sonex_vc_icon_generator() {
	include_once 'inc/list.php'; ?>
	<div id="sonexicon-generator-overlay" class="sonexicon-overlay-bg" style="display:none"></div>
	<div id="sonexicon-generator-wrap" style="display:none">
		<div id="sonexicon-generator">
			<a href="#" id="sonexicon-generator-close"><span class="sonexicon-close-icon"></span></a>
			<div id="sonexicon-generator-shell">
				
				<table border="0" id="sonexicon-generator-options">
					<tr>
						<td class="generator-title">
							<span><?php esc_html_e( 'Icon Pack:', 'sonex' ); ?></span>
						</td>							
						<td>
							<select name="icon-pack" id="sonexicon-generator-select-pack">
							   <option value="fontawesome-icons-list"><?php esc_html_e( 'Font Awesome icons', 'sonex' ); ?></option>
							   <option value="line-icons-list"><?php esc_html_e( 'Line icons', 'sonex' ); ?></option>
							</select>
						</td>
					</tr>
				</table>
				
				<div class="sonexicon-generator-icon-select">
					<ul class="fontawesome-icon-list">
					<?php 
					foreach ( $sonexicon_icon_list['fontawesome'] as $font_awesome_icon ) {
						$selected_icon = ( 'awesome-adjust' == $font_awesome_icon ) ? ' checked' : '';
						echo '<li><input name="name" type="radio" value="' . esc_attr( $font_awesome_icon ) . '" id="' . esc_attr( $font_awesome_icon ) . '" '. $selected_icon .' ><label for="' . $font_awesome_icon . '"><i class="' . $font_awesome_icon . '"></i></label></li>';
					} 
					?>
					</ul>
					<ul class="line-icon-list" style="display:none">
					<?php 
					foreach ( $sonexicon_icon_list['line'] as $line_icon ) {
						echo '<li><input name="name" type="radio" value="' . esc_attr( $line_icon ) . '" id="' . esc_attr( $line_icon ) . '"><label for="' . $line_icon . '"><i class="' . $line_icon . '"></i></label></li>';
					} 
					?>
					</ul>
				</div>
				
				<input name="sonexicon-generator-insert" type="submit" class="button button-primary button-large" id="sonexicon-generator-insert" value="Insert Icon">
				<div class="sonexicon-clear"></div>
				
				<input type="hidden" name="sonexicon-generator-url" id="sonexicon-generator-url" value="<?php echo esc_attr( sonex_vc_icon_url() ); ?>" />
				<input type="hidden" name="sonexicon-generator-result" id="sonexicon-generator-result" value="" />
				<input type="hidden" name="sonexicon-compatibility-mode" id="sonexicon-compatibility-mode" value="sonex_" />
			</div>
		</div>
	</div>
	
<?php
}
add_action( 'admin_footer', 'sonex_vc_icon_generator' );

?>