<?php

$full_path = getcwd();
$ar = explode("wp-", $full_path);
$root =  $ar[0];

if ( file_exists( $root.'wp-config.php' ) ) {

    require_once( $root.'wp-config.php' );

}

header("Content-type: text/css; charset=utf-8");

function sonex_hex2rgb($hex) {

   $hex = str_replace("#", "", $hex);
   if(strlen($hex) == 3) {

      $r = hexdec(substr($hex,0,1).substr($hex,0,1));

      $g = hexdec(substr($hex,1,1).substr($hex,1,1));

      $b = hexdec(substr($hex,2,1).substr($hex,2,1));

   } else {

      $r = hexdec(substr($hex,0,2));

      $g = hexdec(substr($hex,2,2));

      $b = hexdec(substr($hex,4,2));

   }

   $rgb = array($r, $g, $b);

   //return implode(",", $rgb); // returns the rgb values separated by commas

   return $rgb; // returns an array with the rgb values

}

$theme_option=sonex_global();
$rgba = sonex_hex2rgb($b);  
?>

/*  ################################################################

  Custom logo

################################################################# */

<?php if(isset($theme_option['logocheck']) and $theme_option['logocheck']=="1" ){ ?> 
  .site-logo {margin: 10px 0;}
<?php } ?>
.logo-text img {
  <?php if($theme_option['logo_width']) echo 'width:'.esc_attr($theme_option['logo_width']).'px; '; if($theme_option['logo_height']) echo 'height:'.esc_attr($theme_option['logo_height']).'px; max-height: none;'; ?>
}


/*	################################################################

	14. COLOR SCHEMES

################################################################# */

.body-boxed{background-image: url("<?php echo esc_url($theme_option['boxed_bg']['url']); ?>");}

/*********************************************



Secondary Color



*********************************************/

footer.site-footer-1 .copyrights > i.fa,
.pricing-table.featured header p.title, .pricing-tables-group .pricing-tables-group-item.featured p.price
{

	background-color: <?php echo esc_attr($theme_option['second_color']); ?>;

}

.d-btn-primary-border:hover{
	border-color: <?php echo esc_attr($theme_option['second_color']); ?>;
}
.d-btn-primary-border:hover, .pricing-tables-group .pricing-tables-group-item.featured p.desc{

	color: <?php echo esc_attr($theme_option['second_color']); ?> !important;

}

/*********************************************
	Primary Color
*********************************************/
a:hover, blockquote i.fa-quote-left, .primary-color,
p.secondary-color > b, header.site-header div.mobile-nav > i.fa,
header.site-header nav.desktop-nav > i.fa,
header.site-header-3 p.sm-buttons a i.fa.cloned, .d-btn-primary-border, .ls-inner p.title-3,
.ls-inner .layerslider-p-1, ul.side-nav li > i.fa, footer.site-footer form.wpcf7-form .widget_contacts_2 .status span,
.dotted-about-widget p.contacts i, .recent-post.featured-property p.price,
.testimonials-1 p.author, .feature .feature-icon i.fa, .feature p.desc,
.team-member .info p a, .team-member .info p.title a:hover,
.team-member .info p.position, .project-item .info p strong,
.project-item .info p.tags, .project-item .info p.title a:hover, 
.project-item.product-item .info p.price, .project-item.property-item .featured,
.project-item.property-item-2 .info .price, .project-item.property-item-3 p.label,
.project-item.property-item-3 p.price span, .project-item.blog-item.blog-item-single .share a:hover,
.project-item.travel-item .hotel-and-price ul li i.fa, 
.blog-post-author p.position, .used-skills-ul li:before,
.pricing-table header .price p.value, .pricing-table .content ul li i.fa,
.reward-item p.date, .customNavigation a i.fa:hover,
div.rivaCarouselNav a.slider-nav-btn-1:hover i.fa, div.rivaCarouselNav a.slider-nav-btn-2:hover i.fa,
.staff-member-block p.position, ul.staff-member-contact-info > :nth-child(odd) > i.fa,
.work-experience p.title span, .service-item h4 i.fa,
.service-item-2 > i.fa, .secondary-bg .service-item-2:hover > i.fa,
.twitter-widget-1 li i.fa, .widget.widget-property-agent .agent-details p a:hover,
.widget.widget-property-agent .agent-details p.position, .twitter-widget-2 > i.fa,
.widget-top-areas .widget-inner ul li i.fa, 
.rivaAdvancedSelector .rivaAdvancedSelectorSlides .rivaAdvancedSelectorSlidesWrapper .rivaAdvancedSelectorSlide .details p.title a:hover,
p.s_profiles a:hover, .single-product-details p.price,
.single-product-details p.rating, section.section-shopping-cart table.cart-table tbody tr td .qty,
.contact-item i.fa, .ls-inner p.title-3, .ls-inner .layerslider-p-1,
.woocommerce div.product p.price,.woocommerce div.product span.price,
.woocommerce div.product p.price ins,.woocommerce div.product span.price ins,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce .star-rating:before, .woocommerce .star-rating span,
.woocommerce p.stars a, .woocommerce ul.product_list_widget li span.amount,
.cart_totals.dotted_cart_total table td strong, .woocommerce .woocommerce-message:before,
#wp-calendar tfoot #prev a:hover, #wp-calendar tfoot #next a:hover, .bottom-menu li a,
footer.site-footer-1 .copyrights-3 p a, .head-corporate .sonex-header .sonex-menu li:hover > a  {
color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
  .sidebar .widget-title:before,
  .shop-sidebar .widget-title:before {
    position: absolute;
    bottom: 0;
    content: "";
    width: 40px;
    height: 4px;
    left: 4px;
    padding-bottom: 5px;
    margin-bottom: 5px;
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.vc_toggle_square .vc_toggle_icon {
  background-color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.head-corporate .shopping-cart i.fa {
  background: transparent;
}
.head-corporate .search i.fa {
  background: transparent;
}
.page-title-bar ul li {
  color: #ffffff;
  display: inline-block;
}
.transparent-header .sonex-header .sonex-menu li ul,
.transparent-header .sonex-header-bot .sonex-menu li ul,
.transparent-header .sonex-header .sonex-menu .mega-container {
  border-bottom: 5px solid <?php echo esc_attr($theme_option['main_color']); ?>;
}
.smile_icon_list li .icon_list_icon {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.info-circle-icons {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.wpcf7 form input[type=submit]{
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
    transition: 0.6s all ease;
    border: 0px;
    display: block;
    padding: 10px 20px;
    color: #ffffff;
    border-radius: 20px;
  transition: 0.6s all ease;
}
.wpcf7 form input[type=submit]:hover {
  background: #333333;
  transition: 0.6s all ease;
}
.uvc-heading-spacer .aio-icon {
    background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
a.vc_gitem-link.vc_general.vc_btn3.vc_btn3-size-md.vc_btn3-shape-rounded.vc_btn3-style-flat.vc_btn3-color-juicy-pink {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.tweetblock-icon i {
  border: 5px solid <?php echo esc_attr($theme_option['main_color']); ?>;
}
.ubtn-center-dg-bg .ubtn-hover,
.ubtn-center-hz-bg .ubtn-hover,
.ubtn-left-bg .ubtn-hover,
.ubtn-center-vt-bg .ubtn-hover,
.ubtn-top-bg .ubtn-hover,
.vc_progress_bar .vc_single_bar .vc_label_units
 {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.primary-bg,
.head-corporate .search i.fa.active,
header.site-header div.mobile-nav > i.fa.active,
header.site-header div.mobile-nav > i.fa:hover,
header.site-header div.mobile-nav > ul > li > ul > li > ul > li:hover,
header.site-header div.mobile-nav > ul > li > ul > li:hover,
header.site-header div.mobile-nav > ul > li:hover,
header.site-header nav.desktop-nav > i.fa.active,
header.site-header nav.desktop-nav > i.fa:hover,
header.site-header-2 p.sm-buttons a i.fa.cloned, .ls-inner p.sub-title-1, .ls-inner p.content-4,
.ls-inner .p-bg-color, footer.site-footer .widget p.sm-buttons a i.fa.cloned,
footer.site-footer .widget p.sm-buttons-2 a:hover i.fa,
footer.site-footer .widget_contacts p i, footer.site-footer .widget.widget_tag_cloud a:hover,.section-primary-bg, .testimonials-2 > .content .quote i.fa,
.feature:hover i.fa,footer.site-footer-1 .copyrights > i.fa, .project-item.property-item .new, .project-item.property-item .price,.d-btn-gray,.project-item.travel-item .hotel-and-price span.stars,
.pricing-table.featured header, .pricing-tables-group .pricing-tables-group-item.featured p.title,
.pricing-table-3 thead :first-child, .skill-item .val-wrapper .val,
.newsletters-2, .owl-controls .owl-page.active span, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, 
.woocommerce button.button.alt, .woocommerce input.button.alt,
div.rivaCarouselNavBullets .slider-nav-bullets-2.active,
div.rivaCarouselNavBullets .slider-nav-bullets-1.active,
.staff-member-skills, .production-process-step .number span,
.to-the-top-2:hover i.fa, .to-the-top-3, .twitter-widget-1 li p.timePosted,
.widget.widget-property-agent .offer, .widget-quick-search, .hover-effect-1 > a:hover,
.sonex-booking .choose span.active, .rivaAdvancedSelector .rivaAdvancedSelectorThumbs p.title, section.section-shopping-cart p.you-have span,
.ls-inner p.sub-title-1, .ls-inner p.content-4, .ls-inner .p-bg-color,
.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce .widget_price_filter .ui-slider .ui-slider-range,
#wp-calendar tbody td#today, .menu-mobile-wrap ul .sub-open{
background-color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.ult-modal-input-wrapper .btn-modal-md {
  border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?>;
}
.ult-modal-input-wrapper .btn-modal-md:hover {
  background: transparent !important;
  border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?>;
  color: <?php echo esc_attr($theme_option['main_color']); ?> !important;
}
.head-corporate .contacts:hover i {
  background: #132835;
  transition: all 0.7s ease;
}
header.site-header-2 p.contacts i {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
  transition: all 0.7s ease;
}
.project-item.blog-item .info .format {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.testimonials-1 .inner,
.sonex-booking .choose, .riva-countdown .riva-countdown-item .value p{
border-bottom-color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.service-item-2:hover > i.fa {
background: <?php echo esc_attr($theme_option['main_color']); ?>;
border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?>;
}
.accordion > section.active, .tabs.tabs-vertical > header > h4.active{

	border-left-color: <?php echo esc_attr($theme_option['main_color']); ?>;

}
header.site-header div.mobile-nav > ul,
footer.site-footer-1 .copyrights-2,
.tabs > header > h4.active, .testimonials-2 > .content .quote .triangle,
.testimonials-1 span.triangle, .woocommerce .woocommerce-message{
border-top-color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
#wp-calendar caption { 
background:<?php echo esc_attr($theme_option['main_color']); ?>;
color: #ffffff;
}
.ls-inner .layerslider-p-1, header.site-header div.shopping-cart i.fa,
header.site-header div.search i.fa, header.site-header div.mobile-nav > i.fa,
header.site-header nav.desktop-nav > i.fa,
form .form-control:focus,
form input:focus, form textarea:focus, form select:focus,
footer.site-footer form.wpcf7-form .widget_contacts_2 .status span,
.project-item.property-item-2 .info .price, .project-item.property-item-3 p.price span,
div.rivaCarouselNav a.slider-nav-btn-1:hover i.fa,
div.rivaCarouselNav a.slider-nav-btn-2:hover i.fa,
.service-item-2 > i.fa, .twitter-widget-1 li i.fa,
.twitter-widget-2 > i.fa, .customNavigation a i.fa:hover,
{

	border-color: #E2E3E4;

}
.hover-effect > a:hover {
  background-color: <?php echo esc_attr($theme_option['main_color']); ?>;
  border-color: <?php echo esc_attr($theme_option['main_color']); ?>; 
  color: #ffffff;  
}
.classic .lighter-note .tweet-item a {
  color: #AFAF8A ;
}
.woocommerce .quantity .plus:hover, .woocommerce .quantity .minus:hover, .woocommerce #content .quantity .plus:hover, 
.woocommerce #content .quantity .minus:hover, .woocommerce-page .quantity .plus:hover, 
.woocommerce-page .quantity .minus:hover, .woocommerce-page #content .quantity .plus:hover, 
.woocommerce-page #content .quantity .minus:hover {background: <?php echo esc_attr($theme_option['main_color']); ?>; color: #ffffff;}
.woocommerce .woocommerce-info{border-top-color: <?php echo esc_attr($theme_option['main_color']); ?>;}
.woocommerce .woocommerce-info:before{color: <?php echo esc_attr($theme_option['main_color']); ?>;}
.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, 
.woocommerce input.button,.d-btn-primary {
  background-color: <?php echo esc_attr($theme_option['main_color']); ?>;  
}
.wcmp-product .wcmp-price .price {
  color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.wcmp-product .wcmp-product-image .wcmp-add-to-cart, .wcmp-product .wcmp-product-image .wcmp-quick-view {
  background: <?php echo esc_attr($theme_option['main_color']); ?>;
  color: #ffffff;
}
.d-btn-primary:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, 
.woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover,
.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover {
  background-color: #333 !important;  
}
.d-btn-secondary {
  background-color: <?php echo esc_attr($theme_option['main_color']); ?>; 
  transition: background-color 0.2s ease; 
}
.d-btn-secondary:hover {
  background-color: <?php echo esc_attr($theme_option['btn2_bghover']); ?>;  
}
.trancy {
    background: transparent !important;
    transition: background 0.4s ease;
}
.trancy:hover {
    background: <?php echo esc_attr($theme_option['main_color']); ?> !important; 
    color: #ffffff;
    border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?> !important;
}
.trancy-dark {
    background: transparent !important;
    transition: background 0.4s ease;
}
.trancy-dark:hover {
    background: <?php echo esc_attr($theme_option['main_color']); ?> !important; 
    color: #ffffff;
    border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?> !important;
}
.blacky {
  background: #333 !important;  
  transition: background 0.4s ease;
  border: 1px solid #333333;
}
.blacky:hover {
  background: #1B1B1B !important; 
  border: 1px solid #333333;
}

/*********************************************
  Visual Composer Attributes
*********************************************/
.default-backy {
    background: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.vc_icon_element.vc_icon_element-outer .vc_icon_element-inner.vc_icon_element-size-lg.vc_icon_element-have-style-inner {
    width: 5em !important;
    height: 5em !important;
    border: 1px solid <?php echo esc_attr($theme_option['main_color']); ?>;
    padding: 20px;
    color: <?php echo esc_attr($theme_option['main_color']); ?>;
    background: #ffffff;
}

.vc_icon_element.vc_icon_element-outer .vc_icon_element-inner.vc_icon_element-size-lg.vc_icon_element-have-style-inner:hover {
    color: #ffffff;
    border: 1px dotted <?php echo esc_attr($theme_option['main_color']); ?>;
    padding: 20px;
    background: <?php echo esc_attr($theme_option['main_color']); ?>;
    -webkit-transition: all .3s ease;
    -moz-transition: all .3s ease;
    -o-transition: all .3s ease;
    transition: all .3s ease;
}
.color-heading {
    color: <?php echo esc_attr($theme_option['main_color']); ?> !important;
    font-weight: 600;
}
.defaulty .aio-icon {
    color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.style_3 .aio-icon-box .aio-icon, .style_3 .aio-icon-box .img-icon {
    color: <?php echo esc_attr($theme_option['main_color']); ?>;
}
.timeline-separator-text .sep-text {
    background-color: <?php echo esc_attr($theme_option['main_color']); ?> !important;
}