<?php	 		 	
// Template Name: Coming Soon Template

// Set Slider
$slider_page_id = $post->ID;
if(is_home() && !is_front_page()){ $slider_page_id = get_option('page_for_posts'); }

if(get_post_meta($slider_page_id, 'wi_meta_revslider', true) || get_post_meta($slider_page_id, 'wi_meta_revslider', true) != 0) { 
	function add_revolution_slider(){
		echo '<div>';
		echo do_shortcode('[rev_slider '.get_post_meta(get_the_ID(), 'wi_meta_revslider', true).']'); 
		echo '</div>';
	}
	
	if(	get_post_meta($slider_page_id, 'wi_meta_revslider_position', true) == 1) {
		add_action( '__after_header' , 'add_revolution_slider');
	} elseif ( get_post_meta($slider_page_id, 'wi_meta_revslider_position', true) == 2) {
		add_action( '__before_header_topbar' , 'add_revolution_slider');
	} elseif ( get_post_meta($slider_page_id, 'wi_meta_revslider_position', true) == 3) {
		add_action( '__before_header_midbar' , 'add_revolution_slider');
	} elseif ( get_post_meta($slider_page_id, 'wi_meta_revslider_position', true) == 4) {
		add_action( '__before_header_navbar' , 'add_revolution_slider');
	}
}

get_header('blank');
$days = $wi_options['wi_csp_days'];
$days_c = $wi_options['wi_csp_days_color'];
$hours = $wi_options['wi_csp_hours'];
$hours_c = $wi_options['wi_csp_hours_color'];
$minutes = $wi_options['wi_csp_minutes'];
$minutes_c = $wi_options['wi_csp_minutes_color'];
$seconds = $wi_options['wi_csp_seconds'];
$seconds_c = $wi_options['wi_csp_seconds_color'];
$csp_text = $wi_options['wi_csp_text'];
$csp_date = $wi_options['wi_csp_date'];

wp_enqueue_script('timeCircles', get_template_directory_uri() . '/framework/js/TimeCircles.js'); 
?>
<script>
jQuery.noConflict()(function($){
"use strict";

$(document).ready(function(){	
  $("#count-down").TimeCircles(
       {   
	       
           circle_bg_color: "#e6e6e6",
           use_background: true,
           bg_width: 1.0,
           fg_width: 0.02,
           time: {
                Days: { color: "<?php echo esc_js($days_c); ?>",text: "<?php echo esc_js($days); ?>" },
                Hours: { color: "<?php echo esc_js($hours_c); ?>",text: "<?php echo esc_js($hours); ?>"  },
                Minutes: { color: "<?php echo esc_js($minutes_c); ?>",text: "<?php echo esc_js($minutes); ?>"  },
                Seconds: { color: "<?php echo esc_js($seconds_c); ?>",text: "<?php echo esc_js($seconds); ?>"  }
            }
       }
    );
   }); 
});
</script> 


<div class="main_content_area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="csp-image"><img src="<?php echo esc_url($wi_options['wi_csp_logo']['url']); ?>" alt="<?php echo esc_attr( get_bloginfo('name') ); ?>"></div>
			</div>
		</div>
	</div>
	<div class="coming_soon_text_container">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<h1 class="coming_soon_text aligncenter"><?php echo !empty( $csp_text ) ? $csp_text : ''; ?></h1>
				<div class="timing"><div id="count-down" data-date="<?php echo esc_attr($csp_date); ?> 00:00:00"></div></div>
				<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
				<?php the_content(); ?>
				<?php endwhile;  ?> 
				<?php endif; ?>
			</div>
		</div>
	</div>
	</div>
</div>

<?php 
get_footer('blank');
?>