<?php 

/* Loading Theme Scripts
------------------------------------------*/

add_action('wp_enqueue_scripts', 'b_i_g_load_scripts');
if ( !function_exists( 'b_i_g_load_scripts' ) ) {
	function b_i_g_load_scripts() {
		wp_enqueue_script('bootstrap', get_template_directory_uri().'/framework/bootstrap/bootstrap.min.js', array('jquery'), false, true );
		wp_enqueue_script('mobilemenu', get_template_directory_uri().'/framework/js/jquery.mobilemenu.js', array('jquery'), false, true );
		wp_enqueue_script('modernizr', get_template_directory_uri().'/framework/js/modernizr.custom.js', array('jquery'), false, true );
		wp_enqueue_script('inst', get_template_directory_uri().'/framework/js/instagram.min.js', array('jquery'), false, true );
		wp_enqueue_script('bxslider', get_template_directory_uri().'/framework/js/jquery.bxslider.min.js', array('jquery'), false, true );
		wp_enqueue_script('prettyPhoto', get_template_directory_uri().'/framework/js/jquery.prettyPhoto.js', array('jquery'), false, true );
		wp_enqueue_script('magnific-popup', get_template_directory_uri() . '/framework/js/jquery.magnific-popup.min.js', array('jquery'), false, true );
		wp_enqueue_script('waitforimages', get_template_directory_uri().'/framework/js/jquery.waitforimages.js', array('jquery'), false, true );
		wp_enqueue_script('flexslider', get_template_directory_uri().'/framework/FlexSlider/jquery.flexslider-min.js', array('jquery'), false, true );
		wp_enqueue_script('owlcarousel', get_template_directory_uri().'/framework/owl-carousel/owl.carousel.min.js', array('jquery'), false, true );
    	wp_enqueue_script('wi_custom', get_template_directory_uri().'/framework/js/custom.js', array('jquery'), false, true );
		

		$wi_options = get_option('wi_options');
		$wi_theme = array( 
				'theme_url' => get_template_directory_uri(),
			);
    	wp_localize_script( 'wi_custom', 'wi_theme', $wi_theme );
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		wp_enqueue_script( 'ie8style', 'http://html5shim.googlecode.com/svn/trunk/html5.js' );
		wp_script_add_data( 'ie8style', 'conditional', 'lt IE 9' );

	}    
}