<?php

/**
 * Plugin Name: LMM Menu
 * Plugin URI: http://themeforest.net/user/liquida/portfolio
 * Description: This plugin allows you to create the best Wordpress Mega Menu based on Bootstrap 3.0.
 * Version: 1.2.3
 * Author: LiquidaThemes
 * Author URI: http://themeforest.net/user/liquida
 * Text Domain: lmm
 * Domain Path: /languages/
 * License: codecanyon
 */
if (!defined('ABSPATH'))
    die('-1');


function lmm_i18n() {

    $plugin_dir = dirname(__FILE__);

    load_plugin_textdomain('lmm', false, $plugin_dir . '/languages/');
}

add_action('plugins_loaded', 'lmm_i18n');

include_once('lmm-abc.php');

include_once('lmm-activation.php');

include_once('lmm-notices.php');

include_once('lmm-import.php');

include_once('lmm-redux.php');

include_once('lmm-widget.php');

include_once('lmm-vc.php');

include_once('lmm-admin.php');

//include_once('lmm-metabox.php');
//functions needed in admin backend for the importer
include_once('lmm-editwalker.php');

//init this functions after theme setup to allow filters hooks
add_action('init', 'lmm_init', 14);

function lmm_init() {

    require_once('lmm-config.php');

    include_once('lmm-init.php');

    include_once('lmm-options.php');

    include_once('lmm-login.php');

    include_once('lmm-customizer.php');

    if (!is_admin()) {
        include_once('lmm-integration.php');
        include_once('lmm-navwalker.php');
        include_once('lmm-layouts.php');
    }

    //needed in redux panel & less customizer
    if (is_admin() || is_customize_preview()) {
        require_once('lib/importer/index.php');
        require_once('lmm-panel.php');
        require_once('lmm-css.php');
    }
}

add_action('init', 'lmm_nav_menus', 15);

function lmm_nav_menus() {

    if (!is_admin())
        return;

    global $lmm_locations;

    if (empty($lmm_locations) || !is_array($lmm_locations))
        return;

    $menu_locations = isset($_REQUEST['menu-locations']) ? $_REQUEST['menu-locations'] : get_nav_menu_locations();

    if (empty($menu_locations))
        return;

    $_nav_menu_term_id = ( isset($_REQUEST['menu']) ? (int) $_REQUEST['menu'] : ( ( get_user_option('nav_menu_recently_edited') != false ) ? absint(get_user_option('nav_menu_recently_edited')) : 0 ) );

    if (empty($_nav_menu_term_id))
        return;

    // chek if this menu id is in the theme locations
    if (!in_array($_nav_menu_term_id, $menu_locations))
        return;

    if (count(array_intersect(array_keys($menu_locations, $_nav_menu_term_id), array_keys($lmm_locations))) > 0) {

        include_once('lmm-nav-menus.php');
        include_once('lmm-nav-menus-metabox.php');
        include_once('lmm-nav-menus-ajax.php');

        if (!function_exists('mldetect_check_post_limits')) {
            include_once(dirname(__FILE__) . '/lib/nav-menus-limit.php');
        }
    }
}

register_activation_hook(__FILE__, array('LMM_Activation', 'activation'));
