<?php

if (!class_exists('ReduxFramework')) {
    require_once(dirname(__FILE__) . '/lib/redux/ReduxCore/framework.php');
}

if (!class_exists('LMM_Options')) {

    class LMM_Options {

        public $args = array();
        public $sections = array();
        public $theme;
        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (true == Redux_Helpers::isTheme(__FILE__)) {
                $this->initSettings();
            } else {
                add_action('init', array($this, 'initSettings'), 15);
            }

            add_action('redux/page/' . LMM . '/enqueue', array($this, 'redux_scripts'));

            //we've to wait to the re-loaded panel has it has the new instances
            add_action('redux/page/' . LMM . '/load', array($this, 'saved_locations_compiler'), 10, 1);

            add_action('redux/page/' . LMM . '/form/after', array($this, 'redux_modal'));

            add_filter('redux/options/' . LMM . '/compiler', array($this, 'saved_compiler'), 10, 3);

            add_action('redux/options/' . LMM . '/import', array($this, 'saved_bridge'), 10, 1);

            add_action('redux/options/' . LMM . '/reset', array($this, 'saved_bridge'), 10, 1);

            add_action('redux/options/' . LMM . '/section/reset', array($this, 'saved_bridge'), 10, 1);

            add_action('redux/options/' . LMM . '/saved', array($this, 'saved_locations'), 10, 2);

            add_action('redux/options/' . LMM . '/saved', array($this, 'saved_redirect'), 20, 2);

            add_action('redux/options/' . LMM . '/settings/change', array($this, 'redux_redirect'), 20, 2);

            add_filter('redux/' . LMM . '/field/class/custom_locations', array($this, 'field_custom_locations'));

            add_filter('redux/' . LMM . '/field/class/social', array($this, 'field_social'));
        }

        function redux_scripts() {
            wp_enqueue_style('lmm-navmenu');
            wp_enqueue_script('lmm-modal');
            wp_enqueue_script('lmm-admin');
        }

        function field_social($field) {
            return dirname(__FILE__) . '/lib/redux/social/field_social.php';
        }

        function field_custom_locations($field) {
            return dirname(__FILE__) . '/lib/redux/custom_locations/field_custom_locations.php';
        }

        function redux_modal() {
            lmm_modal_box();
        }

        function saved_compiler($options, $css, $changed) {

            //we've have to scape the copiler if locations have changed, has it will be called on the panel re-load
            if (get_option('_lmm_saved_locations_compiler'))
                return;

            lmm_add_redux_notice('yellow', __('Some style options have been changed. Your stylesheet will be compiled to reflect changes. Please wait.', 'lmm'));

            //if (!empty($changed) && in_array($changed, $defaults = lmm_options_locations_defaults()))

            lmm_compiler($options);
        }

        function saved_bridge($options = false) {

            if (empty($options->parent->options) || empty($options->parent->transients['changed_values']))
                return;

            $this->saved_locations($options->parent->options, $options->parent->transients['changed_values']);

            $this->saved_redirect($options->parent->options, $options->parent->transients['changed_values']);
        }

        static function saved_locations($options = false, $changed = false) {

            global $_wp_registered_nav_menus;

            $save_locations = $defaults = array();

            //fix for the first load, defaults locations not loading
            if (empty($options) && !get_option(LMM_LOCATIONS)) {

                $defaults = apply_filters('lmm_hook_options_config_defaults', $options);

                $options = wp_parse_args(apply_filters('lmm_hook_options_developer', $options), $defaults);
            }

            $defaults = apply_filters('lmm_hook_options_locations_defaults', $defaults);

            //if settings change, take new values from redux update
            if (empty($options['lmm_locations']))
                return;

            foreach ($options['lmm_locations'] as $location => $active) {

                // fix for import content, when primary location is not in the theme
                if (!isset($_wp_registered_nav_menus[$location]) || !$active)
                    continue;

                $_integration = !empty($options[$location . '_integration']) ? $options[$location . '_integration'] : $defaults['all_integration'];

                $__filters = !empty($options[$location . '_integration_filters']) ? $options[$location . '_integration_filters'] : $defaults['all_integration_filters'];

                $_filters = (boolean) ($_integration == 'auto' && $__filters);

                $save_locations[$location] = array(
                    'instance' => $location,
                    'name' => $_wp_registered_nav_menus[$location],
                    'style' => (boolean) $active,
                    'integration' => $_integration,
                    'filters' => $_filters,
                    'subsection' => 1,
                );
            }

            update_option(LMM_LOCATIONS, $save_locations);
        }

//run the compiler after load to recompile the stylesheet when new locations have been created or some location have been deleted
        function saved_locations_compiler($screen = false) {

            if (!get_option('_lmm_saved_locations_compiler'))
                return;

            global $lmm;

            lmm_add_admin_notice('updated', __('We have found new theme locations. Your stylesheet have been compiled to include their options.', 'lmm'));

            lmm_compiler($lmm);

            delete_option('_lmm_saved_locations_compiler');
        }

        function saved_redirect($options = false, $changed = false) {

            if (empty($changed))
                return;

            // on fonticons changes ----------------------------------------------------
            if (isset($changed['lmm_styles_icons'])) {

                lmm_add_redux_notice('blue', __('New fonticon have been selected. Your options panel will be reloaded to include them. Please wait.', 'lmm'));

                set_transient('lmm_saved_redirect', true, 30);
            }

            // on add new locations ----------------------------------------------------
            if (isset($changed['lmm_locations'])) {

                lmm_add_redux_notice('blue', __('New locations have been created. Your options panel will be reloaded to include them. Please wait.', 'lmm'));

                set_transient('lmm_saved_redirect', true, 30);
                update_option('_lmm_saved_locations_compiler', true);
            }
        }

        function redux_redirect() {

            if (!is_admin() || !get_transient('lmm_saved_redirect'))
                return;

            echo '<script>parent.window.location.reload(true);</script>';

            delete_transient('lmm_saved_redirect');
        }

        public function initSettings() {
            $this->setArguments();

            if (!isset($this->args['opt_name'])) {
                return;
            }

            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
        }

        public function setArguments() {

            $this->args = array(
                'class' => 'liquida-admin-wrap',
                'opt_name' => LMM, // This is where your data is stored in the database and also becomes your global variable name.
                'disable_tracking' => true,
                'display_name' => __('LMM Menu', 'lmm'), //$theme->get('Name'), // Name that appears at the top of your panel
                'display_version' => LMM_VERSION, //$theme->get('Version'), // Version that appears at the top of your panel
                'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
                'allow_sub_menu' => true, // Show the sections below the admin menu item or not
                'menu_title' => __('LMM Options', 'lmm'),
                'page' => __('LMM Options', 'lmm'),
                'google_api_key' => 'AIzaSyBNsacnx37lZpIIyDyNAjGC1qdE7Z0CrEQ', // Must be defined to add google fonts to the typography module
                'global_variable' => 'lmm', // Set a different name for your global variable other than the opt_name
                'customizer' => false, // Enable basic customizer support
                'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
                'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
                'page_permissions' => 'edit_theme_options', // Permissions needed to access the options panel.
                'menu_icon' => LMM_URL . 'assets/backend/images/vlmm.png', // Specify a custom URL to an icon
//'last_tab' => 0, // Force your panel to always open to a specific tab (by id)
//'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
                'page_slug' => LMM_PANEL, // Page slug used to denote the panel
                'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
                'default_show' => false, // If true, shows the default value next to each field that is not the default value.
                'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
                'output_tag' => false, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
//'domain'         => 'redux-framework', // Translation domain key. Don't change this unless you want to retranslate all of Redux.
//'footer_credit'  => '', // Disable the footer credit of Redux. Please leave if you can help it.
// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
                'database' => '',
                // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
                'use_cdn' => true,
                'hints' => array(
                    'icon' => 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'dark',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '', //youtube',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                ),
                'show_import_export' => true, // REMOVE                
                'dev_mode' => LMM_DEV, // Show the time the page took to load, etc                 
                'dev_mode_icon' => 'lmm-database',
                'dev_mode_icon_class' => 'lmm-database',
                'system_info' => LMM_DEV, // REMOVE
                'ajax_save' => LMM_DEV ? false : true,
            );

// Panel Intro text -> before the form
            if (!isset($this->args['global_variable']) || $this->args['global_variable'] !== false) {
                if (!empty($this->args['global_variable'])) {
                    $v = $this->args['global_variable'];
                } else {
                    $v = str_replace("-", "_", $this->args['opt_name']);
                }
                $this->args['intro_text'] = sprintf('<p>%1$s <strong>%2$s</strong></p>', __('To access any of your saved options from within your code you can use your global variable:', 'lmm'), $v);
            } else {
                $this->args['intro_text'] = sprintf('<p>%s</p>', __('Thanks for buying LMM Menu!', 'lmm'));
            }

// Add content after the form.
            $this->args['footer_text'] = sprintf('<p>%s</p>', __('Thanks for buying LMM Menu!', 'lmm'));
        }

    }

    global $lmm_options;

    $lmm_options = new LMM_Options();
}