<?php

add_filter('lmm_nav_menu_css_class', 'lmm_nav_menu_css_class_prefix', 1, 1);

function lmm_nav_menu_css_class_prefix($classes) {

    $found = false;

    foreach ($classes as $i => $class) {

        if (!$found && $class == 'menu-item')
            $found = true;

        if (!$found || !$class || $class == 'open')
            continue;

        if (substr($class, 0, 4) == 'menu') {
            $classes[$i] = str_replace('menu', 'lmm', $class);
        } elseif (substr($class, 0, 3) != 'lmm' && substr($class, 0, 6) != 'hidden' && substr($class, 0, 4) != 'col-') {
            $classes[$i] = 'lmm-' . $class;
        }
    }

    return $classes;
}

function lmm_nav_menu_css_class($item, $args, $depth) {

    $classes = empty($item->classes) ? array() : (array) $item->classes;

    $classes[] = 'lmm-item-level-' . $depth;

    $classes[] = ($item->object == 'lmm') ? 'lmm-item-type-' . $item->lmm : '';

    $classes[] = ($args->has_dropdown) ? 'lmm-dropdown' : '';

    $classes[] = ($args->has_submenu) ? 'lmm-dropdown-submenu' : '';

    $classes[] = ($args->is_column_title) ? 'lmm-column-has-title' : '';

    $classes[] = (($args->is_mega || $args->is_tabs) && !$item->mega_columns) ? 'lmm-dropdown-full' : '';

    $classes[] = !empty($item->title) ? 'lmm-has-title' : '';

    $classes[] = !empty($item->icon) ? 'lmm-has-icon' : '';

    $classes[] = !empty($item->subtitle) ? 'lmm-has-subtitle' : '';

    $classes[] = !empty($item->description) ? 'lmm-has-description' : '';

    $classes[] = !empty($item->thumb) ? 'lmm-has-image-' . $item->thumb : '';

    $classes[] = !empty($item->mega_background_thumbnail_id) ? 'lmm-has-background' : '';

    $classes[] = !empty($item->dropdown) ? $item->dropdown : '';

    $classes[] = !empty($item->float) ? $item->float : '';

    $classes[] = !empty($item->hidden) && is_array($item->hidden) ? join(' ', array_map('sanitize_html_class', $item->hidden)) : '';

    $classes[] = !empty($item->options) ? $item->lmm . '-' . $item->options : '';

    $classes[] = !empty($args->is_column) && !empty($item->mega_sub_columns) ? esc_attr(str_replace(',', ' ', $item->mega_sub_columns)) : '';


    return apply_filters('lmm_nav_menu_css_class', $classes, $item, $args, $depth);
}

function lmm_nav_menu_link_attributes($item, $args, $depth) {

    $atts = array();

    $atts['title'] = !empty($item->attr_title) ? $item->attr_title : $item->title;

    $atts['target'] = !empty($item->target) ? $item->target : '';

    $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';

    $atts['href'] = !empty($item->url) ? $item->url : 'javascript:void(0)';

    if ($args->has_dropdown) {
        $atts['class'] = 'lmm-dropdown-toggle';
    }

    return apply_filters('lmm_nav_menu_link_attributes', $atts, $item, $args, $depth);
}

function lmm_nav_menu_start_el($item, $args, $depth, $atts) {

    $attributes = '';

    foreach ($atts as $attr => $value) {

        if (empty($value))
            continue;

        $value = filter_var($value, FILTER_VALIDATE_URL) ? esc_url($value) : esc_attr($value);

        $attributes .= ' ' . esc_attr($attr) . '="' . $value . '"';
    }

    $_caret = !empty($args->has_caret) ? '<span class="lmm-caret"></span>' : '';

    $_icon = !empty($item->icon) ? '<i class="' . esc_attr($item->icon) . '"></i>' : '';

    $_subtitle = (!empty($item->subtitle)) ? '<span class="lmm-subtitle">' . esc_attr($item->subtitle) . '</span>' : '';

    $_src = !empty($item->mega_background_thumbnail_id) ? wp_get_attachment_image_src($item->mega_background_thumbnail_id, 'full') : false;

    $_mega_thumbnail = is_array($_src) ? 'data-lmm-src="' . $_src[0] . '"' : '';

    $_mega_thumbnail .=!empty($item->mega_background_position) && is_array($_src) ? ' data-lmm-position="' . esc_attr($item->mega_background_position) . '"' : '';

    $_mega_thumbnail .=!empty($item->mega_background_repeat) && is_array($_src) ? ' data-lmm-repeat="' . esc_attr($item->mega_background_repeat) . '"' : '';

    $_mega_thumbnail .=!empty($item->mega_background_attachment) && is_array($_src) ? ' data-lmm-attachment="' . esc_attr($item->mega_background_attachment) . '"' : '';

    $_mega_thumbnail .=!empty($item->mega_background_size) && is_array($_src) ? ' data-lmm-size="' . esc_attr($item->mega_background_size) . '"' : '';

    $item_output = '<a' . $attributes . '>';

    $item_output .= '<span class="lmm-item-content">';

    $item_output .= $_caret . $_icon;

    $item_output .= $args->link_before;

    $item_output .= $item->title;

    $item_output .= $args->link_after;

    $item_output .= $_subtitle;

    $item_output .= '</span>';

    $item_output .= '</a>';

    // posts with thumbnail ----------------------------------------------------
    if ($args->is_post_type) {
        $item_output = '<a' . $attributes . '>';
        $item_output .= '<span class="lmm-item-content">';
        $item_output .= $item->thumb ? get_the_post_thumbnail($item->object_id, $item->thumb) : '';
        $item_output .= $_caret . $_icon . $item->title;
        $item_output .=!empty($item->description) ? '<span class="desc">' . esc_html($item->description) . '</span>' : '';
        $item_output .= '</span>';
        $item_output .= '<div class="clearfix"></div>';
        $item_output .= '</a>';
    }

    // login -------------------------------------------------------------------
    if ($args->is_login) {
        $item_output .= '<ul class="lmm-dropdown-menu" role="menu"><li class="clearfix">';
        $item_output .= lmm_loginform();
    }

    // search ------------------------------------------------------------------
    if ($args->is_search_dropdown) {
        $item_output .= '<ul class="lmm-dropdown-menu" role="menu"><li>';
        $item_output .= '<form role="search" method="get" id="searchform" action="' . esc_url(home_url('/')) . '">';
        $item_output .= '<div class="form-group">';
        $item_output .= $_icon;
        $item_output .= '<input type="text" id="s" class="form-control" name="s" value="' . get_search_query() . '" placeholder="' . __('Search the Site...', 'lmm') . '" />';
        $item_output .= '</div>';
        $item_output .= '</form>';
        $item_output .= '</li>';
        $item_output .= '</ul>';
    }

    /* if ($args->is_search_toggle) {
      $item_output .= '<div style="" class="hmenu_search_lightbox_input" id="hmenu_slide_1">';
      $item_output .= '<div class="hmenu_search_lightbox_close icon_hero_default_thin_e618"></div>';
      $item_output .= '<div class="hmenu_lightbox_form_holder"> ';
      $item_output .= '<form role="search" method="get" id="searchform" action="' . esc_url(home_url('/')) . '">';
      $item_output .= '<div class="form-group">';
      $item_output .= '<i class="fa fa-search"></i>';
      $item_output .= '<input type="text" id="s" class="hmenu_search_submit" name="s" value="' . get_search_query() . '" placeholder="' . __('Search the Site...', 'lmm') . '" />';
      $item_output .= '</div>';
      $item_output .= '</form>';
      $item_output .= '</div>';
      $item_output .= '</div>';
      } */

    if ($args->is_search_embed) {
        $item_output = '<form role="search" method="get" id="searchform" action="' . esc_url(home_url('/')) . '">';
        $item_output .= '<div class="form-group">';
        $item_output .= $_icon;
        $item_output .= '<input type="text" id="s" class="form-control" name="s" value="' . get_search_query() . '" placeholder="' . __('Search the Site...', 'lmm') . '" />';
        $item_output .= '</div>';
        $item_output .= '</form>';
    }

    // social -------------------------------------------------------------------
    if ($args->is_social_toggle) {
        $item_output .= '<span class="toggle-container">';
        $item_output .= lmm_getnetworks();
        $item_output .= '</span>';
    }

    if ($args->is_social_embed) {
        $item_output = '<span class="toggle-container">';
        $item_output .= lmm_getnetworks();
        $item_output .= '</span>';
    }

    // woo cart ----------------------------------------------------------------
    if ($args->is_cart_woo) {

        global $woocommerce;

        $item_output = '<a' . $attributes . ' data-cart-url="' . esc_url($woocommerce->cart->get_cart_url()) . '" data-cart-qty="' . esc_attr($woocommerce->cart->cart_contents_count) . '">' . $_caret;
        $item_output .= '<span class="lmm-item-content">';
        $item_output .= '<span class="cart_magic">';
        $item_output .= $_icon;
        $item_output .= '<span class="cart_total">' . $woocommerce->cart->get_cart_total() . '</span>';
        $item_output .= '<span class="cart_qty">' . $woocommerce->cart->cart_contents_count . '</span>';
        $item_output .= '</span>';
        $item_output .= $_subtitle;
        $item_output .= '</span>';
        $item_output .= '</a>';
        $item_output .= '<ul class="lmm-dropdown-menu" role="menu"><li class="clearfix">';

        ob_start();

        the_widget('WC_Widget_Cart', 'title=Your cart', 'before_title=<h4 class="menutitle">&after_title=</h4>');

        $item_output .= ob_get_clean();
    }
    // edd cart ----------------------------------------------------------------
    if ($args->is_cart_edd) {
        $item_output = '<a' . $attributes . ' data-cart-qty="' . esc_attr(edd_get_cart_quantity()) . '">' . $_caret;
        $item_output .= '<span class="lmm-item-content">';
        $item_output .= '<span class="cart_magic">';
        $item_output .= $_icon;
        $item_output .= '<span class="cart_total">' . edd_currency_filter(edd_format_amount(edd_get_cart_subtotal())) . '</span>';
        $item_output .= '<span class="cart_qty">' . edd_get_cart_quantity() . '</span>';
        $item_output .= '</span>';
        $item_output .= $_subtitle;
        $item_output .= '</span>';
        $item_output .= '</a>';
        $item_output .= '<ul class="lmm-dropdown-menu" role="menu"><li class="clearfix">';

        ob_start();

        the_widget('edd_cart_widget', 'title=Your cart', 'before_title=<h4 class="menutitle">&after_title=</h4>');

        $item_output .= ob_get_clean();
    }

    // mega --------------------------------------------------------------------
    if ($args->is_mega || $args->is_tabs) {
        $item_output .= '<ul class="lmm-dropdown-menu ' . esc_attr(str_replace(',', ' ', $item->mega_columns)) . '" ' . $_mega_thumbnail . ' role="menu"><li class="clearfix">';
    }

    // column ------------------------------------------------------------------
    if ($args->is_column) {
        $item_output = '';
        $item_output .= $args->is_column_title ? '<h4 class="menutitle">' . $item->title . '</h4>' : '';
    }
    // column alert ------------------------------------------------------------
    if ($args->is_column && !$item->mega_sub_columns) {
        $item_output .= '<div class="alert alert-danger">' . __('Please define sub column width.', 'lmm') . '</div>';
    }

    // widget ------------------------------------------------------------------
    if ($args->is_widget && $item->mega_sidebar) {
        $item_output = lmm_getsidebar($item->mega_sidebar);
    }

    // widget alert ------------------------------------------------------------
    if ($args->is_widget && !$item->mega_sidebar) {
        $item_output = '<div class="alert alert-danger">' . __('Please select widget sidebar.', 'lmm') . '</div>';
    }

    return apply_filters('lmm_nav_menu_start_el', $item_output, $item, $args, $depth, $atts);
}

function lmm_nav_menu_end_el($item, $args, $depth) {

    $item_output = '';

    if (0 === $depth && in_array($item->lmm, array('lmm-mega', 'lmm-tabs'))) {
        $item_output = '</li></ul>';
    }

    if (0 === $depth && $item->lmm == 'lmm-cart' && (class_exists('Woocommerce') || class_exists('Easy_Digital_Downloads'))) {
        $item_output = '</li></ul>';
    }

    if (0 === $depth && $item->lmm == 'lmm-login' && !is_user_logged_in()) {
        $item_output = '</li></ul>';
    }

    return apply_filters('lmm_nav_menu_end_el', $item_output, $item, $args, $depth);
}

class lmm_navwalker extends Walker_Nav_Menu {

    public function start_lvl(&$output, $depth = 0, $args = array()) {

        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"lmm-dropdown-menu\" role=\"menu\">\n";
    }

    public function end_lvl(&$output, $depth = 0, $args = array()) {

        $indent = str_repeat("\t", $depth);

        $output .= "\n$indent</ul>\n";
    }

    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {

        $indent = ( $depth ) ? str_repeat("\t", $depth) : '';

        $classes = 'class="' . join(' ', array_map('esc_attr', array_filter(lmm_nav_menu_css_class($item, $args, (int) $depth)))) . '"';

        $output .= '<li ' . $classes . '>';

        $atts = lmm_nav_menu_link_attributes($item, $args, (int) $depth);

        $output .= lmm_nav_menu_start_el($item, $args, (int) $depth, $atts);
    }

    public function end_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {

        $output .= lmm_nav_menu_end_el($item, $args, (int) $depth);

        $output .= '</li>'; // . "\n";
    }

    /**
     * Traverse elements to create list from elements.
     *
     * Display one element if the element doesn't have any children otherwise,
     * display the element and its children. Will only traverse up to the max
     * depth and no ignore elements under that depth.
     *
     * This method shouldn't be called directly, use the walk() method instead.
     *
     * @see Walker::start_el()
     * @since 2.5.0
     *
     * @param object $element Data object
     * @param array $children_elements List of elements to continue traversing.
     * @param int $max_depth Max depth to traverse.
     * @param int $depth Depth of current element.
     * @param array $args
     * @param string $output Passed by reference. Used to append additional content.
     * @return null Null on failure with no changes to parameters.
     */
    public function display_element($element, &$children_elements, $max_depth, $depth, $args, &$output) {
        if (!$element)
            return;

        $id_field = $this->db_fields['id'];

        // Display this element.
        if (is_object($args[0])) {

            if (0 < $depth) {
                $element->float = '';
                $element->hidden = '';
            }

            $args[0]->has_children = (!empty($children_elements[$element->$id_field]) && !in_array($element->lmm, array('widget', 'column')));

            $args[0]->has_dropdown = $args[0]->has_children;

            $args[0]->has_caret = $args[0]->has_children;

            $args[0]->has_submenu = (0 < $depth && $args[0]->has_dropdown);

            // is icon ---------------------------------------------------------
            if ($args[0]->is_icon = (0 === $depth && $element->lmm == 'lmm-icon')) {
                $element->title = '';
                $element->icon = !$element->icon ? 'fa fa-exclamation-circle' : $element->icon;
            }

            // is mega menu ----------------------------------------------------
            if ($args[0]->is_mega = (0 === $depth && $element->lmm === 'lmm-mega')) {
                $element->url = '';
            }

            // is tabs menu ----------------------------------------------------
            if ($args[0]->is_tabs = (0 === $depth && $element->lmm === 'lmm-tabs')) {
                $element->url = '';
            }

            // is search form --------------------------------------------------
            if ($args[0]->is_search_dropdown = (0 === $depth && $element->lmm == 'lmm-search') && !empty($element->options)) {
                $args[0]->has_children = false;
                $args[0]->has_caret = false;
                $element->url = '';
                $element->title = '';
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-search';
                $args[0]->has_dropdown = true;
            }

            if ($args[0]->is_search_embed = (0 === $depth && $element->lmm == 'lmm-search') && empty($element->options)) {
                $args[0]->has_children = false;
                $args[0]->has_caret = false;
                $element->url = '';
                $element->title = '';
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-search';
            }

            // is social icon --------------------------------------------------
            if ($args[0]->is_social_toggle = (0 === $depth && $element->lmm == 'lmm-social') && !empty($element->options)) {
                $args[0]->has_children = false;
                $args[0]->has_caret = false;
                $element->url = '';
                $element->title = '';
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-share-alt';
                $args[0]->has_dropdown = true;
            }

            if ($args[0]->is_social_embed = (0 === $depth && $element->lmm == 'lmm-social') && empty($element->options)) {
                $args[0]->has_children = false;
                $args[0]->has_caret = false;
                $element->url = '';
                $element->title = '';
            }

            // is woocommerce cart ---------------------------------------------
            if ($args[0]->is_cart_woo = (0 === $depth && $element->lmm == 'lmm-cart' && class_exists('Woocommerce') && empty($element->options))) {

                global $woocommerce;

                $args[0]->has_children = true;
                $args[0]->has_caret = true;
                $args[0]->has_dropdown = !is_cart() ? true : false; //$woocommerce->cart->cart_contents_count > 0 && !is_cart() ? true : false;
                $element->url = $woocommerce->cart->cart_contents_count > 0 && !is_cart() ? esc_url($woocommerce->cart->get_cart_url()) : esc_url(get_permalink(woocommerce_get_page_id('shop')));
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-shopping-cart';
            }

            // is edd cart -----------------------------------------------------
            if ($args[0]->is_cart_edd = (0 === $depth && $element->lmm == 'lmm-cart' && class_exists('Easy_Digital_Downloads') && !$args[0]->is_cart_woo)) {
                $args[0]->has_children = true;
                $args[0]->has_dropdown = !edd_is_checkout() ? true : false; //edd_get_cart_quantity() > 0 && !edd_is_checkout() ? true : false;
                $args[0]->has_caret = true;
                $element->url = esc_url(edd_get_checkout_uri());
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-shopping-cart';
            }

            // is login form ---------------------------------------------------
            if ($args[0]->is_login = (0 === $depth && $element->lmm == 'lmm-login' && !is_user_logged_in())) {
                $args[0]->has_children = true;
                $args[0]->has_dropdown = true;
                $args[0]->has_caret = true;
                $element->url = '';
                $element->icon = !empty($element->icon) ? $element->icon : 'fa fa-user';
            }

            // user is logged in -----------------------------------------------
            if ($args[0]->is_loggedin = (0 === $depth && $element->lmm == 'lmm-login' && is_user_logged_in())) {

                global $wp;

                $args[0]->has_children = false;
                $element->url = wp_logout_url(home_url(add_query_arg(array(), $wp->request)));
                $element->title = __('Log Out', 'lmm');
                $element->icon = 'fa fa-power-off';
            }

            //is column --------------------------------------------------------
            $args[0]->is_column_title = false;

            if ($args[0]->is_column = ((1 === $depth || 2 === $depth) && $element->lmm == 'column')) {
                $args[0]->is_column_title = !empty($element->title) && $element->title != 'Column';
            }

            //is widget --------------------------------------------------------
            $args[0]->is_widget = ((2 === $depth || 3 === $depth) && $element->lmm === 'widget');

            //is post ----------------------------------------------------------
            $args[0]->is_post_type = (0 < $depth && strcasecmp($element->type, 'post_type') == 0);
        }

        parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
    }

    /**
     * Menu Fallback
     * =============
     * If this function is assigned to the wp_nav_menu's fallback_cb variable
     * and a manu has not been assigned to the theme location in the WordPress
     * menu manager the function with display nothing to a non-logged in user,
     * and will add a link to the WordPress menu manager if logged in as an admin.
     *
     * @param array $args passed from the wp_nav_menu function.
     *
     */
    public static function fallback($args) {

        if (!current_user_can('manage_options'))
            return;

        global $_wp_registered_nav_menus;

        extract($args);

        $items = '<li class="lmm-item lmm-item-level-0 lmm-float-opposite lmm-has-subtitle"><a href="' . admin_url('nav-menus.php') . '"><span class="lmm-item-content">' . sprintf(__('Add a menu to %1$s', 'lmm'), $_wp_registered_nav_menus[$theme_location]) . '</span></a></li>';

        $output = sprintf($items_wrap, esc_attr($menu_id), esc_attr($menu_class), $items);

        echo $output;
    }

}
