<?php
if (defined('LMM_METABOXES') && LMM_METABOXES === FALSE)
    return;

// Little function to return a custom field value
function lmm_get_custom_field($value) {
    global $post;

    $custom_field = get_post_meta($post->ID, $value, true);
    if (!empty($custom_field))
        return is_array($custom_field) ? stripslashes_deep($custom_field) : stripslashes(wp_kses_decode_entities($custom_field));

    return false;
}

// Register the Metabox
function lmm_add_custom_meta_box() {
    add_meta_box('wpshed-meta-box', __('LMM Menu', 'textdomain'), 'lmm_meta_box_output', 'post', 'side', 'high');
    add_meta_box('wpshed-meta-box', __('LMM Menu', 'textdomain'), 'lmm_meta_box_output', 'page', 'side', 'high');
}

add_action('add_meta_boxes', 'lmm_add_custom_meta_box');

// Output the Metabox
function lmm_meta_box_output($post) {
    // create a nonce field
    wp_nonce_field('my_lmm_meta_box_nonce', 'lmm_meta_box_nonce');
    ?>

    <p>
        <?php echo lmm_select_menus(); ?>
    </p>

    <p>
        <?php _e('Change the theme location for the first menu.', 'lmm'); ?>
    </p>


    <?php
}

// Save the Metabox values
function lmm_meta_box_save($post_id) {
    // Stop the script when doing autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

    // Verify the nonce. If insn't there, stop the script
    if (!isset($_POST['lmm_meta_box_nonce']) || !wp_verify_nonce($_POST['lmm_meta_box_nonce'], 'my_lmm_meta_box_nonce'))
        return;

    // Stop the script if the user does not have edit permissions
    if (!current_user_can('edit_posts'))
        return;

    // Save the textfield
    if (!empty($_POST['lmm_location']))
        update_post_meta($post_id, 'lmm_location', esc_attr($_POST['lmm_location']));
    else 
        delete_post_meta($post_id, 'lmm_location');
}

add_action('save_post', 'lmm_meta_box_save');
