<?php

// lmm integration auto --------------------------------------------------------

add_filter('wp_nav_menu_args', 'lmmmenu_auto_args', 100000, 1);

function lmmmenu_auto_args($args) {

//get the args -------------------------------------------------------------
    $args = lmm_get_nav_menu_args($args, 'auto');

    if (!empty($args['instance_filters'])) {
        remove_all_filters('wp_nav_menu_items', 60);
        remove_all_filters('wp_nav_menu_args', 60);
    }

    return $args;
}

// lmm menu manual -------------------------------------------------------------

function lmmmenu($args = array()) {

    remove_filter('wp_nav_menu_args', 'lmmmenu_auto_args', 100000);

    $args = lmm_get_nav_menu_args($args, 'manual');

    return wp_nav_menu($args);
}

// lmm shortcode ---------------------------------------------------------------

function lmmmenu_shortcode($atts = array()) {
    extract(shortcode_atts(
                    array(
        'echo' => 'true',
        'allow_metaboxes' => 'false',
        'theme_location' => '',
                    ), $atts
            )
    );

    $args = array(
        'echo' => $echo == 'false' ? false : true,
        'allow_metaboxes' => $allow_metaboxes == 'false' ? false : true,
        'theme_location' => $theme_location,
        'sticky' => 0,
    );

    return lmmmenu($args);
}

add_shortcode('lmmmenu', 'lmmmenu_shortcode');

function lmm_get_nav_menu_args($args = array(), $method = false) {

    global $lmm_locations;
    
    static $menu = 0;

    $menu++;

//do not repeat please -----------------------------------------------------
    if (!empty($args['menu_instance']))
        return $args;

    $defaults = array(
        'echo' => true,
        'menu_mode' => false,
        'theme_location' => '',
        'menu_instance' => '',
        'allow_metaboxes' => true//$method == 'manual' ? true : false,
    );

    $args = wp_parse_args($args, $defaults);

// lmm instance ------------------------------------------------------------

    $location = lmm_theme_location($args['theme_location'], $menu, $args['allow_metaboxes']);

    $instance = isset($lmm_locations[$location]) ? $lmm_locations[$location] : false;

//return alert if method is manual and we have no instance or is inactive
    if ($method == 'manual' && (!$instance || !$instance['instance'])) {

        $args['location'] = $args['theme_location'];
        $args['theme_location'] = 'fewfwfwfwfwfwe'; //allways callback
        $args['fallback_cb'] = 'lmm_layout_alert';

        return $args;
    }

// return args if method is not manual
// and we have no active locations | instance is not active | instance integration is manual
    if ($method != 'manual' && (!$instance || !$instance['instance'] || $instance['integration'] != 'auto')) {
        return $args;
    }

// lmm args ----------------------------------------------------------------

    $args['theme_location'] = $location;

    $args['menu_instance'] = $instance['instance'];

    //$args['instance_active'] = $instance['active'];

    $args['instance_style'] = $instance['style'];

    $args['instance_integration'] = $instance['integration'];

    $args['instance_filters'] = $instance['filters'];

    $args['menu_mode'] = lmm_menu_mode($args['menu_instance'], $args['menu_mode']);

// wp args -----------------------------------------------------------------

    $args['items_wrap'] = call_user_func($args['menu_mode'], $args['menu_instance'], $menu);

    $args['menu_class'] = lmm_menu_class($args['menu_instance']);

    $args['container'] = false;

    $args['walker'] = new lmm_navwalker();

    $args['menu_id'] = 'lmm';

    $args['fallback_cb'] = 'lmm_navwalker::fallback';

    do_action('lmm_get_nav_menu_args', $args);

    return $args;
}

function lmm_theme_location($location = '', $menu = 1, $metaboxes = true) {

    global $post, $lmm_locations;
    //
    // is not the first menu ---------------------------------------------------    
    if ($menu !== 1)
        return $location;

    // metaboxes are deactivated by the developer ------------------------------    
    if (\defined('LMM_METABOXES') && LMM_METABOXES === FALSE)
        return $location;

    // allow_metaboxes is false ------------------------------------------------    
    if (!$metaboxes)
        return $location;

    // location is not active --------------------------------------------------    
    if (empty($lmm_locations[$location]['instance']))
        return $location;

    // this isnt a post or metaboxes is not defined ----------------------------    
    if (empty($post->ID) || !get_post_meta($post->ID, 'lmm_location', true))
        return $location;

    if (get_post_meta($post->ID, 'lmm_location', true))
        return get_post_meta($post->ID, 'lmm_location', true);

    return $location;
}

function lmm_menu_mode($instance = false, $mode = false) {

    if ($mode && function_exists($mode)) {
        return $mode;
    }

    global $lmm;

    if (!$instance || !isset($lmm[$instance . '_navbar_mode']))
        return false;

    $mode = 'lmm_' . $lmm[$instance . '_navbar_mode'] . '_' . $lmm[$instance . '_navbar_mode_' . $lmm[$instance . '_navbar_mode']];

    if ($mode && function_exists($mode)) {
        return $mode;
    } else {
        return false;
    }
}

function lmm_menu_class($instance = false) {

    global $lmm;

    if (!$instance || !isset($lmm[$instance . '_navbar_classes']))
        return;

    $classes = $lmm[$instance . '_navbar_classes'];

    $classes .=!empty($lmm[$instance . '_navbar_mode_horizontal_align']) ? ' lmm-align-items-' . $lmm[$instance . '_navbar_mode_horizontal_align'] : '';

//$classes .=!empty($lmm[$instance . '_navbar_caret']) ? ' ' . $lmm[$instance . '_navbar_caret'] : '';

    $classes .=!empty($lmm[$instance . '_navbar_trigger']) ? ' ' . $lmm[$instance . '_navbar_trigger'] : '';

    $classes .=!empty($lmm[$instance . '_navbar_separator']) ? ' ' . $lmm[$instance . '_navbar_separator'] : '';

    $classes .=!empty($lmm[$instance . '_navbar_hover_effect']) ? ' ' . $lmm[$instance . '_navbar_hover_effect'] : '';

    $classes .=!empty($lmm[$instance . '_navbar_caret']) ? ' ' . $lmm[$instance . '_navbar_caret'] : '';

    $classes .=!empty($lmm[$instance . '_dropdown_triangle']) ? ' ' . $lmm[$instance . '_dropdown_triangle'] : '';

    $classes .=!empty($lmm[$instance . '_dropdown_animation']) ? ' ' . $lmm[$instance . '_dropdown_animation'] : '';

    return $classes;
}
