<?php
// add meta  -------------------------------------------------------------------
add_action('wp_head', 'lmm_meta');

function lmm_meta() {

    global $lmm;

    if (empty($lmm['lmm_viewport']))
        return;
    ?>

    <meta name="viewport" content="initial-scale=1.0">

    <?php
}

// register scripts ------------------------------------------------------------
add_action('wp_enqueue_scripts', 'lmm_scripts', 1);

function lmm_scripts() {

    global $lmm;

    wp_register_script('lmm', LMM_URL . 'assets/frontend/js/lmm.min.js', array('jquery', 'hoverIntent'), false, true);
    wp_register_script('lmm-bootstrap', LMM_URL . 'assets/frontend/js/bootstrap.min.js', array('jquery'), '', true);
    wp_register_script('lmm-pscrollbar', LMM_URL . 'assets/frontend/pscrollbar/perfect-scrollbar.jquery.min.js', array('jquery'), false, true);
    wp_register_script('lmm-jasny', LMM_URL . 'assets/frontend/js/jasny-bootstrap.min.js', array('jquery', 'lmm-bootstrap'), false, true);

    //enqueue
    if ($lmm['lmm_styles_bootstrap']) {
        wp_enqueue_script('lmm-bootstrap');
    }

    if ($lmm['lmm_styles_pscrollbar']) {
        wp_enqueue_script('lmm-pscrollbar');
    }

    wp_enqueue_script('lmm');

    wp_localize_script('lmm', 'lmm', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'registered' => __('Your submission is complete.', 'lmm'),
        'breakpoint' => $lmm['scheme_lmm_navbar_breakpoint'],
        'gutter' => $lmm['scheme_lmm_container_gutter']
    ));
}

// register scripts ------------------------------------------------------------
add_action('wp_enqueue_scripts', 'lmm_styles', 9999);

function lmm_styles() {

    global $lmm, $lmm_icons;

    //register -----------------------------------------------------------------    
    wp_register_style('lmm-normalize', LMM_URL . 'assets/frontend/css/lmm_normalize.min.css', array(), '', 'all');
    wp_register_style('lmm-menu', LMM_URL_CSS . 'lmm.css', array(), false, 'all');
    wp_register_style('lmm-locations', LMM_URL_CSS . 'lmm_locations.css', array(), false, 'all');
    wp_register_style('lmm-bootstrap', LMM_URL_CSS . 'lmm_bootstrap.css', array(), false, 'all');
    wp_register_style('lmm-widgets', LMM_URL_CSS . 'lmm_widgets.css', array(), false, 'all');
    wp_register_style('lmm-pscrollbar', LMM_URL . 'assets/frontend/pscrollbar/perfect-scrollbar.min.css', array(), '', 'all');

    //enqueue ------------------------------------------------------------------
    if (empty($lmm['lmm_styles']))
        return;

    if ($lmm['lmm_styles_pscrollbar']) {
        wp_enqueue_style('lmm-pscrollbar');
    }

    if (!empty($lmm['lmm_styles_icons'])) {
        wp_register_style('lmm-icons', $lmm_icons[$lmm['lmm_styles_icons']]['url']);
        wp_enqueue_style('lmm-icons');
    }

    if (!empty($lmm['lmm_styles_normalize'])) {
        wp_enqueue_style('lmm-normalize');
    }

    if (!empty($lmm['lmm_styles_bootstrap'])) {
        wp_enqueue_style('lmm-bootstrap');
    }

    if (!empty($lmm['lmm_styles_widgets'])) {
        wp_enqueue_style('lmm-widgets');
    }

    wp_enqueue_style('lmm-menu');


    // if we're in the preview mode and customizer is active, less.js will take care
    if (is_customize_preview() && (\defined('LMM_CUSTOMIZER') && LMM_CUSTOMIZER === FALSE))
        return;

    wp_enqueue_style('lmm-locations');
}

// register sidebars -----------------------------------------------------------
add_action('init', 'lmm_register_sidebars', 500);

function lmm_register_sidebars($sidebars = false) {

    global $lmm;

    if (empty($lmm['lmm_widgets']) && !$sidebars)
        return;

    $args = apply_filters('lmm_hook_register_sidebars', array(
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="menutitle">',
        'after_title' => '</h4>'
    ));

    $sidebars = $sidebars ? $sidebars : $lmm['lmm_widgets'];

    foreach ($lmm['lmm_widgets'] as $id => $name) {

        if (empty($name))
            continue;

        $args['id'] = sanitize_key($id);

        $args['name'] = esc_attr($name);

        register_sidebar($args);
    }
}

// get sidebars ----------------------------------------------------------------
function lmm_getsidebar($id) {

    global $wp_registered_sidebars;

    if (!array_key_exists($id, $wp_registered_sidebars))
        return '<div class="alert alert-danger">' . sprintf(__('The sidebar <code>%1$s</code> is not registered.', 'lmm'), $id) . '</div>';

    if (!function_exists('dynamic_sidebar'))
        return;

    ob_start();

    dynamic_sidebar($id);

    $output = ob_get_clean();

    if ($output) {
        return $output;
    } else {
        return '<div class="alert alert-info">' . sprintf(__('Please include a widget in the sidebar <a href="%2$s" target="_blank">%1$s</a>', 'lmm'), $wp_registered_sidebars[$id]['name'], admin_url('widgets.php#' . $id)) . '</div>';
    }
}

// get social networks ---------------------------------------------------------
function lmm_getnetworks($networks = '') {


    global $lmm;

    if (empty($lmm['lmm_social']))
        return sprintf('<a href="%2$s" title="%1$s">%1$s</a>', __('Add your social networks', 'lmm'), lmm_taburl('11'));

    foreach ($lmm['lmm_social'] as $network) {
        $networks .='<a href="' . $network['url'] . '" target="_blank" title="' . $network['title'] . '">';
        $networks .='<i class="' . $network['icon'] . '"></i>';
        $networks .='</a>';
    }


    return $networks;
}

// mega types ------------------------------------------------------------------
add_action('init', 'lmm_get_mega_item_types', 500);

function lmm_get_mega_item_types($items = array()) {

    global $lmm_elements;

    $lmm_elements['custom'] = array(
        'lmm' => false,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
        ),
    );

    $lmm_elements['taxonomy'] = array(
        'lmm' => false,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
        ),
    );


    $lmm_elements['post_type'] = array(
        'lmm' => false,
        'fields' => array(
            'icon' => true,
            //'subtitle' => false,
            'thumb' => array(
                '' => __('None', 'lmm'),
                'thumbnail' => __('Thumb', 'lmm'),
                'medium' => __('Large', 'lmm'),
            ),
        ),
    );

    // lmm items ---------------------------------------------------------------

    $lmm_elements['lmm-mega'] = array(
        'lmm' => true,
        'url' => '#lmm-mega',
        'label' => __('LMM Mega', 'lmm'),
        'title' => __('Mega', 'lmm'),
        'desc' => __('A row which can wrap any type of widget.', 'lmm'),
        'columns' => '',
        'subitem' => 'column',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
            'columns' => true,
            'background' => true,
        ),
    );
    $lmm_elements['lmm-tabs'] = array(
        'lmm' => true,
        'url' => '#lmm-tabs',
        'label' => __('LMM Tabs', 'lmm'),
        'title' => __('Tabs', 'lmm'),
        'desc' => __('A tab menu which can wrap any type of widget.', 'lmm'),
        'columns' => '',
        'subitem' => 'tab',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
            'columns' => true,
            'background' => true,
        ),
    );

    $lmm_elements['lmm-icon'] = array(
        'lmm' => true,
        'url' => 'http://',
        'label' => __('LMM Icon', 'lmm'),
        'title' => __('Icon', 'lmm'),
        'desc' => __('Just an icon, no title.', 'lmm'),
        'columns' => '',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'float' => true,
            'dropdown_align' => true
        ),
    );
    $lmm_elements['lmm-search'] = array(
        'lmm' => true,
        'url' => '#lmm-search',
        'label' => __('LMM Search', 'lmm'),
        'title' => __('Search', 'lmm'),
        'desc' => __('A search form for the site.', 'lmm'),
        'columns' => '',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'float' => true,
            'dropdown_align' => true,
            'options' => array(
                '' => __('Embed', 'lmm'),
                'dropdown' => __('Dropdown', 'lmm'),
            ),
        ),
    );
    $lmm_elements['lmm-social'] = array(
        'lmm' => true,
        'url' => '#lmm-social',
        'label' => __('LMM Social', 'lmm'),
        'title' => __('Social', 'lmm'),
        'desc' => __('Icon list of your social networks.', 'lmm'),
        'columns' => '',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'float' => true,
            'options' => array(
                '' => __('Embed', 'lmm'),
                'toggle' => __('Toggle', 'lmm'),
            ),
        ),
    );
    $lmm_elements['lmm-login'] = array(
        'lmm' => true,
        'url' => '#lmm-login',
        'label' => __('LMM Login', 'lmm'),
        'title' => __('Login', 'lmm'),
        'desc' => __('A login and register widget for your users.', 'lmm'),
        'columns' => '',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'icon_logout' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
        ),
    );

    // subitems ----------------------------------------------------------------

    $lmm_elements['tab'] = array(
        'lmm' => true,
        'url' => '#tab',
        'label' => __('Tab', 'lmm'),
        'title' => __('Tab', 'lmm'),
        'desc' => __('Tab for LMM Tabs.', 'lmm'),
        'columns' => '',
        'subitem' => 'column',
        'depth' => 1,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
        ),
    );

    $lmm_elements['column'] = array(
        'lmm' => true,
        'url' => '#column',
        'label' => __('Column', 'lmm'),
        'title' => __('Column', 'lmm'),
        'desc' => __('Column for the LMM Mega.', 'lmm'),
        'columns' => '3',
        'subitem' => 'widget',
        'depth' => 1,
        'fields' => array(
            'icon' => true,
            'sub_columns' => true,
        ),
    );

    $lmm_elements['widget'] = array(
        'lmm' => true,
        'url' => '#widget',
        'label' => __('Widget', 'lmm'),
        'title' => __('Widget', 'lmm'),
        'desc' => __('Widget for the LMM Mega.', 'lmm'),
        'columns' => '',
        'depth' => 2,
        'fields' => array('widget' => true),
    );

    $lmm_elements = apply_filters('lmm_hook_get_mega_item_types', $lmm_elements);

    if (!class_exists('Woocommerce') && !class_exists('Easy_Digital_Downloads')) {
        return $lmm_elements;
    }

    $lmm_elements['lmm-cart'] = array(
        'lmm' => true,
        'url' => '#lmm-cart',
        'label' => __('LMM Cart', 'lmm'),
        'title' => __('Cart', 'lmm'),
        'desc' => __('A cart widget for Woocommerce or EDD.', 'lmm'),
        'columns' => '',
        'depth' => 0,
        'fields' => array(
            'icon' => true,
            'subtitle' => true,
            'float' => true,
            'dropdown_align' => true,
        ),
    );

    if (class_exists('Woocommerce') && class_exists('Easy_Digital_Downloads')) {
        $lmm_elements['lmm-cart']['fields']['options'] = array(
            '' => __('WooCommerce Cart', 'lmm'),
            'edd' => __('Easy Digital Downloads', 'lmm'),
        );
    }

    return $lmm_elements;
}

// add values ------------------------------------------------------------------
add_filter('wp_setup_nav_menu_item', 'lmm_custom_nav_item');

function lmm_custom_nav_item($item) {

    global $wp_post_types, $lmm_elements;

    //if (!in_array($item->type, array('custom', 'post_type')))
    //return $item;

    $item->lmm = get_post_meta($item->ID, LMM . '_menu_item_lmm', true);
    $item->icon = get_post_meta($item->ID, LMM . '_menu_item_icon', true);
    $item->subtitle = get_post_meta($item->ID, LMM . '_menu_item_subtitle', true);
    $item->float = get_post_meta($item->ID, LMM . '_menu_item_float', true);
    $item->options = get_post_meta($item->ID, LMM . '_menu_item_options', true);
    $item->dropdown = get_post_meta($item->ID, LMM . '_menu_item_dropdown', true);
    $item->hidden = get_post_meta($item->ID, LMM . '_menu_item_hidden', true);
    $item->mega_background_thumbnail_id = get_post_meta($item->ID, LMM . '_menu_item_mega_background_thumbnail_id', true);
    $item->mega_background_position = get_post_meta($item->ID, LMM . '_menu_item_mega_background_position', true);
    $item->mega_background_repeat = get_post_meta($item->ID, LMM . '_menu_item_mega_background_repeat', true);
    $item->mega_background_attachment = get_post_meta($item->ID, LMM . '_menu_item_mega_background_attachment', true);
    $item->mega_background_size = get_post_meta($item->ID, LMM . '_menu_item_mega_background_size', true);
    $item->mega_columns = get_post_meta($item->ID, LMM . '_menu_item_mega_columns', true);
    $item->mega_sub_columns = get_post_meta($item->ID, LMM . '_menu_item_mega_sub_columns', true);
    $item->mega_sidebar = get_post_meta($item->ID, LMM . '_menu_item_mega_sidebar', true);
    $item->thumb = get_post_meta($item->ID, LMM . '_menu_item_thumb', true);

    $item->is_lmm = !empty($lmm_elements[$item->lmm]['lmm']);

    $item->lmm = $item->lmm ? $item->lmm : $item->type;

    $item->object = $item->is_lmm ? 'lmm' : $item->object;

    // is admin ----------------------------------------------------------------

    if (is_admin() && !empty($lmm_elements[$item->lmm])) {
        $item->admin = $lmm_elements[$item->lmm];
    }

    if (is_admin() && $item->is_lmm) {
        $item->admin_subitem = false;
        $item->type_label = $item->admin['label'];
    }

    // is lmm and has subitem --------------------------------------------------
    if (isset($item->admin['subitem'])) {
        $item->admin_subitem = $lmm_elements[$item->admin['subitem']];
    }

    return $item;
}
