<?php

function lmm_compiler($lmm) {

    global $lmm_locations;

    define('LMM_PATH_LESS', apply_filters('lmm_hook_less_folder', LMM_PATH . '/assets/frontend/less'));

    if (empty($lmm)) {
        lmm_add_admin_notice('error', sprintf(__('We can`t create the stylesheets, please go to <a href="%s">LMM Options</a> and press the Reset All button.', 'lmm'), lmm_taburl('0')));
        set_transient('lmm_saved_redirect', true, 30);
        return;
    }

    // create bootstrap style --------------------------------------------------
    if (!empty($lmm['lmm_styles_bootstrap'])) {

        $bootstrap = lmm_get_contents(LMM_PATH_LESS . '/lmm_bootstrap.less');

        if (!is_wp_error($bootstrap)) {
            $bootstrap = str_replace(
                    array(
                '@grid-float-breakpoint-max',
                '@grid-float-breakpoint',
                '@gutter',
                '@screen-md-min',
                '@screen-sm-max',
                '@screen-lg-min',
                '@screen-md-max',
                '@container-sm',
                '@container-md',
                '@container-lg',
                    ), array(
                $lmm['scheme_lmm_navbar_breakpoint'] - 1 . 'px',
                $lmm['scheme_lmm_navbar_breakpoint'] . 'px',
                $lmm['scheme_lmm_container_gutter'] * 0.5 . 'px',
                $lmm['scheme_lmm_screen_md_width'] . 'px',
                $lmm['scheme_lmm_screen_md_width'] - 1 . 'px',
                $lmm['scheme_lmm_screen_lg_width'] . 'px',
                $lmm['scheme_lmm_screen_lg_width'] - 1 . 'px',
                $lmm['scheme_lmm_container_small_width'] + $lmm['scheme_lmm_container_gutter'] . 'px',
                $lmm['scheme_lmm_container_medium_width'] + $lmm['scheme_lmm_container_gutter'] . 'px',
                $lmm['scheme_lmm_container_large_width'] + $lmm['scheme_lmm_container_gutter'] . 'px',
                    ), $bootstrap
            );

            lmm_save_file('lmm_bootstrap.css', LMM_PATH_CSS, $bootstrap);
        }
    }

    // create widgets style ----------------------------------------------------
    if (!empty($lmm['lmm_styles_widgets'])) {

        $widgets = lmm_less_css(LMM_PATH_LESS . '/lmm_widgets.less', $lmm);

        if (!is_wp_error($widgets)) {
            lmm_save_file('lmm_widgets.css', LMM_PATH_CSS, $widgets);
        }
    }

    // create lmm style --------------------------------------------------------
    $css = '';

    if (!empty($lmm['lmm_styles'])) {
        $menu = lmm_less_css(LMM_PATH_LESS . '/lmm.less', $lmm);

        if (!is_wp_error($menu))
            $css = $menu;
    }

    if (!is_wp_error($css)) {
        $css .= $lmm['lmm_css'];
    }

    lmm_save_file('lmm.css', LMM_PATH_CSS, $css);

    if (!empty($lmm_locations) && is_array($lmm_locations)) {
        lmm_save_file('lmm_locations.css', LMM_PATH_CSS, lmm_less_css(LMM_PATH_LESS . '/lmm_locations.less', $lmm));
    }
}

function lmm_save_file($name = false, $dir = false, $content = false) {

    if (!$name || !$dir || !$content) {
        return;
    }

    // create the folder -------------------------------------------------------
    if (!file_exists(LMM_PATH_CSS)) {
        if (!@mkdir(LMM_PATH_CSS, 0777, true)) {
            lmm_add_admin_notice('error', sprintf(__('Cant created folder %1$s do to %2$s.', 'lmm'), LMM_PATH_CSS, error_get_last()));
            set_transient('lmm_saved_redirect', true, 30);
            return;
        } else {
            lmm_add_redux_notice('blue', sprintf(__('Folder created : %1$s', 'lmm'), LMM_PATH_CSS));
        }
    }

    // check content -----------------------------------------------------------
    if (is_wp_error($content)) {
        lmm_add_admin_notice('error', $content->get_error_message());
        //set_transient('lmm_saved_redirect', true, 30);
        return;
    }

    if (($fd = @fopen($dir . $name, 'w')) !== false) {
        @fwrite($fd, $content);
        @fclose($fd);
        lmm_add_redux_notice('blue', sprintf(__('File has been created : %1$s', 'lmm'), $dir . $name));
        return;
    } else {
        lmm_add_admin_notice('error', sprintf(__('File %1$s cant be created : %2$s', 'lmm'), $dir . $name, error_get_last()));
        //set_transient('lmm_saved_redirect', true, 30);
        return;
    }
}

function lmm_get_contents($url) {
    if (ini_get('allow_url_fopen') && function_exists('file_get_contents')) {
        $out = @file_get_contents($url);
    } elseif (function_exists('curl_init')) {
        $ch = @curl_init();
        @curl_setopt($ch, CURLOPT_URL, $url);
        @curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $out = @curl_exec($ch);
        @curl_close($ch);
    } elseif (function_exists('fopen') && function_exists('fread')) {
        $handle = @fopen($url, "rb");
        $out = @fread($handle, filesize($url));
        @fclose($handle);
    } 

    if (empty($out)) {
        $out = new WP_Error('writing_error', sprintf(__('We can\'t read the file %s.', 'lmm'), $url));
    }

    return $out;
}

function lmm_less_variables(&$data, $header = '') {

    $html = array();

    if (!is_array($data))
        return $data;

    foreach ($data as $key => &$val) {

        //we only want the files with this key
        if (strpos($header . $key, 'scheme_') !== false) {

            $value = ($key != 'font-options') ? $val : '';

            $value = (filter_var($value, FILTER_VALIDATE_URL)) ? "'{$value}'" : $value;

            if (is_array($value)) {
                //$html .= lmm_less_variables($value, "{$key}_");
                $html = array_merge(lmm_less_variables($value, "{$key}_"), $html);
            } elseif ($value != '') {
                $html[str_replace('scheme_', '@', $header . $key)] = $value;
            } else {
                $html[str_replace('scheme_', '@', $header . $key)] = '0';
            }
        }
    }

    return $html;
}

function lmm_less_locations($locations = array()) {

    global $lmm_locations;

    foreach ($lmm_locations as $location => $settings) {

        if (!$settings['style'])
            continue;

        $locations[] = '~"' . $location . '"';
    }

    return array('@locations' => implode(',', array_reverse($locations)));
}

function lmm_less_css($input, $lmm) {

    if (!is_file($input)) {
        lmm_add_admin_notice('error', sprintf(__('Error: Wrong file path to %s', 'lmm'), $input));
        //set_transient('lmm_saved_redirect', true, 30);
        return;
    }

    if (!class_exists('Less_Parser')) {
        require_once(LMM_PATH . 'lib/Less/Less.php');
    }

    $config = array('compress' => false);

    $less = new Less_Parser($config);

    try {

        $less->ModifyVars(array_merge(lmm_less_locations(), lmm_less_variables($lmm)));

        $less->parseFile($input, LMM_URL_ASSETS);

        return $less->getCss();
    } catch (exception $e) {

        lmm_add_admin_notice('error', $e->getMessage());

        //set_transient('lmm_saved_redirect', true, 30);

        return new WP_Error('writing_error', $e->getMessage());
    }
}
