<?php
// nav menu location icons -----------------------------------------------------

add_action('admin_init', 'lmm_backend_scripts', 1);

function lmm_backend_scripts() {

    global $lmm, $lmm_icons;

    wp_register_style('lmm-icons', $lmm_icons[isset($lmm['lmm_styles_icons']) ? $lmm['lmm_styles_icons'] : 'fontawesome']['url']);

    wp_register_style('lmm-modal', LMM_URL . 'assets/backend/css/modal.min.css', array('lmm-icons'), '', 'all');

    wp_register_style('lmm-admin-icons', LMM_URL . 'assets/backend/css/wp-admin-icons.css', array(), '', 'all');

    wp_register_style('lmm-admin', LMM_URL . 'assets/backend/css/wp-admin.css', array('lmm-icons', 'lmm-modal'), '', 'all');

    wp_register_style('lmm-navmenu', LMM_URL . 'assets/backend/css/wp-navmenu.css', array(), '', 'all');

    wp_register_script('lmm-modal', LMM_URL . 'assets/backend/js/modal.min.js', array('jquery'), '', false);

    wp_register_script('lmm-admin', LMM_URL . 'assets/backend/js/lmm.js', array('jquery', 'jquery-ui-sortable'), '', false);

    wp_enqueue_style('lmm-admin');

    wp_enqueue_style('lmm-admin-icons');

    //add script variables
    $developer_options = apply_filters('lmm_hook_options_developer', $developer = array());

    wp_localize_script('lmm-admin', 'lmm', array(
        'nonce' => wp_create_nonce('add-lmm-custom-menu-item'),
        'developer_options' => !empty($developer_options) ? '#lmm-' . implode(array_keys($developer_options), ',#lmm-') : '',
        'add_background' => __('Add Background', 'lmm'),
            )
    );
}

// load in nav menus even if lmm is not active
add_action('admin_footer-nav-menus.php', 'lmm_locations_icons');

//add locations icons ----------------------------------------------------------
function lmm_locations_icons() {

    $screen = get_current_screen();

    if ($screen->base != 'nav-menus')
        return;

    global $lmm_locations;
    ?>
    <script>
        jQuery(document).ready(function () {
            var $list = jQuery('.menu-theme-locations'),
                    locations = <?php echo json_encode(array_keys($lmm_locations)); ?>,
                    icon = '<i class="lmm-th-menu"></i>';

            jQuery.each(locations, function (index, item) {
                $list.find('input#locations-' + item).after(icon);

            });

        });
    </script>

    <?php
}

//modal box --------------------------------------------------------------------

function lmm_modal_box($icons = '') {

    global $lmm, $lmm_icons;

    if (empty($lmm_icons[$lmm['lmm_styles_icons']]['classes']))
        return;

    foreach (explode(',', $lmm_icons[$lmm['lmm_styles_icons']]['classes']) as $icon) {

        $icon = trim(str_replace('.', '', $icon));

        $class = str_replace(' ', '_', trim($icon));

        $icons .= '<a style="display: block;" class="icon _' . $class . '"><i class="' . $icon . '"></i></a>';
    }

    $param_line = '<div id="icons_scroll">' . $icons . '<div class="clearfix"></div></div>';
    ?>
    <!-- Modal Icon -->
    <div id="modalIcon" class="modal fade lmm" tabindex="-1" role="dialog" aria-labelledby="modalIconLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">                    
                    <button type="button" class="close button-secondary" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php _e('Icon Selector', 'lmm'); ?></h4>
                </div>
                <div class="modal-body">
                    <?php echo $param_line; ?>
                    <input name="modal_icons_target" type="hidden"/>
                    <input name="modal_icons_search" class="modal_icons_search widefat code" type="text" value="" placeholder="<?php _e('Search icon', 'lmm'); ?>"/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="button button-secondary" data-dismiss="modal"><?php _e('Close', 'lmm') ?></button>
                    <button type="button" class="button button-primary save"><?php _e('Save', 'lmm') ?></button>
                </div>
            </div>
        </div>
    </div>
    <!-- /Modal Icon -->

    <!-- Modal Column Offset -->
    <div id="modalColumnOffset" class="modal fade lmm" tabindex="-1" role="dialog" aria-labelledby="modalColumnOffsetLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close button-secondary" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php _e('Set Width', 'lmm'); ?></h4>
                </div>
                <div class="modal-body">
                    <table>
                        <tbody>
                            <tr>
                                <th>Device</th>

                                <th>Width <small><?php _e('- Based on the device screen size', 'lmm'); ?></small></th>

                                <th>Offset <small><?php _e('- Set a padding for the column', 'lmm'); ?></small></th>
                            </tr>

                            <tr class="lg">
                                <td class="lg">
                                    <span class="icon" title="Large"></span>
                                </td>
                                <td>
                                    <select data-type="col-lg" name="lmm_col_lg_size">
                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option value="col-lg-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-lg-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-lg-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-lg-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-lg-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-lg-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-lg-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-lg-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-lg-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-lg-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-lg-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-lg-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>
                                <td>
                                    <select data-type="col-lg-offset" name="lmm_lg_offset_size">
                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option style="color: #ccc;" value="col-lg-offset-0">
                                            No offset
                                        </option>

                                        <option value="col-lg-offset-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-lg-offset-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-lg-offset-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-lg-offset-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-lg-offset-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-lg-offset-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-lg-offset-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-lg-offset-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-lg-offset-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-lg-offset-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-lg-offset-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-lg-offset-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>

                            </tr>

                            <tr class="md">
                                <td class="md">
                                    <span class="icon" title="Medium"></span>
                                </td>

                                <td>
                                    <select data-type="col-md" name="lmm_col_md_size">
                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option value="col-md-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-md-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-md-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-md-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-md-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-md-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-md-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-md-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-md-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-md-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-md-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-md-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>

                                <td>
                                    <select data-type="col-md-offset" name="lmm_md_offset_size">
                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option style="color: #ccc;" value="col-md-offset-0">
                                            No offset
                                        </option>

                                        <option value="col-md-offset-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-md-offset-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-md-offset-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-md-offset-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-md-offset-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-md-offset-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-md-offset-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-md-offset-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-md-offset-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-md-offset-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-md-offset-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-md-offset-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>
                            </tr>

                            <tr class="sm">
                                <td class="sm">
                                    <span class="icon" title="Small"></span>
                                </td>

                                <td>
                                    <select data-type="col-sm" name="lmm_col_sm_size">

                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option value="col-sm-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-sm-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-sm-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-sm-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-sm-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-sm-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-sm-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-sm-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-sm-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-sm-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-sm-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-sm-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>

                                <td>
                                    <select data-type="col-sm-offset" name="lmm_sm_offset_size">
                                        <option style="color: #ccc;" value="">
                                            Inherit from smaller
                                        </option>

                                        <option style="color: #ccc;" value="col-sm-offset-0">
                                            No offset
                                        </option>

                                        <option value="col-sm-offset-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-sm-offset-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-sm-offset-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-sm-offset-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-sm-offset-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-sm-offset-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-sm-offset-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-sm-offset-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-sm-offset-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-sm-offset-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-sm-offset-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-sm-offset-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>
                            </tr>

                            <tr class="xs">
                                <td class="xs">
                                    <span class="icon" title="Extra small"></span>
                                </td>

                                <td>
                                    <select data-type="col-xs" name="lmm_col_xs_size">
                                        <option style="color: #ccc;" value="">
                                        </option>

                                        <option value="col-xs-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-xs-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-xs-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-xs-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-xs-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-xs-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-xs-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-xs-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-xs-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-xs-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-xs-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-xs-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>

                                <td>
                                    <select data-type="col-xs-offset" name="lmm_xs_offset_size">
                                        <option style="color: #ccc;" value="">
                                            No offset
                                        </option>

                                        <option value="col-xs-offset-1">
                                            1 column - 1/12
                                        </option>

                                        <option value="col-xs-offset-2">
                                            2 columns - 1/6
                                        </option>

                                        <option value="col-xs-offset-3">
                                            3 columns - 1/4
                                        </option>

                                        <option value="col-xs-offset-4">
                                            4 columns - 1/3
                                        </option>

                                        <option value="col-xs-offset-5">
                                            5 columns - 5/12
                                        </option>

                                        <option value="col-xs-offset-6">
                                            6 columns - 1/2
                                        </option>

                                        <option value="col-xs-offset-7">
                                            7 columns - 7/12
                                        </option>

                                        <option value="col-xs-offset-8">
                                            8 columns - 2/3
                                        </option>

                                        <option value="col-xs-offset-9">
                                            9 columns - 3/4
                                        </option>

                                        <option value="col-xs-offset-10">
                                            10 columns - 5/6
                                        </option>

                                        <option value="col-xs-offset-11">
                                            11 columns - 11/12
                                        </option>

                                        <option value="col-xs-offset-12">
                                            12 columns - 1/1
                                        </option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <p><?php _e('Set the column width for different screen sizes based on the bootstrap grid system or leave all fields emptys to set full width. See an example of the boostrap grid system in the next <a targe="_blank" href="https://getbootstrap.com/examples/grid/">link.</a>', 'lmm'); ?></p>
                    <input name="modal_columnsoffset_target" type="hidden"/>
                </div>

                <div class="modal-footer">
                    <button type="button" class="button button-secondary" data-dismiss="modal"><?php _e('Close', 'lmm') ?></button>
                    <button type="button" class="button button-primary save"><?php _e('Save', 'lmm') ?></button>
                </div>
            </div>
        </div>
    </div>
    <!-- /Modal Column Offset -->
    <?php
}

function lmm_select_menus($current = '') {

    global $lmm_locations;

    $output = '<select name="lmm_location" id="lmm_location" class="widefat">';

    $output .= '<option value=""></option>';

    foreach ($lmm_locations as $key => $location) {

        if (!$location['instance'] || !$location['subsection'])
            continue;

        $selected = lmm_get_custom_field('lmm_location') == $key ? 'selected="selected"' : '';

        $output .= '<option value="' . esc_attr($key) . '" ' . $selected . '>';
        $output .= $location['name'];
        $output .= '</option>';
    }

    $output .= '</select>';

    return $output;
}

function lmm_select_sidebar($id, $current) {

    global $wp_registered_sidebars;

    $output = '<select id="edit-menu-item-mega-sidebar-' . $id . '" name="menu-item-mega-sidebar[' . $id . ']" class="edit-menu-item-mega-sidebar widefat code">';

    $output .= '<option value=""></option>';

    foreach ($wp_registered_sidebars as $sidebar) {

        if (strpos($sidebar['id'], 'lmm-') !== false) {

            $selected = $current == $sidebar['id'] ? 'selected="selected"' : '';

            $output .= '<option value="' . esc_attr($sidebar['id']) . '" ' . $selected . '>';
            $output .= ucwords($sidebar['name']);
            $output .= '</option>';
        }
    }

    $output .= '</select>';

    return $output;
}
