function lmm_modal_icon() {

    var $modal = jQuery('#modalIcon'),
            $scroll = $modal.find('#icons_scroll .icon'),
            $target = $modal.find('input[name="modal_icons_target"]'),
            $icon = $modal.find('input[name="modal_icons_search"]'),
            $save = $modal.find('button.save');

    $modal.on('show.bs.modal', function (e) {

        $scroll.removeAttr('style').removeClass('selected');

        var $item = jQuery(e.relatedTarget),
                id = $item.data('id'),
                value = $item.data('value');

        $target.val(id);

        if (!value)
            return;

        $icon.val(value);

        var value = '.' + jQuery.trim(value).toString().replace(' ', '.');

        if (!$scroll.find(value).lenght)
            return;

        $scroll.find(value).parent().addClass('selected').focus();
    });

    $icon.keyup(function () {
        setTimeout(function () {
            var icon_query = $icon.val();
            if (icon_query != '') {
                $scroll.css({'display': 'none'});
                $scroll.filter('[class*="' + icon_query + '"]').css({'display': 'block'});
            } else {
                $scroll.removeAttr('style');
            }
        }, 1200);
    });

    $scroll.click(function (e) {
        e.preventDefault();

        jQuery(this).addClass('selected').siblings().removeClass('selected');

        $icon.val(jQuery(this).find('i').attr('class'));
    });

    $save.on('click', function (e) {

        e.preventDefault();

        var $item = jQuery('#' + $target.val()),
                $a = jQuery('a[data-id="' + $target.val() + '"]'),
                $replace = jQuery('#' + $target.val() + '_replace'),
                icon = $icon.val();

        $item.val(icon);

        $a.data('value', icon);

        $replace.hide().removeAttr('class').addClass(icon).fadeIn();

        $modal.modal('hide');
    });

}

function lmm_modal_columnoffset() {

    var $modal = jQuery('#modalColumnOffset'),
            $target = $modal.find('input[name="modal_columnsoffset_target"]'),
            $select = $modal.find('select'),
            $save = $modal.find('button.save');

    $modal.on('show.bs.modal', function (e) {

        var $item = jQuery(e.relatedTarget),
                id = $item.data('id'),
                field = $item.data('field');

        var values = jQuery.isArray($item.data('value')) ? $item.data('value') : $item.data('value').split(',');
        
        //var values = jQuery.isArray($item.val()) ? $item.val() : $item.val().split(',');

        if (field == 'columns') {
            $modal.find('tr.xs, tr > th:nth-child(3), tr > td:nth-child(3)').hide();
            $modal.find('tr.xs select, tr > th:nth-child(3) select, tr > td:nth-child(3) select').prop('disabled', true);
        } else {
            $modal.find('tr.xs, tr > th:nth-child(3), tr > td:nth-child(3)').show();
            $modal.find('tr.xs select, tr > th:nth-child(3) select, tr > td:nth-child(3) select').prop('disabled', false);
        }

        $target.val(id);

        if (!jQuery.isArray(values))
            return;

        jQuery.each(values, function (index, option) {
            $select.find('option[value="' + option + '"]').attr('selected', 'selected');
        });

    });

    $save.on('click', function (e) {

        e.preventDefault();

        var $item = jQuery('#' + $target.val()),
                $a = jQuery('a[data-id="' + $target.val() + '"]'),
                $options = $select.find('option:selected');

        var array = jQuery.map($options, function (option) {
            if (option.value)
                return option.value;

        });

        //var value = jQuery.isEmptyObject(array) ? 'falso' : array;

        $item.val(array);

        $a.data('value', array);

        $modal.modal('hide');
    });
}

// redux functions -------------------------------------------------------------

function lmm_developer_options() {
    'use strict';

    if (typeof lmm.developer_options == 'undefined')
        return;

    jQuery(lmm.developer_options).closest('tr').addClass('developer');

}

function lmm_layout_options_hide(layout, hmode, vmode, location) {
    'use strict';

    var $navbar_vertical_float = jQuery('#lmm-' + location + '_navbar_mode_vertical_float').closest('tr'),
            $navbar_mode_vertical_collapsed = jQuery('#lmm-' + location + '_navbar_mode_vertical_collapsed').closest('tr'),
            $navbar_items_align = jQuery('#lmm-' + location + '_navbar_mode_horizontal_align').closest('tr'),
            $navbar_sticky = jQuery('#lmm-' + location + '_navbar_sticky').closest('tr').add(jQuery('#section-' + location + '_navbar_sticky_divider')).add(jQuery('#lmm-' + location + '_navbar_sticky_offset').closest('tr')).add(jQuery('#lmm-' + location + '_navbar_sticky_logo').closest('tr')),
            $navbar_sticky_logo = jQuery('#lmm-' + location + '_navbar_sticky_logo').closest('tr'),
            $navbar_width = jQuery('#lmm-' + location + '_navbar_width').closest('tr'),
            $dropdown_animation = jQuery('#lmm-' + location + '_dropdown_animation').closest('tr'),
            $scheme_width = jQuery('#lmm-scheme_' + location + '_navbar_width').closest('tr'),
            $scheme_height = jQuery('#lmm-scheme_' + location + '_navbar_height').closest('tr'),
            $scheme_toggle = jQuery('#lmm-scheme_' + location + '_navbar_toggle_icon, #lmm-scheme_' + location + '_navbar_toggle_border, #lmm-scheme_' + location + '_navbar_toggle_bg, #lmm-scheme_' + location + '_navbar_toggle_hover').closest('tr'),
            $scheme_sticky = jQuery('#lmm-scheme_' + location + '_navbar_sticky_height, #lmm-scheme_' + location + '_navbar_sticky_background').closest('tr'),
            $navbar_sticky = $navbar_sticky.add($scheme_sticky).add(jQuery('#section-' + location + '_sticky'));

    if (layout == 'horizontal' && hmode == 'button') {
        $navbar_vertical_float.fadeOut();
        $navbar_mode_vertical_collapsed.fadeOut();
        $navbar_items_align.fadeIn();
        $navbar_sticky.fadeIn();
        $navbar_width.fadeIn();
        $scheme_width.fadeOut();
        $dropdown_animation.fadeIn();
        $scheme_toggle.fadeIn();
    }

    if (layout == 'horizontal' && hmode == 'collapsed') {
        $navbar_vertical_float.fadeOut();
        $navbar_mode_vertical_collapsed.fadeOut();
        $navbar_items_align.fadeIn();
        $navbar_sticky.fadeOut();
        $navbar_width.fadeIn();
        $dropdown_animation.fadeIn();
        $scheme_width.fadeOut();
        $scheme_toggle.fadeOut();
    }

    if (layout == 'horizontal' && hmode == 'offcanvas') {
        $navbar_vertical_float.fadeOut();
        $navbar_mode_vertical_collapsed.fadeOut();
        $navbar_items_align.fadeIn();
        $navbar_sticky.fadeIn();
        $navbar_width.fadeIn();
        $scheme_width.fadeIn();
        $dropdown_animation.fadeIn();
        $scheme_toggle.fadeIn();
    }

    if (layout == 'vertical' && vmode == 'button') {
        $navbar_vertical_float.fadeIn();
        $navbar_mode_vertical_collapsed.fadeOut();
        $navbar_items_align.fadeOut();
        $navbar_sticky.fadeIn();
        $navbar_sticky_logo.fadeOut();
        $navbar_width.fadeOut();
        $scheme_width.fadeIn();
        $dropdown_animation.fadeOut();
    }

    if (layout == 'vertical' && vmode == 'collapsed') {
        $navbar_vertical_float.fadeIn();
        $navbar_mode_vertical_collapsed.fadeIn();
        $navbar_items_align.fadeOut();
        $navbar_sticky.fadeIn();
        $navbar_width.fadeOut();
        $scheme_width.fadeIn();
        $dropdown_animation.fadeOut();
    }

    if (layout == 'vertical' && vmode == 'inherit') {
        $navbar_vertical_float.fadeOut();
        $navbar_mode_vertical_collapsed.fadeOut();
        $navbar_items_align.fadeOut();
        $navbar_sticky.fadeOut();
        $navbar_width.fadeOut();
        $scheme_width.fadeOut();
        $scheme_height.fadeOut();
        $dropdown_animation.fadeOut();
        $scheme_toggle.fadeOut();
    }

}

function lmm_layout_options() {

    'use strict';

    jQuery('ul.redux-group-menu > li').each(function () {

        var string = jQuery(this).attr('class').match(/lmm_location_[\w-]*\b/);

        if (string) {

            var location = string.toString().replace('lmm_location_', ''),
                    $layout = jQuery('#lmm-' + location + '_navbar_mode input'),
                    $hmode = jQuery('#lmm-' + location + '_navbar_mode_horizontal input'),
                    $vmode = jQuery('#lmm-' + location + '_navbar_mode_vertical input'),
                    layout = $layout.filter(':checked').val().toString(),
                    hmode = $hmode.filter(':checked').val().toString(),
                    vmode = $vmode.filter(':checked').val().toString();

            lmm_layout_options_hide(layout, hmode, vmode, location);

            $layout.add($hmode).add($vmode).change(function () {

                var $overlay = jQuery('#redux_ajax_overlay');

                $overlay.fadeIn();

                layout = $layout.filter(':checked').val().toString(),
                        hmode = $hmode.filter(':checked').val().toString(),
                        vmode = $vmode.filter(':checked').val().toString();

                lmm_layout_options_hide(layout, hmode, vmode, location);

                $overlay.delay(400).fadeOut('fast');
            });

        }
    });

}

function lmm_redux_fix() {
    'use strict';

    jQuery('.redux-action_bar input').removeAttr('disabled');
}

function lmm_locations_styles() {
    'use strict';

    var $locations = jQuery('#lmm-lmm_locations').find('ul > li'),
            $styles = jQuery('#lmm-lmm_locations_styles').find('ul > li');

    jQuery.each($locations, function (index) {

        if (jQuery(this).find('input[type=checkbox]').is(':checked')) {
            $styles.eq(index).show();
            $styles.eq(index).find('input').prop('disabled', false);
        } else {
            $styles.eq(index).hide();
            $styles.eq(index).find('input').prop('checked', false).prop('disabled', true);
        }

        jQuery(this).find('input[type=checkbox]').click(function () {
            if (jQuery(this).is(":checked")) {
                $styles.eq(index).show(300);
                $styles.eq(index).find('input').prop('disabled', false);
            } else {
                $styles.eq(index).hide(200);
                $styles.eq(index).find('input').prop('checked', false).prop('disabled', true);
            }
        });

    });
}

function lmm_navbar_breakpoint() {
    'use strict';

    var $breakpoint = jQuery('#lmm-scheme_lmm_navbar_breakpoint').find('div.redux-slider-container'),
            $small = jQuery('#lmm-scheme_lmm_container_small_width').find('div.redux-slider-container'),
            $gutter = jQuery('#lmm-scheme_lmm_container_gutter').find('div.redux-slider-container');

    $breakpoint.add($gutter).on('change', function () {

        var breakpoint = ($breakpoint.val()) ? $breakpoint.val() : $breakpoint.data('default-one'),
                gutter = ($gutter.val()) ? $gutter.val() : $gutter.data('default-one'),
                small = ($small.val()) ? $small.val() + gutter : $small.data('default-one') + gutter;

        $small.noUiSlider({
            //start: [0],
            range: [0, breakpoint - gutter],
        }, true);

        if (small >= breakpoint)
            $small.val(breakpoint - gutter);
    });

    $breakpoint.trigger('click');
}

function getUrlParameter(sParam, URL)
{
    var sPageURL = URL.search.substring(1);
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++)
    {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == sParam)
        {
            return sParameterName[1];
        }
    }
}

function lmm_importer() {
    'use strict';

    jQuery(document).ajaxSuccess(function (event, request, settings) {

        var action = JSON.stringify(settings.data);

        if (typeof action == 'undefined')
            return;

        if (action.indexOf('redux_wbc_importer') >= 0)
            location.reload();
    });
}

// nav menus functions ---------------------------------------------------------

function lmm_disable_shortable() {

    jQuery('ul#menu-to-edit').sortable({
        cancel: "dt.lmm-item-disable-sortable"
    });

}

function lmm_ajax() {

    jQuery.fn.extend({
        lmmItemData: function (itemType, id) {
            itemType = itemType || 'menu-item';

            var itemData = {}, i,
                    fields = [
                        'menu-item-db-id',
                        'menu-item-object-id',
                        'menu-item-object',
                        'menu-item-parent-id',
                        'menu-item-position',
                        'menu-item-type',
                        'menu-item-title',
                        'menu-item-url',
                        'menu-item-description',
                        'menu-item-attr-title',
                        'menu-item-target',
                        'menu-item-classes',
                        'menu-item-xfn',
                        'menu-item-lmm',
                        'menu-item-mega-columns',
                        'menu-item-mega-sub-columns',
                        'menu-item-subitems'
                    ];

            if (!id && itemType == 'menu-item') {
                id = this.find('.menu-item-data-db-id').val();
            }

            if (!id)
                return itemData;

            this.find('input').each(function () {
                var field;
                i = fields.length;
                while (i--) {
                    if (itemType == 'menu-item')
                        field = fields[i] + '[' + id + ']';
                    else if (itemType == 'add-menu-item')
                        field = 'menu-item[' + id + '][' + fields[i] + ']';

                    if (
                            this.name &&
                            field == this.name
                            ) {
                        itemData[fields[i]] = this.value;
                    }
                }
            });

            return itemData;
        }
    });

    jQuery('#submit-lmm-custom-menu-metabox').click(function (event) {
        event.preventDefault();

        var menuItems = {};

        var $spinner = jQuery(this).parent().find('span.spinner');

        $spinner.addClass('is-active');

        jQuery('#lmm-custom-checklist li :checked').each(function () {

            var t = jQuery(this),
                    re = /menu-item\[([^\]]*)/,
                    listItemDBIDMatch = re.exec(t.attr('name')),
                    listItemDBID = 'undefined' == typeof listItemDBIDMatch[1] ? 0 : parseInt(listItemDBIDMatch[1], 10);

            menuItems[listItemDBID] = t.closest('li').lmmItemData('add-menu-item', listItemDBID);
        });

        //alert(JSON.stringify(menuItems));

        jQuery.post(ajaxurl, {
            'action': "add-lmm-custom-menu-item",
            'lmm-settings-column-nonce': lmm.nonce, //jQuery('#lmm-settings-column-nonce').val(),
            'menu': jQuery('#menu').val(),
            'menu-item': menuItems
        },
                function (response) {
                    jQuery('#menu-to-edit').append(response);
                    $spinner.removeClass('is-active');
                }
        );
    });

    jQuery('#menu-to-edit').on('click', '.menu-item-actions input.submit-add-lmm-subitem', function (event) {
        event.preventDefault();

        var menuItems = {};

        var $spinner = jQuery(this).parent().find('span.spinner');

        $spinner.addClass('is-active');

        var t = jQuery(this).closest('li.menu-item'),
                depth = parseInt(t.prop('class').match(/menu-item-depth-([0-9]+)/)[1]) + 1;
        //depth = t.data('depth') + 1;

        menuItems[-1] = t.lmmItemData('add-menu-item', -1);

        //alert(JSON.stringify(menuItems));

        t.find('.lmm-add-to-menu .spinner').show();

        jQuery.post(ajaxurl, {
            'action': "add-lmm-custom-menu-item",
            'lmm-settings-column-nonce': lmm.nonce,
            'menu': jQuery('#menu').val(),
            'menu-item': menuItems
        },
                function (response) {

                    t.find('.lmm-add-to-menu .spinner').hide();

                    //ahh! worpdress bug
                    response = response.replace('menu-item-depth-0', 'menu-item-depth-' + depth.toString());

                    t.after(response);

                    $spinner.removeClass('is-active');
                });
    });
}

function lmm_thumnails() {

    var media_uploader = null;

    jQuery('.custom_upload_mega_image').live('click', function () {

        if (typeof wp.media.view.Attachment.Details != 'undefined') {
            wp.media.view.Attachment.Details.prototype.template = wp.media.template('attachment-background');
        }

        var $wrapper = jQuery(this).closest('.field-mega-background-wrapper'),
                $css = jQuery(this).siblings('.edit-menu-item-mega-background-css'),
                $preview = jQuery(this).siblings('.edit-menu-item-mega-background-thumbnail'),
                $background_thumbnail_id = jQuery(this).siblings('.edit-menu-item-mega-background-thumbnail-id'),
                $background_position = jQuery(this).siblings('.edit-menu-item-mega-background-position'),
                $background_repeat = jQuery(this).siblings('.edit-menu-item-mega-background-repeat'),
                $background_attachment = jQuery(this).siblings('.edit-menu-item-mega-background-attachment'),
                $background_size = jQuery(this).siblings('.edit-menu-item-mega-background-size');

        media_uploader = wp.media({
            button: {
                text: lmm.add_background
            },
            library: {
                type: 'image'
            },
            multiple: false  // Set to true to allow multiple files to be selected
        });

        media_uploader.on('select', function () {

            //media_uploader.state().get('selection').trigger('change');

            var json = media_uploader.state().get('selection').first().toJSON(),
                    src = typeof json.sizes.thumbnail !== 'undefined' ? json.sizes.thumbnail.url : json.url,
                    position = json.position || 'top left',
                    repeat = json.repeat || 'no-repat',
                    attachment = json.attachment || 'fixed',
                    size = json.size || 'contain';

            $wrapper.addClass('active');

            $preview.html('<img src="' + src + '" width="50" height="50" >');

            $background_thumbnail_id.val(json.id);
            $background_position.val(position);
            $background_repeat.val(repeat);
            $background_attachment.val(attachment);
            $background_size.val(size);

            $css.html(position + ',' + repeat + ',' + attachment + ',' + size);

        });

        media_uploader.open();

    });

    jQuery('.custom_clear_mega_image').live('click', function () {

        var $wrapper = jQuery(this).closest('.field-mega-background-wrapper'),
                $css = jQuery(this).siblings('.edit-menu-item-mega-background-css'),
                $preview = jQuery(this).siblings('.edit-menu-item-mega-background-thumbnail'),
                $background_thumbnail_id = jQuery(this).siblings('.edit-menu-item-mega-background-thumbnail-id'),
                $background_position = jQuery(this).siblings('.edit-menu-item-mega-background-position'),
                $background_repeat = jQuery(this).siblings('.edit-menu-item-mega-background-repeat'),
                $background_attachment = jQuery(this).siblings('.edit-menu-item-mega-background-attachment'),
                $background_size = jQuery(this).siblings('.edit-menu-item-mega-background-size');


        $wrapper.removeClass('active');

        $preview.html('');

        $background_thumbnail_id.val('');
        $background_position.val('');
        $background_repeat.val('');
        $background_attachment.val('');
        $background_size.val('');

        $css.html('');

        return false;
    });


}

function lmm_find_all_child(li_current) {
    li_children_arr = li_current.nextUntil('.menu-item-depth-0');
    return li_children_arr;
}

function lmm_find_top_parent(li_current) {

    if (li_current.hasClass('menu-item-depth-0'))
        return li_current;

    li_top_parrent = li_current.prevUntil('.menu-item-depth-0');

    if (li_top_parrent.length <= 0) {

        li_top_parrent = li_current.prev();

    } else {

        array_len = li_top_parrent.length - 1;

        li_top_parrent = li_top_parrent.eq(array_len).prev();
    }

    return li_top_parrent;
}

function lmm_megamenu(li_current) {

    var types = {
        '': false,
        'undefined': false,
        'no': true,
        'lmm-social': [],
        'lmm-search': [],
        'lmm-login': [],
        'lmm-cart': [],
        'lmm-tabs': {
            1: ['tab'],
            2: ['column'],
            3: ['widget', 'custom', 'post_type', 'taxonomy']
        },
        'lmm-mega': {
            1: ['column'],
            2: ['widget', 'custom', 'post_type', 'taxonomy']
        }
    };

    var li_parrent = lmm_find_top_parent(li_current),
            type = li_parrent.find('input.menu-item-data-lmm').val(),
            lmm = (types[type]) ? type : 'no';

    li_parrent.find('p.lmm-mega-menu').hide();

    li_parrent.find('.' + type + '-show').show();

    li_parrent.find('.' + type + '-show-lvl-0').show();

    // check supported levels --------------------------------------------------
    if (!types[lmm]) {
        li_parrent.addClass('menu-item-invalid');
        alert('Unsupported nested level, please remove on lvl1.');
    } else {
        li_parrent.removeClass('menu-item-invalid');
    }

    jQuery.each(lmm_find_all_child(li_parrent), function (index, subelement) {

        var depth = parseInt(jQuery(subelement).prop('class').match(/menu-item-depth-([0-9]+)/)[1]),
                curr = jQuery(subelement).find('input.menu-item-data-lmm').val();

        jQuery(subelement).find('p.lmm-mega-menu').hide();

        jQuery(subelement).find('.' + curr + '-show').show();

        jQuery(subelement).find('.' + curr + '-show-lvl-' + depth).show();


        //set child menu item type --------------------------------------------
        //alert(JSON.stringify(types[lmm][depth]) + curr);
        /*if (types[type] && (jQuery.isArray(types[lmm][depth]) && jQuery.inArray(curr, types[lmm][depth]) > -1)) {
         jQuery(subelement).find('input.menu-item-data-type').val(types[lmm][depth][0]);
         jQuery(subelement).removeClass('menu-item-invalid');
         }*/

        // check supported levels ----------------------------------------------
        if (types[type] && (!jQuery.isArray(types[lmm][depth]) || jQuery.inArray(curr, types[lmm][depth]) < 0)) {
            jQuery(subelement).addClass('menu-item-invalid');
            alert('Unsupported nested level, please remove.');
        } else {
            jQuery(subelement).removeClass('menu-item-invalid');
        }

    });

    return;

}


function lmm_items() {

    jQuery('a.item-edit').live('mouseup', function () {
        jQuery(this).parent().parent().parent().parent().trigger('click');//.find('p.field-mega select').trigger('change');
    });

    jQuery('ul#menu-to-edit > li').live('click', function (event) {

        lmm_megamenu(jQuery(this));

    });

}

jQuery(document).ready(function () {
    lmm_modal_icon();
    lmm_modal_columnoffset();
    // redux functions
    lmm_locations_styles();
    lmm_developer_options();
    lmm_layout_options();
    lmm_redux_fix();
    lmm_navbar_breakpoint();
    lmm_importer();
    // navmenus functions 
    lmm_disable_shortable();
    lmm_ajax();
    lmm_thumnails();
    lmm_items();

});

