<?php
/**
 * Single Product Image
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.14
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$post = get_post();
global $woocommerce;
global $product;
$attachment_ids = $product->get_gallery_attachment_ids();

?>

<div class="float-left width-100 margin-bottom-70" id="single-product-imgs">
										
	<?php
		if ( has_post_thumbnail() ) {

			$image_title 	= esc_attr( get_the_title( get_post_thumbnail_id() ) );
			$image_caption 	= get_post( get_post_thumbnail_id() )->post_excerpt;
			$image_link  	= wp_get_attachment_url( get_post_thumbnail_id() );
			$image       	= get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array(
				'title'	=> $image_title,
				'alt'	=> $image_title
				) );

			$attachment_count = count( $product->get_gallery_attachment_ids() );

			if ( $attachment_count > 0 ) {
				$gallery = '[product-gallery]';
			} else {
				$gallery = '';
			}

			echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img src="%s" alt="" class="single-product-img" />', $image_link, $image_caption, $image ), $post->ID );

		} else {

			echo apply_filters( 'woocommerce_single_product_image_html', sprintf( '<img src="%s" alt="%s" />', wc_placeholder_img_src(), __( 'Placeholder', 'sonex' ) ), $post->ID );

		}


	if ( $attachment_ids ) {
		$loop 		= 0;
		$columns 	= apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
		

			foreach ( $attachment_ids as $attachment_id ) {

				$classes = array( 'zoom' );

				if ( $loop == 0 || $loop % $columns == 0 )
					$classes[] = 'first';

				if ( ( $loop + 1 ) % $columns == 0 )
					$classes[] = 'last';

				$image_link = wp_get_attachment_url( $attachment_id );

				if ( ! $image_link )
					continue;

				$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ) );
				$image_class = esc_attr( implode( ' ', $classes ) );
				$image_title = esc_attr( get_the_title( $attachment_id ) );

				echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<img src="%s" alt="" class="single-product-img" />', $image_link, $image_class, $image_title, $image ), $attachment_id, $post->ID, $image_class );

				$loop++;
			}
		}
	?>

	<?php //do_action( 'woocommerce_product_thumbnails' ); ?>

<div class="riva-insert-menu-here"></div>
</div>

<script type="text/javascript">
	(function($) {
		"use strict";			

		$('#single-product-imgs').rivaCarousel({
			style:'horizontal',
			navigation:'bullets',
			navigation_class:'width-100 float-left margin-top-0 align-center',
			navigation_item_class:'slider-nav-bullets-2',
			button_left_text:'',
			button_right_text:'',
			visible:1,
			selector:'single-product-img',
			gutter:0,
			infinite:0,
			interval:2000,
			autostart:1,
			speed:600,
			ease: 'jswing'
		});

	})(jQuery);
</script>