<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) )
	$woocommerce_loop['loop'] = 0;

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) )
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 3 );

// Ensure visibility
if ( ! $product || ! $product->is_visible() )
	return;

// Increase loop count
$woocommerce_loop['loop']++;

// Extra post classes
$classes = array();
if ($woocommerce_loop['columns'] == 2) {
	$classes[] = 'col-md-6 col-sm-6';
}elseif($woocommerce_loop['columns'] == 4){
	$classes[] = 'col-md-3 col-sm-3';
}elseif($woocommerce_loop['columns'] == 6){
	$classes[] = 'col-md-2 col-sm-2';
}else{
	$classes[] = 'col-md-4 col-sm-4';
}


if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] )
	$classes[] = 'first';
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )
	$classes[] = 'last';
?>

<div <?php post_class( $classes ); ?>>
<div class="project-item product-item margin-bottom-20" >
<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>
	<!-- Project image //-->

	<figure class="hover-effect">

		<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon">

		<div><?php woocommerce_template_loop_product_thumbnail(); ?></div>
		</a>


	</figure>

	<!-- Project info //-->

	<div class="product-info">

		<p class="product-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
		
		<?php
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */
			do_action( 'woocommerce_after_shop_loop_item_title' );
		?>

		<?php
			$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
			$button_icon = '';
			switch ( $handler ) {
			case "variable" :
				$add_cart = get_permalink();
				$button_icon = '<i class="fa fa-align-justify"></i>';
			break;
			case "grouped" :
				$add_cart = get_permalink();
				$button_icon = '<i class="fa fa-align-justify"></i>';
			break;
			case "external" :
				 $add_cart = get_permalink();
				 $button_icon = '<i class="fa fa-align-justify"></i>';
			break;
			default :
				if ( $product->is_purchasable() ) {
					 $add_cart = esc_url( $product->add_to_cart_url() );
					 $button_icon = '<i class="fa fa-shopping-cart"></i>';
				} else {
					 $add_cart = get_permalink();
					 $button_icon = '<i class="fa fa-align-justify"></i>';
				}
			break;
		}
		?>

		<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode( $button_icon ); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

	</div>

</div>
</div>
