<?php
/**
 * Checkout Form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>


<div class="row">
	<div class="col-md-12">

<?php

wc_print_notices();

do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout
if ( ! $checkout->enable_signup && ! $checkout->enable_guest_checkout && ! is_user_logged_in() ) {
	echo apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'You must be logged in to checkout.', 'sonex' ) );
	return;
}

// filter hook for include new pages inside the payment method
$get_checkout_url = apply_filters( 'woocommerce_get_checkout_url', WC()->cart->get_checkout_url() ); ?>

<form name="checkout" method="post" class="checkout woocommerce-checkout form-checkout" action="<?php echo esc_url( $get_checkout_url ); ?>" enctype="multipart/form-data">
	<div class="tabs" data-active="1">
		<header>				

			<h4 id="checkout-billing-header"><?php esc_html_e( 'Billing address', 'sonex' ); ?></h4>

			<h4 id="checkout-shipping-header"><?php esc_html_e( 'Shipping address', 'sonex' ); ?></h4>

			<h4 id="checkout-payment-header"><?php esc_html_e( 'Review and payment', 'sonex' ); ?></h4>

		</header>
		<div class="tabs-main">
			<?php if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>				
				<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
				
					<div class="tabs-item padding-bottom-10" id="checkout-billing">
						<?php do_action( 'woocommerce_checkout_billing' ); ?>
						<div class="form-elem align-right"><a href="" class="d-btn d-btn-normal d-btn-secondary" id="checkout-billing-next"><?php esc_html_e( 'next step', 'sonex' ); ?></a></div>
					</div>

					<div class="tabs-item padding-bottom-10" id="checkout-shipping">
						<?php do_action( 'woocommerce_checkout_shipping' ); ?>
						<div class="form-elem float-left" style="padding-left: 0;width:auto;"><a href="" class="d-btn d-btn-normal d-btn-secondary" id="checkout-shipping-prev"><?php esc_html_e( 'prev step', 'sonex' ); ?></a></div>
						<div class="form-elem align-right float-right" style="width:auto;"><a href="" class="d-btn d-btn-normal d-btn-secondary" id="checkout-shipping-next"><?php esc_html_e( 'next step', 'sonex' ); ?></a></div>
						<div class="clearfix"></div>
					</div>			

				<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

				<!--<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'sonex' ); ?></h3>-->

			<?php endif; ?>
			<div class="tabs-item padding-bottom-10" id="checkout-payment">
				<h2 class="margin-top-20"><?php esc_html_e( 'review and payment', 'sonex' ); ?></h2>
				<div class="divider-1 margin-bottom-40"></div>	
				<div class="clearfix"></div>		
				<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
				<div id="order_review" class="woocommerce-checkout-review-order">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>
				<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
				<p><a href="" class="d-btn d-btn-normal d-btn-secondary" id="checkout-payment-prev"><?php esc_html_e( 'prev step', 'sonex' ); ?></a></p>
			</div>
		</div>
	</div>
</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
</div>
</div>

