<?php
$theme_option=sonex_global();
get_header(); ?>

  <section class="page-title-bar">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <h2><?php printf( __( 'Category: <span>%s</span>', 'sonex' ), single_cat_title( '', false ) ); ?></h2>
          <?php if ($theme_option['breadcrumbs_opt'] != '0') { ?>
            <?php sonex_breadcrumbs(); ?>
          <?php }else{} ?>
        </div>
      </div>
    </div>
  </section>

  <section>



    <div class="container">



      <div class="row">

        

        <div class="col-md-12">



          <div class="riva-sorting" id="filtering-projects">            



            <div class="listing">



              <?php while (have_posts()) : the_post(); ?>



              <!-- Project item //-->



              <article class="project-item">



                <!-- Project image //-->



                <figure class="hover-effect">



                  <a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon"><i class="fa fa-expand"></i></a>



                  <a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-link"></i></a>



                  <span>

                    <?php $params = array( 'width' => 800, 'height' => 500 );

                    $image = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params ); ?>

                    <img src="<?php echo esc_url($image);?>" alt="">

                  </span>



                </figure>



                <!-- Project info //-->



                <div class="info">



                  <p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>                  



                </div>



              </article>



              <?php endwhile;?>



            </div>

          </div>
           <div class="pagination margin-top-30 margin-bottom-20">

            <?php
                global $wp_query;
                $big = 999999999;
                echo paginate_links( array(
                  'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                  'format' => '?paged=%#%',
                  'current' => max( 1, get_query_var('paged') ),
                  'total' => $wp_query->max_num_pages
                ) );
            ?>

          </div>

        </div>
      </div>
    </div>
  </section>

<?php get_footer(); ?>