<?php

/*

 * Template Name: Coming Soon

 * Description: A Page Template.

 */

//get_header(); ?>

<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<?php $theme_option=sonex_global(); ?>
<head>
  <!-- Metas
  ================================================== -->
  <meta charset="<?php bloginfo( 'charset' ); ?>">  
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
  <!-- Page Title 
  ================================================== -->
  <link rel="profile" href="http://gmpg.org/xfn/11">
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"> 
  <!-- Favicons -->
  <?php if($theme_option['favicon']['url'] !=''){ ?>
  <link rel="icon" href="<?php echo esc_url($theme_option['favicon']['url']); ?>" type="image/x-icon">  
  <?php } ?>
<?php wp_head();?>  
</head>
<body <?php body_class(); ?>>

  <?php if($theme_option['prcheck']) { ?>
  <div class="images-preloader" id="images-preloader">

    <div class="spinner">

      <div class="bounce1"></div>

      <div class="bounce2"></div>

      <div class="bounce3"></div>

    </div>

  </div>
  <?php } ?>

  <div id="wrap-all">

    <main class="site-content" id="content">

<section class="section-404 bg-image bg-image-7 dark" id="section-404" style="background-image: url(<?php echo esc_url($theme_option['cs_bg']['url']); ?>)">

  <div class="relative z-100">

  <div class="section-404-content" id="section-404-content">

    <p class="p1"><?php echo esc_attr($theme_option['cs_title']); ?></p>

    <p class="p2"><?php echo esc_attr($theme_option['cs_stitle']); ?></p>

          <!-- Countdown //-->

    <div class="riva-countdown" id="riva-countdown">

      <div class="riva-countdown-item" id="riva-countdown-days">

        <div class="value"><p>0</p></div>

        <div class="label">days</div>

      </div>

      <div class="riva-countdown-item" id="riva-countdown-hours">

        <div class="value"><p>0</p></div>

        <div class="label">hours</div>

      </div>

      <div class="riva-countdown-item" id="riva-countdown-minutes">

        <div class="value"><p>0</p></div>

        <div class="label">minutes</div>

      </div>

      <div class="riva-countdown-item" id="riva-countdown-seconds">

        <div class="value"><p>0</p></div>

        <div class="label">seconds</div>

      </div>

    </div>

    <script>
    (function($) {
      "use strict";

      //
      // Preload images
      //

      $('document').ready(function() {

        var $container = $('body');

        $container.imagesLoaded( function() {

          $('#images-preloader').hide();

          $('.section-404').height($(window).height());
        
          $('#section-404-content').css('margin-top', ( ( $(window).height() - parseInt( $('#section-404-content').height() ) ) / 2 ) + 'px');

          $('#riva-countdown').rivaCountdown({
            year : <?php echo esc_attr($theme_option['cs_year']); ?>,
            month : <?php echo esc_attr($theme_option['cs_month']); ?>,
            day : <?php echo esc_attr($theme_option['cs_day']); ?>,
            hours : 0,
            minutes : 0,
            seconds : 0,
          });

        });
      });

    })(jQuery);
    </script>

    <p><?php echo htmlspecialchars_decode($theme_option['cs_social']); ?></p>

    <p class="s_profiles">

      <?php if($theme_option['facebook']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['facebook']); ?>"><i class="fa fa-facebook"></i></a>
      <?php } ?>
      <?php if($theme_option['google']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['google']); ?>"><i class="fa fa-google-plus"></i></a>
      <?php } ?>
      <?php if($theme_option['twitter']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['twitter']); ?>"><i class="fa fa-twitter"></i></a>
      <?php } ?>
      <?php if($theme_option['youtube']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['youtube']); ?>"><i class="fa fa-youtube"></i></a>
      <?php } ?>
      <?php if($theme_option['linkedin']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['linkedin']); ?>"><i class="fa fa-linkedin"></i></a>
      <?php } ?>
      <?php if($theme_option['dribbble']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['dribbble']); ?>"><i class="fa fa-dribbble"></i></a>
      <?php } ?>
      <?php if($theme_option['instagram']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['instagram']); ?>"><i class="fa fa-instagram"></i></a>
      <?php } ?> 
      <?php if($theme_option['skype']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['skype']); ?>"><i class="fa fa-skype"></i></a>
      <?php } ?>  
      <?php if($theme_option['rssfeed']!=''){ ?>
      <a target="_blank" href="<?php echo esc_url($theme_option['rssfeed']); ?>"><i class="fa fa-rss"></i></a>
      <?php } ?>

    </p>

  </div>

  </div>
  
</section>

<?php wp_footer(); ?>

</body>

</html>