<?php 

/**
 * Sonex Theme Functions Engine
 */

require_once get_template_directory() . '/framework/sample-config.php';
require_once get_template_directory() . '/framework/bfi_thumb-master/BFI_Thumb.php';	
require_once get_template_directory() . '/framework/meta-boxes.php';
require_once get_template_directory() . '/framework/widget/widget.php';
require_once get_template_directory() . '/framework/mega-menu-framework.php';
require_once get_template_directory() . '/framework/mega-menus.php';
require_once get_template_directory() . '/framework/icons/sonexicon.php';
function sonex_setup() {
    /* Set the $content_width for things such as video embeds. */
    if ( ! isset( $content_width ) ) 
        $content_width = 900;
	
    load_theme_textdomain( 'sonex', get_template_directory() . '/languages' );
	// Add RSS feed links to <head> for posts and comments.p
	add_theme_support( 'automatic-feed-links' );
    add_theme_support( 'custom-header' );
	// Enable support for Post Thumbnails, and declare two sizes.
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 672, 372, true );
	add_image_size( 'sonex-full-width', 1038, 576, true );
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array( 'video', 'audio', 'gallery', 'quote', 'image') );

	// This theme allows users to set a custom background.
	add_theme_support( 'custom-background', apply_filters( 'sonex_custom_background_args', array(
		'default-color' => 'f5f5f5',
	) ) );


}
add_action( 'after_setup_theme', 'sonex_setup' );

function sonex_register_menu() {
  /* register menu. */  
  register_nav_menus( array(
		'primary'   => esc_html__( 'Primary menu', 'sonex' ),
        'secondary' => esc_html__( 'Footer menu','sonex' ),
        'top' => esc_html__( 'Sub bar menu','sonex' ),
	) );
}
//adding function to register the titles
add_theme_support( 'title-tag' );
// Generate random string 

function sonex_PTid(){

$postids = array();
$latest_category_posts = get_posts('post_type=pricetable&showposts=1000');
foreach ($latest_category_posts as $catpost) {
    
$thetitle = get_the_title( $catpost->ID );
    $postids[$thetitle] = $catpost->ID;
}

return $postids;

}
add_action( 'init', 'sonex_register_menu' );
function sonex_load_custom_wp_admin_style() {
    wp_enqueue_style( 'custom_wp_admin_css', get_template_directory_uri() . '/framework/admin/admin-style.css', false, '1.0.0' );
    wp_enqueue_style( 'mega-menu-css', get_template_directory_uri().'/css/megamenu.css','','3.2');
    wp_enqueue_script( 'media-load-js', get_template_directory_uri().'/js/media-load.js','','3.2');   
}
/* Adding Woocommerce Support*/
add_action( 'admin_enqueue_scripts', 'sonex_load_custom_wp_admin_style' );

    add_action( 'after_setup_theme', 'woocommerce_support' );
    function woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
// Function to load theme default fonts
function sonex_fonts_url() {
    $font_url = '';
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'sonex' ) ) {
        $font_url = add_query_arg( 'family',( 'Oswald:400,700,300' ), "//fonts.googleapis.com/css" );
    }
    return esc_url($font_url);
}
function sonex_fontstwo_url() {
    $fonttwo_url = '';
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'sonex' ) ) {
        $fonttwo_url = add_query_arg( 'family',( 'Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic' ), "//fonts.googleapis.com/css" );
    }
    return esc_url($fonttwo_url);
}
function sonex_global() {
    $theme_option=get_option('theme_option');
    return $theme_option;
}
// Reqire File Style and JS
function sonex_theme_scripts_styles(){
     wp_enqueue_style( 'sonex-fonts', sonex_fonts_url(), array(), '1.0.0' );
     wp_enqueue_style( 'sonex-fontstwo', sonex_fontstwo_url(), array(), '1.0.0' );
     wp_enqueue_style( 'owl-carousel', get_template_directory_uri().'/css/owl.carousel.css','','3.2');
     /* Load the Cool Animation Effects */
     wp_enqueue_style( 'animate-css', get_template_directory_uri().'/css/animate.css','','3.2');
     /* Loading Font Awesome & Icomoon Fonts */
     wp_enqueue_style( 'icomoon-css', get_template_directory_uri().'/css/icomoon.css','','3.2');
	 wp_enqueue_style( 'awesome-css', get_template_directory_uri().'/css/font-awesome/css/font-awesome.css','','3.2');
     wp_enqueue_style( 'helpers-css', get_template_directory_uri().'/css/helpers.css','','3.2');
     /* Loading Mega Menu */
     wp_enqueue_style( 'mega-menu-css', get_template_directory_uri().'/css/megamenu.css','','3.2');
     wp_enqueue_style( 'main-css', get_template_directory_uri().'/css/megaheader.css','','3.2');
     /* Style css woocommerce shop */
	 wp_enqueue_style( 'woocommerce-css', get_template_directory_uri().'/css/woocommerce.css','','3.2');
    /* Bootstrap */
     wp_enqueue_style( 'bootstrap-css', get_template_directory_uri().'/css/bootstrap.min.css','','3.2');
     wp_enqueue_style( 'style', get_stylesheet_uri(), array(),'2016-05-05');
     /* theme option for color */
     wp_enqueue_style( 'color', get_template_directory_uri() .'/framework/color.php');
     /* Loading Media Queries */
     wp_enqueue_style( 'responsive-css', get_template_directory_uri().'/css/responsive.css','','3.2');  
    /**** Bootstrap core and JavaScript's ****/
    wp_enqueue_script("modernizr", get_template_directory_uri()."/js/vendor/modernizr-2.6.2-respond-1.1.0.min.js",array(),false,false);
    wp_enqueue_script("bootstrap-js", get_template_directory_uri()."/js/vendor/bootstrap.min.js",array('jquery'),false,true);
    wp_enqueue_script("easing", get_template_directory_uri()."/js/jquery.easing.1.3.js",array('jquery'),false,true);
    $theme_option=sonex_global(); 
    if ($theme_option[esc_attr('smooth_opt')] != '') {
    if ($theme_option[esc_attr('smooth_opt')] = 'true') {
    wp_enqueue_script("SmoothScroll", get_template_directory_uri()."/js/SmoothScroll.js",array(),false,true);
    }
    }
    wp_enqueue_script("owlcarousel", get_template_directory_uri()."/js/owl.carousel.min.js",array('jquery'),false,true);
    wp_enqueue_script("finstudio", get_template_directory_uri()."/js/jquery.finsstudio.js",array('jquery'),false,false);
    wp_enqueue_script("masonry-js", get_template_directory_uri()."/js/masonry.pkgd.min.js",array(),false,true);
	wp_enqueue_script("imagesloaded-js", get_template_directory_uri()."/js/imagesloaded.pkgd.min.js",array(),false,true);
    wp_enqueue_script("mediaload-js", get_template_directory_uri()."/js/media-load.js",array('jquery'),false,true);
    wp_enqueue_script("fitvid-js", get_template_directory_uri()."/js/jquery.fitvids.js",array('jquery'),false,true);
    wp_enqueue_script("retina-js", get_template_directory_uri()."/js/retina.js",array(),false,true);
    wp_enqueue_script("SmoothScroll-js", get_template_directory_uri()."/js/page-scroll.js",array('jquery'),false,true);
    wp_enqueue_script("custom-js", get_template_directory_uri()."/js/sonex.js",array('jquery'),false,true);
}
add_action( 'wp_enqueue_scripts', 'sonex_theme_scripts_styles' );



//css For Option Header Layout and Footer Layout
function sonex_customize_css() {
	if(isset($theme_option[esc_attr('custom-css')])) {
		echo '<style type="text/css">'.$theme_option[esc_attr('custom-css')].'</style>';
	}
}
add_action( 'wp_head', 'sonex_customize_css');

//JS In footer
function sonex_code_js() {
	if(isset($theme_option['footer_js'])) {
		echo '<script type="text/javascript">'.$theme_option[esc_js('footer_js')].'</script>';
	}
}
add_action( 'wp_footer', 'sonex_code_js');
// Sonex Comments
function sonex_theme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
    <li>
        <div class="comment-item">
            <div class="comment-inner">
                <header>
                    <figure><?php if ( 0 != $args['avatar_size'] ) echo get_avatar( $comment ); ?></figure>
                    <p><?php printf(esc_html__('%s','sonex'), get_comment_author()) ?></p>
                    <p class="comment-date"><?php printf(get_comment_date('d M, Y'));?></p>
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'reply_text'=>'<i class="fa fa-reply"></i>', 'max_depth' => $args['max_depth']))) ?>
                </header>

                <div class="content">
                    <?php if ($comment->comment_approved == '0') { ?>
                    <em><?php esc_html_e('Your comment is awaiting moderation.','sonex') ?></em>
                    <?php } else {?>
                    <p><?php comment_text() ?></p>
                    <?php } ?>
                </div>
            </div>    
        </div> 
    </li>
<?php
}
//Custom Pagination
function sonex_pagination($prev = 'Prev', $next = 'Next', $pages='') {
    function sonex_wpquery() {
    global $wp_query;
    return $wp_query;
    }
    $wp_query=sonex_wpquery();
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }

    $pagination = array(
        'base'          => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
        'format'        => '',
        'current'       => max( 1, get_query_var('paged') ),
        'total'         => $pages,
        'prev_text' => $prev,
        'next_text' => $next,
        'end_size'      => 3,
        'mid_size'      => 3
);
    $return =  paginate_links( $pagination );
    echo str_replace( "<ul class='page-numbers'>", '<ul>', $return );
}

// Remove Background and Header setting in Appearance
add_action( 'after_setup_theme','remove_sonex_options', 100 );
function remove_sonex_options() {
	remove_theme_support( 'custom-background' );
	remove_theme_support( 'custom-header' );
}


// Widget Sidebar
function sonex_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Primary Sidebar', 'sonex' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Main sidebar that appears on the left.', 'sonex' ),
		'before_widget' => '<div class="sonex-widget %2$s main-content-block">',
		'after_widget'  => '<div class="clearfix"></div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) ); 

	register_sidebar( array(
		'name'          => esc_html__( 'Shop Sidebar', 'sonex' ),
		'id'            => 'sidebar-shop',
		'description'   => esc_html__( 'Shop sidebar that appears on the left.', 'sonex' ),
		'before_widget' => '<div class="sonex-widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer One Widget Area', 'sonex' ),
		'id'            => 'footer-area-1',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'sonex' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3><div class="widget-inner">',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Two Widget Area', 'sonex' ),
		'id'            => 'footer-area-2',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'sonex' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Three Widget Area', 'sonex' ),
		'id'            => 'footer-area-3',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'sonex' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Fourth Widget Area', 'sonex' ),
		'id'            => 'footer-area-4',
		'description'   => esc_html__( 'Footer Widget that appears on the Footer.', 'sonex' ),
		'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
	) );   

    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu Widget', 'sonex' ),
        'id'            => 'mega-menu-1',
        'description'   => esc_html__( 'Mega Menu widget.', 'sonex' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
    ) );   
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu Widget 2', 'sonex' ),
        'id'            => 'mega-menu-2',
        'description'   => esc_html__( 'Mega Menu Second widget.', 'sonex' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
    ) );   
    register_sidebar( array(
        'name'          => esc_html__( 'Mega Menu Widget 3', 'sonex' ),
        'id'            => 'mega-menu-3',
        'description'   => esc_html__( 'Mega Menu Third widget.', 'sonex' ),
        'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">',
        'after_widget'  => '</div></aside>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3><div class="widget-inner">',
    ) );     

}
add_action( 'widgets_init', 'sonex_widgets_init' );

// Custom Breadcrumbs
function sonex_breadcrumbs() {

    /* === OPTIONS === */
    $text['home']     = esc_html__('Home', 'sonex'); // text for the 'Home' link
    $text['category'] = '%s'; // text for a category page
    $text['tax']      = '%s'; // text for a taxonomy page
    $text['search']   = '%s'; // text for a search results page
    $text['tag']      = '%s'; // text for a tag page
    $text['author']   = '%s'; // text for an author page
    $text['404']      = '404'; // text for the 404 page

    $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
    $showOnHome  = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $delimiter   = ''; // delimiter between crumbs
    $before      = '<li class="active">'; // tag before the current crumb
    $after       = '</li>'; // tag after the current crumb

    /* === END OF OPTIONS === */
    $post = get_post();
    $homeLink = home_url("/") . '';
    $linkBefore = '<li>';
    $linkAfter = '</li>';
    $linkAttr = ' rel="v:url" property="v:title"';
    $link = $linkBefore . '<a' . $linkAttr . ' href="%1$s">%2$s</a>' . $linkAfter;

    if (is_home() || is_front_page()) {
        if ($showOnHome == 1) echo '<div id="crumbs"><a href="' . $homeLink . '">' . $text['home'] . '</a></div>';
    } else {
        echo '<ul class="breadcrumb">' . sprintf($link, $homeLink, $text['home']) . $delimiter;
        if ( is_category() ) {
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
            }

            echo htmlspecialchars_decode( $before ) . sprintf($text['category'], single_cat_title('', false)) . htmlspecialchars_decode( $after );
        } elseif( is_tax() ){
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) {
                $cats = get_category_parents($thisCat->parent, TRUE, $delimiter);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
            }

            echo htmlspecialchars_decode( $before ) . sprintf($text['tax'], single_cat_title('', false)) . htmlspecialchars_decode( $after );
        }elseif ( is_search() ) {
            echo htmlspecialchars_decode( $before ) . sprintf($text['search'], get_search_query()) . htmlspecialchars_decode( $after );
        } elseif ( is_day() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
            echo htmlspecialchars_decode( $before ) . get_the_time('d') . htmlspecialchars_decode( $after );
        } elseif ( is_month() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo htmlspecialchars_decode( $before ) . get_the_time('F') . htmlspecialchars_decode( $after );
        } elseif ( is_year() ) {
            echo htmlspecialchars_decode( $before ) . get_the_time('Y') . htmlspecialchars_decode( $after );
        } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                if ( get_post_type() == 'portfolio' ) {
                	printf($link, $homeLink . '' . $slug['slug'] . '/', 'Portfolio'); //Translate breadcrumb.
            	}else{
            		printf($link, $homeLink . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
            	}
                if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . htmlspecialchars_decode( $before ) . get_the_title() . htmlspecialchars_decode( $after );
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, $delimiter);
                if ($showCurrent == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
                $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
                echo htmlspecialchars_decode( $cats );
                if ($showCurrent == 1) echo htmlspecialchars_decode( $before ) . get_the_title() . htmlspecialchars_decode( $after );
            }

        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            $post_type = get_post_type_object(get_post_type());
            echo htmlspecialchars_decode( $before ) . $post_type->labels->singular_name . htmlspecialchars_decode( $after );
        } elseif ( is_attachment() ) {
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); $cat = $cat[0];
            $cats = get_category_parents($cat, TRUE, $delimiter);
            $cats = str_replace('<a', $linkBefore . '<a' . $linkAttr, $cats);
            $cats = str_replace('</a>', '</a>' . $linkAfter, $cats);
            echo htmlspecialchars_decode( $cats );
            printf($link, get_permalink($parent), $parent->post_title);
            if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . $before . get_the_title() . htmlspecialchars_decode( $after );
        } elseif ( is_page() && !$post->post_parent ) {
            if ($showCurrent == 1) echo htmlspecialchars_decode( $before ) . get_the_title() . htmlspecialchars_decode( $after );
        } elseif ( is_page() && $post->post_parent ) {
            $parent_id  = $post->post_parent;
            $breadcrumbs = array();
            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
                $parent_id  = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                echo htmlspecialchars_decode( $breadcrumbs[$i] );
                if ($i != count($breadcrumbs)-1) echo htmlspecialchars_decode( $delimiter );
            }
            if ($showCurrent == 1) echo htmlspecialchars_decode( $delimiter ) . htmlspecialchars_decode( $before ) . get_the_title() . htmlspecialchars_decode( $after );
        } elseif ( is_tag() ) {
            echo htmlspecialchars_decode( $before ) . sprintf($text['tag'], single_tag_title('', false)) . htmlspecialchars_decode( $after );
        } elseif ( is_author() ) {
            function sonex_author() {
             global $author;
             return $author;
             }
             $author=sonex_author();
            $userdata = get_userdata($author);
            echo htmlspecialchars_decode( $before ) . sprintf($text['author'], $userdata->display_name) . htmlspecialchars_decode( $after );
        } elseif ( is_404() ) {
            echo htmlspecialchars_decode( $before ) . esc_attr( $text['404'] ) . htmlspecialchars_decode( $after );
        }
        if ( get_query_var('paged') ) {
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() );
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
        }
        echo '</ul>';
    }
}   
function sonex_rddata() {
    global $rddata;
    return $rddata;
}
//Title element text for output
function sonex_wp_title( $title, $sep ) {
    $paged = paged_global();
    $page = page_global();

	if ( is_feed() ) {
		return $title;
	}

	// Add the site name.
	$title .= get_bloginfo( 'name', 'display' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) ) {
		$title = "$title $sep $site_description";
	}
	
	// Add a page number if necessary.
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
		$title = "$title $sep " . sprintf( esc_html__( 'Page %s', 'sonex' ), max( $paged, $page ) );
	}
	
	return $title;
}
add_filter( 'wp_title', 'sonex_wp_title', 10, 2 );

//function tag widgets
function sonex_tag_cloud_widget($args) {
    $args['number'] = 0; //adding a 0 will display all tags
    $args['largest'] = 13; //largest tag
    $args['smallest'] = 13; //smallest tag
    $args['unit'] = 'px'; //tag font unit
    $args['format'] = ''; //ul with a class of wp-tag-cloud
    $args['exclude'] = array(20, 80, 92); //exclude tags by ID
    return $args;
}
add_filter( 'widget_tag_cloud_args', 'sonex_tag_cloud_widget' );

// Excerp Number use: echo sonex_excerpt(25);
function sonex_excerpt($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
	  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
      return $excerpt;
}

// Create a query for the custom taxonomy
function sonexrelated_posts_by_taxonomy( $post_id, $taxonomy, $args=array() ) {
    $query = new WP_Query();
    $terms = wp_get_object_terms( $post_id, $taxonomy );
    // Make sure we have terms from the current post

    if ( count( $terms ) ) {
        $post_ids = get_objects_in_term( $terms[0]->term_id, $taxonomy );
        $post = get_post( $post_id );
        $post_type = get_post_type( $post );
        $type = 'portfolio';
        $args = wp_parse_args( $args, array(
                'post_type' => $type,
                'post__in' => $post_ids,
                'taxonomy' => $taxonomy,
                'term' => $terms[0]->slug,
            ) );
        $query = new WP_Query( $args );
    }
    // Return our results in query form
    return $query;
}

// WooCommerce
if (class_exists('Woocommerce')) {
    // Remove each style one by one
    add_filter( 'woocommerce_enqueue_styles', 'sonex_dequeue_styles' );
    function sonex_dequeue_styles( $enqueue_styles ) {
        unset( $enqueue_styles['woocommerce-general'] );
        return $enqueue_styles;
    }

    // Display 12 products per page. Goes in functions.php
    add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 12;' ), 20 );

    /**
    * woo_custom_product_searchform
    */
    add_filter( 'get_product_search_form' , 'sonex_woo_custom_product_searchform' );
    function sonex_woo_custom_product_searchform( $form ) {
        $form = '<form role="search" method="get" class="sidebar-search search" action="' . home_url( '/' ) . '" >  
            <input class="form-control" type="text" value="' . get_search_query() . '" name="s" placeholder="'. esc_html__( 'type to search...', 'sonex' ) .'" />       
            <input type="hidden" name="post_type" value="product" />
        </form>';
    return $form;
    }

    // breadcrumb woocommerce
    remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    add_action('breadcrumb_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    // related products woocommerce
    function sonexwoocommerce_output_related_products() {
        woocommerce_related_products(array( 'posts_per_page' => 12 ),4);  // Display 4 products in rows of 2
    }
}



//Code Visual Compurso.
require_once get_template_directory() . '/vc_shortcode.php';
function sonexcustom_css_classes_for_vc_row_and_vc_column($class_string, $tag) {
    if($tag=='vc_row' || $tag=='vc_row_inner') {
        $class_string = str_replace('vc_row-fluid', '', $class_string);
    }

    if($tag=='vc_column' || $tag=='vc_column_inner') {
        $class_string = preg_replace('/vc_col-xs-(\d{1,2})/', 'col-xs-$1', $class_string);
        $class_string = preg_replace('/vc_col-sm-(\d{1,2})/', 'col-md-$1', $class_string);
        $class_string = preg_replace('/vc_col-md-(\d{1,2})/', 'col-sm-$1', $class_string);
        $class_string = preg_replace('/vc_col-lg-(\d{1,2})/', 'col-lg-$1', $class_string);
    }
    return $class_string;
}




//Active Plugin: 

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package   TGM-Plugin-Activation
 * @version   2.5.2 for parent theme Sonex for publication on ThemeForest
 * @link      http://tgmpluginactivation.com/
 * @author    Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright Copyright (c) 2011, Thomas Griffin
 * @license   GPL-2.0+
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'sonex_register_required_plugins' );

function sonex_register_required_plugins() {

    $plugins = array(

        array(
            'name'               => 'Meta Box',
            'slug'               => 'meta-box',
            'required'           => true,
            'force_deactivation' => false,
        ),

        array(
            'name'                     => 'Contact Form 7', // The plugin name
            'slug'                     => 'contact-form-7', // The plugin slug (typically the folder name)
            'required'                 => false, // If false, the plugin is only 'recommended' instead of required
        ),

        array(
            'name'                     => 'Woocommerce', // The plugin name
            'slug'                     => 'woocommerce', // The plugin slug (typically the folder name)
            'required'                 => false, // If false, the plugin is only 'recommended' instead of required
        ),

        array(
            'name'                     => 'Newsletter', // The plugin name
            'slug'                     => 'newsletter', // The plugin slug (typically the folder name)
            'required'                 => false, // If false, the plugin is only 'recommended' instead of required
        ),

        
        // Plugin Include in Folder Theme
        array(            
            'name'               => 'Redux Framework', // The plugin name.
            'slug'               => 'reduxframework', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/redux-framework.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),
        array(            
            'name'               => 'Radium Importer', // The plugin name.
            'slug'               => 'radiummporter', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/radium.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),
        array(            
            'name'               => 'Sonex Core', // The plugin name.
            'slug'               => 'sonexcore', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/sonexcore.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),


        array(            
            'name'               => 'WPBakery Visual Composer', // The plugin name.
            'slug'               => 'js_composer', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/js_composer.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),
        

        array(            
            'name'               => 'Ultimate VC Addons', // The plugin name.
            'slug'               => 'Ultimate_VC_Addons', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/Ultimate_VC_Addons.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),


        array(
            'name' => 'LayerSlider WP',
            'slug' => 'LayerSlider',
            'source' => get_stylesheet_directory() . '/framework/plugins/LayerSlider.zip',
            'required' => false,
            'version' => '5.5.0',
            'force_deactivation' => true,
        ),

                
        array(
            'name'               => 'Essential Grid', // The plugin name.
            'slug'               => 'EssentialGrid', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/essential-grid.zip', // The plugin source.
            'required'           => true, // If false, the plugin is only 'recommended' instead of required.
        ),

        array(            
            'name'               => 'Fins Studio Testimonial', // The plugin name.
            'slug'               => 'fs_testimonial', // The plugin slug (typically the folder name).
            'source'             => get_template_directory_uri() . '/framework/plugins/fs_testimonial.zip', // The plugin source.
            'required'           => false, // If false, the plugin is only 'recommended' instead of required.
        ), 

    );
                        $config = array(

                            'default_path' => '',                      // Default absolute path to pre-packaged plugins.
                            'menu'         => 'tgmpa-install-plugins', // Menu slug.
                            'has_notices'  => true,                    // Show admin notices or not.
                            'dismissable'  => false,                    // If false, a user cannot dismiss the nag message.
                            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
                            'is_automatic' => true,                   // Automatically activate plugins after installation or not.
                            'message'      => '',                      // Message to output right before the plugins table.

                        );
tgmpa( $plugins, $config );
}
//remove redux annoying stuff
function sonex_removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}

add_action('init', 'sonex_removeDemoModeLink');

//remove redux from under the tools menu
add_action( 'admin_menu', 'sonex_remove_redux_menu',12 );
function sonex_remove_redux_menu() {
    remove_submenu_page('tools.php','redux-about');
}
function paged_global()
{
    $pagedGlobal = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
    return $pagedGlobal;
}
function page_global()
{
    $pageGlobal = get_query_var( 'page', 1 );;
    return $pageGlobal;
}
