<?php
/**
 * Register FF Tab Widget
 * @since 0.0.1
 */
 
 
function register_sonex_tab_widget() {
    register_widget( 'sonex_Tab_Widget' );
}
add_action( 'widgets_init', 'register_sonex_tab_widget' );

function sonex_set_post_views($postID) {
    $count_key = 'sonex_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}


/**
 * Add filter to single post
 * @since 0.0.1
 * updated 1.0
 */
 

function sonex_post_view($content) {
	if(is_single()){
		$content .= sonex_set_post_views(get_the_ID());
		// return sonex_get_post_views(get_the_ID());
	}
	return $content;
}

add_filter( 'the_content', 'sonex_post_view' ); 
 

/**
 * FF Tab Widget Class
 * @since 0.0.1
 */


class sonex_Tab_Widget extends WP_Widget {
	
	/**
	 * Widget actual process
	 * Reference: http://codex.wordpress.org/Plugins/WordPress_Widgets_Api
	 * @since 0.0.1
	 */
	
	public function __construct() {
		$widget_ops = array('classname' => 'sonex_tab_widget', 'description' => esc_html__('Display popular posts, recent posts, recent commets, and tags in an animated tabs.', 'sonex'));
		$control_ops = array('width' => 250, 'height' => 350);
		parent::__construct(null, esc_html__('sonex Tab Widget', 'sonex'), $widget_ops, $control_ops);
	}
	
	
	
	
	/**
	 * Widget output
	 * Reference: http://codex.wordpress.org/Plugins/WordPress_Widgets_Api
	 * @since 0.0.1
	 */ 
	 
	public function widget( $args, $instance ) {
		extract( $args );
		$pop = empty( $instance['pop'] ) ? '' : $instance['pop'];
		$poplimit = empty( $instance['poplimit'] ) ? '' : $instance['poplimit'];
		$recent = empty( $instance['recent'] ) ? '' : $instance['recent'];
		$recentlimit = empty( $instance['recentlimit'] ) ? '' : $instance['recentlimit'];
		$comment = empty( $instance['comment'] ) ? '' : $instance['comment'];
		$commentlimit = empty( $instance['commentlimit'] ) ? '' : $instance['commentlimit'];
		$title = apply_filters( 'widget_title', $instance['title'] );
		echo htmlspecialchars_decode( $before_widget );
		if ( ! empty( $title ) )
			echo htmlspecialchars_decode( $args['before_title'] ) . esc_attr( $title ) . htmlspecialchars_decode( $args['after_title'] );
	?>	

	<aside class="widget">

		<div class="widget-inner">

			<div class="tabs" data-active="1">

				<header>

					<h4><?php echo esc_attr($recent); ?></h4>

					<h4><?php echo esc_attr($pop); ?></h4>					

					<h4><?php echo esc_attr($comment); ?></h4>

				</header>	
		
				<div class="tabs-main">
			
				<?php
				
				/**
				 * Recent posts
				 * ------------
				 */			 



				$args = array(
					'post_type' => 'post', 
					'numberposts' => $recentlimit		
				);

				$get_query_posts = get_posts($args);

				if($get_query_posts) :

					$count=0; ?>

					<div class="tabs-item padding-bottom-10">
					<?php foreach($get_query_posts as $post) : 
						$num_comments = get_comments_number(); // get_comments_number returns only a numeric value

						if ( comments_open() ) {
							if ( $num_comments == 0 ) {
								$comments = esc_html__('0 Comment', 'sonex');
							} elseif ( $num_comments > 1 ) {
								$comments = $num_comments . esc_html__(' Comments', 'sonex');
							} else {
								$comments = esc_html__('1 Comment', 'sonex');
							}
							$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
						} else {
							$write_comments =  esc_html__('Comments are off for this post.', 'sonex');
						}
						$params = array( 'width' => 112, 'height' => 70 );
                        $url = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params );
						setup_postdata($post);
						//$format = get_post_format();
						?>
						
                        <article class="recent-post">

							<figure>

								<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($url); ?>" alt=""></a>

							</figure>

							<p><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>

							<p><?php echo esc_attr( sonex_excerpt(9) ); ?></p>

							<p class="meta"><?php esc_html_e('By', 'sonex'); ?> <?php the_author_posts_link(); ?> <?php esc_html_e('on', 'sonex'); ?> <span><?php the_time('M d, Y') ?></span></p>

						</article>
		
					<?php endforeach; ?>					
					<div class="clearfix"></div>
					</div>
					
				<?php endif; 

				// End of recent posts
				?>		
			
			
			
			
				<?php 
				
				// Popular posts
							
				$popular = new WP_Query( array( 
					'posts_per_page' => $poplimit, 
					'meta_key' => 'sonex_post_views_count', 
					'orderby' => 'meta_value_num', 
					'order' => 'DESC'  
				) );?>
				
				<div class="tabs-item padding-bottom-10">
				<?php while ( $popular->have_posts() ) : $popular->the_post();
					$num_comments = get_comments_number(); // get_comments_number returns only a numeric value

					if ( comments_open() ) {
						if ( $num_comments == 0 ) {
							$comments = esc_html__('0 Comment', 'sonex');
						} elseif ( $num_comments > 1 ) {
							$comments = $num_comments . esc_html__(' Comments', 'sonex');
						} else {
							$comments = esc_html__('1 Comment', 'sonex');
						}
						$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
					} else {
						$write_comments =  esc_html__('Comments are off for this post.', 'sonex');
					}
					$params = array( 'width' => 112, 'height' => 70 );
                    $url = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params );
					?>

					<article class="recent-post">

						<figure>

							<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($url); ?>" alt=""></a>

						</figure>

						<p><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>

						<p><?php echo esc_attr( sonex_excerpt(9) ); ?></p>

						<p class="meta"><?php esc_html_e('By', 'sonex'); ?> <?php the_author_posts_link(); ?> <?php esc_html_e('on', 'sonex'); ?> <span><?php the_time('M d, Y') ?></span></p>

					</article>

				<?php endwhile;	?>				<div class="clearfix"></div>
				</div>
				
				<?php
				
				// Comments
				//$GLOBALS['comment'] = $comment;
				$comments = get_comments( apply_filters( 'widget_comments_args', array( 
					'number' => $commentlimit, 
					'status' => 'approve', 
					'post_status' => 'publish' 
				) ) ); ?>
				
				<div class="tabs-item padding-bottom-0">
					<?php if ( $comments ) {
					// Prime cache for associated posts. (Prime post term cache if we need it for permalinks.)
					$post_ids = array_unique( wp_list_pluck( $comments, 'comment_post_ID' ) );
					_prime_post_caches( $post_ids, strpos( get_option( 'permalink_structure' ), '%category%' ), false );

					foreach ( (array) $comments as $comment) { 
						?>
						
                        <article class="recent-post recent-comment">

							<p>"<?php echo esc_attr( wp_html_excerpt( $comment->comment_content, 50 ) ); ?>..."</p>

							<p class="meta"><?php esc_html_e('By', 'sonex'); ?> <?php the_author_posts_link(); ?> on <span><?php the_time('M d, Y') ?></span></p>

						</article>
					<?php }	}?>
					<div class="clearfix"></div>
					</div>	
				</div>
			</div>			<div class="clearfix"></div>
		</div>		<div class="clearfix"></div>
	</aside>		
		
	<?php	
		
		echo htmlspecialchars_decode( $after_widget );
		
	}	
	
	/**
	 * Widget form on admin
	 * Reference: http://codex.wordpress.org/Plugins/WordPress_Widgets_Api
	 * @since 0.0.1
	 */ 
	
	public function form( $instance ) {

		$instance = wp_parse_args( (array) $instance, array(  
			'title'			=> '',
			'poplimit' 		=> 3, 
			'recentlimit' 	=> 3, 
			'commentlimit' 	=> 3,
			'pop'			=> 'Popular',
			'recent'			=> 'Recent',
			'comment'			=> 'comments',			  			
		) );
		$pop = strip_tags($instance['pop']);
		$poplimit = strip_tags($instance['poplimit']);
		$recent = strip_tags($instance['recent']);
		$recentlimit = strip_tags($instance['recentlimit']);
		$comment = strip_tags($instance['comment']);
		$commentlimit = strip_tags($instance['commentlimit']);
		$title = isset( $instance['title'] ) ? $instance['title'] : 'Blog Post';

	?>	
		<p>
			<label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'sonex' ); ?></label> 
			<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<!-- = Popular posts setting -->
	
		<p><span><strong><?php esc_html_e('Popular posts:', 'sonex'); ?></strong></span><br />
		
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('pop') ); ?>"><?php esc_html_e('Tab name: ', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('pop') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('pop') ); ?>" type="text" value="<?php echo esc_attr($pop); ?>" /><br />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('poplimit') ); ?>"><?php esc_html_e('Show number:', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('poplimit') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('poplimit') ); ?>" type="text" value="<?php echo esc_attr($poplimit); ?>" />
		
		</p>
		
		<!-- / Popular posts setting -->
		
		
		<!-- = Recent posts setting -->
		
		<p><span><strong><?php esc_html_e('Recent posts:', 'sonex'); ?></strong></span><br />
		
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('recent') ); ?>"><?php esc_html_e('Tab name: ', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('recent') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('recent') ); ?>" type="text" value="<?php echo esc_attr($recent); ?>" /><br />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('recentlimit') ); ?>"><?php esc_html_e('Show number: ', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('recentlimit') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('recentlimit') ); ?>" type="text" value="<?php echo esc_attr($recentlimit); ?>" />
		
		</p>
		
		<!-- / Recent posts setting -->
		

		<!-- = Recent comments setting -->
		
		<p><span><strong><?php esc_html_e('Recent comments:', 'sonex'); ?></strong></span><br />
		
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('comment') ); ?>"><?php esc_html_e('Tab name: ', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('comment') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('comment') ); ?>" type="text" value="<?php echo esc_attr($comment); ?>" /><br />
		<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('commentlimit') ); ?>"><?php esc_html_e('Limit number: ', 'sonex');?></label><input id="<?php echo htmlspecialchars_decode( $this->get_field_id('commentlimit') ); ?>" class="widefat" name="<?php echo htmlspecialchars_decode( $this->get_field_name('commentlimit') ); ?>" type="text" value="<?php echo esc_attr($commentlimit); ?>" />
		
		</p>
		
		<!-- / Recent comments setting -->
		
	
	<?php
	}

	/**
	 * Processes widget options to be saved
	 * Reference: http://codex.wordpress.org/Plugins/WordPress_Widgets_Api
	 * @since 0.0.1
	 */ 
	 
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['pop'] = strip_tags($new_instance['pop']);
		$instance['poplimit'] = strip_tags($new_instance['poplimit']);
		$instance['recent'] = strip_tags($new_instance['recent']);
		$instance['recentlimit'] = strip_tags($new_instance['recentlimit']);	
		$instance['comment'] = strip_tags($new_instance['comment']);
		$instance['commentlimit'] = strip_tags($new_instance['commentlimit']);
		$instance['title'] = strip_tags( $new_instance['title'] );	
		return $instance;
	}	
}