<?php 



// Creating the widget 



class sonexsocials_widget extends WP_Widget {







function __construct() {



parent::__construct(



// Base ID of your widget



'sonexsocials_widget', 







// Widget name will appear in UI



__('sonex Socials', 'sonex'), 







// Widget description



array( 'description' => esc_html__( 'sonex Socials Footer', 'sonex' ), ) 



);



}







// Creating widget front-end



// This is where the action happens



public function widget( $args, $instance ) {



	// these are the widget options



	$title = apply_filters( 'widget_title', $instance['title'] );



	 $facebook = esc_attr($instance['facebook']); 

	 $gplus = esc_attr($instance['gplus']); 



	 $twitter = esc_attr($instance['twitter']); 

	 $youtube = esc_attr($instance['youtube']); 

	 $pinterest = esc_attr($instance['pinterest']); 

	 $linkedin = esc_attr($instance['linkedin']); 

	 $dribbble = esc_attr($instance['dribbble']); 



	 $skype = esc_attr($instance['skype']); 

	 $rss = esc_attr($instance['rss']);







// before and after widget arguments are defined by themes



echo htmlspecialchars_decode( $args['before_widget'] );



if ( ! empty( $title ) ){

	echo htmlspecialchars_decode( $args['before_title'] ) . esc_attr( $title ) . htmlspecialchars_decode( $args['after_title'] ); 

}?>



	<p class="sm-buttons-2">



	<?php



		if( $facebook ) {



	      echo '<a href="'.esc_url($facebook).'" title="" ><i class="fa fa-facebook"></i></a>';



	   }





	   if( $twitter ) {



	      echo '<a href="'.esc_url($twitter).'" title=""><i class="fa fa-twitter"></i></a>';



	   }



	   if( $youtube ) {



	      echo '<a href="'.esc_url($youtube).'" title=""><i class="fa fa-youtube"></i></a>';



	   }



	   if( $linkedin ) {



	      echo '<a href="'.esc_url($linkedin).'" title=""><i class="fa fa-linkedin"></i></a>';



	   }



	   if( $gplus ) {



	      echo '<a href="'.esc_url($gplus).'" title=""><i class="fa fa-google-plus"></i></a>';



	   }



	   if( $dribbble ) {



	      echo '<a href="'.esc_url($dribbble).'" title=""><i class="fa fa-dribbble"></i></a>';



	   }

	    if( $pinterest ) {



	      echo '<a href="'.esc_url($pinterest).'" title=""><i class="fa fa-pinterest"></i></a>';



	   }

	   


	   if( $skype ) {



	      echo '<a href="'.esc_url($skype).'" title=""><i class="fa fa-skype"></i></a>';



	   } 



	   if( $rss ) {



	      echo '<a href="'.esc_url($rss).'" title=""><i class="fa fa-rss"></i></a>';



	   }  



	?>



	</p>



</div>



<?php 



echo htmlspecialchars_decode( $args['after_widget'] );

}



		



// Widget Backend 



public function form( $instance ) {



// Check values

if(isset( $instance[ 'title' ] ) || isset($instance['rss']) || isset($instance['pinterest']) || isset( $instance[ 'facebook' ] ) || isset( $instance[ 'gplus' ] ) || isset( $instance[ 'twitter' ] ) || isset( $instance[ 'youtube' ] ) || isset( $instance[ 'linkedin' ] ) || isset( $instance[ 'dribbble' ] ) || isset( $instance[ 'skype' ] )) {

     $title = esc_attr($instance['title']);

	 $facebook = esc_attr($instance['facebook']); 

	 $gplus = esc_attr($instance['gplus']); 

	 $twitter = esc_attr($instance['twitter']); 

	 $youtube = esc_attr($instance['youtube']); 

	 $linkedin = esc_attr($instance['linkedin']); 

	 $dribbble = esc_attr($instance['dribbble']); 

	 $pinterest = esc_attr($instance['pinterest']); 

	 $skype = esc_attr($instance['skype']); 

	 $rss = esc_attr($instance['rss']);
} else {

     $title = esc_html__( 'New title', 'sonex' );    
	 $facebook = ''; $gplus = ''; $twitter = ''; $youtube = ''; 
	 $linkedin = ''; $dribbble = ''; $skype = ''; $rss = '';$pinterest = '';

}
 



// Widget admin form



?>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'sonex' ); ?></label> 



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id( 'title' ) ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />



</p>





<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('facebook') ); ?>"><?php esc_html_e('Link Facebook:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('facebook') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('facebook') ); ?>" type="text" value="<?php echo esc_attr( $facebook ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('gplus') ); ?>"><?php esc_html_e('Link Google+:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('gplus') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('gplus') ); ?>" type="text" value="<?php echo esc_attr( $gplus ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('twitter') ); ?>"><?php esc_html_e('Link Twitter:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('twitter') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('twitter') ); ?>" type="text" value="<?php echo esc_attr( $twitter ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('youtube') ); ?>"><?php esc_html_e('Link Youtube:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('youtube') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('youtube') ); ?>" type="text" value="<?php echo esc_attr( $youtube ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('linkedin') ); ?>"><?php esc_html_e('Link Linkedin:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('linkedin') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('linkedin') ); ?>" type="text" value="<?php echo esc_attr( $linkedin ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('dribbble') ); ?>"><?php esc_html_e('Link Dribbble:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('dribbble') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('dribbble') ); ?>" type="text" value="<?php echo esc_attr( $dribbble ); ?>" />



</p>

<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('pinterest') ); ?>"><?php esc_html_e('Link Pinterest:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('pinterest') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('pinterest') ); ?>" type="text" value="<?php echo esc_attr( $pinterest ); ?>" />



</p>

<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('skype') ); ?>"><?php esc_html_e('Link Skype:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('skype') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('skype') ); ?>" type="text" value="<?php echo esc_attr( $skype ); ?>" />



</p>



<p>



<label for="<?php echo htmlspecialchars_decode( $this->get_field_id('rss') ); ?>"><?php esc_html_e('Link Rss:', 'sonex'); ?></label>



<input class="widefat" id="<?php echo htmlspecialchars_decode( $this->get_field_id('rss') ); ?>" name="<?php echo htmlspecialchars_decode( $this->get_field_name('rss') ); ?>" type="text" value="<?php echo esc_attr( $rss ); ?>" />



</p>



<?php 



}



	



// Updating widget replacing old instances with new



public function update( $new_instance, $old_instance ) {



$instance = array();



$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';



$instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';



$instance['gplus'] = ( ! empty( $new_instance['gplus'] ) ) ? strip_tags( $new_instance['gplus'] ) : '';



$instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';



$instance['youtube'] = ( ! empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : '';



$instance['linkedin'] = ( ! empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : '';



$instance['dribbble'] = ( ! empty( $new_instance['dribbble'] ) ) ? strip_tags( $new_instance['dribbble'] ) : '';

$instance['pinterest'] = ( ! empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';


$instance['skype'] = ( ! empty( $new_instance['skype'] ) ) ? strip_tags( $new_instance['skype'] ) : '';



$instance['rss'] = ( ! empty( $new_instance['rss'] ) ) ? strip_tags( $new_instance['rss'] ) : '';



return $instance;



}



} // Class wpb_widget ends here







// Register and load the widget



function wpb_sonexsocials_widget() {



	register_widget( 'sonexsocials_widget' );



}



add_action( 'widgets_init', 'wpb_sonexsocials_widget' );



