<?php

/**
*ReduxFramework Sample Config File
*For full documentation, please visit: https://github.com/ReduxFramework/ReduxFramework/wiki
 * */



if (!class_exists("Redux_Framework_sample_config")) {



    class Redux_Framework_sample_config {



        public $args = array();

        public $sections = array();

        public $theme;

        public $ReduxFramework;



        public function __construct() {

            // This is needed. Bah WordPress bugs.  ;)           

            $this->initSettings();

        }



        public function initSettings() {



            if ( !class_exists("ReduxFramework" ) ) {

                return;

            }       

            

            // Just for demo purposes. Not needed per say.

            $this->theme = wp_get_theme();



            // Set the default arguments

            $this->setArguments();



            // Set a few help tabs so you can see how it's done

            $this->setHelpTabs();



            // Create the sections and fields

            $this->setSections();



            if (!isset($this->args['opt_name'])) { // No errors please

                return;

            }



            // If Redux is running as a plugin, this will remove the demo notice and links

            //add_action( 'redux/plugin/hooks', array( $this, 'remove_demo' ) );

            // Function to test the compiler hook and demo CSS output.

            //add_filter('redux/options/'.$this->args['opt_name'].'/compiler', array( $this, 'compiler_action' ), 10, 2); 

            // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.

            // Change the arguments after they've been declared, but before the panel is created

            //add_filter('redux/options/'.$this->args['opt_name'].'/args', array( $this, 'change_arguments' ) );

            // Change the default value of a field after it's been set, but before it's been useds

            //add_filter('redux/options/'.$this->args['opt_name'].'/defaults', array( $this,'change_defaults' ) );

            // Dynamically add a section. Can be also used to modify sections/fields

            add_filter('redux/options/' . $this->args['opt_name'] . '/sections', array($this, 'dynamic_section'));



            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);

        }



        /**
          * This is a test function that will let you see when the compiler hook occurs.
          * It only runs if a field	set with compiler=>true is changed.
         **/

        function compiler_action($options, $css) {

            //echo "<h1>The compiler hook has run!";

            //print_r($options); //Option values

            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )



            /*

              // Demo of how to use the dynamic CSS and write your own static CSS file

              $filename = get_template_directory() . '/style' . '.css';

              global $wp_filesystem;

              if( empty( $wp_filesystem ) ) {

              require_once( ABSPATH .'/wp-admin/includes/file.php' );

              WP_Filesystem();

              }



              if( $wp_filesystem ) {

              $wp_filesystem->put_contents(

              $filename,

              $css,

              FS_CHMOD_FILE // predefined mode settings for WP files

              );

              }

             */

        }



        /**
          * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
          * Simply include this function in the child themes functions.php file.
          * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
          * so you must use get_template_directory_uri() if you want to use any of the built in icons
         * */

        function dynamic_section($sections) {

            //$sections = array();
           
            return $sections;

        }



        /**
          * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
         * */

        function change_arguments($args) {

            //$args['dev_mode'] = true;



            return $args;

        }



        /**
          * Filter hook for filtering the default value of any given field. Very useful in development mode.
         * */

        function change_defaults($defaults) {

            $defaults['str_replace'] = "Testing filter hook!";



            return $defaults;

        }



        // Remove the demo link and the notice of integrated demo from the redux-framework plugin

        function remove_demo() {



            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.

            if (class_exists('ReduxFrameworkPlugin')) {

                remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::get_instance(), 'plugin_meta_demo_mode_link'), null, 2);

            }



            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.

            remove_action('admin_notices', array(ReduxFrameworkPlugin::get_instance(), 'admin_notices'));

        }



        public function setSections() {



            /**
              * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
             * */

            // Background Patterns Reader

            $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';

            $sample_patterns_url = ReduxFramework::$_url . '../sample/patterns/';

            $sample_patterns = array();



            if (is_dir($sample_patterns_path)) :



                if ($sample_patterns_dir = opendir($sample_patterns_path)) :

                    $sample_patterns = array();



                    while (( $sample_patterns_file = readdir($sample_patterns_dir) ) !== false) {



                        if (stristr($sample_patterns_file, '.png') !== false || stristr($sample_patterns_file, '.jpg') !== false) {

                            $name = explode(".", $sample_patterns_file);

                            $name = str_replace('.' . end($name), '', $sample_patterns_file);

                            $sample_patterns[] = array('alt' => $name, 'img' => $sample_patterns_url . $sample_patterns_file);

                        }

                    }

                endif;

            endif;



            ob_start();



            $ct = wp_get_theme();

            $this->theme = $ct;

            $item_name = $this->theme->get('Name');

            $tags = $this->theme->Tags;

            $screenshot = $this->theme->get_screenshot();

            $class = $screenshot ? 'has-screenshot' : '';



            $customize_title = sprintf(__('Customize &#8220;%s&#8221;', 'sonex'), $this->theme->display('Name'));

            ?>

            <div id="current-theme" class="<?php echo esc_attr($class); ?>">

            <?php if ($screenshot) : ?>

                <?php if (current_user_can('edit_theme_options')) : ?>

                        <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr($customize_title); ?>">

                            <img src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview','sonex'); ?>" />

                        </a>

                <?php endif; ?>

                    <img class="hide-if-customize" src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview','sonex'); ?>" />

            <?php endif; ?>



                <h4>

            <?php echo $this->theme->display('Name'); ?>

                </h4>



                <div>

                    <ul class="theme-info">

                        <li><?php printf(__('By %s', 'sonex'), $this->theme->display('Author')); ?></li>

                        <li><?php printf(__('Version %s', 'sonex'), $this->theme->display('Version')); ?></li>

                        <li><?php echo '<strong>' . esc_html__('Tags', 'sonex') . ':</strong> '; ?><?php printf($this->theme->display('Tags')); ?></li>

                    </ul>

                    <p class="theme-description"><?php echo $this->theme->display('Description'); ?></p>

                <?php

                if ($this->theme->parent()) {

                    printf(' <p class="howto">' . esc_html__('This <a href="%1$s">child theme</a> requires its parent theme, %2$s.','sonex') . '</p>', esc_html__('http://codex.wordpress.org/Child_Themes', 'sonex'), $this->theme->parent()->display('Name'));

                }

                ?>



                </div>



            </div>



            <?php

            $item_info = ob_get_contents();



            ob_end_clean();



            $sampleHTML = '';

            if (file_exists(get_template_directory() . '/ReduxFramework/sample/info-html.html')) {

                /** @global WP_Filesystem_Direct $wp_filesystem  */

                global $wp_filesystem;

                if (empty($wp_filesystem)) {

                    require_once(ABSPATH . '/wp-admin/includes/file.php');

                    WP_Filesystem();
                }
                $sampleHTML = $wp_filesystem->get_contents(get_template_directory() . '/ReduxFramework/sample/info-html.html');
            }
            // ACTUAL DECLARATION OF SECTIONS          
			$this->sections[] = array(
                'icon' => 'el-icon-stackoverflow',
                'title' => esc_html__('Basic Settings', 'sonex'),
                'fields' => array(                                           
                    array(
                        'id'       => 'preload_opt',
                        'type'     => 'switch',
                        'title'    => esc_html__('On/Off Preload', 'sonex'),
                        'subtitle' => esc_html__('Look, it\'s on!', 'sonex'),
                        'default'  => true,
                    ),
                    array(
                        'id'       => 'smooth_opt',
                        'type'     => 'switch',
                        'title'    => esc_html__('On/Off Smooth Scroll', 'sonex'),
                        'subtitle' => esc_html__('Look, it\'s on!', 'sonex'),
                        'default'  => false,
                    ),
					array(
						'id'       => 'search_opt',
						'type'     => 'switch',
						'title'    => esc_html__('Search box in header', 'sonex'),
						'subtitle' => esc_html__('Look, it\'s on!', 'sonex'),
						'default'  => true,
					),     
				    array(
						'id'       => 'breadcrumbs_opt',
						'type'     => 'switch',
						'title'    => esc_html__('Breadcrumbs in top page.', 'sonex'),
						'subtitle' => esc_html__('Look, it\'s on!', 'sonex'),
						'default'  => true,
					),   
                 )
            );

			$this->sections[] = array(

                'icon' => ' el-icon-picture',

                'title' => esc_html__('Branding', 'sonex'),

                'fields' => array(

                    array(

                        'id' => 'bcimage',

                        'type' => 'media',

                        'url' => true,

                        'title' => esc_html__('Breadcrumb Background', 'sonex'),

                        'compiler' => 'true',

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'desc' => esc_html__('Upload the background image for Breadcrumbs section.', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/breadbg.jpg'),

                    ),


					array(

                        'id' => 'logocheck',

                        'type' => 'checkbox',

                        'title' => esc_html__('Use Big Logo?', 'sonex'),

                        'subtitle' => 'default: Logo small + text',

                        'desc' => '',

                        'default' => '0'// 1 = on | 0 = off

                    ),
                                        array(

                        'id' => 'favicon',

                        'type' => 'media',

                        'url' => true,

                        'title' => esc_html__('Custom Favicon', 'sonex'),

                        'compiler' => 'true',

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'desc' => esc_html__('Upload your Favicon.', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/favicon.ico'),

                    ),

					array(

                        'id' => 'logo',

                        'type' => 'media',

                        'url' => true,

                        'title' => esc_html__('Logo', 'sonex'),

                        'compiler' => 'true',

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'desc' => esc_html__('Upload your logo.', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/sonex.png'),

                    ),

                    array(

                        'id' => 'logo_width',

                        'type' => 'text',

                        'title' => esc_html__('Width of Logo (px)', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => 'sonex',

                    ),

                    array(

                        'id' => 'logo_height',

                        'type' => 'text',

                        'title' => esc_html__('Height of Logo (px)', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => '',

                    ),

					array(

                        'id' => 'site_name',

                        'type' => 'text',

                        'title' => esc_html__('Site Name', 'sonex'),

                        'subtitle' => esc_html__('Site Name, leave a blank do not show.', 'sonex'),

                        'default' => '',

                    ),

					array(

                        'id' => 'tagline',

                        'type' => 'text',

                        'title' => esc_html__('Tag Line', 'sonex'),

                        'subtitle' => esc_html__('Tag Line, leave a blank do not show.', 'sonex'),

                        'default' => 'WordPress Theme for Creatives',

                    ),

                )

            );

			

			

			$this->sections[] = array(

                'icon' => 'el-icon-qrcode',

                'title' => esc_html__('Header Settings', 'sonex'),

                'fields' => array(					

					array(

                        'id' => 'header_layout',

                        'type' => 'image_select',

                        'title' => esc_html__('Header Layout', 'sonex'),

                        'subtitle' => esc_html__('Select Your Header layout', 'sonex'),

                        'desc' => '',

                        'options' => array(


                            'header4' => array(

                                'alt'   => 'Hlayout 4',

                                'img'   => ReduxFramework::$_url.'assets/img/hlayout4.png'

                            ), 
						

						), 

                        'default' => 'header4'

                    ),

					array(

                        'id' => 'top_info_address',

                        'type' => 'text',

                        'title' => esc_html__('Contact on Top Address', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'Sonex Inc, Commercial Suite, Sydney.'

                    ),

					array(

                        'id' => 'top_info_phone',

                        'type' => 'text',

                        'title' => esc_html__('Contact on Top Phone Number', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => '655-897-5252'

                    ),

					array(

                        'id' => 'top_info_email',

                        'type' => 'text',

                        'title' => esc_html__('Contact on Top Email', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'support@yourdomain.com'

                    ),

					

				)

			);			

			

			 $this->sections[] = array(

                'icon' => 'el-icon-blogger',

                'title' => esc_html__('Blog Settings', 'sonex'),

                'fields' => array(	
                    array(
                        'id' => 'blog_title',
                        'type' => 'text',
                        'title' => esc_html__('Blog Title', 'sonex'),
                        'subtitle' => esc_html__('Input Blog Title', 'sonex'),
                        'desc' => esc_html__('', 'sonex'),
                        'default' => 'Blog'
                    ),				

                    array(

                        'id' => 'single_title',

                        'type' => 'text',

                        'title' => esc_html__('Single Blog Title', 'sonex'),

                        'subtitle' => esc_html__('Input Single Title', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'Blog Article'

                    ),      

					array(

                        'id' => 'blog_excerpt',

                        'type' => 'text',

                        'title' => esc_html__('Blog Custom Excerpt', 'sonex'),

                        'subtitle' => esc_html__('Input number custom excerpt', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => '30'

                    ),

                    array(

                        'id' => 'blog_rm',

                        'type' => 'text',

                        'title' => esc_html__('Text Read More', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'read more'

                    ),

                    array(

                        'id' => 'author',

                        'type' => 'select',

                        'title' => esc_html__('Show About Author Single Blog ?', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'options'  => array(

                            'yes' => 'Yes',

                            'no'  => 'No',

                        ),

                        'default' => 'yes',

                    ), 				 

				 )

            );

             $this->sections[] = array(

                'icon' => 'el-icon-briefcase',

                'title' => esc_html__('Portfolio Settings', 'sonex'),

                'fields' => array(

					array(

                        'id' => 'show_all',

                        'type' => 'text',

                        'title' => esc_html__('Text Show All Filter', 'sonex'),

                        'subtitle' => '',                                              

                        'default' => 'Show All'

                    ), 

					array(

                        'id' => 'portfolio_related',

                        'type' => 'text',

                        'title' => esc_html__('Title Related Portfolio Single Page ', 'sonex'),

                        'subtitle' => '',                                              

                        'default' => 'Related <strong>Projects</strong>'

                    ),

                    array(

                        'id' => 'portfolio_show',

                        'type' => 'text',

                        'title' => esc_html__('Show Posts', 'sonex'),

                        'subtitle' => 'Show number posts in portfolio page',                                              

                        'default' => '8'

                    ),

				)
			);	
			
            $this->sections[] = array(
                'icon' => 'el-icon-shopping-cart-sign',
                'title' => esc_html__('Shop Settings', 'sonex'),
                'fields' => array(   
                    array(
                        'id' => 'single_product_title',
                        'type' => 'text',
                        'title' => esc_html__('Single Title', 'sonex'),
                        'subtitle' => '',
                        'desc' => esc_html__('Title on Single Page', 'sonex'),
                        'default' => 'Shop Product'
                    ),                 
                    array(
                        'id' => 'product_related_title',
                        'type' => 'text',
                        'title' => esc_html__('Related Title', 'sonex'),
                        'subtitle' => '',
                        'desc' => esc_html__('Title Box Related Product on Single Page', 'sonex'),
                        'default' => 'Related Products'
                    ),
                )
            );

			$this->sections[] = array(

                'icon' => 'el-icon-group',

                'title' => esc_html__('Social Media Settings', 'sonex'),

                'fields' => array(
					array(

                        'id' => 'facebook',

                        'type' => 'text',

                        'title' => esc_html__('Facebook Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://www.facebook.com/',

                    ),

					array(

                        'id' => 'google',

                        'type' => 'text',

                        'title' => esc_html__('Google+ Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://plus.google.com',

                    ),

					array(

                        'id' => 'twitter',

                        'type' => 'text',

                        'title' => esc_html__('Twitter Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://twitter.com/',

                    ),

					array(

                        'id' => 'youtube',

                        'type' => 'text',

                        'title' => esc_html__('Youtube Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://youtube.com/',

                    ),

					array(

                        'id' => 'linkedin',

                        'type' => 'text',

                        'title' => esc_html__('Linkedin Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://www.linkedin.com/',

                    ),

					array(

                        'id' => 'dribbble',

                        'type' => 'text',

                        'title' => esc_html__('Dribbble Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://www.dribbble.com/',

                    ),

                    array(

                        'id' => 'pinterest',

                        'type' => 'text',

                        'title' => esc_html__('Pinterest Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://www.pinterest.com/',

                    ),                    

                    array(

                        'id' => 'instagram',

                        'type' => 'text',

                        'title' => esc_html__('Instagram Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => 'https://www.instagram.com/',

                    ),

					array(

                        'id' => 'skype',

                        'type' => 'text',

                        'title' => esc_html__('Skype Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => '#'

                    ),					

                    array(

                        'id' => 'rssfeed',

                        'type' => 'text',

                        'title' => esc_html__('RSS Feed Url', 'sonex'),

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'default' => '#'

                    ),

				)

			);
                    $this->sections[] = array(

                'icon' => 'el-icon-graph',

                'title' => esc_html__('404 Settings', 'sonex'),

                'fields' => array(

                    array(

                        'id' => '404_bg',

                        'type' => 'media',

                        'title' => esc_html__('Background Image', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/404.jpg'),

                    ),

                    array(

                        'id' => '404_title',

                        'type' => 'text',

                        'title' => esc_html__('404 Title', 'sonex'),

                        'subtitle' => esc_html__('Input 404 Title', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => '404 Page Not Found !'

                    ),                              

                    array(

                        'id' => '404_content',

                        'type' => 'editor',

                        'title' => esc_html__('404 Content', 'sonex'),

                        'subtitle' => esc_html__('Enter 404 Content', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'The link you followed is probably broken, or the page has been removed.'

                    ),

                    array(

                        'id' => 'back_home',

                        'type' => 'text',

                        'title' => esc_html__('Text Back Home', 'sonex'),

                        'subtitle' => esc_html__('Input text back', 'sonex'),

                        'desc' => esc_html__('', 'sonex'),

                        'default' => 'Back to Homepage'

                    ),               

                 )

            );
			$this->sections[] = array(

                'icon' => ' el-icon-credit-card',

                'title' => esc_html__('Footer Settings', 'sonex'),

                'fields' => array(	

                    array(

                        'id' => 'footer_layout',

                        'type' => 'image_select',

                        'title' => esc_html__('Footer Layout', 'sonex'),

                        'subtitle' => esc_html__('Select Your Footer layout', 'sonex'),

                        'desc' => '',

                        'options' => array(

                            'footer1' => array(

                                'alt'   => 'Flayout 1',

                                'img'   => ReduxFramework::$_url.'assets/img/flayout1.png'

                            ),

                            'footer2' => array(

                                'alt'   => 'Flayout 2',

                                'img'   => ReduxFramework::$_url.'assets/img/flayout3.png'

                            ),                           

                        ), 

                        'default' => 'footer1'

                    ),				

					array(

                        'id' => 'footer_text',

                        'type' => 'editor',

                        'title' => esc_html__('Footer Text', 'sonex'),

                        'subtitle' => esc_html__('Copyright Text', 'sonex'),

                        'default' => 'Sonex Copyright 2016. All Rights Reserved.',

                    ),

                    array(

                        'id' => 'footlogo',

                        'type' => 'media',

                        'url' => true,

                        'title' => esc_html__('Footer Logo', 'sonex'),

                        'compiler' => 'true',

                        //'mode' => false, // Can be set to false to allow any media type, or can also be set to any mime type.

                        'desc' => esc_html__('Upload your Footer logo.', 'sonex'),

                        'subtitle' => esc_html__('', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/foot-sonex.png'),

                    ),

                    array(
                        'id'       => 'footer_js',
                        'type'     => 'ace_editor',
                        'title'    => esc_html__( 'JS Code', 'sonex' ),
                        'subtitle' => esc_html__( 'Paste your JS code here.', 'sonex' ),
                        'mode'     => 'javascript',
                        'theme'    => 'chrome',
                        'desc'     => 'Possible modes can be found at http://ace.c9.io',
                        'default'  => "jQuery(document).ready(function(){\n\n});"
                    ),

				)

			);

            $this->sections[] = array(

                'icon' => 'el-icon-website',

                'title' => esc_html__('Styling Options', 'sonex'),

                'fields' => array(


                    array(

                        'id' => 'boxed_bg',

                        'type' => 'media',

                        'title' => esc_html__('Background Image', 'sonex'),

                        'subtitle' => esc_html__('Background Image for Boxed Version', 'sonex'),

                        'desc' => esc_html__('Background Image only for Boxed Version', 'sonex'),

                        'default' => array('url' => get_template_directory_uri().'/images/bg-patterns/1.jpg')

                    ),  

                    array(

                        'id' => 'main_color',

                        'type' => 'color',

                        'title' => esc_html__('Theme Main Color', 'sonex'),

                        'subtitle' => esc_html__('Pick the main color for the theme (default: #4183D7).', 'sonex'),

                        'default' => '#4183D7',

                        'validate' => 'color',

                    ),

                    

                    array(

                        'id' => 'second_color',

                        'type' => 'color',

                        'title' => esc_html__('Border Color', 'sonex'),

                        'subtitle' => esc_html__('Pick a secondary color for theme (default: #017193).', 'sonex'),

                        'default' => '#017193',

                        'validate' => 'color',

                    ),		                   

                    array(

                        'id' => 'footer_bg',

                        'type' => 'color',

                        'title' => esc_html__('The Footer Background Color', 'sonex'),

                        'subtitle' => esc_html__('Pick a footer background color for theme (default: #182127).', 'sonex'),

                        'default' => '#182127',

                        'validate' => 'color',

                    ),

                    array(

                        'id' => 'body-font2',

                        'type' => 'typography',

						'output' => array('body'),

                        'title' => esc_html__('Body Font', 'sonex'),

                        'subtitle' => esc_html__('Specify the body font properties.', 'sonex'),

                        'google' => true,

                        'default' => array(

                            'color' => '',

                            'font-size' => '',

                            'line-height' => '',

                            'font-family' => "",

                        ),

                    ),

                     array(

                        'id' => 'custom-css',

                        'type' => 'ace_editor',

                        'title' => esc_html__('CSS Code', 'sonex'),

                        'subtitle' => esc_html__('Paste your CSS code here.', 'sonex'),

                        'mode' => 'css',

                        'theme' => 'monokai',

                        'desc' => 'Possible modes can be found at ace.c9.io',

                        'default' => "#header{\nmargin: 0 auto;\n}"

                    ),

                )

            );
            
            $this->sections[] = array(
                'icon' => 'el-icon-tint',
                'title' => esc_html__('Buttons Styling', 'sonex'),
                'fields' => array(   
                    array(
                        'id' => 'btn1_bg',
                        'type' => 'color',
                        'title' => esc_html__('Button Background Color', 'sonex'),
                        'subtitle' => esc_html__('Button background color for theme (default: #4183D7).', 'sonex'),
                        'default' => '#4183D7',
                        'validate' => 'color',
                    ),             
                    array(
                        'id' => 'btn1_border',
                        'type' => 'color',
                        'title' => esc_html__('Button Border Bottom Color', 'sonex'),
                        'subtitle' => esc_html__('Button border bottom color for theme (default: #1385C6).', 'sonex'),
                        'default' => '#4183d7',
                        'validate' => 'color',
                    ), 
                    array(
                        'id' => 'btn1_bghover',
                        'type' => 'color',
                        'title' => esc_html__('Button Background Hover Color', 'sonex'),
                        'subtitle' => esc_html__('Button background hover color for theme (default: #1385c6).', 'sonex'),
                        'default' => '#1385c6',
                        'validate' => 'color',
                    ), 
                    array(
                        'id'   =>'divider_2',
                        'desc' => esc_html__('Button Black', 'sonex'),
                        'type' => 'divide'
                    ),
                    array(
                        'id' => 'btn2_bg',
                        'type' => 'color',
                        'title' => esc_html__('Button Background Color', 'sonex'),
                        'subtitle' => esc_html__('Button background color for theme (default: #303335).', 'sonex'),
                        'default' => '#303335',
                        'validate' => 'color',
                    ),             
                    array(
                        'id' => 'btn2_border',
                        'type' => 'color',
                        'title' => esc_html__('Button Border Bottom Color', 'sonex'),
                        'subtitle' => esc_html__('Button border bottom color for theme (default: #0e1113).', 'sonex'),
                        'default' => '#0e1113',
                        'validate' => 'color',
                    ), 
                    array(
                        'id' => 'btn2_bghover',
                        'type' => 'color',
                        'title' => esc_html__('Button Background Hover Color', 'sonex'),
                        'subtitle' => esc_html__('Button background hover color for theme (default: #1f2224).', 'sonex'),
                        'default' => '#1f2224',
                        'validate' => 'color',
                    ), 
                )
            );
			

            $theme_info = '<div class="redux-framework-section-desc">';

            $theme_info .= '<p class="redux-framework-theme-data description theme-uri">' . esc_html__('<strong>Theme URL:</strong> ', 'sonex') . '<a href="' . $this->theme->get('ThemeURI') . '" target="_blank">' . $this->theme->get('ThemeURI') . '</a></p>';

            $theme_info .= '<p class="redux-framework-theme-data description theme-author">' . esc_html__('<strong>Author:</strong> ', 'sonex') . $this->theme->get('Author') . '</p>';

            $theme_info .= '<p class="redux-framework-theme-data description theme-version">' . esc_html__('<strong>Version:</strong> ', 'sonex') . $this->theme->get('Version') . '</p>';

            $theme_info .= '<p class="redux-framework-theme-data description theme-description">' . $this->theme->get('Description') . '</p>';

            $tabs = $this->theme->get('Tags');

            if (!empty($tabs)) {

                $theme_info .= '<p class="redux-framework-theme-data description theme-tags">' . esc_html__('<strong>Tags:</strong> ', 'sonex') . implode(', ', $tabs) . '</p>';

            }

            $theme_info .= '</div>';

        }



        public function setHelpTabs() {



            // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.

            $this->args['help_tabs'][] = array(

                'id' => 'redux-opts-1',

                'title' => esc_html__('Theme Information 1', 'sonex'),

                'content' => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'sonex')

            );



            $this->args['help_tabs'][] = array(

                'id' => 'redux-opts-2',

                'title' => esc_html__('Theme Information 2', 'sonex'),

                'content' => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'sonex')

            );



            // Set the help sidebar

            $this->args['help_sidebar'] = esc_html__('<p>This is the sidebar content, HTML is allowed.</p>', 'sonex');

        }



        /**
          * All the possible arguments for Redux.
          * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
         * */

        public function setArguments() {



            $theme = wp_get_theme(); // For use with some settings. Not necessary.



            $this->args = array(

                // TYPICAL -> Change these values as you need/desire

                'opt_name' => 'theme_option', // This is where your data is stored in the database and also becomes your global variable name.

                'display_name' => $theme->get('Name'), // Name that appears at the top of your panel

                'display_version' => $theme->get('Version'), // Version that appears at the top of your panel

                'menu_type' => 'menu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)

                'allow_sub_menu' => true, // Show the sections below the admin menu item or not

                'menu_title' => esc_html__('Sonex Options', 'sonex'),

                'page' => esc_html__('Sonex Options', 'sonex'),

                // You will need to generate a Google API key to use this feature.

                // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth

                'google_api_key' => 'AIzaSyBM9vxebWLN3bq4Urobnr6tEtn7zM06rEw', // Must be defined to add google fonts to the typography module

                //'admin_bar' => false, // Show the panel pages on the admin bar

                'global_variable' => '', // Set a different name for your global variable other than the opt_name

                'dev_mode' => false, // Show the time the page took to load, etc

                'customizer' => true, // Enable basic customizer support

                // OPTIONAL -> Give you extra features

                'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.

                'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters

                'page_permissions' => 'manage_options', // Permissions needed to access the options panel.

                'menu_icon' => '', // Specify a custom URL to an icon

                'last_tab' => '', // Force your panel to always open to a specific tab (by id)

                'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title

                'page_slug' => '_options', // Page slug used to denote the panel

                'save_defaults' => true, // On load save the defaults to DB before user clicks save or not

                'default_show' => false, // If true, shows the default value next to each field that is not the default value.

                'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

                // CAREFUL -> These options are for advanced use only

                'transient_time' => 60 * MINUTE_IN_SECONDS,

                'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output

                'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

                //'domain'             	=> 'redux-framework', // Translation domain key. Don't change this unless you want to retranslate all of Redux.

                //'footer_credit'      	=> '', // Disable the footer credit of Redux. Please leave if you can help it.

                // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.

                'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

                'show_import_export' => true, // REMOVE

                'system_info' => false, // REMOVE

                'help_tabs' => array(),

                'help_sidebar' => '',          

            );

            // Panel Intro text -> before the form

            if (!isset($this->args['global_variable']) || $this->args['global_variable'] !== false) {

                if (!empty($this->args['global_variable'])) {

                    $v = $this->args['global_variable'];

                } else {

                    $v = str_replace("-", "_", $this->args['opt_name']);

                }

                $this->args['intro_text'] = sprintf(__('<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'sonex'), $v);

            } else {

                $this->args['intro_text'] = esc_html__('<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'sonex');

            }



            // Add content after the form.

            $this->args['footer_text'] = esc_html__('<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'sonex');

        }



    }



    new Redux_Framework_sample_config();

}





/**
  * Custom function for the callback referenced above
 */

if (!function_exists('redux_my_custom_field')):



    function redux_my_custom_field($field, $value) {

        print_r($field);

        print_r($value);

    }



endif;



/**
  * Custom function for the callback validation referenced above
 * */

if (!function_exists('redux_validate_callback_function')):



    function redux_validate_callback_function($field, $value, $existing_value) {

        $error = false;

        $value = 'just testing';

        /*

          do your validation



          if(something) {

          $value = $value;

          } elseif(something else) {

          $error = true;

          $value = $existing_value;

          $field['msg'] = 'your custom error message';

          }

         */



        $return['value'] = $value;

        if ($error == true) {

            $return['error'] = $field;

        }

        return $return;

    }



endif;

