<?php

/* Theme Parameters*/

$bg_images_path = get_template_directory() . '/framework/images/bg/'; // change this to where you store your bg images
$bg_images_url = get_template_directory_uri() . '/framework/images/bg/'; // change this to where you store your bg images

$ct_theme_patterns = array();

if ( is_dir($bg_images_path) ) {
	if ($bg_images_dir = opendir($bg_images_path) ) { 
		while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
			if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
				natsort($ct_theme_patterns); //Sorts the array into a natural order
				$ct_theme_patterns[] = $bg_images_url . $bg_images_file;
			}
		}    
	}
}

/**
 * Start Theme Options
 * -----------------------------------------------------------------------------
 */
if ( ! class_exists( 'Redux' ) ) {
	return;
}
 
$theme_path_images = get_template_directory_uri() . '/framework/images/';
$theme_path_redux_skin = get_template_directory_uri() . '/framework/css/options/redux-img/';

// This is your option name where all the Redux data is stored.
$opt_name = "wi_options";

// New Design
function addPanelCSS() {
    wp_register_style( 'redux-custom-css', get_template_directory_uri() . '/framework/css/options/redux-custom.css', array( 'redux-admin-css' ), time(), 'all' ); 
    wp_enqueue_style('redux-custom-css');
}
// This example assumes your opt_name is set to redux_demo, replace with your opt_name value
add_action( 'redux/page/' . $opt_name . '/enqueue', 'addPanelCSS' );

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */
$theme = wp_get_theme(); // For use with some settings. Not necessary.
$b_i_g_promo_top = wp_remote_get( 'http://wwwebinvader.com/!share/redux-promo/promo-top.html' );
if( is_array($b_i_g_promo_top) ) {
  $b_i_g_promo_top = $b_i_g_promo_top['body']; // use the content
}
$args = array(
	// TYPICAL -> Change these values as you need/desire
	'opt_name'             => $opt_name,
	'class'                => 'admin-color-winvader',
	// This is where your data is stored in the database and also becomes your global variable name.
	'display_name'         => '<img src="' . $theme_path_redux_skin . 'wi-options-main-logo.png"><span class="wi-promo">' . $b_i_g_promo_top . '</span>', // $theme->get('Name')
	// Name that appears at the top of your panel
	'display_version'      => '', // $theme->get('Version')
	// Version that appears at the top of your panel
	'menu_type'            => 'menu',
	//Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
	'allow_sub_menu'       => true,
	// Show the sections below the admin menu item or not
	'menu_title'           => esc_attr__( 'Theme Options','b-i-g'),
	'page_title'           => esc_attr__( 'Theme Options','b-i-g'),
	// You will need to generate a Google API key to use this feature.
	// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
	'google_api_key'       => 'AIzaSyAJJpoCo4490LI9YgSKHCbmx9MP6O7taRU',
	// Set it you want google fonts to update weekly. A google_api_key value is required.
	'google_update_weekly' => false,
	// Must be defined to add google fonts to the typography module
	'async_typography'     => true,
	// Use a asynchronous font on the front end or font string
	//'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
	'admin_bar'            => true,
	// Show the panel pages on the admin bar
	'admin_bar_icon'       => '', // 'dashicons-admin-generic'
	// Choose an icon for the admin bar menu
	'admin_bar_priority'   => 85,
	// Choose an priority for the admin bar menu
	'global_variable'      => '',
	// Set a different name for your global variable other than the opt_name
	'dev_mode'             => false,
	// Show the time the page took to load, etc
	'dev_mode_icon_class'  => 'icon-large',
	'import_icon_class'    => 'icon-large',
	'default_icon_class'   => 'icon-large',
	'update_notice'        => true,
	// If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
	'customizer'           => false,
	// Enable basic customizer support
	//'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
	//'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
	// OPTIONAL -> Give you extra features
	'page_priority'        => null,
	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_parent'          => 'themes.php',
	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
	'page_permissions'     => 'manage_options',
	// Permissions needed to access the options panel.
	'menu_icon'            => $theme_path_redux_skin . 'wi-options-logo.png',
	// Specify a custom URL to an icon
	'last_tab'             => '',
	// Force your panel to always open to a specific tab (by id)
	'page_icon'            => 'icon-themes',
	// Icon displayed in the admin panel next to your menu_title
	'page_slug'            => $opt_name,
	// Page slug used to denote the panel
	'save_defaults'        => true,
	// On load save the defaults to DB before user clicks save or not
	'default_show'         => true,
	// If true, shows the default value next to each field that is not the default value.
	'default_mark'         => '*',
	// What to print by the field's title if the value shown is default. Suggested: *
	'show_import_export'   => true,
	// Shows the Import/Export panel when not used as a field.
	// CAREFUL -> These options are for advanced use only
	'transient_time'       => 60 * MINUTE_IN_SECONDS,
	'output'               => true,
	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
	'output_tag'           => true,
	// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
	'footer_credit'        => 'Latest Redux Version',                   // Disable the footer credit of Redux. Please leave if you can help it.
	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	'database'             => '',
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'use_cdn'              => true,
	// If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
	'compiler'             => true,
	// HINTS
	'hints'                => array(
		'icon'          => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color'    => 'lightgray',
		'icon_size'     => 'normal',
		'tip_style'     => array(
			'color'   => 'light',
			'shadow'  => true,
			'rounded' => false,
			'style'   => '',
		),
		'tip_position'  => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect'    => array(
			'show' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'mouseover',
			),
			'hide' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'click mouseleave',
			),
		),
	)
);

// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
$args['admin_bar_links'][] = array(
	'id'    => 'wwwebinvader-profile',
	'href'  => 'http://themeforest.net/user/wwwebinvader/portfolio?ref=wwwebinvader',
	'title' => esc_attr__( 'Web Invader Profile','b-i-g'),
);
$args['admin_bar_links'][] = array(
	'id'    => 'wwwebinvader-support',
	'href'  => 'http://wwwebinvader.com/',
	'title' => esc_attr__( 'Web Invader Support','b-i-g'),
);
$args['admin_bar_links'][] = array(
	'id'    => 'wwwebinvader-rating',
	'href'  => 'http://themeforest.net/downloads?ref=wwwebinvader',
	'title' => esc_attr__( 'Share Your Love','b-i-g'),
);

// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
$args['share_icons'][] = array(
	'url'   => 'http://themeforest.net/user/wwwebinvader',
	'title' => 'Visit on ThemeForest Envato',
	'icon'  => 'el el-user'
	//'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
);
$args['share_icons'][] = array(
	'url'   => 'https://www.facebook.com/wwwebinvader',
	'title' => 'Like on Facebook',
	'icon'  => 'el el-facebook'
);
$args['share_icons'][] = array(
	'url'   => 'https://twitter.com/BBershadsky',
	'title' => 'Follow on Twitter',
	'icon'  => 'el el-twitter'
);
$args['share_icons'][] = array(
	'url'   => 'https://www.linkedin.com/in/bbershadskyi',
	'title' => 'Find on LinkedIn',
	'icon'  => 'el el-linkedin'
);
// Panel Intro text -> before the form
if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
	if ( ! empty( $args['global_variable'] ) ) {
		$v = $args['global_variable'];
	} else {
		$v = str_replace( '-', '_', $args['opt_name'] );
	}
	$args['intro_text'] = sprintf( esc_attr__( 'To access any of your saved options from within your code you can use your global variable: $%1$s','b-i-g'), $v );
} else {
	$args['intro_text'] = esc_attr__( 'Glad to Present Web Invader themes family.','b-i-g');
}

$b_i_g_promo_bottom = wp_remote_get( 'http://wwwebinvader.com/!share/redux-promo/promo-bottom.html' );
if( is_array($b_i_g_promo_bottom) ) {
  $b_i_g_promo_bottom = $b_i_g_promo_bottom['body']; // use the content
}
// Add content after the form.
$args['footer_text'] = $b_i_g_promo_bottom;




$sections = array();              

//Background Patterns Reader

$sample_patterns_path = get_template_directory_uri() . '/img/bg/';
$sample_patterns_url = get_template_directory_uri() . '/img/bg/';

$ct_bg_type = array( "none" => "None" , "upload" => "Upload" , "predefined" => "Predefined" );
$ct_bg_repeat = array( "repeat" => "repeat" , "repeat-x" => "repeat-x", "repeat-y" => "repeat-y", "no-repeat" => "no-repeat" );
$ct_bg_position = array( "top left" => "top left", "top center" => "top center", "top right" => "top right", "center left" => "center left", "center center" => "center center", "center right" => "center right", "bottom left" => "bottom left", "bottom center" => "bottom center", "bottom right" => "bottom right");
$ct_type_animation = array( "fade" => "Fade", "scale_up" => "Scale Up", "scale_down" => "Scale Down", "slide_top" => "Slide Top", "slide_bottom" => "Slide Bottom", "slide_right" => "Slide Right", "slide_left" => "Slide Left" );
$type_of_pagination = array( "standard" => "Standard", "numeric" => "Numeric", "load_more" => "Load More button" );
$type_of_pagination_cat = array( "standard" => "Standard", "numeric" => "Numeric" );

$theme_bg_type = array ( "uploaded" => "Uploaded", "predefined" => "Predefined" , "color" => "Color" );
$theme_bg_attachment = array ( "scroll" => "Scroll" , "fixed" => "Fixed" );
$theme_bg_position = array ( "left" => "Left" , "right" => "Right", "centered" => "Centered" , "full_screen" => "Full Screen" );
$theme_bg_color = array ( "bg_image" => "Background Image", "color" => "Color", "upload" => "Upload" );
$sl_port_style = array ( "Random Thumbnails" => "Random Thumbnails", "Standard Thumbnails" => "Standard Thumbnails");
$sample_patterns = array();

if ( is_dir( $sample_patterns_path ) ) :
	
  if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) :
  	$sample_patterns = array();

    while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

      if( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
      	$name = explode(".", $sample_patterns_file);
      	$name = str_replace('.'.end($name), '', $sample_patterns_file);
      	$sample_patterns[] = array( 'alt'=>$name,'img' => $sample_patterns_url . $sample_patterns_file );
      }
    }
  endif;
endif;

$sections[] = array(
	'title' => esc_attr__('General Settings','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-icon-home',
	'fields' => array(
			array(
				'id'        => 'wi_custom_bootstrap_maxsize',
				'type'      => 'slider',
				'compiler' => true,
				'title'     => esc_attr__('Custom Bootstrap Max Size','b-i-g'),
				'subtitle'  => esc_attr__('This slider displays the value as a label.','b-i-g'),
				'desc'      => esc_attr__('Slider description. Min: 860, max: 1640, step: 1, default value: 1170','b-i-g'),
				"default"   => 1170,
				"min"       => 860,
				"step"      => 10,
				"max"       => 1640,
				'display_value' => 'label'
			),
			array(
				'id'=>'wi_header_favicon',
				'type' => 'media', 
				'readonly' => false,
				'url'=> true,
				'title' => esc_attr__('Favicon Upload','b-i-g'),
				'desc'=> esc_attr__('Upload your favicon the url','b-i-g'),
				'subtitle' => esc_attr__('Upload image using the native media uploader, or define the URL directly','b-i-g'),
				'default'=>array('url'=> $theme_path_images . 'favicon.ico' ),
			),
			array(
				'id'       => 'wi_preloader',
				'type'     => 'switch',
				'title'    => esc_attr__('Turn Preloader?','b-i-g'),
				'default'  => false,
				'on' => esc_attr__('Enabled','b-i-g'),
				'off' => esc_attr__('Disabled','b-i-g'),
			),
			array(
				'id'	   =>'wi_logo_upload',
				'type'     => 'media', 
				'readonly' => false,
				'url'      => true,
				'title'    => esc_attr__('Light Background Logo Upload','b-i-g'),
				'desc'     => esc_attr__('Upload your logo or paste the url','b-i-g'),
				'subtitle' => esc_attr__('Upload image using the native media uploader, or define the URL directly','b-i-g'),
				'default'  =>array('url'=> $theme_path_images . '/logos/logo-light.png' ),
			),
			array(
				'id'       =>'wi_logo_dark_upload',
				'type'     => 'media',
				'readonly' => false, 
				'url'      => true,
				'title'    => esc_attr__('Dark Background Logo Upload','b-i-g'),  
				'desc'     => esc_attr__('Upload your logo or paste the url','b-i-g'),
				'subtitle' => esc_attr__('Upload image using the native media uploader, or define the URL directly','b-i-g'),
				'default'  => array('url'=> $theme_path_images . '/logos/logo-dark.png' ),
			),
		array(
			'id'=>'wi_logo_style_width',
			'validate' => 'numeric',
			'type' => 'text',
			'title' => esc_attr__('Max Logo Size (Width)','b-i-g'),
			'subtitle' => esc_attr__('Value example: 300','b-i-g'),
			'desc'     => esc_attr__('Use it only in order to limit the image','b-i-g'),
			'default' => '',
			'required' => array( 
					array('wi_logo_style', '=', array('1', '2')),
				),
			),
		array(
			'id'=>'wi_logo_style_height',
			'validate' => 'numeric',
			'type' => 'text',
			'title' => esc_attr__('Max Logo Size (Height)','b-i-g'),
			'subtitle' => esc_attr__('Value example: 300','b-i-g'),
			'desc'     => esc_attr__('Use it only in order to limit the image','b-i-g'),
			'default' => '',
			'required' => array( 
					array('wi_logo_style', '=', array('1', '2')),
				),
			),
			array(
				'id'       => 'wi_logo_custom_field',
				'type'     => 'ace_editor',
				'mode'	   => 'html',
				'title'    => esc_attr__('Custom Logo Field','b-i-g'),
				'subtitle' => esc_attr__('Type your custom HTML markup','b-i-g'),
				'default'          => '
<h2>' . esc_attr__('B.I.G','b-i-g') . '</h2>
<h5 class="colored">' . esc_attr__('Business Ideas Group','b-i-g') . '</h5>
				'
			),

			array(
				'id'=>'wi_background_upload',
				'type' => 'media', 
				'url'=> true,
				'compiler' => true, // Use if you want to hook in your own CSS compiler
				'title' => esc_attr__('Background Pattern Upload','b-i-g'),
				'desc'=> esc_attr__('Upload your background or paste the url','b-i-g'),
				'subtitle' => esc_attr__('Upload image using the native media uploader, or define the URL directly','b-i-g'),
				'readonly' => false,
				'default'=>array('url'=> $theme_path_images . 'bg.jpg' ),
			),
			array(
				'id'=>'wi_pattern_size',
				'compiler' => true, // Use if you want to hook in your own CSS compiler
				'type' => 'text',
				'title' => esc_attr__('Pattern Size (Width)','b-i-g'),
				'subtitle' => esc_attr__('Default width: 264px','b-i-g'),
				'default' => '264px',
			),
			array(
				'id'       => 'wi_blog_sidebar_position',
				'type'     => 'button_set',
				'title'    => esc_attr__('Sidebar Position for Blog','b-i-g'),
				'subtitle' => esc_attr__('Choose a Sidebar Position','b-i-g'),
				'desc'     => esc_attr__('Choose Sidebar Position','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Right','b-i-g'),
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('None','b-i-g'),
				 ), 
				'default' => '1',
			),
			array(
				'id'       => 'wi_shop_sidebar_position',
				'type'     => 'button_set',
				'title'    => esc_attr__('Sidebar Position for Shop','b-i-g'),
				'subtitle' => esc_attr__('Choose a Sidebar Position','b-i-g'),
				'desc'     => esc_attr__('Choose Sidebar Position','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Right','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 
				 ), 
				'default' => '2',
			),
			array(
				'id'       => 'wi_hidepagetitle_default',
				'type'     => 'switch',
				'title'    => esc_attr__('Hide Title for all Pages','b-i-g'),
				'default'  => false,
				'on' => esc_attr__('Enabled','b-i-g'),
				'off' => esc_attr__('Disabled','b-i-g'),
			),
		array(
			'id'=>'wi_custom_css',
			'type' => 'ace_editor',
			'mode' => 'css',
			'compiler' => true,
			'theme' => 'monokai',
			'title' => esc_attr__('Custom CSS','b-i-g'), 
			'subtitle' => esc_attr__('Quickly add some CSS to your theme by adding it to this block.','b-i-g'),
			'desc' => esc_attr__('This field is even CSS validated!', 'b-i-g'),
			'validate' => "css",
			'default' => "",
		),

		
		),
	);
	

$sections[] = array(
	'title' => esc_attr__('Header Settings','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-cog',
    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
	'fields' => array(
		array(
			'id'        => 'wi_notice_preset_header',
			'type'      => 'info',					
			'icon' 		=> 'el el-idea',
			'style'     => 'critical',
			'title'     => esc_attr__('PRESET OPTIONS','b-i-g'),
			'desc'      => esc_attr__('If you just want to use a preset design check the tab "Header Preset".','b-i-g')
		),
		// Default Cart Value
		array(
				'id'       => 'wi_cart_val',
				'type'     => 'button_set',
				'title'    => esc_attr__('Default Cart Value for Mid and Top bars','b-i-g'),
				'subtitle' => esc_attr__('Choose a view od the cart option','b-i-g'),
				'desc'     => esc_attr__('Choose your favorite','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Total Amount','b-i-g'), 
					'2' => esc_attr__('Quantity','b-i-g'), 
					'3' => esc_attr__('Total Amount & Quantity','b-i-g'),
				 ), 
				'default' => '1',
			),	
		// Top Bar Area				
		array(
			'id'        => 'wi_notice_topbar_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-cog-alt',
			'title'     => esc_attr__('Top Bar Section Settings','b-i-g'),
			'desc'      => esc_attr__('If you\'d like to use a Top Bar for the Header please see settings below.','b-i-g')
		),
		// Top Bar
		array(
				'id'       => 'wi_topbar',
				'type'     => 'switch', 
				'title'    => esc_attr__('Show the Top Bar Area','b-i-g'),
				'subtitle' => esc_attr__('Show the Top Bar Area in Header','b-i-g'),
				'default'  => false,
				'on' => esc_attr__('Enabled','b-i-g'),
				'off' => esc_attr__('Disabled','b-i-g'),
		),
		// Social Icons
		array(
				'id'       => 'wi_topbar_social',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Social Icons in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose a Social Icons option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),			
		// Shopping Cart
		array(
			'id'        => 'wi_notice_woo_info_critical',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'critical',
			'icon' 		=> 'el el-info-circle',
			'required'  => array('wi_topbar_cart','!=', 1),
			'title'     => esc_attr__('WooCommerce Options.','b-i-g'),
			'desc'      => esc_attr__('The following options are only available if you are using WooCommerce. Choose Cart Style in Header Styling Section.','b-i-g')
		),
		array(
				'id'       => 'wi_topbar_cart',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Cart in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose this option to Enable/Disable Shopping Cart in Top Header','b-i-g'),
				'desc'     => esc_attr__('Choose position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'),
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		// Search
		array(
				'id'       => 'wi_topbar_search',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Search field in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose this option to Enable/Disable Search in Top Header','b-i-g'),
				'desc'     => esc_attr__('Choose position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		// Phone
		array(
				'id'       => 'wi_topbar_phone',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Phone field in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose a phone number option','b-i-g'),
				'desc'     => esc_attr__('Choose position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'),
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		array(
				'id'        => 'wi_topbar_phone_field',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your Phone number','b-i-g'),
				'subtitle'  => esc_attr__('Text to display next to the phone icon.','b-i-g'),
				'desc'      => esc_attr__('Set your number','b-i-g'),
				'validate'  => 'html',
				'default'   => '1-800-633-3469',
				'required' => array( 
					array('wi_topbar', '=', 1),
					array('wi_topbar_phone','!=', 1),
				),
			),
		// Email
		array(
				'id'       => 'wi_topbar_email',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Email field in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose an email option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		array(
				'id'        => 'wi_topbar_email_field',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your Phone number','b-i-g'),
				'subtitle'  => esc_attr__('Text to display next to the email icon.','b-i-g'),
				'desc'      => esc_attr__('Set your email','b-i-g'),
				'validate'  => 'html',
				'default'   => 'admin@website.com',
				'required' => array( 
					array('wi_topbar', '=', 1),
					array('wi_topbar_email','!=', 1),
				),
			),	
		// Working Hours
		array(
				'id'       => 'wi_topbar_whours',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Working Hours field in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose a working hours option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'),
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		array(
				'id'        => 'wi_topbar_whours_field',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your Working Hours number','b-i-g'),
				'subtitle'  => esc_attr__('Text to display next to the time icon.','b-i-g'),
				'desc'      => esc_attr__('Set your working hours','b-i-g'),
				'validate'  => 'html',
				'default'   => 'Mn-Fr (9.00 am - 5.00 pm)',
				'required' => array( 
					array('wi_topbar', '=', 1),
					array('wi_topbar_whours','!=', 1),
				),
			),	
		// Text or Menu
		array(
				'id'       => 'wi_topbar_textmenu_position',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Custom Text or Top Bar Menu in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose a position and options after it','b-i-g'),
				'desc'     => esc_attr__('Choose Position, Options or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 				
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		array(
				'id'       => 'wi_topbar_textmenu',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Text/HTML or Top Bar Menu','b-i-g'),
				'subtitle' => esc_attr__('Choose an option','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Text/HTML','b-i-g'), 
					'2' => esc_attr__('Menu','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
					array('wi_topbar_textmenu_position','=', array('2', '3')),
				),
			),
		// -- Text Field
		array(
				'id'        => 'wi_topbar_textmenu_field',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your Text or HTML','b-i-g'),
				'subtitle'  => esc_attr__('Text to display in Own Text area.','b-i-g'),
				'desc'      => esc_attr__('Set your Text or HTML','b-i-g'),
				'validate'  => 'html',
				'default'   => esc_attr__('Your Text or HTML','b-i-g'),
				'required' => array( 
					array('wi_topbar_textmenu','=', 1 ),
				),
			),
		// -- Menu Setup
		array(
				'id'        => 'wi_notice_topbar_textmenu_info_critical',
				'type'      => 'info',
				'notice'    => true,
				'style'     => 'critical',
				'icon' 		=> 'el el-info-circle',
				'title'     => esc_attr__('Top Bar Menu','b-i-g'),
				'desc'      => esc_attr__('Add and customize your menu at: Appearance - Menus','b-i-g'),
				'required' => array( 
					array('wi_topbar_textmenu','=', 2 ),
				),
			),
		// Profile Links
		array(
				'id'       => 'wi_topbar_profile',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Profile Links in Top Header','b-i-g'),
				'subtitle' => esc_attr__('Choose a Profile Links option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => esc_attr__('Disabled','b-i-g'), 
					'2' => esc_attr__('Left','b-i-g'), 
					'3' => esc_attr__('Right','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_topbar', '=', 1),
				),
			),
		array(
				'id'        => 'wi_topbar_profile_field_0',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your text instead of "My Account"','b-i-g'),
				'validate'  => 'html',
				'default'   => esc_attr__('My Account','b-i-g'),
				'compiler'  => true,
				'required'  => array('wi_topbar_profile','!=', 1),
			),	
		array(
				'id'        => 'wi_topbar_profile_field_1',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your text instead of "Sign In"','b-i-g'),
				'validate'  => 'html',
				'default'   => esc_attr__('Sign In','b-i-g'),
				'compiler'  => true,
				'required'  => array('wi_topbar_profile','!=', 1),
			),		
		array(
				'id'        => 'wi_topbar_profile_field_2',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your text instead of "or"','b-i-g'),
				'validate'  => 'html',
				'default'   => esc_attr__('or','b-i-g'),
				'compiler'  => true,
				'required'  => array('wi_topbar_profile','!=', 1),
			),		
		array(
				'id'        => 'wi_topbar_profile_field_3',
				'type'      => 'text',
				'title'     => esc_attr__('Enter your text instead of "Join Now"','b-i-g'),
				'validate'  => 'html',
				'default'   => esc_attr__('Join Now','b-i-g'),
				'compiler'  => true,
				'required'  => array('wi_topbar_profile','!=', 1),
			),		
		// Middle Bar Section
		array(
			'id'        => 'wi_notice_midbar_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-cog-alt',
			'title'     => esc_attr__('Middle Bar Section Settings','b-i-g'),
			'desc'      => esc_attr__('If you\'d like to use a Middle Bar for the Header please see settings below.','b-i-g')
		),
		array(
				'id'       => 'wi_midbar',
				'type'     => 'switch',
				'title'    => esc_attr__('Show the Middle Bar Area','b-i-g'),				
				'subtitle' => esc_attr__('Show the Middle Bar Area in Header','b-i-g'),
				'default'  => true,
				'on' => esc_attr__('Enabled','b-i-g'),
				'off' => esc_attr__('Disabled','b-i-g'),			
			),
		array(
				'id'       => 'wi_midbar_custom_code',
				'type'     => 'button_set',
				'title'    => esc_attr__('Middle Bar Section Content','b-i-g'),
				'subtitle' => esc_attr__('Choose mid bar content option','b-i-g'),
				'desc'     => esc_attr__('Choose content option','b-i-g'),
				'multi'    => false,
				'options' => array(
					'1' => esc_attr__('Standard Options','b-i-g'), 
					'2' => esc_attr__('Custom Code','b-i-g'),
				 ), 
				'default' => '1',
				'required' => array( 
					array('wi_midbar', '=', 1),
				),
			),
		
		// Standard Content
		array(
			'id'       => 'wi_logo_style',
			'type'     => 'button_set',
			'title'    => esc_attr__('Logo Style in Middle Bar Header','b-i-g'),
			'multi'    => false,
			'options' => array(
				'1' => esc_attr__('Logo Light','b-i-g'), 
				'2' => esc_attr__('Logo Dark','b-i-g'),
				'3' => esc_attr__('Custom HTML','b-i-g'), 
			 ), 
			'default' => '1',
			'required' => array( 
				array('wi_midbar_custom_code','=', 1),
			),
		),
		array(
			'id'       => 'wi_midbar_logo',
			'type'     => 'button_set',
			'title'    => esc_attr__('Logo Position in Mid Header','b-i-g'),
			'subtitle' => esc_attr__('Choose Logo Position option','b-i-g'),
			'desc'     => esc_attr__('Choose Position option','b-i-g'),
			'multi'    => false,
			'options' => array(
				'1' => esc_attr__('Disabled','b-i-g'), 
				'2' => esc_attr__('Left','b-i-g'), 
				'3' => esc_attr__('Center','b-i-g'),
				'4' => esc_attr__('Right','b-i-g'),
			 ),
			'default' => '1',
			'required' => array( 
				array('wi_midbar_custom_code','=', 1),
			),
		),
		array(
			'id'       => 'wi_midbar_social',
			'type'     => 'button_set',
			'title'    => esc_attr__('Show Social Icons in Middle Bar','b-i-g'),				
			'subtitle' => esc_attr__('Choose this option to Enable/Disable Social Icons in Mid Header','b-i-g'),
			'desc'     => esc_attr__('Choose Position option','b-i-g'),
			'multi'    => false,
			'options' => array(
				'1' => esc_attr__('Disabled','b-i-g'),
				'2' => esc_attr__('Left','b-i-g'),
				'3' => esc_attr__('Center','b-i-g'),
				'4' => esc_attr__('Right','b-i-g'),
			 ),
			'default' => '1',
			'required' => array( 
				array('wi_midbar_custom_code','=', 1),
			),							
		),
		array(
			'id'       => 'wi_midbar_search',
			'type'     => 'button_set',
			'title'    => esc_attr__('Show Search in Middle Bar','b-i-g'),				
			'subtitle' => esc_attr__('Choose this option to Enable/Disable Search in Mid Header','b-i-g'),
			'desc'     => esc_attr__('Choose Position option','b-i-g'),
			'multi'    => false,
			'options' => array(
				'1' => esc_attr__('Disabled','b-i-g'), 
				'2' => esc_attr__('Left','b-i-g'), 
				'3' => esc_attr__('Center','b-i-g'),
				'4' => esc_attr__('Right','b-i-g'),
			 ),
			'default' => '1',
			'required' => array( 
				array('wi_midbar_custom_code','=', 1),
			),			
		),
		array(
			'id'        => 'wi_notice_woo_mid_info_critical',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'critical',
			'icon' 		=> 'el el-info-circle',
			'required'  => array('wi_midbar_cart','!=', 1),
			'title'     => esc_attr__('WooCommerce Options.','b-i-g'),
			'desc'      => esc_attr__('The following options are only available if you are using WooCommerce. Choose Cart Style in Header Styling Section.','b-i-g')
		),
		array(
			'id'       => 'wi_midbar_cart',
			'type'     => 'button_set',
			'title'    => esc_attr__('Show Cart in Middle Bar','b-i-g'),				
			'subtitle' => esc_attr__('Choose this option to Enable/Disable Cart in Mid Header','b-i-g'),
			'desc'     => esc_attr__('Choose Position option','b-i-g'),
			'multi'    => false,
			'options' => array(
				'1' => esc_attr__('Disabled','b-i-g'), 
				'2' => esc_attr__('Left','b-i-g'), 
				'3' => esc_attr__('Center','b-i-g'),
				'4' => esc_attr__('Right','b-i-g'),
			 ),
			'default' => '1',
			'required' => array( 
				array('wi_midbar_custom_code','=', 1),
			),		
		),
		// Custom Code
		array(
			'id'               => 'wi_midbar_custom_code_field',
			'type'             => 'ace_editor',
			'mode'			   => 'html',
			'required' => array( 
				array('wi_midbar_custom_code','=', 2),
			),
			'title'  => esc_attr__('Your Custom Code for Middle Bar Section','b-i-g'),
			'subtitle' => esc_attr__('Type your custom HTML markup','b-i-g'),
			'desc'     => esc_attr__('Use bootstrap columns div elements to create column like: &#60;div class="col-md-3"&#62;
&#60;/div&#62;
','b-i-g'),
			'default'          => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
				'
		),
		// Navigation Bar Section
		array(
			'id'        => 'wi_notice_navbar_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-cog-alt',
			'title'     => esc_attr__('Navigation Bar (LMM Plugin) Section Settings','b-i-g'),
			'desc'      => esc_attr__('Navigation Bar reserved for LMM Menu Plugin.','b-i-g')
		),
		array(
			'id'        => 'wi_notice_LMM_plugin_info',
			'type'      => 'info',
			'notice'    => false,
			'style'     => 'info',
			'title'     => esc_attr__('LMM Menu plugin goes here','b-i-g'),
			'desc'      => esc_attr__('You should choose Header Type below and use <a href="/wp-admin/admin.php?page=lmm_menu_panel">LMM Menu Plugin Settings</a> to set each Header Nav Menu. LMM Menu Support main header settings, from simple to advanced. With LMM Menu you can set logo, social icons, cart, search and more but only inside menu area, so you can enable only this area or use TOP BAR and MID BAR Settings for Header Usage. Also you should use LMM Menu Section for Left/Right Overlayed menu on pages.','b-i-g')
		),
		array(
				'id'       => 'wi_navbar',
				'type'     => 'switch', 
				'title'    => esc_attr__('Show the Navigation Bar Area','b-i-g'),
				'subtitle' => esc_attr__('Show the Navigation Bar Area in Header','b-i-g'),
				'default'  => true,
				'on'  => esc_attr__('Enabled','b-i-g'),
				'off' => esc_attr__('Disabled','b-i-g'),
		),
		array(
			'id'        => 'wi_header_nav_type',
			'type'      => 'select',
			'title'     => esc_attr__('Header Navigation Menu','b-i-g'),
			'subtitle'  => esc_attr__('Select the Header Navigation and Customize corresponding Menu after if you need','b-i-g'),
			'desc'  	=> esc_attr__('Select the Header Navigation, number of the Navigation corresponds to Header Nav number in Menus area. For example: Header Nav 01 it is Header Nav 01 in Appearance - Menus area','b-i-g'),
		   
			
			//Must provide key => value pairs for select options
			'options'   => array( 
				'01' => esc_attr__('Header Nav 01','b-i-g'), 
				'02' => esc_attr__('Header Nav 02','b-i-g'),
				'03' => esc_attr__('Left Navigation','b-i-g'),
				'04' => esc_attr__('Left Navigation Fixed','b-i-g'),
			),
			'default'   => '01'
		),		
	),
);



$sections[] = array(
	'title' => esc_attr__('Header Styling','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-brush',
    'subsection' => true,
	'fields' => array(
		// Topbar Styling
		array(
			'id'        => 'wi_notice_topbar_styling_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-brush',
			'title'     => esc_attr__('Top Bar Section Styling','b-i-g'),
			'desc'      => esc_attr__('If you\'d like to use a Top Bar for the Header please see styling below.','b-i-g'),
		),
		array(
			'id' => 'section-topbar-st-start',
			'type' => 'section',
			'title' => esc_attr__('Border Styling','b-i-g'),
			//'subtitle' => esc_attr__('With the "section" field you can create indent option sections.','b-i-g'),
			'indent' => true,
		),
			array(
				'id'          => 'wi_top_st_separator',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Separator between elements','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#4b4b4b, Use transparent to disable it.','b-i-g'),
				'default'     => '#4b4b4b',
				'transparent' => true,
				'validate'    => 'color',
			),		
			array(
				'id'          => 'wi_top_st_separator_first',
				'type'        => 'switch',
				'compiler'    => true,
				'title'       => esc_attr__('Show First Separator between left and right areas','b-i-g'), 
				'subtitle'    => esc_attr__('Use this option if you use only left elements position.','b-i-g'),
				'default'  => false,
					'on'  => esc_attr__('Enabled','b-i-g'),
					'off' => esc_attr__('Disabled','b-i-g'),	
			),
			array(
				'id'          => 'wi_top_st_separator_last',
				'type'        => 'switch',
				'compiler'    => true,
				'title'       => esc_attr__('Show Last Separator between left and right areas','b-i-g'), 
				'subtitle'    => esc_attr__('Use this option if you use left and right elements position.','b-i-g'),
				'default'  => true,
					'on'  => esc_attr__('Enabled','b-i-g'),
					'off' => esc_attr__('Disabled','b-i-g'),
			),
			// Border Top
			array(
				'id'          => 'wi_top_st_t_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Top Border Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#4b4b4b, Use transparent to disable it.','b-i-g'),
				'default'     => '#4b4b4b',
				'transparent' => true,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_top_st_t_width',
				'type'     => 'spinner',
				'compiler'    => true,
				'title'    => esc_attr__('Top Border Width','b-i-g'),
				'subtitle' => esc_attr__('Default: 1, Use 0 to disable it.','b-i-g'),
				'desc'     => esc_attr__('Min:0, max: 30, step:1, default value: 1','b-i-g'),
				'default'  => '1',
				'min'      => '0',
				'step'     => '1',
				'max'      => '30',
			),
			array(
				'id'          => 'wi_top_st_b_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Bottom Border','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#4b4b4b','b-i-g'),
				'default'     => '#4b4b4b',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_top_st_b_width',
				'type'     => 'spinner',
				'compiler'    => true,				
				'title'    => esc_attr__('Bottom Border Width','b-i-g'),
				'subtitle' => esc_attr__('Default: 1, Use 0 to disable it.','b-i-g'),
				'desc'     => esc_attr__('Min:0, max: 30, step:1, default value: 1','b-i-g'),
				'default'  => '1',
				'min'      => '0',
				'step'     => '1',
				'max'      => '30',
			),
		array(
			'id'     => 'section-topbar-st-end',
			'type'   => 'section',
			'indent' => false,
		),
		// Content Color
		array(
			'id' => 'section-topbar-st-color-start',
			'type' => 'section',
			'title' => esc_attr__('Color Styling','b-i-g'),
			//'subtitle' => esc_attr__('With the "section" field you can create indent option sections.','b-i-g'),
			'indent' => true,
		),	
		array(
				'id'          => 'wi_top_st_bg',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Background Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#212121','b-i-g'),
				'default'     => '#212121',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_top_st_text_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Text Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff','b-i-g'),
				'default'     => '#ffffff',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_top_st_text_icons_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Text Icons Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff','b-i-g'),
				'default'     => '#ffffff',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_top_st_text_link_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Text Links Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_top_st_social_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Social Icons Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_top_st_search_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Search Icon Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => true,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffffff',
					'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_top_st_cart_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Icon Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffffff',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_top_st_cart_val',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Value Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#212121',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_top_st_cart_bg',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Value Background','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffd824',
					'hover'    => '#ffd824',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'          => 'wi_top_st_searcharea_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Search Area Text Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff','b-i-g'),
				'default'     => '#ffffff',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_top_st_searcharea_bg',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Search Area Background','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#212121','b-i-g'),
				'default'     => '#212121',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_top_st_searcharea_icon_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Search Area Icon Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffd824',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
		array(
			'id'     => 'section-topbar-st-color-end',
			'type'   => 'section',
			'indent' => false,
		),
		// Midbar Styling
		array(
			'id'        => 'wi_notice_midbar_styling_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-brush',
			'title'     => esc_attr__('Middle Bar Section Styling','b-i-g'),
			'desc'      => esc_attr__('If you\'d like to use a Middle Bar for the Header please see styling below.','b-i-g'),
		),
		array(
			'id' => 'section-midbar-st-start',
			'type' => 'section',
			'title' => esc_attr__('Color Styling','b-i-g'),
			//'subtitle' => esc_attr__('With the "section" field you can create indent option sections.','b-i-g'),
			'indent' => true,
		),
			array(
				'id'          => 'wi_mid_st_bg', 
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Middle Bar Section Background','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff','b-i-g'),
				'default'     => '#ffffff',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_mid_st_text_color', 
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Text Color','b-i-g'), 
				'subtitle'    => esc_attr__('For Custom Code Area','b-i-g'),
				'default'     => '#212121',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_mid_st_text_link_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Text Links Color','b-i-g'),
				'subtitle' => esc_attr__('For Custom Code Area','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_mid_st_social_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Social Icons Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_mid_st_search_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Search Icon Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => true,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#212121',
					'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_mid_st_cart_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Icon Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#212121',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_mid_st_cart_val',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Value Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#212121',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_mid_st_cart_bg',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Shopping Cart Value Background','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffd824',
					'hover'    => '#ffd824',
				//	'active'   => '#ffffff',
				//	'visited'  => '#ffd824',
				)
			),
		array(
			'id'     => 'section-midbar-st-end',
			'type'   => 'section',
			'indent' => false,
		),
		array(
			'id'        => 'wi_notice_navbar_styling_info',
			'type'      => 'info',
			'notice'    => true,
			'style'     => 'info',
			'icon'      => 'el el-brush',
			'title'     => esc_attr__('Navigation Bar (LMM Plugin) Section Styling','b-i-g'),
			'desc'      => esc_attr__('If you\'d like to use a Nav Bar for the Header please see styling below.','b-i-g')
		),	
		array(
				'id'          => 'wi_navbar_border_color',
				'type'        => 'color',
				'compiler'    => true,
				'transparent' => true,
				'title'       => esc_attr__('Navbar Border Color ( Additionally to LMM Menu )','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#f0f0f0','b-i-g'),
				'default'     => '#f0f0f0',
				'validate'    => 'color',
			),
	),
);
	
$sections[] = array(
	'title' => esc_attr__('Header Preset','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-icon-credit-card',
    'subsection' => true,
	'fields' => array(
			array( 
					'id'       => 'wi_header_preset',
					'type'     => 'image_select', 
					'presets'  => true,
					'compiler' => true,
					'width'    => '',
					'height'   => '',
					'title'    => esc_attr__('Choose Header Preset','b-i-g'),
					'subtitle' => esc_attr__('Allow you to set default header preset','b-i-g'),
					'desc'     => esc_attr__('Choose Default Header Layout','b-i-g'),
					'default'  => 1,
					'options'  => array(
			        // Array of preset options
					'1'      => array(
		            'alt'   => 'Preset 1', 
		            'img'   => $theme_path_images . 'options/header_preset_01.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 1,
						'wi_topbar_social'  		 	  => 3,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 3,
						'wi_topbar_phone'	        	  => 2,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 2,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 2,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 2,
						'wi_topbar_textmenu'		 	  => 1,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 2,
						// midbar
						'wi_midbar'						  => 1,
						'wi_midbar_custom_code'		  	  => 2,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 2,
						'wi_midbar_social'		 	 	  => 4,
						'wi_midbar_search'		  		  => 4,
						'wi_midbar_cart'		 	 	  => 4,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '01',
						// colors
						'wi_top_st_separator'		  	  => '#4b4b4b',
						'wi_top_st_separator_first'  	  => 0,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => '#4b4b4b',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => '#4b4b4b',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffd824', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#ffd824', 'hover' => '#ffd824'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#ffd824'),
						'wi_mid_st_bg' 					  => '#ffffff',
						'wi_mid_st_text_color'			  => '#212121',
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#ffd824'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#ffd824'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#ffd824' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#ffd824', 'hover' => '#ffd824'),
						'wi_navbar_border_color'		  => '#f0f0f0',
						)	
					),
        			'2'      => array(
		            'alt'   => 'Preset 2', 
		            'img'   => $theme_path_images . 'options/header_preset_02.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 1,
						'wi_topbar_social'  		 	  => 1,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 1,
						'wi_topbar_phone'	        	  => 2,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 2,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 2,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 3,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 1,
						// midbar
						'wi_midbar'						  => 1,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 2,
						'wi_midbar_social'		 	 	  => 4,
						'wi_midbar_search'		  		  => 4,
						'wi_midbar_cart'		 	 	  => 4,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '02',
						// colors
						'wi_top_st_separator'		  	  => '#4b4b4b',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => '#4b4b4b',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => '#4b4b4b',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#00ccfd', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#00ccfd', 'hover' => '#00ccfd'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#00ccfd'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#00ccfd'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#00ccfd'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#00ccfd' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#00ccfd', 'hover' => '#00ccfd'),
						'wi_navbar_border_color'		  => '#f0f0f0',
						)
					),
					'3'      => array(
		            'alt'   => 'Preset 3', 
		            'img'   => $theme_path_images . 'options/header_preset_03.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 2,
						'wi_topbar_social'  		 	  => 1,
						'wi_topbar_cart'			 	  => 3,
						'wi_topbar_search'			 	  => 1,
						'wi_topbar_phone'	        	  => 2,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 2,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 2,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 3,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 1,
						// midbar
						'wi_midbar'						  => 2,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 3,
						'wi_midbar_social'		 	 	  => 1,
						'wi_midbar_search'		  		  => 1,
						'wi_midbar_cart'		 	 	  => 1,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '03',
						// colors
						'wi_top_st_separator'		  	  => '#4b4b4b',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => '#4b4b4b',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => '#4b4b4b',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#95532c', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#95532c', 'hover' => '#95532c'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#95532c'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#95532c'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#95532c'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#95532c' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#95532c', 'hover' => '#95532c'),
						'wi_navbar_border_color'		  => 'transparent',
						)
					),
					'4'      => array(
		            'alt'   => 'Preset 4', 
		            'img'   => $theme_path_images . 'options/header_preset_04.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 1,
						'wi_topbar_social'  		 	  => 1,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 1,
						'wi_topbar_phone'	        	  => 3,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 3,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 2,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 2,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 1,
						// midbar
						'wi_midbar'						  => 2,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 3,
						'wi_midbar_social'		 	 	  => 1,
						'wi_midbar_search'		  		  => 1,
						'wi_midbar_cart'		 	 	  => 1,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '04',
						// colors
						'wi_top_st_separator'		  	  => 'transparent',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => 'transparent',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => 'transparent',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#ffb900', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#ffb900', 'hover' => '#ffb900'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#ffb900'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#ffb900'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#ffb900'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#ffb900' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#ffb900', 'hover' => '#ffb900'),
						'wi_navbar_border_color'		  => 'transparent',
						)
					),
					'5'      => array(
		            'alt'   => 'Preset 5', 
		            'img'   => $theme_path_images . 'options/header_preset_05.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 1,
						'wi_topbar_social'  		 	  => 1,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 3,
						'wi_topbar_phone'	        	  => 2,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 2,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 2,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 3,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 2,
						// midbar
						'wi_midbar'						  => 1,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 3,
						'wi_midbar_social'		 	 	  => 1,
						'wi_midbar_search'		  		  => 1,
						'wi_midbar_cart'		 	 	  => 1,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '05',
						// colors
						'wi_top_st_separator'		  	  => '#4b4b4b',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => '#4b4b4b',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => '#4b4b4b',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#1bc0ea', 'hover' => '#1bc0ea'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#1bc0ea'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#1bc0ea'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#1bc0ea' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#1bc0ea', 'hover' => '#1bc0ea'),
						'wi_navbar_border_color'		  => 'transparent',
						)
					),
					'6'      => array(
		            'alt'   => 'Preset 6', 
		            'img'   => $theme_path_images . 'options/header_preset_06.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 1,
						'wi_topbar_social'  		 	  => 2,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 1,
						'wi_topbar_phone'	        	  => 1,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 1,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 1,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 3,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 1,
						// midbar
						'wi_midbar'						  => 2,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 3,
						'wi_midbar_social'		 	 	  => 1,
						'wi_midbar_search'		  		  => 1,
						'wi_midbar_cart'		 	 	  => 1,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '06',
						// colors
						'wi_top_st_separator'		  	  => 'transparent',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => 'transparent',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => 'transparent',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#d40d14', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#d40d14', 'hover' => '#d40d14'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#d40d14'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#d40d14'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#d40d14'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#d40d14' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#d40d14', 'hover' => '#d40d14'),
						'wi_navbar_border_color'		  => 'transparent',
						)
					),
					'7'      => array(
		            'alt'   => 'Preset 7', 
		            'img'   => $theme_path_images . 'options/header_preset_07.jpg',
		            'presets'   => array(
						// topbar
						'wi_topbar'					 	  => 2,
						'wi_topbar_social'  		 	  => 2,
						'wi_topbar_cart'			 	  => 1,
						'wi_topbar_search'			 	  => 1,
						'wi_topbar_phone'	        	  => 1,
						'wi_topbar_phone_field'           => '1-800-633-3469',
						'wi_topbar_email' 	 		 	  => 1,
						'wi_topbar_email_field'           => 'admin@website.com',
						'wi_topbar_whours' 	 		 	  => 1,
						'wi_topbar_whours_field'          => 'Mn-Fr (9.00 am - 5.00 pm)',
						'wi_topbar_textmenu_position'	  => 3,
						'wi_topbar_textmenu'		 	  => 2,
						'wi_topbar_textmenu_field'        => 'Your Text or HTML',
						'wi_topbar_profile'			 	  => 1,
						// midbar
						'wi_midbar'						  => 2,
						'wi_midbar_custom_code'		  	  => 1,
						// if you need code
						'wi_midbar_custom_code_field' 	  => '
	<div class="col-md-3 col-sm-6 col-xs-12 mobile-more-space"><a href="' . esc_url(home_url('/')) . '" title="' . esc_html__( 'Your Logo','b-i-g') . '"><img width="130" src="'. get_template_directory_uri() . '/framework/images/logos/logo-light.png" alt="' . esc_html__( 'Your Logo','b-i-g') . '"></a></div>
	<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-phone"></i> ' . esc_html__( 'Main Number','b-i-g') . '<br><span class="title-bold">' . esc_html__( '1-800-123-4567','b-i-g') . '</span></div>
	<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space"><i class="fa fa-location-arrow"></i> ' . esc_html__( 'Find us on Google Maps','b-i-g') . '<br><a href="#">' . esc_html__( 'You can send message here','b-i-g') . '</a></div>
	<div class="col-md-3 col-sm-6 col-xs-no mobile-more-space">' . esc_html__( 'Mn-Fr (9.00 am - 5.00 pm)','b-i-g') . '<br>' . esc_html__( 'wwweb.invader@gmail.com','b-i-g') . '</div>
						',
						// if you need simple settings
						'wi_logo_style'				  	  => 1,
						'wi_midbar_logo'			  	  => 3,
						'wi_midbar_social'		 	 	  => 1,
						'wi_midbar_search'		  		  => 1,
						'wi_midbar_cart'		 	 	  => 1,
						// navbar
						'wi_navbar'					 	  => 1,
						'wi_header_nav_type'		 	  => '07',
						// colors
						'wi_top_st_separator'		  	  => 'transparent',
						'wi_top_st_separator_first'  	  => 1,
						'wi_top_st_separator_last'	 	  => 1,
						'wi_top_st_t_color' 			  => 'transparent',
						'wi_top_st_t_width' 			  => '1',
						'wi_top_st_b_color'				  => 'transparent',
						'wi_top_st_b_width'				  => '1',
						'wi_top_st_bg'				 	  => '#212121',
						'wi_top_st_text_color'		 	  => '#ffffff',
						'wi_top_st_text_icons_color' 	  => '#ffffff',
						'wi_top_st_text_link_color'  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679'), 
						'wi_top_st_social_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679'),
						'wi_top_st_search_color' 	  	  => array( 'regular' => '#ffffff', 'hover' => '#b09679', 'active' => '#ffffff' ), 
						'wi_top_st_cart_color'		 	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_val'		  	  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_top_st_cart_bg' 		  	  => array( 'regular' => '#b09679', 'hover' => '#b09679'),
						'wi_top_st_searcharea_color'  	  => '#ffffff',
						'wi_top_st_searcharea_bg'     	  => '#212121',
						'wi_top_st_searcharea_icon_color' => array( 'regular' => '#ffffff', 'hover' => '#b09679'),
						'wi_mid_st_bg' 					  => '#ffffff',						
						'wi_mid_st_text_color'			  => '#212121',						
						'wi_mid_st_text_link_color'       => array( 'regular' => '#212121', 'hover' => '#b09679'),
						'wi_mid_st_social_color'		  => array( 'regular' => '#212121', 'hover' => '#b09679'),
						'wi_mid_st_search_color'		  => array( 'regular' => '#212121', 'hover' => '#212121', 'active' => '#b09679' ),
						'wi_mid_st_cart_color' 			  => array( 'regular' => '#212121', 'hover' => '#212121'),
						'wi_mid_st_cart_val'			  => array( 'regular' => '#ffffff', 'hover' => '#ffffff'),
						'wi_mid_st_cart_bg'				  => array( 'regular' => '#b09679', 'hover' => '#b09679'),
						'wi_navbar_border_color'		  => 'transparent',
						)
					),
				),		
			),
		),		
	);

$sections[] = array(
	'title' => esc_attr__('Blog Settings','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-th-list',
    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
	'fields' => array(	
			array(
				'id'       => 'wi_blog_content',
				'type'     => 'select',
				'title'    => esc_attr__('Select Content Option','b-i-g'), 
				//'subtitle' => esc_attr__('No validation can be done on this field type','b-i-g'),
				'desc'     => esc_attr__('Select your option','b-i-g'),
				// Must provide key => value pairs for select options
				'options'  => array(
					'1' => 'Excerpt',
					'2' => 'Content',
				),
				'default'  => '1',
			),
			array(
				'id'	   => 'wi_blog_content_excerpt',
				'validate' => 'numeric',
				'type'     => 'text',
				'title'    => esc_attr__('Excerpt Value','b-i-g'),
				//'subtitle' => esc_attr__('Default: 256','b-i-g'),
				'desc'     => esc_attr__('Use this to crop your Excerpt','b-i-g'),
				'default'  => '256',
			),
			array(
				'id'       => 'wi_blog_meta_date',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Post Date','b-i-g'),
				'subtitle' => esc_attr__('Choose a Post Date option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => 'Disabled', 
					'2' => 'On Image', 
					'3' => 'In meta data',
				 ), 
				'default' => '2',
			),
			array(
				'id'       => 'wi_blog_meta_likes',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Post Likes','b-i-g'),
				'subtitle' => esc_attr__('Choose a Post Likes option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => 'Disabled', 
					'2' => 'Enabled',
				 ), 
				'default' => '2',
			),
			array(
				'id'       => 'wi_blog_meta_author',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Post Author','b-i-g'),
				'subtitle' => esc_attr__('Choose a Post Author option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => 'Disabled', 
					'2' => 'Enabled',
				 ), 
				'default' => '2',
			),	
			array(
				'id'       => 'wi_blog_meta_comments',
				'type'     => 'button_set',
				'title'    => esc_attr__('Show Post Comments','b-i-g'),
				'subtitle' => esc_attr__('Choose a Post Comments option','b-i-g'),
				'desc'     => esc_attr__('Choose Position or Disable it','b-i-g'),
				'multi'    => false,
				//Must provide key => value pairs for options
				'options' => array(
					'1' => 'Disabled', 
					'2' => 'Enabled',
				 ), 
				'default' => '2',
			),
			array(
				'id'	   => 'wi_blog_meta_readmore',
				'validate' => 'html',
				'type'     => 'text',
				'title'    => esc_attr__('Read More Text','b-i-g'),
				'desc'     => esc_attr__('Use it to set text as Read More or leave it empty','b-i-g'),
				'default'  => 'Read More',
			),
			array(
				'id'       => 'wi_blog_post_nav',
				'type'     => 'switch', 
				'title'    => esc_attr__('Show the Post Navigation','b-i-g'),
				// 'subtitle' => esc_attr__('Show the Top Bar Area in Header','b-i-g'),
				'default'  => true,
				'on' => 'Enabled',
				'off' => 'Disabled',
			),
			array(
				'id'       => 'wi_blog_related_posts',
				'type'     => 'switch', 
				'title'    => esc_attr__('Show the Related Posts','b-i-g'),
				// 'subtitle' => esc_attr__('Show the Top Bar Area in Header','b-i-g'),
				'default'  => true,
				'on' => 'Enabled',
				'off' => 'Disabled',
			),				
		),
	);

$sections[] = array(
	'title' => esc_attr__('Footer Settings','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-icon-photo',
    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
	'fields' => array(
			
			array(
					'id'       => 'wi_footer',
					'type'     => 'switch', 
					'title'    => esc_attr__('Show the Footer Widgets Area','b-i-g'),
					'subtitle' => esc_attr__('Show the Footer Widgets Area in Footer','b-i-g'),
					'default'  => true,
					'on' => 'Enabled',
					'off' => 'Disabled',
			),
			array(
				'id'       => 'wi_footer_widget_areas',
				'type'     => 'image_select',
				'title'    => esc_attr__('Footer Widget Areas','b-i-g'), 
				'subtitle' => esc_attr__('Select footer content layout','b-i-g'),
				'options'  => array(
					'1'      => array(
						'alt'   => '1 Column', 
						'img'   => $theme_path_images . 'options/footer_widgets_01.jpg'
					),
					'2'      => array(
						'alt'   => '2 Columns', 
						'img'   => $theme_path_images . 'options/footer_widgets_02.jpg'
					),
					'3'      => array(
						'alt'   => '3 Columns', 
						'img'   => $theme_path_images . 'options/footer_widgets_03.jpg'
					),
					'4'      => array(
						'alt'   => '4 Columns', 
						'img'   => $theme_path_images . 'options/footer_widgets_04.jpg'
					),
				),
				'default' => '4'
			),
			array(
				'id'      => 'wi_bottom_line_text',
				'type'    => 'text',
				'title'   => esc_attr__('Bottom footer text','b-i-g'), 
				'default' => 'Copyright &#169; 2016 <a href="http://wwwebinvader.com/">wwwebinvader</a>. All Rights Reserved.',
				'args'    => array(
					'teeny'         => true,
					'textarea_rows' => 10
				)
			),
			
	
		),
	);
	
$sections[] = array(
	'title' => esc_attr__('Footer Styling','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-brush',
    'subsection' => true,
	'fields' => array(
			// Border Top
			array(
				'id'          => 'wi_foo_bg_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Background Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#212121, Use transparent to disable it.','b-i-g'),
				'default'     => '#212121',
				'transparent' => true,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_foo_headings_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Widget Title Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff, Use transparent to disable it.','b-i-g'),
				'default'     => '#ffffff',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'          => 'wi_foo_text_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Text Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#c2c2c2, Use transparent to disable it.','b-i-g'),
				'default'     => '#c2c2c2',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_foo_text_link_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Footer Text Links Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_foo_bottom_border',
				'type'     => 'spinner', 
				'compiler'    => true,
				'title'    => esc_attr__('Footer Bottom Border Size','b-i-g'),
				'subtitle' => esc_attr__('Default: 1, Use 0 to disable it.','b-i-g'),
				'desc'     => esc_attr__('Min:0, max: 30, step:1, default value: 3','b-i-g'),
				'default'  => '3',
				'min'      => '0',
				'step'     => '1',
				'max'      => '30',
			),
			array(
				'id'          => 'wi_foo_bottom_border_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Bottom Border Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffd824','b-i-g'),
				'default'     => '#ffd824',
				'transparent' => false,
				'validate'    => 'color',
			),
			array(
				'id'        => 'wi_notice_footer_bottom_styling_info',
				'type'      => 'info',
				'notice'    => true,
				'style'     => 'info',
				'icon'      => 'el el-brush',
				'title'     => esc_attr__('Footer Bottom Bar Section Styling','b-i-g'),
				'desc'      => esc_attr__('If you\'d like to use a Bottom Bar for the Footer please see styling below.','b-i-g'),
			),
			array(
				'id'          => 'wi_foo_bt_bar_bg_color',
				'type'        => 'color',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Bottom Bar Background Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#252525','b-i-g'),
				'default'     => '#252525',
				'transparent' => true,
				'validate'    => 'color',
			),
			array(
				'id'       => 'wi_foo_bt_bar_link_color',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Footer Bottom Bar Links Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffffff',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'       => 'wi_foo_bt_bar_border',
				'type'     => 'spinner', 
				'compiler'    => true,
				'title'    => esc_attr__('Footer Bottom Bar Top Border Size','b-i-g'),
				'subtitle' => esc_attr__('Default: 1, Use 0 to disable it.','b-i-g'),
				'desc'     => esc_attr__('Min:0, max: 30, step:1, default value: 1','b-i-g'),
				'default'  => '1',
				'min'      => '0',
				'step'     => '1',
				'max'      => '30',
			),
			array(
				'id'          => 'wi_foo_bt_bar_color',
				'type'        => 'color_rgba',
				'compiler'    => true,
				'title'       => esc_attr__('Footer Bottom Bar Top Border Color','b-i-g'), 
				'subtitle'    => esc_attr__('Default:#ffffff','b-i-g'),
				'default'   => array(
					'color'     => '#ffffff',
					'alpha'     => '0.18',
				),
				'transparent' => false,
				'validate'    => 'colorrgba',
			),
	),
);	

$sections[] = array(
	'title' => esc_attr__('Footer Preset','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-icon-credit-card',
    'subsection' => true,
	'fields' => array(
			array( 
					'id'       => 'wi_footer_preset',
					'type'     => 'image_select', 
					'presets'  => true,
					'compiler' => true,
					'width'    => '',
					'height'   => '',
					'title'    => esc_attr__('Choose Footer Preset','b-i-g'),
					'subtitle' => esc_attr__('Allow you to set default footer preset','b-i-g'),
					'desc'     => esc_attr__('Choose Default Footer Layout','b-i-g'),
					'default'  => 1,
					'options'  => array(
			        // Array of preset options
					'1'      => array(
					'alt'   => 'Preset 1', 
					'img'   => $theme_path_images . 'options/footer_preset_01.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#ffd824' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#ffd824',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#ffd824' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'2'      => array(
					'alt'   => 'Preset 2', 
					'img'   => $theme_path_images . 'options/footer_preset_02.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#00ccfd' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#00ccfd',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#00ccfd' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'3'      => array(
					'alt'   => 'Preset 3', 
					'img'   => $theme_path_images . 'options/footer_preset_03.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#95532c' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#95532c',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#95532c' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'4'      => array(
					'alt'   => 'Preset 4', 
					'img'   => $theme_path_images . 'options/footer_preset_04.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#ffb900' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#ffb900',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#ffb900' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'5'      => array(
					'alt'   => 'Preset 5', 
					'img'   => $theme_path_images . 'options/footer_preset_05.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#1bc0ea',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#1bc0ea' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'6'      => array(
					'alt'   => 'Preset 6', 
					'img'   => $theme_path_images . 'options/footer_preset_06.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '4',
						'wi_foo_bg_color'               => '#212121',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#c2c2c2',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#d40d14' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#d40d14',
						'wi_foo_bt_bar_bg_color'        => '#252525',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#d40d14' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),
					'7'      => array(
					'alt'   => 'Preset 7', 
					'img'   => $theme_path_images . 'options/footer_preset_07.jpg',
					'presets'   => array(
						'wi_footer_widget_areas'        => '3',
						'wi_foo_bg_color'               => '#2D2C35',
						'wi_foo_headings_color'         => '#ffffff',
						'wi_foo_text_color'             => '#848484',
						'wi_foo_text_link_color'        => array( 'regular' => '#ffffff', 'hover' => '#b09679' ),
						'wi_foo_bottom_border'          => '3',
						'wi_foo_bottom_border_color'    => '#b09679',
						'wi_foo_bt_bar_bg_color'        => '#2D2C35',
						'wi_foo_bt_bar_link_color'      => array( 'regular' => '#ffffff', 'hover' => '#b09679' ),
						'wi_foo_bt_bar_border'          => '1',
						'wi_foo_bt_bar_color'           => array( 'color' => '#ffffff', 'alpha' => '0.18' ),
						)	
					),

				),		
			),
		),		
	);

$sections[] = array(
                'icon'      => 'el el-icon-globe',
                'title'     => esc_attr__('Social Media','b-i-g'),
                'fields'    => array(				
                    
					array(
                        'id'        => 'wi_feedburner',
                        'type'      => 'text',
                        'title'     => esc_attr__('FeedBurner URL','b-i-g'),
                        'subtitle'  => esc_attr__('Enter your full FeedBurner URL (or any other preferred feed URL) if you wish to use FeedBurner over the standard WordPress Feed e.g. http://feeds.feedburner.com/yoururlhere','b-i-g'),
                        'desc'      => esc_attr__('This is must be an url.','b-i-g'),
                        'validate'  => 'url',
                        'default'   => '',
                        'text_hint' => array(
                           'title'     => '',
                           'content'   => 'Please enter a valid <strong>URL</strong> in this field.'
                       )
                    ),	
					array(
                        'id'        => 'wi_facebook_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Facebook URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Facebook URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_twitter_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Twitter URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Twitter URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_googleplus_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Google+ URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Google+ URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_vimeo_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Vimeo URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Vimeo URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_lin_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Linkedin URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Linkedin URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_tumblr_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Tumblr URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Tumblr URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_pinterest_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Pinterest URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Pinterest URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_skype_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Skype ID','b-i-g'),
                        'subtitle'  => esc_attr__('Enter your skype ID.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_dribbble_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Dribbble URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Dribbble URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_yt_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Youtube URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Youtube URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_behance_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Behance URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Behance URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_flickr_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Flickr URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Flickr URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_instagram_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Instagram URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Instagram URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_da_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Deviant Art URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Deviant Art URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_digg_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Digg URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Digg URL.','b-i-g'),
                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					array(
                        'id'        => 'wi_reddit_link',
                        'type'      => 'text',
                        'title'     => esc_attr__('Reddit URL','b-i-g'),
                        'subtitle'  => esc_attr__('Please enter in your Reddit URL.','b-i-g'),                       
                        'validate'  => 'url',
                        'default'   => '',
                    ),
					// Custom Social Icons
					array(
						'id'       => 'wi_social_custom_icons',
						'type'     => 'switch',
						'title'    => esc_attr__('Show Custom Social Icons','b-i-g'),				
						'subtitle' => esc_attr__('Add your Custom Social Icons and Show it','b-i-g'),
						'default'  => false,
						'on' => 'Enabled',
						'off' => 'Disabled'			
					),
					array(
							'id'               => 'wi_social_custom_icons_field',
							'type'             => 'ace_editor',
							'mode'			   => 'html',
							'required' => array( 
								array('wi_social_custom_icons','=', 1),
							),
							'title'  => esc_attr__('Your Custom Code to Social Icons','b-i-g'),
							'subtitle' => esc_attr__('Type your custom HTML markup','b-i-g'),
							'desc'     => esc_attr__('You can use any HTML code and FontAwesome icons you want. Change code in Code Area Below','b-i-g'),
							'default'          => '
<div><a href="#" target="_blank"><i class="fa fa-user"></i></a></div>
<div><a href="#" target="_blank"><i class="fa fa-heart"></i></a></div>
<div><a href="#" target="_blank"><i class="fa fa-thumbs-up"></i></a></div>
							'
					),
                )
            );
	
	
$sections[] = array( 
	'title' => esc_attr__('Typography','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-icon-font',
    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
	'fields' => array(
			array(
				'id'          => 'wi_main_body_typography',
				'type'        => 'typography', 
				'title'       => esc_attr__('Main Body Typography','b-i-g'),
				'subtitle'    => esc_attr__('Set your own typography options.','b-i-g'),
				'google'      => true, 
				'font-backup'    => false,
				'font-weight'    => true,
				'letter-spacing' => true,
				'text-align'     => false,
				'units'       =>'px',
				'compiler'    => true,
				'default'     => array(
					'color'       => '#212121', 
					'font-weight'    => '400', 
					'font-family'    => 'Open Sans', 
					'google'         => true,
					'font-size'      => '14px', 
					'line-height'    => '24',
					'letter-spacing' => 'normal',
				),
			),
			array(
				'id'       => 'wi_main_links_typography',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Main Links Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#ffd824',
					'hover'    => '#212121',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
			array(
				'id'          => 'wi_headings_typography',
				'type'        => 'typography', 
				'title'       => esc_attr__('Headings Typography','b-i-g'),
				'subtitle'    => esc_attr__('Set your own typography options.','b-i-g'),
				'google'      => true, 
				'font-backup'    => false,
				'font-weight'    => true,
				'letter-spacing' => true,
				'line-height'    => false,
				'text-align'     => false,
				'font-size'      => false,
				'units'       =>'px',
				'compiler'    => true,
				'default'     => array(
					'color'       => '#212121', 
					'font-weight'    => '600', 
					'font-family'    => 'Open Sans', 
					'google'         => true,
					'font-size'      => '14px', 
					'line-height'    => '24',
					'letter-spacing' => 'normal',
				),
			),			
			array(
				'id'       => 'wi_headings_links_typography',
				'type'     => 'link_color',
				'compiler' => true,
				'title'    => esc_attr__('Heading Links Color','b-i-g'),
				'regular'  => true,
				'hover'    => true,
				'active'   => false,
				'visited'  => false,
				'default'  => array(
					'regular'  => '#212121',
					'hover'    => '#ffd824',
				//	'active'   => '#ffd824',
				//	'visited'  => '#ffd824',
				)
			),
	
		),
	);		
	
$sections[] = array(
	'title'      => esc_attr__( 'Main Palette','b-i-g'),
	'desc'       => esc_attr__( 'Choose one of the demo layouts right here.','b-i-g'),
	'id'         => 'color-palette',
	'icon_class' => 'icon-large',
	'icon'       => 'el el-brush',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'        => 'wi_notice_settings_preset',
			'type'      => 'info',					
			'icon' => 'el el-idea',
			'style'     => 'critical',
			'title'     => esc_attr__('PRESET OPTIONS','b-i-g'),
			'desc'      => esc_attr__('If you will use one of this Settings Presets you will lost your setting and get Default Demo settings instead!','b-i-g')
			
			
		),
		array(	
			'id'       => 'wi_accent_colors_preset',
			'type'     => 'image_select', 
			'presets'  => true,
			'compiler' => true,
			'width'    => '',
			'height'   => '',
			'title'    => esc_attr__('Choose Settings Preset','b-i-g'),
			'subtitle' => esc_attr__('Allow you to set all settings preset same to demo','b-i-g'),
			'desc'     => esc_attr__('Choose Default Demo Settings','b-i-g'),
			'default'  => 1,
			'options'  => array(
			// Array of preset options
				'1'      => array(
				'alt'   => 'Preset 1', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_01.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#ffd824',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#212121' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#ffd824' ),
						'wi_accent_top_button_color'    => '#212121',
						'wi_accent_top_button_bg_color' => '#ffd824',	
					),
				),
				'2'      => array(
				'alt'   => 'Preset 2', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_02.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#00ccfd',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#00ccfd' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#00ccfd',	
					),
				),
				'3'      => array(
				'alt'   => 'Preset 3', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_03.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#95532c',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#95532c', 'hover' => '#95532c' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#95532c',	
					),
				),
				'4'      => array(
				'alt'   => 'Preset 4', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_04.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#ffb900',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#212121', 'hover' => '#ffb900' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#ffb900',	
					),
				),
				'5'      => array(
				'alt'   => 'Preset 5', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_05.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#1bc0ea',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#1bc0ea', 'hover' => '#30cff8' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#1bc0ea',		
					),
				),
				'6'      => array(
				'alt'   => 'Preset 6', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_06.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#d40d14',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#d40d14', 'hover' => '#e6262d' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#d40d14',		
					),
				),
				'7'      => array(
				'alt'   => 'Preset 7', 
				'img'   => $theme_path_images . 'options/accent_colors_preset_07.jpg',
				'presets'   => array(
						'wi_accent_color'               => '#b09679',
						'wi_accent_dark_color'          => '#212121',
						'wi_accent_buttons_color'       => array( 'regular' => '#ffffff', 'hover' => '#ffffff' ),
						'wi_accent_buttons_bg_color'    => array( 'regular' => '#b09679', 'hover' => '#957858' ),
						'wi_accent_top_button_color'    => '#ffffff',
						'wi_accent_top_button_bg_color' => '#b09679',	
					),
				),
			),		
		),
		array(
			'id'          => 'wi_accent_color',
			'type'        => 'color',
			'compiler'    => true, // Use if you want to hook in your own CSS compiler
			'title'       => esc_attr__('Main accent color','b-i-g'), 
			'subtitle'    => esc_attr__('Default:#ffd824','b-i-g'),
			'default'     => '#ffd824',
			'validate'    => 'color',
			'transparent' => false,
		),
		array(
			'id'          => 'wi_accent_dark_color',
			'type'        => 'color',
			'compiler'    => true, // Use if you want to hook in your own CSS compiler
			'title'       => esc_attr__('Main accent dark color','b-i-g'), 
			'subtitle'    => esc_attr__('Default:#212121','b-i-g'),
			'default'     => '#212121',
			'validate'    => 'color',
			'transparent' => false,
		),
		array(
			'id'       => 'wi_accent_buttons_color',
			'type'     => 'link_color',
			'compiler' => true,
			'title'    => esc_attr__('Theme Buttons Color','b-i-g'),
			'regular'  => true,
			'hover'    => true,
			'active'   => false,
			'visited'  => false,
			'default'  => array(
				'regular'  => '#ffffff',
				'hover'    => '#212121',
			)
		),
		array(
			'id'       => 'wi_accent_buttons_bg_color',
			'type'     => 'link_color',
			'compiler' => true,
			'title'    => esc_attr__('Theme Buttons Background Color','b-i-g'),
			'regular'  => true,
			'hover'    => true,
			'active'   => false,
			'visited'  => false,
			'default'  => array(
				'regular'  => '#212121',
				'hover'    => '#ffd824',
			)
		),
		array(
			'id'          => 'wi_accent_top_button_color',
			'type'        => 'color',
			'compiler'    => true, // Use if you want to hook in your own CSS compiler
			'title'       => esc_attr__('Go Top Button Color','b-i-g'), 
			'subtitle'    => esc_attr__('Default:#212121','b-i-g'),
			'default'     => '#212121',
			'validate'    => 'color',
			'transparent' => false,
		),		
		array(
			'id'          => 'wi_accent_top_button_bg_color',
			'type'        => 'color',
			'compiler'    => true, // Use if you want to hook in your own CSS compiler
			'title'       => esc_attr__('Go Top Button Background Color','b-i-g'), 
			'subtitle'    => esc_attr__('Default:#ffd824','b-i-g'),
			'default'     => '#ffd824',
			'validate'    => 'color',
			'transparent' => false,
		),
	)
);	

	
$sections[] = array(
	'title' => esc_attr__('404 Page Settings','b-i-g'),
	'header' => '',
	'desc' => '',
	'icon_class' => 'icon-large',
    'icon' => 'el el-remove-circle',
    // 'submenu' => false, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
	'fields' => array(
			array(
				'id'	   =>'wi_404_image',
				'type'     => 'media', 
				'url'      => true,
				'title'    => esc_attr__('404 Page Image Upload','b-i-g'),
				'desc'     => esc_attr__('Upload your logo or paste the url','b-i-g'),
				'subtitle' => esc_attr__('Upload image using the native media uploader, or define the URL directly','b-i-g'),
				'default'  =>array('url'=> $theme_path_images . '/logos/404-page.png' ),
			),
			array(
				'id'      => 'wi_404_text_1',
				'type'    => 'text',
				'title'   => esc_attr__('Main Page on 404 Page','b-i-g'), 
				'default' => 'Oops, This Page Could Not Be Found!',
			),	
			array(
				'id'      => 'wi_404_text_2',
				'type'    => 'text',
				'title'   => esc_attr__('Secondary Page on 404 Page','b-i-g'), 
				'default' => 'The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.',
			),				
		),
	);

$sections[] = array(
			'icon'      => 'el el-icon-time',
			'title'     => esc_attr__('Coming Soon Page','b-i-g'),
			'fields'    => array(			
				array(
					'id'        => 'wi_csp_logo',
					'type'      => 'media',
					'url'       => true,
					'title'     => esc_attr__('Coming Soon Page Logo upload','b-i-g'),				   
					'subtitle'  => esc_attr__('Use big logo for retina ready display','b-i-g'),
					'default'   => array('url'=> $theme_path_images . '/logos/coming-soon-page.png' ),
				),
				array(
					'id'        => 'wi_csp_text',
					'type'      => 'text',
					'title'     => esc_attr__('Coming Soon Page Text','b-i-g'),
					'subtitle'  => esc_attr__('Insert the text to show on the coming soon page','b-i-g'),				   
					'default'   => 'WE ARE COMING SOON',
				),					
				array(
					'id'        => 'wi_csp_date',
					'type'      => 'text',
					'title'     => esc_attr__('Date','b-i-g'),
					'subtitle'  => esc_attr__('Format yyyy-mm-dd ( eg. 2016-08-06 )','b-i-g'),
					'desc'      => esc_attr__('Insert the Release Date ( format yyyy-mm-dd, eg. 2016-08-06 )','b-i-g'),
					'default'   => '2016-08-06',
				),
				array(
					'id'        => 'wi_csp_days',
					'type'      => 'text',
					'title'     => esc_attr__('Text For Days','b-i-g'),
					'subtitle'  => esc_attr__('Insert the text to use for the Days counter','b-i-g'),
				   
					'default'   => 'Days',
				),					
				array(
					'id'        => 'wi_csp_days_color',
					'type'      => 'color',
					'title'     => esc_attr__('Days Counter Bar color','b-i-g'),
					'subtitle'  => esc_attr__('Days Bar Color.','b-i-g'),
					'default'   => '#fff224',
					'validate'  => 'color',
				),
				array(
					'id'        => 'wi_csp_hours',
					'type'      => 'text',
					'title'     => esc_attr__('Text For Hours','b-i-g'),
					'subtitle'  => esc_attr__('Insert the text to use for the Hours counter','b-i-g'),
				   
					'default'   => 'Hours',
				),									
				array(
					'id'        => 'wi_csp_hours_color',
					'type'      => 'color',
					'title'     => esc_attr__('Hours Counter Bar color','b-i-g'),
					'subtitle'  => esc_attr__('Hours Bar Color.','b-i-g'),
					'default'   => '#ffd824',
					'validate'  => 'color',
				),
				array(
					'id'        => 'wi_csp_minutes',
					'type'      => 'text',
					'title'     => esc_attr__('Text For Minutes','b-i-g'),
					'subtitle'  => esc_attr__('Insert the text to use for the Minutes counter','b-i-g'),
				   
					'default'   => 'Minutes',
				),								
				array(
					'id'        => 'wi_csp_minutes_color',
					'type'      => 'color',
					'title'     => esc_attr__('Minutes Counter Bar color','b-i-g'),
					'subtitle'  => esc_attr__('Minutes Bar Color.','b-i-g'),
					'default'   => '#ffc924',
					'validate'  => 'color',
				),
				array(
					'id'        => 'wi_csp_seconds',
					'type'      => 'text',
					'title'     => esc_attr__('Text For Seconds','b-i-g'),
					'subtitle'  => esc_attr__('Insert the text to use for the Seconds counter','b-i-g'),
				   
					'default'   => 'Seconds',
				),									
				array(
					'id'        => 'wi_csp_seconds_color',
					'type'      => 'color',
					'title'     => esc_attr__('Seconds Counter Bar color','b-i-g'),
					'subtitle'  => esc_attr__('Seconds Bar Color.','b-i-g'),
					'default'   => '#ffb424',
					'validate'  => 'color',
				),	
				
			)
		);
		
// Info Requirements

$mem_limit = ini_get('memory_limit');
$mem_limit_byte = wp_convert_hr_to_bytes($mem_limit);
$upload_max_filesize = ini_get('upload_max_filesize');
$upload_max_filesize_byte = wp_convert_hr_to_bytes($upload_max_filesize);
$post_max_size = ini_get('post_max_size');
$post_max_size_byte = wp_convert_hr_to_bytes($post_max_size);

$mem_limit_byte_boolean = $mem_limit_byte<268435456;
$upload_max_filesize_byte_boolean = ($upload_max_filesize_byte < 67108864);
$post_max_size_byte_boolean = ($post_max_size_byte < 67108864);

$max_execution_time = ini_get("max_execution_time");
$max_execution_time_boolean = ($max_execution_time < 3600);

$max_input_time = ini_get("max_input_time");
$max_input_time_boolean = ($max_input_time < 3600);

$max_input_vars = ini_get("max_input_vars");
$max_input_vars_boolean = ($max_input_vars < 3000);

$dash_rr_status = ($max_execution_time_boolean==false && $max_input_time_boolean==false && $max_input_vars_boolean==false && $mem_limit_byte_boolean==false && $upload_max_filesize_byte_boolean==false && $post_max_size_byte_boolean==false) ? "success" : "warning";

// memory_limit

if($mem_limit_byte_boolean){ 
	//not good
	$mem_limit_output_status = 'wi-dash-red-content';
} else {
	//good
	$mem_limit_output_status = 'wi-dash-green-content';
}
$mem_limit_output = 
	'<tr>' .
	'<th>' . esc_attr__('memory_limit','b-i-g') . '</th>' .
	'<th class="' . $mem_limit_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $mem_limit . '</th>' .
	'<th>' . esc_attr__('min: 256M', 'b-i-g') . '</th>' .
	'</tr>';

// post_max_size	

if($post_max_size_byte_boolean){
	//not good
	$post_max_size_output_status = 'wi-dash-red-content';
} else {
	//good
	$post_max_size_output_status = 'wi-dash-green-content';
}
$post_max_size_output = 
	'<tr>' . 
	'<th>' . esc_attr__('post_max_size','b-i-g') . '</th>' .
	'<th class="' . $post_max_size_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $post_max_size . '</th>' .
	'<th>' . esc_attr__('min: 64M', 'b-i-g') . '</th>' .
	'</tr>';

// upload_max_filesize	


if($upload_max_filesize_byte_boolean){
	//not good
	$upload_max_filesize_output_status = 'wi-dash-red-content';
} else {
	//good
	$upload_max_filesize_output_status = 'wi-dash-green-content';
}

$upload_max_filesize_output = 
	'<tr>' . 
	'<th>' . esc_attr__('upload_max_filesize','b-i-g') . '</th>' .
	'<th class="' . $upload_max_filesize_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $upload_max_filesize . '</th>' .
	'<th>' . esc_attr__('min: 64M', 'b-i-g') . '</th>' .
	'</tr>';
	
// max_execution_time	


if($max_execution_time_boolean){
	//not good
	$max_execution_time_output_status = 'wi-dash-red-content';
} else {
	//good
	$max_execution_time_output_status = 'wi-dash-green-content';
}

$max_execution_time_output = 
	'<tr>' . 
	'<th>' . esc_attr__('max_execution_time','b-i-g') . '</th>' .
	'<th class="' . $max_execution_time_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $max_execution_time . '</th>' .
	'<th>' . esc_attr__('min: 3600', 'b-i-g') . '</th>' .
	'</tr>';
	
// max_input_time	


if($max_input_time_boolean){
	//not good
	$max_input_time_output_status = 'wi-dash-red-content';
} else {
	//good
	$max_input_time_output_status = 'wi-dash-green-content';
}

$max_input_time_output = 
	'<tr>' . 
	'<th>' . esc_attr__('max_input_time','b-i-g') . '</th>' .
	'<th class="' . $max_input_time_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $max_input_time . '</th>' .
	'<th>' . esc_attr__('min: 3600', 'b-i-g') . '</th>' .
	'</tr>';

// max_input_vars
	
if($max_input_vars_boolean){
	//not good
	$max_input_vars_output_status = 'wi-dash-red-content';
} else {
	//good
	$max_input_vars_output_status = 'wi-dash-green-content';
}

$max_input_vars_output = 
	'<tr>' . 
	'<th>' . esc_attr__('max_input_vars','b-i-g') . '</th>' .
	'<th class="' . $max_input_vars_output_status . '">' . '<i class="check el el-ok-sign"></i>' . esc_attr__('Currently: ', 'b-i-g') . $max_input_vars . '</th>' .
	'<th>' . esc_attr__('min: 3000', 'b-i-g') . '</th>' .
	'</tr>';
	

// info requirements output

$requirements_start = '<table class="wi-dash-content"><tbody>';
$requirements_end = '</tbody></table>';
$info_requirements_desc = 
$requirements_start . 
$mem_limit_output . $post_max_size_output . $upload_max_filesize_output . $max_execution_time_output . $max_input_time_output . $max_input_vars_output . 
$requirements_end;

		// Demo Content Section			
		$sections[] = array(
                'id' => 'wbc_importer_section',
                'title'  => esc_html__( 'Demo Content', 'b-i-g' ),
                'desc'   => esc_html__( 'Content Parts 1, 2, 3, 4, 5 are required. Read all Notices.					
					', 'b-i-g' ),
                'icon'   => 'el-icon-website',
                'fields' => array(	
					array(
							'id'    => 'info_requirements',
							'type'  => 'info',
							'style' => $dash_rr_status,
							'title'     => esc_attr__('REQUIRED VALUES','b-i-g'),
							'desc'  => $info_requirements_desc,
						),				
					array(
						'id'        => 'wi_notice_demo import',
						'type'      => 'info',					
						'icon' 		=> 'el el-exclamation-sign',
						'style'     => 'critical',
						'title'     => esc_attr__('READ MORE BEFORE IMPORT','b-i-g'),
						'desc'      => esc_attr__('Because of large import file for some hosting was decided to separate one file on different parts. Read how to Prevent Issues!','b-i-g') . '<br><br>' . 
						esc_attr__('I. Increase REQUIRED VALUES on your Hosting if needed','b-i-g') . '<br>' . 						
						esc_attr__('II. Activate LMM Menu area, go to LMM Menu > Menu Panel > Config and activate this theme location: Header Nav 01','b-i-g') . '<br>' .
						esc_attr__('III. Dont forget import options to LMM Menu > Menu Panel > Import/Export from file in "demo-content" folder in your Main File','b-i-g') . '<br>' .
						esc_attr__('IV. Activate all plugins and start importing of Content Part - 1, Content Part - 2, Content Part - 3, Content Part - 4, Content Part - 5 one by one, keep calm, server need some time to import it.','b-i-g') . '<br>' .
						esc_attr__('V. All main sliders allready imported, more sliders you may find in "demo-content" folder in the Main File, you may easily import it in the RevSlider manually because their weight more than 200mb in general, it is too much for hosting php memory and other values, and maybe you do not need all of them.','b-i-g') . '<br><br>' . 
						esc_attr__('*  - Start import anew if you will find 500 Internal Server Error on your Console (F12 in Chrome Browser)','b-i-g') . '<br>' .
						esc_attr__('** - Use WordPress Database Reset Plugin to reset database if it is needed.','b-i-g') . '<br><br>',
					),
					array(
						'id'   => 'wbc_demo_importer',
						'type' => 'wbc_importer'
					),
			),
				
		);


/**
 * Sample Data Import function
 */
 
if ( !function_exists( 'b_i_g_wbc_extended' ) ) {
    function b_i_g_wbc_extended( $demo_active_import , $demo_directory_path ) {
 
        reset( $demo_active_import );
        $current_key = key( $demo_active_import );
 
    // Import Revolution Sliders
    if ( class_exists( 'RevSlider' ) ) {
      $wbc_sliders_array = array(
        'Content Part - 1' => array(
			'features-page.zip',
			'slider-01.zip',
			'slider-02.zip',
		),
		'Content Part - 2' => array(
			'slider-03.zip',
		),
		'Content Part - 3' => array(
			'slider-04.zip',
		),
		'Content Part - 4' => array(
			'slider-05.zip',
		),
		'Content Part - 5' => array(
			'slider-06.zip',
		),
		'Lawyers Layout' => array(
			'slider-07.zip',
		),
      );
 
      if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists(    $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
        $wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];
 
        if( is_array( $wbc_slider_import ) ){
          foreach ($wbc_slider_import as $slider_zip) {
            if ( !empty($slider_zip) && file_exists( $demo_directory_path.$slider_zip ) ) {
              $slider = new RevSlider();
              $slider->importSliderFromPost( true, true, $demo_directory_path.$slider_zip );
            }
          }
        } else{
          if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) {
            $slider = new RevSlider();
            $slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
          }
        }
      }
    }
 
 
        // Setting Menus
        $wbc_menu_array = array( 
			'Content Part - 1', 
			'Content Part - 2', 
			'Content Part - 3', 
			'Content Part - 4', 
			'Content Part - 5', 
		);
 
        if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
            $header_nav = get_term_by( 'name', esc_html__( 'Header Navigation', 'b-i-g' ), 'nav_menu' );
            $topbar_menu = get_term_by( 'name', esc_html__( 'Top Bar Menu', 'b-i-g' ), 'nav_menu' );
 
            if ( isset( $primary_menu->term_id ) ) {
                set_theme_mod( 'nav_menu_locations', array(
                        'header_nav_01' => $header_nav->term_id,
                        'topbar_menu' => $topbar_menu->term_id
                    )
                );
            }
 
        }
 
        // Set HomePage
        $wbc_home_pages = array(
            'Content Part - 1' => 'Theme Features',
			'Content Part - 2' => 'Theme Features',
			'Content Part - 3' => 'Theme Features',
			'Content Part - 4' => 'Theme Features',
			'Content Part - 5' => 'Theme Features',
        );
 
        if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
            $page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
            if ( isset( $page->ID ) ) {
                update_option( 'page_on_front', $page->ID );
                update_option( 'show_on_front', 'page' );
            }
        }
 
    }
    add_action( 'wbc_importer_after_content_import', 'b_i_g_wbc_extended', 10, 2 );
}

/* Compilation of the CSS
 * -------------------------------------------------- */

$ReduxFramework = get_option('ReduxFramework');
if ( !isset( $tabs ) ) $tabs = 0;
$ReduxFramework = new ReduxFramework($sections, $args, $tabs);

// END Sample Config

function generate_options_css( $newdata ) {
    $smof_data = $newdata;
    $css_dir = get_template_directory() . '/framework/css/';
    $css_php_dir = get_template_directory() . '/framework/css/';
    ob_start();
    require( $css_php_dir . 'style.php' );
    $css = ob_get_clean();
    global $wp_filesystem;
    WP_Filesystem();
    if ( ! $wp_filesystem->put_contents( $css_php_dir . 'options.css', $css, 0644 ) ) {
        return true;
    }
}

function wi_theme_css_compiler() {
	$wi_options = get_option('wi_options');
	generate_options_css( $wi_options );
}
add_action('redux/options/wi_options/compiler', 'wi_theme_css_compiler');