<?php
$wi_options = get_option('wi_options');

/**
 * Conditionally displays a metabox when used as a callback in the 'show_on_cb' cmb2_box parameter
 */
function wwwebinvader_show_if_front_page( $cmb ) {
	// Don't show this metabox if it's not the front page template
	if ( $cmb->object_id !== get_option( 'page_on_front' ) ) {
		return false;
	}
	return true;
}

/**
 * Conditionally displays a field when used as a callback in the 'show_on_cb' field parameter
 *
 * @param  CMB2_Field object $field Field object
 *
 * @return bool                     True if metabox should show
 */
function wwwebinvader_hide_if_no_cats( $field ) {
	// Don't show this field if not in the cats category
	if ( ! has_tag( 'cats', $field->object_id ) ) {
		return false;
	}
	return true;
}

/**
 * Conditionally displays a message if the $post_id is 2
 *
 * @param  array             $field_args Array of field parameters
 * @param  CMB2_Field object $field      Field object
 */
function wwwebinvader_before_row_if_2( $field_args, $field ) {
	if ( 2 == $field->object_id ) {
		echo '<p>Testing <b>"before_row"</b> parameter (on $post_id 2)</p>';
	} else {
		echo '<p>Testing <b>"before_row"</b> parameter (<b>NOT</b> on $post_id 2)</p>';
	}
}

function page_settings_box( array $meta_box_config ) {
	return cmb2_get_metabox( $meta_box_config );
}
add_action( 'cmb2_admin_init', 'wwwebinvader_register_page_settings_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */
function wwwebinvader_register_page_settings_metabox() {

	// Start with an underscore to hide fields from custom fields list

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demo = page_settings_box( array(
		'id'            => 'wi_page_meta_metabox',
		'title'         => esc_html__( 'Additional Settings', 'b-i-g' ),
		'object_types'  => array( 'page', ), // Post type
		// 'show_on_cb' => 'wwwebinvader_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
	) );

		/* Start Options */
		if(is_plugin_active('revslider/revslider.php')) {
		
		// Rev Slider
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Select Revolution Slider', 'b-i-g' ),
		//	'desc'             => esc_html__( 'Choose yourRevSlider slider here', 'b-i-g' ),
			'id'               => 'wi_meta_revslider',
			'type'             => 'select',
			'show_option_none' => true,
			'options'          => all_rev_sliders_in_array(),
		) );	
		
		// Slider Position
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Select Revolution Slider Position', 'b-i-g' ),
		//	'desc'             => esc_html__( 'Choose yourRevSlider slider position here', 'b-i-g' ),
			'id'               => 'wi_meta_revslider_position',
			'type'             => 'select',
			'show_option_none' => false,
			'options'          => array(
				'1' => esc_html__( 'After a Header', 'b-i-g' ),
				'2' => esc_html__( 'Before a Header Top Bar', 'b-i-g' ),
				'3' => esc_html__( 'Before a Header Mid Bar', 'b-i-g' ),
				'4' => esc_html__( 'Before a Header Navigation Bar', 'b-i-g' ),
			),
		) );
		}
		
		
		// Content Top Gap
		$cmb_demo->add_field( array(
				'name'   => 'Hide the Title?',
				//'desc' => 'field description (optional)',
				'id'     => 'wi_meta_display_title',
				'type'   => 'checkbox'
			)
		);
		
		// Content Top Gap
		$cmb_demo->add_field( array(
				'name'    => 'Set Top Content Margin (40px)',
				//'desc'  => 'field description (optional)',
				'default' => '40px',
				'id'      => 'wi_meta_top_content_margin',
				'type'    => 'text',
			)
		);	
		
		global $wp_registered_sidebars;
		$sidebar_array = array();
		$dp_sidebars = $wp_registered_sidebars;

		foreach ( $dp_sidebars as $sidebar ) {
			$sidebar_array[$sidebar['name']] = $sidebar['name'];
		}
	
		// Sidebar
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Choose your Sidebar', 'b-i-g' ),
			'desc'             => wp_kses(__( '<strong>Don&#39;t forget set page template as "With Sidebars"</strong>. You can create new sidebar area here: <a href="/wp-admin/themes.php?page=multiple_sidebars">Sidebars Manager</a>', 'b-i-g' ) , array( 'a' => array( 'href' => array(), 'title' => array() ), 'strong' => array(), ) ),
			'id'               => 'wi_meta_sidebar',
			'type'             => 'select',
			'show_option_none' => true,
			'options'          => $sidebar_array,
			'default'          => 'Blog Sidebar',
		) );

		// Sidebar Position
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Choose Sidebar Position', 'b-i-g' ),
			'desc'             => wp_kses(__( '<strong>Don&#39;t forget set page template as "With Sidebars"</strong>', 'b-i-g' ), array( 'a' => array( 'href' => array(), 'title' => array() ), 'strong' => array(),  )),
			'id'               => 'wi_meta_sidebar_position',
			'type'             => 'select',
			'show_option_none' => false,
			'options'          => array (
				'1' => esc_html__( 'Right Sidebar', 'b-i-g' ),
				'2' => esc_html__( 'Left Sidebar', 'b-i-g' ),
			),
		) );
	
	
	/*
	
	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Header Layout', 'b-i-g' ),
		'desc'             => esc_html__( 'You can change Header on this Page', 'b-i-g' ),
		'id'               => 'wi_meta_header_page_layout',
		'type'             => 'select',
		'show_option_none' => false,
		'options'          => array(
			'1' => esc_html__( 'Custom HTML', 'b-i-g' ),
			'2' => esc_html__( 'Logo Light', 'b-i-g' ),
			'3' => esc_html__( 'Logo Dark', 'b-i-g' ),
			'4' => esc_html__( 'Without Logo', 'b-i-g' ),
		),
	) );	
	
	
	$cmb_demo->add_field( array(
		'name'    => esc_html__( 'Test Color Picker', 'b-i-g' ),
		'desc'    => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'      => 'wi_meta_colorpicker',
		'type'    => 'colorpicker',
		'default' => '#ffffff',
	) );


	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Test Select', 'b-i-g' ),
		'desc'             => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'               => 'wi_meta_select',
		'type'             => 'select',
		'show_option_none' => true,
		'options'          => array(
			'standard' => esc_html__( 'Option One', 'b-i-g' ),
			'custom'   => esc_html__( 'Option Two', 'b-i-g' ),
			'none'     => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );

	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Test Radio inline', 'b-i-g' ),
		'desc'             => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'               => 'wi_meta_radio_inline',
		'type'             => 'radio_inline',
		'show_option_none' => 'No Selection',
		'options'          => array(
			'standard' => esc_html__( 'Option One', 'b-i-g' ),
			'custom'   => esc_html__( 'Option Two', 'b-i-g' ),
			'none'     => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );

	$cmb_demo->add_field( array(
		'name'    => esc_html__( 'Test Radio', 'b-i-g' ),
		'desc'    => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'      => 'wi_meta_radio',
		'type'    => 'radio',
		'options' => array(
			'option1' => esc_html__( 'Option One', 'b-i-g' ),
			'option2' => esc_html__( 'Option Two', 'b-i-g' ),
			'option3' => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );*/

}

// Meta Box for Post

function post_settings_box( array $meta_box_config ) {
	return cmb2_get_metabox( $meta_box_config );
}
add_action( 'cmb2_admin_init', 'wwwebinvader_register_post_settings_metabox' );
function wwwebinvader_register_post_settings_metabox() {

	// Start with an underscore to hide fields from custom fields list

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demo = post_settings_box( array(
		'id'            => 'wi_post_meta_metabox',
		'title'         => esc_html__( 'Additional Settings', 'b-i-g' ),
		'object_types'  => array( 'post', 'portfolio', ), // Post type
		// 'show_on_cb' => 'wwwebinvader_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
	) );

		/* Start Options */
		if(is_plugin_active('revslider/revslider.php')) {
		
		// Rev Slider
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Select Revolution Slider', 'b-i-g' ),
		//	'desc'             => esc_html__( 'Choose yourRevSlider slider here', 'b-i-g' ),
			'id'               => 'wi_meta_revslider',
			'type'             => 'select',
			'show_option_none' => true,
			'options'          => all_rev_sliders_in_array(),
		) );	
		
		// Slider Position
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Select Revolution Slider Position', 'b-i-g' ),
		//	'desc'             => esc_html__( 'Choose yourRevSlider slider position here', 'b-i-g' ),
			'id'               => 'wi_meta_revslider_position',
			'type'             => 'select',
			'show_option_none' => false,
			'options'          => array(
				'1' => esc_html__( 'After a Header', 'b-i-g' ),
				'2' => esc_html__( 'Before a Header Top Bar', 'b-i-g' ),
				'3' => esc_html__( 'Before a Header Mid Bar', 'b-i-g' ),
				'4' => esc_html__( 'Before a Header Navigation Bar', 'b-i-g' ),
			),
		) );
		}
		// Content Top Gap
		$cmb_demo->add_field( array(
				'name'    => 'Set Top Content Margin (40px)',
				//'desc'  => 'field description (optional)',
				'default' => '40px',
				'id'      => 'wi_meta_top_content_margin',
				'type'    => 'text',
			)
		);	
		
		global $wp_registered_sidebars;
		$sidebar_array = array();
		$dp_sidebars = $wp_registered_sidebars;

		foreach ( $dp_sidebars as $sidebar ) {
			$sidebar_array[$sidebar['name']] = $sidebar['name'];
		}
	
		// Sidebar
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Choose your Sidebar', 'b-i-g' ),
			'desc'             => wp_kses(__( '<strong>Don&#39;t forget set page template as "With Sidebars"</strong>. You can create new sidebar area here: <a href="/wp-admin/themes.php?page=multiple_sidebars">Sidebars Manager</a>', 'b-i-g' ) , array( 'a' => array( 'href' => array(), 'title' => array() ), 'strong' => array(), ) ),
			'id'               => 'wi_meta_sidebar',
			'type'             => 'select',
			'show_option_none' => true,
			'options'          => $sidebar_array,
			'default'          => 'Blog Sidebar',
		) );

		// Sidebar Position
		$cmb_demo->add_field( array(
			'name'             => esc_html__( 'Choose Sidebar Position', 'b-i-g' ),
			'desc'             => wp_kses(__( '<strong>Don&#39;t forget set page template as "With Sidebars"</strong>', 'b-i-g' ), array( 'a' => array( 'href' => array(), 'title' => array() ), 'strong' => array(),  )),
			'id'               => 'wi_meta_sidebar_position',
			'type'             => 'select',
			'show_option_none' => false,
			'options'          => array (
				'1' => esc_html__( 'Right Sidebar', 'b-i-g' ),
				'2' => esc_html__( 'Left Sidebar', 'b-i-g' ),
				'3' => esc_html__( 'Without Sidebar', 'b-i-g' ),
			),
		) );	

}

// Meta Box for Gallery Posts

function post_gallery_settings_box( array $meta_box_config ) {
	return cmb2_get_metabox( $meta_box_config );
}
add_action( 'cmb2_admin_init', 'wwwebinvader_register_post_gallery_settings_metabox' );
function wwwebinvader_register_post_gallery_settings_metabox() {

	// Start with an underscore to hide fields from custom fields list

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demo = post_gallery_settings_box( array(
		'id'            => 'wi_post_gallery_meta_metabox',
		'title'         => esc_html__( 'Additional Description', 'b-i-g' ),
		'object_types'  => array( 'post', ), // Post type
		// 'show_on_cb' => 'wwwebinvader_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
	) );

		/* Start Options */	
		
		$cmb_demo->add_field( array(
			'name' => esc_html__( 'Load Images', 'b-i-g' ),		
			'before_row'   => '<b>You can upload additional images (Optional For Gallery). Best choice is up to 5 images</b>', // callback
			'desc' => esc_html__( 'Upload an image or enter a URL.', 'b-i-g' ),
			'id'   => 'wi_meta_gallery_image',
			'type' => 'file_list',
			'preview_size' => array( 150, 150 ),
		) );

}

	// Post Gallery Images Function

	function gallery_post_output_file_list( $file_list_meta_key, $img_size = 'medium' ) {
		// Get the list of files
		$images = get_post_meta( get_the_ID(), $file_list_meta_key, 1 );

		// Loop through them and output an image
		foreach ($images as $image) {
			echo '<li>';
			echo wp_get_attachment_image( $image, $img_size );
			echo '</li>';
		}	
	}
	

// Meta Box for Testimonials

function post_testimonials_settings_box( array $meta_box_config ) {
	return cmb2_get_metabox( $meta_box_config );
}
add_action( 'cmb2_admin_init', 'wwwebinvader_register_post_testimonials_settings_metabox' );
function wwwebinvader_register_post_testimonials_settings_metabox() {

	// Start with an underscore to hide fields from custom fields list

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demo = post_testimonials_settings_box( array(
		'id'            => 'wi_post_testimonials_meta_metabox',
		'title'         => esc_html__( 'Additional Testimonials Settings', 'b-i-g' ),
		'object_types'  => array( 'testimonials', ), // Post type
		// 'show_on_cb' => 'wwwebinvader_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
	) );

		/* Start Options */	
		
		$cmb_demo->add_field( array(
			'name' => esc_html__( 'Company Name', 'b-i-g' ),
			//'desc' => esc_html__( 'field description (optional)', 'b-i-g' ),
			'id'   => 'wi_meta_testimonials_text',
			'type' => 'text',
		) );

}

// Demo Admin Metabox

function demo_admin_settings_box( array $meta_box_config ) {
	return cmb2_get_metabox( $meta_box_config );
}
add_action( 'cmb2_admin_init', 'wwwebinvader_register_demo_admin_settings_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */
function wwwebinvader_register_demo_admin_settings_metabox() {

	// Start with an underscore to hide fields from custom fields list

	/**
	 * Sample metabox to demonstrate each field type included
	 */
	$cmb_demo = demo_admin_settings_box( array(
		'id'            => 'wi_demo_admin_meta_metabox',
		'title'         => esc_html__( 'Demo Preset Settings', 'b-i-g' ),
		'object_types'  => array( 'page', ), // Post type
		// 'show_on_cb' => 'wwwebinvader_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		//'closed'     => true, // true to keep the metabox closed by default
	) );
	
	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Header Preset', 'b-i-g' ),
		'desc'             => esc_html__( 'You can change Header on this Page', 'b-i-g' ),
		'id'               => 'wi_meta_header_preset',
		'type'             => 'select',
		'show_option_none' => true,
		'options'          => array(
			'1' => esc_html__( 'Header Preset 01', 'b-i-g' ),
			'2' => esc_html__( 'Header Preset 02', 'b-i-g' ),
			'3' => esc_html__( 'Header Preset 03', 'b-i-g' ),
			'4' => esc_html__( 'Header Preset 04', 'b-i-g' ),
			'5' => esc_html__( 'Header Preset 05', 'b-i-g' ),
			'6' => esc_html__( 'Header Preset 06', 'b-i-g' ),
			'7' => esc_html__( 'Header Preset 07', 'b-i-g' ),
		),
	) );	
	
	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Color Preset', 'b-i-g' ),
		'desc'             => esc_html__( 'You can change Color on this Page', 'b-i-g' ),
		'id'               => 'wi_meta_color_preset',
		'type'             => 'select',
		'show_option_none' => true,
		'options'          => array(
			'1' => esc_html__( 'Color Preset 01', 'b-i-g' ),
			'2' => esc_html__( 'Color Preset 02', 'b-i-g' ),
			'3' => esc_html__( 'Color Preset 03', 'b-i-g' ),
			'4' => esc_html__( 'Color Preset 04', 'b-i-g' ),
			'5' => esc_html__( 'Color Preset 05', 'b-i-g' ),
			'6' => esc_html__( 'Color Preset 06', 'b-i-g' ),
			'7' => esc_html__( 'Color Preset 07', 'b-i-g' ),
		),
	) );
	
	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Footer Preset', 'b-i-g' ),
		'desc'             => esc_html__( 'You can change Footer on this Page', 'b-i-g' ),
		'id'               => 'wi_meta_footer_preset',
		'type'             => 'select',
		'show_option_none' => true,
		'options'          => array(
			'1' => esc_html__( 'Footer Preset 01', 'b-i-g' ),
			'2' => esc_html__( 'Footer Preset 02', 'b-i-g' ),
			'3' => esc_html__( 'Footer Preset 03', 'b-i-g' ),
			'4' => esc_html__( 'Footer Preset 04', 'b-i-g' ),
			'5' => esc_html__( 'Footer Preset 05', 'b-i-g' ),
			'6' => esc_html__( 'Footer Preset 06', 'b-i-g' ),
			'7' => esc_html__( 'Footer Preset 07', 'b-i-g' ),
		),
	) );
	
	/*
	$cmb_demo->add_field( array(
		'name'    => esc_html__( 'Test Color Picker', 'b-i-g' ),
		'desc'    => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'      => 'wi_meta_colorpicker',
		'type'    => 'colorpicker',
		'default' => '#ffffff',
	) );


	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Test Select', 'b-i-g' ),
		'desc'             => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'               => 'wi_meta_select',
		'type'             => 'select',
		'show_option_none' => true,
		'options'          => array(
			'standard' => esc_html__( 'Option One', 'b-i-g' ),
			'custom'   => esc_html__( 'Option Two', 'b-i-g' ),
			'none'     => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );

	$cmb_demo->add_field( array(
		'name'             => esc_html__( 'Test Radio inline', 'b-i-g' ),
		'desc'             => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'               => 'wi_meta_radio_inline',
		'type'             => 'radio_inline',
		'show_option_none' => 'No Selection',
		'options'          => array(
			'standard' => esc_html__( 'Option One', 'b-i-g' ),
			'custom'   => esc_html__( 'Option Two', 'b-i-g' ),
			'none'     => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );

	$cmb_demo->add_field( array(
		'name'    => esc_html__( 'Test Radio', 'b-i-g' ),
		'desc'    => esc_html__( 'field description (optional)', 'b-i-g' ),
		'id'      => 'wi_meta_radio',
		'type'    => 'radio',
		'options' => array(
			'option1' => esc_html__( 'Option One', 'b-i-g' ),
			'option2' => esc_html__( 'Option Two', 'b-i-g' ),
			'option3' => esc_html__( 'Option Three', 'b-i-g' ),
		),
	) );*/

}