<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<?php $wi_options = get_option('wi_options'); ?>
	<?php b_i_g_favicon_wp_head(); ?>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> >
<!--PRELOADER -->
<?php if ($wi_options['wi_preloader'] == true) { ?>  
    <div class="preloader-holder" >
        <div class="preloader dont-move-me">
            <img alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" src="<?php echo esc_url($wi_options['wi_logo_upload']['url']); ?>">
        </div>
    </div>
<?php } ?>
<!--/PRELOADER -->
<?php do_action( '__before_header_topbar' ); ?>
<!--SEARCHBAR HEADER -->
<div class="wi_searchbar">
    <div class="container">
    <div class="row">
		<div class="col-md-12">
			<?php b_i_g_header_search_form_output(); ?>
		</div>
	</div>
	</div>
</div>
<!--/SEARCH HEADER -->
<!--TOP HEADER -->
<?php if ($wi_options['wi_topbar'] == 1) : ?>
<div class="wi_topbar">
    <div class="container">
    <div class="row">
		<div class="col-md-12 wi_tb_st">
			<div class="float-left">
				<?php if($wi_options['wi_topbar_cart']    == 2) { echo wi_head_cart('top_cart'); } ?>
				<?php if($wi_options['wi_topbar_search']  == 2) { ?><div class="top_search"><i class="fa fa-search"></i></div><?php } ?>
				<?php if($wi_options['wi_topbar_social']  == 2) { echo wi_social_icon('top_social'); } ?>			
				<?php if($wi_options['wi_topbar_phone']   == 2) { ?><div class="top_phone"><?php echo esc_attr($wi_options['wi_topbar_phone_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_email']   == 2) { ?><div class="top_email"><?php echo esc_attr($wi_options['wi_topbar_email_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_whours']  == 2) { ?><div class="top_whours"><?php echo esc_attr($wi_options['wi_topbar_whours_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_textmenu_position'] == 2) { ?><div class="top_textmenu"><?php if ($wi_options['wi_topbar_textmenu'] == 1) { echo esc_attr($wi_options['wi_topbar_textmenu_field']); } elseif ( $wi_options['wi_topbar_textmenu'] == 2) { wp_nav_menu( array( 'menu' => 'Top Bar Menu' ) ); } ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_profile']== 2) { echo wi_topbar_profile_links(); } ?>
			</div><!--/ .float-left -->
			<div class="float-right">
				<?php if($wi_options['wi_topbar_phone']   == 3) { ?><div class="top_phone"><?php echo esc_attr($wi_options['wi_topbar_phone_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_email']   == 3) { ?><div class="top_email"><?php echo esc_attr($wi_options['wi_topbar_email_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_whours']  == 3) { ?><div class="top_whours"><?php echo esc_attr($wi_options['wi_topbar_whours_field']); ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_textmenu_position'] == 3) { ?><div class="top_textmenu"><?php if ($wi_options['wi_topbar_textmenu'] == 1) { echo esc_attr($wi_options['wi_topbar_textmenu_field']); } elseif ( $wi_options['wi_topbar_textmenu'] == 2) { wp_nav_menu( array( 'menu' => 'Top Bar Menu' ) ); } ?></div><?php } ?>
				<?php if($wi_options['wi_topbar_profile']== 3) { echo wi_topbar_profile_links(); } ?>
				<?php if($wi_options['wi_topbar_social']  == 3) { echo wi_social_icon('top_social'); } ?>			
				<?php if($wi_options['wi_topbar_search']  == 3) { ?><div class="top_search"><i class="fa fa-search"></i></div><?php } ?>
				<?php if($wi_options['wi_topbar_cart']    == 3) { echo wi_head_cart('top_cart'); } ?>
			</div><!--/ .float-right -->
        </div>
	</div>
    </div>
</div><!--/ .wi_topbar -->
<?php endif; ?>
<!--/TOP HEADER -->
<?php do_action( '__before_header_midbar' ); ?>
<!--MIDBAR HEADER -->
<?php if ($wi_options['wi_midbar'] == 1) { ?>
<?php if ($wi_options['wi_midbar_custom_code'] == 1) { ?>
<?php if ($wi_options['wi_midbar_logo'] != 1 || $wi_options['wi_midbar_social'] != 1 || $wi_options['wi_midbar_search'] != 1 || $wi_options['wi_midbar_cart'] != 1) { ?>
<div class="wi_midbar">
	<div class="container">
    <div class="row">
	<div class="mid-elements-table">
			<div class="col-md-4 col-sm-12 col-xs-12 mid-elements-left">
					<?php if ($wi_options['wi_midbar_logo']   == 2) { echo wi_head_logo('midbar'); } ?>
					<?php if ($wi_options['wi_midbar_social'] == 2 || $wi_options['wi_midbar_search'] == 2 || $wi_options['wi_midbar_cart'] == 2) { ?>
					<div class="mid-elements-area">
						<?php if ($wi_options['wi_midbar_social'] == 2) { echo wi_social_icon('mid_social'); } ?>
						<?php if ($wi_options['wi_midbar_search'] == 2) { ?><div class="mid_search"><i class="fa fa-search"></i></div><?php } ?>
						<?php if ($wi_options['wi_midbar_cart']   == 2) { echo wi_head_cart('mid_cart'); } ?>
					</div>
					<?php } ?>
			</div>
		
			<div class="col-md-4 col-sm-12 col-xs-12 mid-elements-center">
					<?php if ($wi_options['wi_midbar_logo']   == 3) { echo wi_head_logo('midbar'); } ?>
					<?php if ($wi_options['wi_midbar_social'] == 3 || $wi_options['wi_midbar_search'] == 3 || $wi_options['wi_midbar_cart'] == 3) { ?>
					<div class="mid-elements-area">
					<?php if ($wi_options['wi_midbar_social'] == 3) { echo wi_social_icon('mid_social'); } ?>
						<?php if ($wi_options['wi_midbar_search'] == 3) { ?><div class="mid_search"><i class="fa fa-search"></i></div><?php } ?>
						<?php if ($wi_options['wi_midbar_cart']   == 3) { echo wi_head_cart('mid_cart'); } ?>
					</div>
					<?php } ?>
			</div>
			
			<div class="col-md-4 col-sm-12 col-xs-12 mid-elements-right">
					<?php if ($wi_options['wi_midbar_logo']   == 4) { echo wi_head_logo('midbar');  } ?>
					<?php if ($wi_options['wi_midbar_social'] == 4 || $wi_options['wi_midbar_search'] == 4 || $wi_options['wi_midbar_cart'] == 4) { ?>
					<div class="mid-elements-area">
						<?php if ($wi_options['wi_midbar_social'] == 4) { echo wi_social_icon('mid_social'); } ?>
						<?php if ($wi_options['wi_midbar_search'] == 4) { ?><div class="mid_search"><i class="fa fa-search"></i></div><?php } ?>
						<?php if ($wi_options['wi_midbar_cart']   == 4) { echo wi_head_cart('mid_cart'); } ?>
					</div>
					<?php } ?>
			</div>	
	</div>
	</div>
	</div>
</div><!--/ .wi_midbar -->
<?php } /* is all options disabled */ ?>
<?php } elseif ($wi_options['wi_midbar_custom_code'] == 2) { ?>
<div class="wi_midbar midbar-cutom-code">
	<div class="container">
    <div class="row">
		<?php echo balanceTags($wi_options['wi_midbar_custom_code_field']); ?>
	</div>
	</div>
</div>
<?php } ?>
<?php } ?>
<!--/MIDBAR HEADER -->
<?php do_action( '__before_header_navbar' ); ?>
<!--NAVBAR HEADER -->
<?php if ($wi_options['wi_navbar'] == 1 || !is_plugin_active( 'redux-framework/redux-framework.php' )) : ?>
<div class="wi_navbar">
	<?php $header_nav_type = $wi_options['wi_header_nav_type']; ?>
	<?php if( function_exists( 'lmmmenu' ) ) {
			lmmmenu(array('theme_location' => 'header_nav_'.$header_nav_type.'', 'menu' => 'Header Nav '.$header_nav_type.'' ));
		} else { ?>
		<div class="navbar_menu" >
		<div class="container" >
		<div class="row">
		<div class="col-md-12">
		<nav id="navigation">
			<?php if (is_plugin_active( 'redux-framework/redux-framework.php' )) { echo wi_head_logo('defaultlogo'); } else { echo '<span class="defaultlogotext">' . esc_attr( get_bloginfo('name') ) . '</span>'; } ?>
			<?php if (has_nav_menu( 'navbar_menu' )) {
			wp_nav_menu( array( 'theme_location' => 'navbar_menu', 'menu' => 'Nav Bar Menu', 'fallback_cb' => false ) ); } else { 
				echo '<div class="menu-all-pages-container"><ul><li><a>' . esc_attr__('Add a menu to Nav Bar Menu','b-i-g') . '</a></li></ul></div>';
			} ?>
		</nav>
		</div>
		</div>
		</div>
		</div>
	<?php }?>
</div><!--/ .wi_navbar -->
<?php endif; ?>
<!--/NAVBAR HEADER -->
<?php do_action( '__after_header' ); ?>
<!--/HEADER -->
<!--CONTENT -->
<?php echo b_i_g_content_start(); ?>