<?php
/* Latest Posts Widget
------------------------------------------*/

add_action( 'widgets_init', 'b_i_g_latest_news_load_widget' );

function b_i_g_latest_news_load_widget() {
	register_widget( 'b_i_g_latest_news_widget' );
}

class b_i_g_latest_news_widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function b_i_g_latest_news_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'b_i_g_latest_news_widget', 'description' => esc_html__('A widget that displays your latest posts from all categories or a certain', 'b-i-g') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'b_i_g_latest_news_widget' );

		/* Create the widget. */
		parent::__construct( 'b_i_g_latest_news_widget', esc_html__('WI: Latest Posts', 'b-i-g'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$categories = $instance['categories'];
		$number = $instance['number'];

		
		$query = array('showposts' => $number, 'nopaging' => 0, 'post_status' => 'publish', 'ignore_sticky_posts' => 1, 'cat' => $categories);
		
		$loop = new WP_Query($query);
		if ($loop->have_posts()) :
		
		/* Before widget (defined by themes). */
		echo balanceTags($before_widget);

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo balanceTags($before_title . $title . $after_title);

		?>
			<ul class="side-newsfeed">
			
			<?php  while ($loop->have_posts()) : $loop->the_post(); ?>
			
				<li>
				
					<div class="side-item">
											
						<?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) : ?>
						<div class="side-image">
							<a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_post_thumbnail('b_i_g_related-posts-thumbnail', array('class' => 'side-item-thumb')); ?></a>
						</div>
						<?php endif; ?>
						<div class="side-item-text">
							<span class="side-item-meta"><?php the_time( get_option('date_format') ); ?></span>
							<h4><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h4>
						</div>
					</div>
				
				</li>
			
			<?php endwhile; ?>
			<?php wp_reset_postdata(); ?>
			<?php endif; ?>
			
			</ul>
			
		<?php

		/* After widget (defined by themes). */
		echo balanceTags($after_widget);
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['categories'] = $new_instance['categories'];
		$instance['number'] = strip_tags( $new_instance['number'] );

		return $instance;
	}


	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => esc_html__('Latest Posts','b-i-g'), 'number' => 5, 'categories' => '');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo balanceTags($this->get_field_id( 'title' )); ?>"><?php esc_html_e('Title:','b-i-g'); ?></label>
			<input  type="text" class="widefat" id="<?php echo balanceTags($this->get_field_id( 'title' )); ?>" name="<?php echo balanceTags($this->get_field_name( 'title' )); ?>" value="<?php echo balanceTags($instance['title']); ?>"  />
		</p>
		
		<!-- Category -->
		<p>
		<label for="<?php echo balanceTags($this->get_field_id('categories')); ?>">Filter by Category:</label> 
		<select id="<?php echo balanceTags($this->get_field_id('categories')); ?>" name="<?php echo balanceTags($this->get_field_name('categories')); ?>" class="widefat categories widefat_styleinlined">
			<option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>>All categories</option>
			<?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
			<?php foreach($categories as $category) { ?>
			<option value='<?php echo balanceTags($category->term_id); ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo balanceTags($category->cat_name); ?></option>
			<?php } ?>
		</select>
		</p>
		
		<!-- Number of posts -->
		<p>
			<label for="<?php echo balanceTags($this->get_field_id( 'number' )); ?>"><?php esc_html_e('Number of posts to show:','b-i-g'); ?></label>
			<input  type="text" class="widefat" id="<?php echo balanceTags($this->get_field_id( 'number' )); ?>" name="<?php echo balanceTags($this->get_field_name( 'number' )); ?>" value="<?php echo balanceTags($instance['number']); ?>" size="3" />
		</p>


	<?php
	}
}

?>