<?php

function lmm_taburl($id = 0) {
    return admin_url('admin.php?page=' . LMM_PANEL . '&tab=' . $id);
}

// redux notices ---------------------------------------------------------------
add_action('redux/options/' . LMM . '/settings/change', 'lmm_redux_notices', 10, 2);

function lmm_add_redux_notice($class = 'updated', $notice = false) {

    if (!$notice)
        return;

    $notices = get_option('lmm_redux_notices', array());

    $notices[] = array(
        'class' => $class,
        'notice' => $notice
    );

    update_option('lmm_redux_notices', $notices);
}

function lmm_redux_notices() {
    if ($notices = get_option('lmm_redux_notices', false)) {
        foreach ($notices as $notice) {

            if (empty($notice['class']) || empty($notice['notice']))
                continue;

            echo '<div class="saved_notice admin-notice notice-' . $notice['class'] . '">' . $notice['notice'] . '</div>';
        }
        delete_option('lmm_redux_notices');
    }
}

// wordpress notices -----------------------------------------------------------
add_action('admin_notices', 'lmm_admin_notices');

function lmm_add_admin_notice($class = 'updated', $notice = false) {

    if (!$notice)
        return;

    //$screen = get_current_screen();

    $notices = get_option('lmm_admin_notices', array());

    $notices[] = array(
        'class' => $class,
        'notice' => $notice,
            //'screen' => $screen->base
    );

    update_option('lmm_admin_notices', $notices);
}

function lmm_admin_notices() {

    //$screen = get_current_screen();

    if ($notices = get_option('lmm_admin_notices', false)) {
        foreach ($notices as $notice) {

            if (empty($notice['class']) || empty($notice['notice']))
                continue;

            echo '<div class="' . $notice['class'] . '"><p>' . $notice['notice'] . '</p></div>';
        }
        delete_option('lmm_admin_notices');
    }
}
