<?php
//admin metabox ----------------------------------------------------------------

add_action('admin_init', 'lmm_add_custom_menu_items_meta_box');

function lmm_add_custom_menu_items_meta_box() {
    add_meta_box('lmm_custom_nav_items', __('LMM Items', 'lmm'), 'lmm_custom_menu_items_meta_box', 'nav-menus', 'side', 'high');
}

function lmm_custom_menu_items_meta_box() {

    global $_nav_menu_placeholder, $nav_menu_selected_id, $lmm_elements;
    ?>
    <div id="lmm-custom-menu-metabox" class="posttypediv">
        <div id="tabs-panel-lmm-custom" class="tabs-panel tabs-panel-active">
            <ul id ="lmm-custom-checklist" class="categorychecklist form-no-clear">

                <?php
                foreach ($lmm_elements as $type => $item):

                    if (!$item['lmm'] || $item['depth'] != 0)
                        continue;

                    $_nav_menu_placeholder = ( 0 > $_nav_menu_placeholder ) ? intval($_nav_menu_placeholder) - 1 : -1;

                    $url = isset($item['url']) ? $item['url'] : '#lmm-' . $type;
                    $title = isset($item['title']) ? $item['title'] : '';
                    $label = isset($item['label']) ? $item['label'] : '';
                    $desc = isset($item['desc']) ? $item['desc'] : '';
                    $columns = isset($item['columns']) ? $item['columns'] : '';
                    ?>

                    <li>
                        <label class="menu-item-title um-tooltip-wrap">
                            <input type="checkbox" class="menu-item-checkbox" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-label]" value="0"> <?php echo $label; ?>
                            <small><?php echo $desc; ?></small>
                        </label>
                        <input type="hidden" class="menu-item-type" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-type]" value="custom">
                        <input type="hidden" class="menu-item-title" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-title]" value="<?php echo $title; ?>">     
                        <input type="hidden" class="menu-item-url" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-url]" value="<?php echo $url; ?>">
                        <input type="hidden" class="menu-item-lmm" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-lmm]" value="<?php echo $type; ?>">
                        <input type="hidden" class="menu-item-mega-columns" name="menu-item[<?php echo $_nav_menu_placeholder ?>][menu-item-mega-columns]" value="<?php echo $columns; ?>">                                                        

                    </li>

                <?php endforeach; ?>
                <?php //wp_nonce_field('add-lmm-custom-menu-item', 'lmm-settings-column-nonce');    ?>
            </ul>
        </div>
        <p class="button-controls">
            <span class="add-to-menu">
                <input type="submit" class="button-primary right" value="<?php _e('Add to Menu'); ?>" name="add-lmm-custom-menu-item" id="submit-lmm-custom-menu-metabox">
                <span class="spinner"></span>
            </span>
        </p>
    </div>
    <?php
}
