<?php

//find thumbnail ---------------------------------------------------------------

add_action('wp_ajax_find_media_thumbnail', 'lmm_find_media_thumbnail');

function lmm_find_media_thumbnail() {
    $thumbnail_id = $_POST['thumbnail_id'];
    $img_arr = wp_get_attachment_image_src($thumbnail_id, array(32, 32), true);
    echo $img_arr[0];
    die();
}

//admin ajax -------------------------------------------------------------------

add_action('wp_ajax_add-lmm-custom-menu-item', 'lmm_ajax_add_menu_item');

function lmm_ajax_add_menu_item() {

    global $lmm_elements;

    check_ajax_referer('add-lmm-custom-menu-item', 'lmm-settings-column-nonce');

    if (!current_user_can('edit_theme_options'))
        wp_die(-1);

    require_once ABSPATH . 'wp-admin/includes/nav-menu.php';

    // For performance reasons, we omit some object properties from the checklist.
    // The following is a hacky way to restore them when adding non-custom items.

    $menu_items_data = array();

    foreach ((array) $_POST['menu-item'] as $menu_item_data) {

        if (empty($lmm_elements[$menu_item_data['menu-item-lmm']]['lmm'])) {
            return;
        }

        $menu_items_data[] = $menu_item_data;
    }

    $item_ids = lmm_ajax_create_nav_menu_items(0, $menu_items_data);

    if (is_wp_error($item_ids))
        wp_die(0);

    $menu_items = array();

    foreach ((array) $item_ids as $menu_item_id) {
        $menu_obj = get_post($menu_item_id);
        if (!empty($menu_obj->ID)) {
            $menu_obj = wp_setup_nav_menu_item($menu_obj);
            $menu_obj->label = $menu_obj->title; // don't show "(pending)" in ajax-added items
            $menu_items[] = $menu_obj;
        }
    }

    /** This filter is documented in wp-admin/includes/nav-menu.php */
    $walker_class_name = apply_filters('wp_edit_nav_menu_walker', 'Walker_Nav_Menu_Edit', $_POST['menu']);

    if (!class_exists($walker_class_name))
        wp_die(0);

    if (!empty($menu_items)) {
        $args = array(
            'after' => '',
            'before' => '',
            'link_after' => '',
            'link_before' => '',
            'walker' => new $walker_class_name,
        );
        echo walk_nav_menu_tree($menu_items, 0, (object) $args);
    }
    wp_die();
}

function lmm_ajax_create_nav_menu_items($menu_id = 0, $menu_data = array()) {

    $menu_id = (int) $menu_id;

    $items_saved = lmm_ajax_save_nav_menu_items($menu_id, $menu_data);

    return $items_saved;
}

function lmm_ajax_save_nav_menu_items($menu_id = 0, $menu_data = array(), $items_saved = array()) {

    if (0 == $menu_id || is_nav_menu($menu_id)) {

        // Loop through all the menu items' POST values.
        foreach ((array) $menu_data as $_possible_db_id => $_item_object_data) {

            // If this possible menu item doesn't actually have a menu database ID yet.
            if (
                    empty($_item_object_data['menu-item-db-id']) ||
                    ( 0 > $_possible_db_id ) ||
                    $_possible_db_id != $_item_object_data['menu-item-db-id']
            ) {
                $_actual_db_id = 0;
            } else {
                $_actual_db_id = (int) $_item_object_data['menu-item-db-id'];
            }

            $args = array(
                'menu-item-db-id' => ( isset($_item_object_data['menu-item-db-id']) ? $_item_object_data['menu-item-db-id'] : '' ),
                'menu-item-object-id' => ( isset($_item_object_data['menu-item-object-id']) ? $_item_object_data['menu-item-object-id'] : '' ),
                'menu-item-object' => ( isset($_item_object_data['menu-item-object']) ? $_item_object_data['menu-item-object'] : '' ),
                'menu-item-type' => ( isset($_item_object_data['menu-item-type']) ? $_item_object_data['menu-item-type'] : '' ),
                'menu-item-title' => ( isset($_item_object_data['menu-item-title']) ? $_item_object_data['menu-item-title'] : '' ),
                'menu-item-url' => ( isset($_item_object_data['menu-item-url']) ? $_item_object_data['menu-item-url'] : '' ),
                'menu-item-lmm' => ( isset($_item_object_data['menu-item-lmm']) ? $_item_object_data['menu-item-lmm'] : '' ),
                'menu-item-parent-id' => ( isset($_item_object_data['menu-item-parent-id']) ? $_item_object_data['menu-item-parent-id'] : '' ),
                'menu-item-mega-columns' => ( isset($_item_object_data['menu-item-mega-columns']) ? $_item_object_data['menu-item-mega-columns'] : '' ),
                'menu-item-mega-sub-columns' => ( isset($_item_object_data['menu-item-mega-sub-columns']) ? $_item_object_data['menu-item-mega-sub-columns'] : '' ),
            );

            $items_saved[] = wp_update_nav_menu_item($menu_id, $_actual_db_id, $args);
        }
    }

    return $items_saved;
}