<?php

function lmm_getbutton($location = false, $toggle = 'collapse', $target = '.lmm-navbar-collapse', $classes = '') {

    global $lmm;

    if (!$location)
        return;

    $classes .= ' lmm-' . $location;

    $classes .= $lmm[$location . '_navbar_mode'] == 'vertical' ? ' pull-' . $lmm[$location . '_navbar_mode_vertical_float'] : '';

    $canvas = $toggle == 'offcanvas' ? 'data-canvas="body"' : 'aria-expanded="false" aria-controls="lmm-navbar"';

    $output = '<button type="button" class="lmm-navbar-toggle ' . $classes . '" data-toggle="' . $toggle . '" data-target="' . $target . '" ' . $canvas . '>';
    $output .= '<span class="icon-bar"></span>';
    $output .= '<span class="icon-bar"></span>';
    $output .= '<span class="icon-bar"></span>';
    $output .= '</button>';

    return $output;
}

function lmm_getlogo($location = false, $classes = 'lmm-navbar-brand') {

    global $lmm;

    if (!$location || empty($lmm[$location . '_navbar_logo']['url']))
        return;

    $classes .= $classes == 'lmm-navbar-brand' && $lmm[$location . '_navbar_mode'] == 'vertical' && $lmm[$location . '_navbar_mode_vertical_float'] == 'left' ? ' pull-right' : '';

    $classes .=!empty($lmm[$location . '_navbar_sticky_logo']) && !empty($lmm[$location . '_navbar_sticky']) ? ' show-on-sticky' : '';

    $output = '<a class="' . $classes . ' img" href="' . esc_url(home_url('/')) . '">';
    $output .= sprintf('<img height="60" width="160" src="%1$s" alt="%2$s"/>', esc_url($lmm[$location . '_navbar_logo']['url']), esc_attr(get_bloginfo('name')));
    $output .= '</a>';

    return $output;
}

function lmm_getdata($location, $args = array()) {

    global $lmm;

    $args['classes'] = 'lmm-' . $location . ' lmm-v' . LMM_VERSION;

    $args['vertical'] = 'lmm-' . $location . ' navmenu-fixed-' . $lmm[$location . '_navbar_mode_vertical_float'];

    $args['offcanvas'] = !empty($lmm[$location . '_navbar_mode_vertical_collapsed']) ? join(' ', array_map('sanitize_html_class', array_keys($lmm[$location . '_navbar_mode_vertical_collapsed'], 1))) : '';

    $args['visible'] = str_replace('offcanvas-', 'visible-', $args['offcanvas']);

    $args['data'] = 'data-location="' . $location . '"';

    if (empty($lmm[$location . '_navbar_sticky']))
        return $args;

    $args['classes'] .= $lmm[$location . '_navbar_sticky_offset'] == 0 ? ' lmm-navbar-fixed-top' : '';

    if ($lmm[$location . '_navbar_sticky_offset'] == 0)
        return $args;

    $args['data'] .= ' data-sticky="' . $lmm[$location . '_navbar_sticky'] . '" data-stickyoffset="' . $lmm[$location . '_navbar_sticky_offset'] . '"';

    return $args;
}

function lmm_horizontal_button($location, $menu = 0) {

    global $lmm;

    $id = 'lmm_' . $menu;

    $data = lmm_getdata($location);

    $output = '<nav id="%1$s" class="lmm lmm-navbar ' . $data['classes'] . '" ' . $data['data'] . ' itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement" role="navigation">';
    $output .= '<div class="' . $lmm[$location . '_navbar_width'] . '">';
    $output .= '<div class="lmm-navbar-header">';
    $output .= lmm_getbutton($location, 'collapse', '#' . $id, 'collapsed');
    $output .= lmm_getlogo($location);
    $output .= '</div>';
    $output .= '<div id="' . $id . '" class="lmm-navbar-collapse collapse">';
    $output .= '<ul class="lmm-navbar-nav %2$s">%3$s</ul>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</nav>';

    return $output;
}

function lmm_horizontal_collapsed($location, $menu = 0) {

    global $lmm;

    $data = lmm_getdata($location);

    $output = '<nav id="%1$s" class="lmm lmm-navbar ' . $data['classes'] . '" ' . $data['data'] . '" itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement" role="navigation">';
    $output .= '<div class="' . $lmm[$location . '_navbar_width'] . '">';
    $output .= '<div class="lmm-navbar-header hidden-xs">';
    $output .= lmm_getlogo($location);
    $output .= '</div>';
    $output .= '<div id="lmm-navbar" class="lmm-navbar-collapse collapse in">';
    $output .= '<ul class="lmm-navbar-nav %2$s">%3$s</ul>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</nav>';

    return $output;
}

function lmm_horizontal_offcanvas($location, $menu = 0) {

    global $lmm;

    $data = lmm_getdata($location);

    //enqueue not needed for mobile devices
    //if ($lmm['lmm_styles_pscrollbar']) {
    //wp_enqueue_style('lmm_pscrollbar');
    //}
    wp_enqueue_script('lmm-jasny');

    $id = 'lmm_' . $menu;

    $output = '<nav id="%1$s" class="lmm lmm-navbar ' . $data['classes'] . '" ' . $data['data'] . ' itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement" role="navigation">';
    $output .= '<div class="' . $lmm[$location . '_navbar_width'] . '">';
    $output .= '<div class="lmm-navbar-header">';
    $output .= lmm_getbutton($location, 'offcanvas', '#' . $id);
    $output .= lmm_getlogo($location);
    $output .= '</div>';
    $output .= '<div id="' . $id . '" class="navbar-offcanvas offcanvas navmenu-fixed-right">';
    $output .= lmm_getlogo($location, 'navmenu-brand');
    $output .= '<ul class="lmm-navbar-nav %2$s">%3$s</ul>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</nav>';

    return $output;
}

function lmm_vertical_button($location, $menu = 0) {

    global $lmm;

    $data = lmm_getdata($location);

    wp_enqueue_script('lmm-jasny');

    $output = '<div id="%1$s" class="lmm navmenu ' . $data['vertical'] . ' offcanvas" role="navigation">';
    $output .= lmm_getlogo($location, 'navmenu-brand');
    $output .= '<ul class="navmenu-nav %2$s">%3$s</ul>';
    $output .= '</div>';
    $output .= '<nav id="%1$s" class="lmm lmm-navbar ' . $data['classes'] . '" ' . $data['data'] . ' itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement" role="navigation">';
    //$output .= '<div class="container-fluid">';
    $output .= lmm_getbutton($location, 'offcanvas', '.navmenu', 'show');
    //$output .= '</div>';
    $output .= '</nav>';

    return $output;
}

function lmm_vertical_collapsed($location, $menu = 0) {

    global $lmm;

    $data = lmm_getdata($location);

    wp_enqueue_script('lmm-jasny');

    $output = '<div id="%1$s" class="lmm navmenu ' . $data['vertical'] . ' ' . $data['offcanvas'] . '" role="navigation">';
    $output .= lmm_getlogo($location, 'navmenu-brand');
    $output .= '<ul class="navmenu-nav %2$s">%3$s</ul>';
    $output .= '</div>';
    $output .= '<nav id="%1$s" class="lmm lmm-navbar ' . $data['classes'] . ' ' . $data['visible'] . '" ' . $data['data'] . ' itemscope="itemscope" itemtype="http://schema.org/SiteNavigationElement" role="navigation">';
    $output .= '<div class="container-fluid">';
    $output .= '<div class="lmm-navbar-header">';
    $output .= lmm_getbutton($location, 'offcanvas', '.navmenu', 'show');
    $output .= lmm_getlogo($location);
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</nav>';

    return $output;
}

function lmm_vertical_inherit($location, $menu = 0) {

    global $lmm;

    //enqueue
    //if ($lmm['lmm_styles_pscrollbar']) {
    //    wp_enqueue_script('lmm_pscrollbar');
    //    wp_enqueue_style('lmm_pscrollbar');
    //}
    $output = '<div id="%1$s" class="lmm navmenu ' . $location . ' inherit" role="navigation" data-location="' . $location . '">';
    $output .= lmm_getlogo($location, 'navmenu-brand');
    $output .='<ul class="navmenu-nav %2$s">%3$s</ul>';
    $output .='</div>';

    return $output;
}

function lmm_layout_alert($args) {

    global $_wp_registered_nav_menus, $lmm_locations;

    $_location = array_keys($_wp_registered_nav_menus);

    $_location_no = !empty($args['location']);

    $_location_exist = !empty($_wp_registered_nav_menus[$args['location']]);

    $_location_active = !empty($lmm_locations[$args['location']]['active']);

    $output = '<div id="lmm" class="lmm-alert">';

    $output .= '<p class="title"><b>' . __('Something went wrong...', 'lmm') . '</b></p>';

    if (!isset($_location[0])) {
        $output .= '<p>' . __('This theme has no theme locations.', 'lmm') . '</p>';
    }

    if (!$_location_no) {
        $output .= '<p>' . __('Please include a theme location in your php functions. For example:', 'lmm') . '</p>';
        $output .= '<p>' . sprintf(__('<code>&lt;?php lmmmenu(array(theme_location => &quot;%1$s&quot;)); ?&gt;</code>', 'lmm'), $_location[0]) . '</p>';
    } elseif (!$_location_exist) {
        $output .= '<p>' . sprintf(__('This theme location (%1$s) doesn\'t exist. Please include a valid theme location id. For example:', 'lmm'), $args['location']) . '</p>';
        $output .=!'<p>' . sprintf(__('<code>&lt;?php lmmmenu(array(&quot;theme_location&quot; => &quot;%1$s&quot;)); ?&gt;</code>', 'lmm'), $_location[0]) . '</p>';
    } elseif (!$_location_active) {
        $output .= '<p>' . sprintf(__('This theme location is not active. Please go to <a href="%1$s" target="_blank">LMM Config</a> and activate this theme location <b>%2$s</b>', 'lmm'), lmm_taburl('0'), $_wp_registered_nav_menus[$args['location']]) . '</p>';
    } else {
        $output .= '<p>' . __('We don\'t know what\'s going on. :S', 'lmm') . '</p>';
    }

    $output .='</div>';

    if ($args['echo']) {
        echo $output;
        return;
    }

    return $output;
}
