<?php

//subcount items ---------------------------------------------------------------

add_filter('wp_nav_menu_objects', 'lmm_modify_nav_items');

function lmm_has_sub($menu_item_id, &$items) {
    $sub_count = 0;
    foreach ($items as $item) {
        if ($item->menu_item_parent && $item->menu_item_parent == $menu_item_id) {
            $sub_count++;
        }
    }
    return $sub_count;
}

function lmm_modify_nav_items($items) {
    foreach ($items as $item) {
        if ($sub_count = lmm_has_sub($item->ID, $items)) {
            $item->sub_count = $sub_count;
        }
    }
    return $items;
}

//update postmeta --------------------------------------------------------------

add_action('wp_update_nav_menu_item', 'lmm_custom_nav_update', 999, 3);

function lmm_custom_nav_update($menu_id, $menu_item_db_id, $args) {

    $defaults = array(
        'menu-item-lmm' => '',
        'menu-item-icon' => '',
        'menu-item-subtitle' => '',
        'menu-item-float' => '',
        'menu-item-options' => '',
        'menu-item-dropdown' => '',
        'menu-item-hidden' => '',
        'menu-item-mega-columns' => '',
        'menu-item-mega-background-thumbnail-id' => '',
        'menu-item-mega-background-position' => '',
        'menu-item-mega-background-repeat' => '',
        'menu-item-mega-background-attachment' => '',
        'menu-item-mega-background-size' => '',
        'menu-item-mega-sub-columns' => '',
        'menu-item-mega-sidebar' => '',
        'menu-item-thumb' => '',
    );

    // importer
    $options = wp_parse_args($args, $defaults);

    foreach ($options as $key => $value) {

        //do not duplicate with wordpress
        if (!isset($defaults[$key]))
            continue;

        $request = isset($_REQUEST[$key][$menu_item_db_id]);

        $options[$key] = empty($value) && $request ? $_REQUEST[$key][$menu_item_db_id] : $value;

        $db_key = LMM . '_' . str_replace('-', '_', $key);
  
        if (!empty($options[$key])) {
            update_post_meta($menu_item_db_id, $db_key, $options[$key]);
        } elseif ($request && empty($options[$key]) && get_post_meta($menu_item_db_id, $db_key)) {
            delete_post_meta($menu_item_db_id, $db_key);
        }
    }
}
