<?php
/*
Plugin Name: Fins Studio Testimonial
Plugin URI: http://www.finsstudio.com/
Description: Plugin to Show Clients Testimonials.
Version: 1.0
Author: Fins Studio
Author URI: http://www.finsstudio.col/
License: GPLv2
*/

function fs_testimonials_type() {
	$testimoniallabels = array (	

		'name' => __('Testimonial','fs_testimonial'),

		'singular_name' => __('Testimonial','fs_testimonial'),

		'add_new' => __('Add testimonial','fs_testimonial'),

		'add_new_item' => __('Add new testimonial','fs_testimonial'),

		'edit_item' => __('Edit testimonial','fs_testimonial'),

		'new_item' => __('Add new testimonial','fs_testimonial'),

		'all_items' => __('All testimonial','fs_testimonial'),

		'view_item' => __('View testimonial','fs_testimonial'),

		'search_item' => __('Search testimonial','fs_testimonial'),

		'nfs_found' => __('No testimonial found..','fs_testimonial'),

		'nfs_found_in_trash' => __('No testimonial found in Trash.','fs_testimonial'),

		'menu_name' => 'Testimonial'

	

	);

	$args = array(

		'labels' => $testimoniallabels,
		'hierarchical' => true,
		'description' => 'Manages testimonial',
		'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
		'menu_icon' => plugins_url( 'images/testimonial.png', __FILE__ ),		
		'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => true,
        'capability_type' => 'post',
		'supports' => array( 'title','editor','thumbnail','excerpt','comments','custom-fields'),
	);
		register_post_type ('testimonial',$args);
	}
add_action ('init','fs_testimonials_type');

function fs_testimonial_taxonomy () {
	$taxonomylabels = array(

	'name' => __('Category testimonial','fs_testimonial'),

	'singular_name' => __('Category testimonial','fs_testimonial'),

	'search_items' => __('Search Category testimonial','fs_testimonial'),

	'all_items' => __('All Category testimonial','fs_testimonial'),

	'edit_item' => __('Edit Category testimonial','fs_testimonial'),

	'add_new_item' => __('Add new Category testimonial','fs_testimonial'),

	'menu_name' => __('Category testimonial','fs_testimonial'),

	);

	$args = array(

	'labels' => $taxonomylabels,

	'hierarchical' => true,

);
	register_taxonomy('category_testimonial','testimonial',$args);
}
add_action ('init','fs_testimonial_taxonomy',0);

?>