<?php
require_once "header.php";
?>
<div class="about-wrap liquida-admin-wrap">
    <h1><?php echo LMM_NAME ?> system status</h1>
    <div class="about-text" style="margin-bottom: 32px;">
        <p>
            Here you can check the system status. Yellow status means that the site will work as expected on the front end but it may cause problems in wp-admin.
            <strong>Memory notice:</strong> - the plugin is well tested with a limit of 40MB/request but plugins may require more, for example woocommerce requires 64MB.
        </p>

    </div>

    <?php
    /*  ----------------------------------------------------------------------------
      Theme config
     */

    // Theme name
    Liquida_System_Status::add('Plugin config', array(
        'check_name' => 'Plugin',
        'tooltip' => '',
        'value' => LMM_NAME,
        'status' => 'info'
    ));

    // Theme version
    Liquida_System_Status::add('Plugin config', array(
        'check_name' => 'Plugin version',
        'tooltip' => '',
        'value' => LMM_VERSION,
        'status' => 'info'
    ));

    // Redux version
    Liquida_System_Status::add('Plugin config', array(
        'check_name' => 'Redux version',
        'tooltip' => '',
        'value' => class_exists('ReduxFramework') ? ReduxFramework::$_version : _('Activate ReduxFramework', 'liquidatheme'),
        'status' => class_exists('ReduxFramework') ? 'green' : 'red',
    ));

    // Customizer version
    Liquida_System_Status::add('Plugin config', array(
        'check_name' => 'Customizer version',
        'tooltip' => '',
        'value' => class_exists('ReduxFramework_extension_advanced_customizer') ? ReduxFramework_extension_advanced_customizer::$version : __('Customizer is not working', 'liquidatheme'),
        'status' => class_exists('ReduxFramework_extension_advanced_customizer') ? 'green' : 'yellow',
    ));

    /*  ----------------------------------------------------------------------------
      Server status
     */

    // server info
    Liquida_System_Status::add('php.ini configuration', array(
        'check_name' => 'Server software',
        'tooltip' => '',
        'value' => esc_html($_SERVER['SERVER_SOFTWARE']),
        'status' => 'info'
    ));

    // php version
    Liquida_System_Status::add('php.ini configuration', array(
        'check_name' => 'PHP Version',
        'tooltip' => '',
        'value' => phpversion(),
        'status' => 'info'
    ));

    // post_max_size
    Liquida_System_Status::add('php.ini configuration', array(
        'check_name' => 'post_max_size',
        'tooltip' => '',
        'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s</span>', ini_get('post_max_size'), __('You cannot upload images, themes and plugins that have a size bigger than this value', 'liquidatheme')),
        'status' => 'info'
    ));

    // php time limit
    $max_execution_time = ini_get('max_execution_time');
    if ($max_execution_time == 0 or $max_execution_time >= 300) {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'max_execution_time',
            'tooltip' => '',
            'value' => $max_execution_time,
            'status' => 'green'
        ));
    } else {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'max_execution_time',
            'tooltip' => '',
            'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s <a href="%3$s" target="_blank">%4$s</a></span>', $max_execution_time, __('To import the demo content 300 seconds of max execution time is required. See: ', 'liquidatheme'), 'http://codex.wordpress.org/Common_WordPress_Errors#Maximum_execution_time_exceeded', __('Increasing max execution to PHP', 'liquidatheme')),
            'status' => 'red'
        ));
    }


    // php max input vars
    $max_input_vars = ini_get('max_input_vars');
    if ($max_input_vars == 0 or $max_input_vars >= 2000) {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'max_input_vars',
            'tooltip' => '',
            'value' => $max_input_vars,
            'status' => 'green'
        ));
    } else {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'max_input_vars',
            'tooltip' => '',
            'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s</span>', $max_input_vars, __('The max_input_vars should be bigger than 2000, otherwise it can cause incomplete saves in the menu panel in WordPress', 'liquidatheme')),
            'status' => 'red'
        ));
    }

    // suhosin
    if (extension_loaded('suhosin') !== true) {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'SUHOSIN Installed',
            'tooltip' => '',
            'value' => 'False',
            'status' => 'green'
        ));
    } else {
        Liquida_System_Status::add('php.ini configuration', array(
            'check_name' => 'SUHOSIN Installed',
            'tooltip' => '',
            'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s</span>', __('SUHOSIN is installed', 'liquidatheme'), __('It may cause problems with saving the theme panel if it\'s not properly configured', 'liquidatheme')),
            'status' => 'yellow'
        ));
    }

    /*  ----------------------------------------------------------------------------
      WordPress
     */
    // home url
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'WP Home URL',
        'tooltip' => 'test tooltip',
        'value' => home_url(),
        'status' => 'info'
    ));

    // site url
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'WP Site URL',
        'tooltip' => 'test tooltip',
        'value' => site_url(),
        'status' => 'info'
    ));

    // home_url == site_url
    if (home_url() != site_url()) {
        Liquida_System_Status::add('WordPress and plugins', array(
            'check_name' => 'Home URL - Site URL',
            'tooltip' => 'Home URL not equal to Site URL, this may indicate a problem with your WordPress configuration.',
            'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s</span>', _('Home URL != Site URL', 'liquidatheme'), __('Home URL not equal to Site URL, this may indicate a problem with your WordPress configuration.', 'liquidatheme')),
            'status' => 'red'
        ));
    }

    // version
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'WP version',
        'tooltip' => '',
        'value' => get_bloginfo('version'),
        'status' => 'info'
    ));


    // is_multisite
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'WP multisite enabled',
        'tooltip' => '',
        'value' => is_multisite() ? 'Yes' : 'No',
        'status' => 'info'
    ));


    // language
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'WP Language',
        'tooltip' => '',
        'value' => get_locale(),
        'status' => 'info'
    ));



    // memory limit
    $memory_limit = Liquida_System_Status::wp_memory_notation_to_number(WP_MEMORY_LIMIT);
    if ($memory_limit < 67108864) {
        Liquida_System_Status::add('WordPress and plugins', array(
            'check_name' => 'WP Memory Limit',
            'tooltip' => '',
            'value' => sprintf('%1$s - <span class="liquida-status-small-text">%2$s <a href="%3$s" target="_blank">%4$s</a></span>', size_format($memory_limit) . '/request', __('We recommend setting memory to at least 64MB. The theme is well tested with a 40MB/request limit, but if you are using multiple plugins that may not be enough. See: ', 'liquidatheme'), 'http://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP', __('Increasing memory allocated to PHP', 'liquidatheme')),
            'status' => 'red'
        ));
    } else {
        Liquida_System_Status::add('WordPress and plugins', array(
            'check_name' => 'WP Memory Limit',
            'tooltip' => '',
            'value' => size_format($memory_limit) . '/request',
            'status' => 'green'
        ));
    }


    // wp debug
    if (defined('WP_DEBUG') and WP_DEBUG === true) {
        Liquida_System_Status::add('WordPress and plugins', array(
            'check_name' => 'WP_DEBUG',
            'tooltip' => '',
            'value' => __('WP_DEBUG is enabled', 'liquidatheme'),
            'status' => 'yellow'
        ));
    } else {
        Liquida_System_Status::add('WordPress and plugins', array(
            'check_name' => 'WP_DEBUG',
            'tooltip' => '',
            'value' => 'False',
            'status' => 'green'
        ));
    }






    // caching
    $caching_plugin_list = array(
        'wp-super-cache/wp-cache.php' => array(
            'name' => 'WP super cache',
            'status' => 'green',
        ),
        'w3-total-cache/w3-total-cache.php' => array(
            'name' => 'W3 total cache (we recommend WP super cache)',
            'status' => 'yellow',
        ),
        'wp-fastest-cache/wpFastestCache.php' => array(
            'name' => 'WP Fastest Cache (we recommend WP super cache)',
            'status' => 'yellow',
        ),
    );
    $active_plugins = get_option('active_plugins');
    $caching_plugin = __('No caching plugin detected', 'liquidatheme');
    $caching_plugin_status = 'yellow';
    foreach ($active_plugins as $active_plugin) {
        if (isset($caching_plugin_list[$active_plugin])) {
            $caching_plugin = $caching_plugin_list[$active_plugin]['name'];
            $caching_plugin_status = $caching_plugin_list[$active_plugin]['status'];
            break;
        }
    }
    Liquida_System_Status::add('WordPress and plugins', array(
        'check_name' => 'Caching plugin',
        'tooltip' => '',
        'value' => $caching_plugin,
        'status' => $caching_plugin_status
    ));

    Liquida_System_Status::render_tables();
    ?>

</div>



<?php

class Liquida_System_Status {

    static $system_status = array();

    static function add($section, $status_array) {
        self::$system_status[$section] [] = $status_array;
    }

    static function render_tables() {
        foreach (self::$system_status as $section_name => $section_statuses) {
            ?>
            <table class="widefat liquida-system-status-table" cellspacing="0">
                <thead>
                    <tr>
                        <th colspan="4"><?php echo esc_html($section_name); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($section_statuses as $status_params) {
                        ?>
                        <tr>
                            <td class="liquida-system-status-name"><?php echo esc_html($status_params['check_name']); ?></td>
                            <td class="liquida-system-status-help"><!--<a href="#" class="help_tip">[?]</a>--></td>
                            <td class="liquida-system-status-status">
                                <?php
                                switch ($status_params['status']) {
                                    case 'green':
                                        echo '<div class="liquida-system-status-led liquida-system-status-green liquida-tooltip" data-position="right" title="Green status: this check passed our system status test!"></div>';
                                        break;
                                    case 'yellow':
                                        echo '<div class="liquida-system-status-led liquida-system-status-yellow liquida-tooltip" data-position="right" title="Yellow status: this setting may affect the backend of the site. The front end should still run as expected. We recommend that you fix this."></div>';
                                        break;
                                    case 'red' :
                                        echo '<div class="liquida-system-status-led liquida-system-status-red liquida-tooltip" data-position="right" title="Red status: the site may not work as expected with this option."></div>';
                                        break;
                                    case 'info':
                                        echo '<div class="liquida-system-status-led liquida-system-status-info liquida-tooltip" data-position="right" title="Info status: this is just for information purposes and easier debug if a problem appears">i</div>';
                                        break;
                                }
                                ?>
                            </td>
                            <td class="liquida-system-status-value"><?php echo $status_params['value']; ?></td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
            <?php
        }
    }

    static function wp_memory_notation_to_number($size) {
        $l = substr($size, -1);
        $ret = substr($size, 0, -1);
        switch (strtoupper($l)) {
            case 'P':
                $ret *= 1024;
            case 'T':
                $ret *= 1024;
            case 'G':
                $ret *= 1024;
            case 'M':
                $ret *= 1024;
            case 'K':
                $ret *= 1024;
        }
        return $ret;
    }

}
