<?php

//disable lmm metabox ----------------------------------------------------------
//you can include this filters and functions in your functions.php
//use this constant to disable the locations metabox in post and pages
define('LMM_METABOXES', FALSE);

//developer options ------------------------------------------------------------
//this options will be hidden for the user and cant be modified
//this options will override the options set by other filters

add_filter('lmm_hook_options_developer', 'my_hook_developer');

function my_hook_developer($developer = array()) {

    $developer['lmm_locations'] = array(
        'my_theme_location' => 1
    );

    $developer['lmm_styles'] = 1;

    $developer['lmm_styles_normalize'] = 1;

    $developer['lmm_styles_bootstrap'] = 1;

    $developer['lmm_styles_widgets'] = 1;
    
    $developer['lmm_styles_icons'] = 'eleganticons';

    $developer['lmm_styles_pscrollbar'] = 1;

    return $developer;
}

//lmm config default options ---------------------------------------------------
//this options will be loaded as defaults and can be modified by the user
add_filter('lmm_hook_options_config_defaults', 'my_hook_defaults');

function my_hook_defaults($defaults) {

    $defaults['lmm_locations'] = array(
        'primary' => 1,
        'lmm-location-1' => 1
    );

    $defaults['lmm_multioptions'] = 1;

    $defaults['lmm_locations_styles'] = array(
        'lmm-location-1' => 1
    );

    $defaults['lmm_widgets'] = array(
        'lmm-widget-1' => 'LMM Widget Area 1',
        'lmm-widget-2' => 'LMM Widget Area 2',
        'lmm-widget-3' => 'LMM Widget Area 3',
        'lmm-widget-4' => 'LMM Widget Area 4',
        'lmm-widget-5' => 'LMM Widget Area 5',
        'lmm-widget-6' => 'LMM Widget Area 6',
        'lmm-widget-7' => 'LMM Widget Area 7',
        'lmm-widget-8' => 'LMM Widget Area 8',
        'lmm-widget-9' => 'LMM Widget Area 9',
        'lmm-widget-10' => 'LMM Widget Area 10',
        'lmm-widget-11' => 'LMM Widget Area 11',
        'lmm-widget-12' => 'LMM Widget Area 12',
    );

    $defaults['lmm_custom_locations'] = array(
        'lmm-location-1' => 'LMM Location 1',
    );

    $defaults['lmm_styles'] = 1;

    $defaults['lmm_styles_normalize'] = 1;

    $defaults['lmm_styles_widgets'] = 1;

    $defaults['lmm_styles_bootstrap'] = 1;

    $defaults['lmm_styles_pscrollbar'] = 1;

    $defaults['lmm_styles_icons'] = 'eleganticons'; //accepted values : 'eleganticons', 'elusive', 'fontawesome', 'foundation', 'themify'

    return $defaults;
}

//lmm general default options --------------------------------------------------
//this options will be loaded as defaults and can be modified by the user
add_filter('lmm_hook_options_general_defaults', 'my_hook_defaults_general');

function my_hook_defaults_general($defaults) {

    $defaults['scheme_lmm_navbar_breakpoint'] = '768';
    $defaults['scheme_lmm_container_gutter'] = '30';
    
    $defaults['scheme_lmm_screen_md_width'] = '992';
    $defaults['scheme_lmm_screen_lg_width'] = '1200';
    
    $defaults['scheme_lmm_container_small_width'] = '720';
    $defaults['scheme_lmm_container_medium_width'] = '940';
    $defaults['scheme_lmm_container_large_width'] = '1140';


    $defaults['scheme_lmm_general_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,//uncomment only if you set a google font. Ej : Open Sans
        'font-size' => '11',
        'font-weight' => '400',
    );

    $defaults['scheme_lmm_navbar_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,//uncomment only if you set a google font. Ej : Open Sans
        'font-size' => '11',
        'font-weight' => '400',
    );

    $defaults['scheme_lmm_dropdown_font'] = array(
        'font-family' => 'Verdana, Geneva, sans-serif',
        //'google' => true,//uncomment only if you set a google font. Ej : Open Sans
        'font-size' => '11',
        'font-weight' => '400',
    );

    return $defaults;
}

//lmm general default options --------------------------------------------------
//this options will be loaded as defaults and can be modified by the user
add_filter('lmm_hook_options_locations_defaults', 'my_hook_defaults_locations');

function my_hook_defaults_locations($defaults) {
    // layout defaults ---------------------------------------------------------
    $defaults['all_integration'] = 'auto'; // accepted values : 'manual' , 'auto'
    $defaults['all_integration_filters'] = 0; // accepted values : 1 , 0
    $defaults['all_navbar_mode'] = 'horizontal'; // accepted values : 'horizontal', 'vertical'
    $defaults['all_navbar_mode_horizontal'] = 'button'; // accepted values : 'button', 'collapsed', 'offcanvas'
    $defaults['all_navbar_mode_vertical'] = 'collapsed'; // accepted values : 'button', 'collapsed', 'inherit'
    $defaults['all_navbar_mode_vertical_float'] = 'left'; // accepted values : 'left', 'right'
    $defaults['all_navbar_mode_horizontal_align'] = 'left';  // accepted values : 'left', 'center', 'right'
    $defaults['all_navbar_sticky'] = 1; // accepted values : 1 , 0
    $defaults['all_navbar_sticky_offset'] = '60';
    $defaults['all_navbar_sticky_logo'] = 0; // accepted values : 1 , 0
    $defaults['all_navbar_width'] = 'container-auto'; // accepted values : 'container', 'container-auto', 'container-fluid'
    $defaults['all_navbar_separator'] = 'lmm-separators-smooth'; // accepted values : '', 'lmm-separators-smooth'    
    $defaults['all_navbar_trigger'] = 'lmm-trigger-hoverintent'; // 'lmm-trigger-click' , 'lmm-trigger-hoverintent'
    $defaults['all_navbar_classes'] = 'custom'; // accepted values : any string
    $defaults['all_navbar_logo'] = array(
        'url' => LMM_URL . 'assets/frontend/images/logo.png'
    );
    $defaults['all_navbar_hover_effect'] = 'lmm-hover-slidebar';
    $defaults['all_dropdown_triangle'] = 'lmm-dropdown-triangle'; // accepted values : '', 'lmm-dropdown-triangle'
    $defaults['all_dropdown_animation'] = 'lmm_fadeIn'; // accepted values : 'lmm_rtl', 'lmm_rtl', 'lmm_ltr', 'lmm_hinge'
    // navbar defaults ---------------------------------------------------------
    $defaults['scheme_all_navbar_height'] = '90';
    $defaults['scheme_all_navbar_width'] = '260';
    $defaults['scheme_all_navbar_toggle_icon'] = '#ffffff';
    $defaults['scheme_all_navbar_toggle_border'] = 'transparent';
    $defaults['scheme_all_navbar_toggle_bg'] = 'transparent';
    $defaults['scheme_all_navbar_toggle_hover'] = '#444444';
    $defaults['scheme_all_navbar_background'] = 'color'; // accepted values : 'color', 'gradient'
    $defaults['scheme_all_navbar_background_color'] = array(
        'color' => '#000000',
        'alpha' => '0.9'
    );
    $defaults['scheme_all_navbar_background_to'] = array(
        'color' => '#222222',
        'alpha' => '0.9'
    );

    $defaults['scheme_all_navbar_border'] = '#000000';
    $defaults['scheme_all_navbar_text'] = '#aaaaaa';

    $defaults['scheme_all_navbar_logo_bg'] = array(
        'color' => '#ffffff',
        'alpha' => '0'
    );
    $defaults['scheme_all_navbar_link'] = '#f1f1f1';
    $defaults['scheme_all_navbar_link_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_link_hover_bg'] = array(
        'color' => '#000000',
        'alpha' => '1'
    );
    $defaults['scheme_all_navbar_link_hover_effect'] = array(
        'color' => '#ffffff',
        'alpha' => '1'
    );
    $defaults['scheme_all_navbar_link_margin'] = array(
        'border-top' => '0',
        'border-right' => '0',
        'border-left' => '0',
        'border-bottom' => '0'
    );
    $defaults['scheme_all_navbar_link_radius'] = 0;
    $defaults['scheme_all_navbar_link_transform'] = 'uppercase'; // accepted values : 'none', 'capitalize', 'uppercase', 'lowercase'
    $defaults['scheme_all_navbar_link_icon'] = '#eeeeee';
    $defaults['scheme_all_navbar_link_icon_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_link_subtitle'] = '#eeeeee';
    $defaults['scheme_all_navbar_link_subtitle_hover'] = '#ffffff';
    $defaults['scheme_all_navbar_search_bg'] = '#555555';
    $defaults['scheme_all_navbar_search_border'] = '#555555';
    $defaults['scheme_all_navbar_search_color'] = '#dddddd';
    $defaults['scheme_all_navbar_cart_bubble'] = '#21C2F8';
    $defaults['scheme_all_navbar_cart_bubble_color'] = '#ffffff';
    $defaults['scheme_all_navbar_sticky_height'] = '56';
    $defaults['scheme_all_navbar_sticky_background'] = array('color' => '#ffffff', 'alpha' => '0');
    // dropdown defaults -------------------------------------------------------
    $defaults['scheme_all_dropdown_margin'] = 0;
    $defaults['scheme_all_dropdown_radius'] = 3;
    $defaults['scheme_all_dropdown_border'] = array(
        'border-all' => '3',
        'border-top' => '3',
        'border-color' => '#eeeeee'
    );
    $defaults['scheme_all_dropdown_background'] = array(
        'color' => '#ffffff',
        'alpha' => '0.8'
    );
    $defaults['scheme_all_dropdown_title'] = '#444444';
    $defaults['scheme_all_dropdown_title_border'] = array(
        'border-all' => '2',
        'border-top' => '2',
        'border-color' => '#eee',
        'border-style' => 'solid'
    );
    $defaults['scheme_all_dropdown_link'] = '#555555';
    $defaults['scheme_all_dropdown_link_hover'] = '#000000';
    $defaults['scheme_all_dropdown_link_hover_bg'] = array(
        'color' => '#dddddd',
        'alpha' => '0.9'
    );
    $defaults['scheme_all_dropdown_link_border'] = array(
        'border-all' => '1',
        'border-top' => '1',
        'border-color' => '#eee',
        'border-style' => 'solid'  // accepted values : 'solid', 'dashed', 'dotted', 'none'
    );
    $defaults['scheme_all_dropdown_link_transform'] = 'uppercase';  // accepted values : 'none', 'capitalize', 'uppercase', 'lowercase'
    $defaults['scheme_all_dropdown_link_icon'] = '#555555';
    $defaults['scheme_all_dropdown_link_icon_hover'] = '#000000';
    $defaults['scheme_all_dropdown_link_subtitle'] = '#8c8c8c';
    $defaults['scheme_all_dropdown_link_subtitle_hover'] = '#ffffff';

    //specific location default options ----------------------------------------
    //this options will be loaded as defaults for the location primary
    //please note the slug of the location in the array keys

    $defaults['primary_integration'] = 'auto';
    $defaults['primary_integration_filters'] = 0;

    $defaults['scheme_primary_navbar_height'] = '90';
    $defaults['scheme_primary_navbar_width'] = '260';

    return $defaults;
}

//lmm social default options ------------------------------------------------------
//this options will be loaded as defaults and can be modified by the user
add_filter('lmm_hook_options_social_defaults', 'my_hook_default_social');

function lmm_hook_defaults_social($defaults) {

    $defaults['lmm_social'] = array(
        array(
            'title' => 'Facebook',
            'icon' => 'social_facebook',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Twitter',
            'icon' => 'social_twitter',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Google Plus',
            'icon' => 'social_googleplus',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'Viemo',
            'icon' => 'social_vimeo',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
        array(
            'title' => 'RSS',
            'icon' => 'social_rss',
            'url' => 'http://codecanyon.net/user/liquida/portfolio?ref=liquida',
        ),
    );

    return $defaults;
}

//lmm css default options ------------------------------------------------------
//this options will be loaded as defaults and can be modified by the user
add_filter('lmm_hook_options_css_default', 'my_hook_defaults_css');

function my_hook_defaults_css($css = '') {
    $css = '.custom {}';   // accepted values : valid css
    return $css;
}

//html filters -----------------------------------------------------------------
//this filters allows you to override the html output of the plugin
//lmm item classes -------------------------------------------------------------
add_filter('lmm_nav_menu_css_class', 'my_hook_lmm_nav_menu_css_class', 10, 4);

function my_hook_lmm_nav_menu_css_class($classes = array(), $item, $args, $depth) {
    
    $classes[] = 'my_custom_class';
    
    return $classes;
}

//lmm item attributes ----------------------------------------------------------
add_filter('lmm_nav_menu_link_attributes', 'my_hook_lmm_nav_menu_link_attributes', 10, 3);

function my_hook_lmm_nav_menu_link_attributes($atts = array(), $item, $args, $depth) {
    return $atts;
}

//lmm item li start ------------------------------------------------------------
add_filter('lmm_nav_menu_start_el', 'my_hook_lmm_nav_menu_start_el', 10, 5);

function my_hook_lmm_nav_menu_start_el($output = '', $item, $args, $depth, $atts) {
    return $output;
}

//lmm item li end --------------------------------------------------------------
add_filter('lmm_nav_menu_end_el', 'lmm_nav_menu_end_el', 10, 4);

function my_hook_lmm_nav_menu_end_el($output = '', $item, $args, $depth) {
    return $output;
}

//lmm item sidebars ------------------------------------------------------------
add_filter('lmm_hook_register_sidebars', 'my_hook_register_sidebars');

function my_hook_register_sidebars($args = array()) {

    $args = array(
        'before_widget' => '<div id="%1$s" class="widget %2$s custom">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="menutitle">',
        'after_title' => '</h4>'
    );

    return $args;
}

//options filters --------------------------------------------------------------
//this filters allows you to override the options in the panel
add_filter('lmm_hook_animations', 'my_hook_animations');

function my_hook_animations($args = array()) {

    $args['custom'] = 'Custom';

    return $args;
}

//theme integration filters ----------------------------------------------------
//this filters allows you to change the path of the less files to compile

add_filter('lmm_hook_less_folder', 'my_hook_less_folder');

function my_hook_less_folder($folder = '') {
    return get_template_directory() . '/lmm/less';
}
//demo importer filters --------------------------------------------------------
//https://github.com/Webcreations907/WBC-Importer-extension
//use this constant to disable the Demo Importer tab
define('LMM_IMPORTER', FALSE);

//this filters allows you to change the path of the demos for the importer
add_filter('lmm_import_demo_path', 'my_hook_import_demo_path');

function my_hook_import_demo_path($file = '') {
    return get_template_directory() . '/lmm/demos/';
}

//set menu after import --------------------------------------------------------
add_action('wbc_importer_after_content_import', 'my_hook_import_demo_menus', 10, 2);

function my_hook_import_demo_menus($demo_active_import, $demo_directory_path) {

    reset($demo_active_import);

    $current_key = key($demo_active_import);

    if (!empty($demo_active_import[$current_key]['directory'])) {

        $top_menu = get_term_by('name', 'My Menu', 'nav_menu');

        if (isset($top_menu->term_id)) {
            set_theme_mod('nav_menu_locations', array(
                'primary' => $top_menu->term_id,
                'my_theme_location' => $top_menu->term_id,
                    )
            );
        }
    }
}
