<?php
add_action('widgets_init', 'lmm_sidebar_menu');

function lmm_sidebar_menu() {

    register_widget('Lmm_Sidebar_Menu');
}

class Lmm_Sidebar_Menu extends WP_Widget {

    function Lmm_Sidebar_Menu() {
        $widget_ops = array('classname' => 'widget_lmm_sidebar_menu', 'description' => __('A widget that displays the menu in the sidebar.', 'lmm'));

        $control_ops = array('width' => 200, 'height' => 250, 'id_base' => 'lmm_sidebar_menu');

        parent::__construct('lmm_sidebar_menu', __('LMM Sidebar Menu', 'lmm'), $widget_ops, $control_ops);
    }

    function widget($args, $instance) {

        extract($args);

        echo $before_widget;

        if (empty($instance['location']))
            echo __('Select a valid theme location', 'lmm');
        else
            lmmmenu(array(
                'theme_location' => $instance['location'],
                'menu_mode' => 'lmm_vertical_inherit',
                'allow_metaboxes' => false,
            ));

        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['location'] = strip_tags($new_instance['location']);
        return $instance;
    }

    function select_location($current = false) {

        global $lmm_locations;

        foreach ($lmm_locations as $key => $location) {

            if (!$location['active'] || !$location['subsection'])
                continue;

            $selected = $current == $key ? 'selected="selected"' : '';

            $output .= '<option value="' . esc_attr($key) . '" ' . $selected . '>';
            $output .= $location['name'];
            $output .= '</option>';
        }

        return $output;
    }

    function form($instance) {

        $defaults = array(
            'location' => '',
        );

        $instance = wp_parse_args((array) $instance, $defaults);
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('location'); ?>"><?php _e('Location', 'lmm'); ?>:</label>
            <select id="<?php echo $this->get_field_id('location'); ?>" name="<?php echo $this->get_field_name('location'); ?>" class="widefat">
                <?php echo $this->select_location($instance['location']); ?>
            </select>
        </p>

        <?php
    }

}
