<?php

// wordpress importer ----------------------------------------------------------

add_filter('wp_import_post_data_raw', 'lmm_import_meta', 10, 1);

function lmm_import_meta($item, $i = 0, $lmmmeta = array()) {

    global $wp_import;

    if ('nav_menu_item' != $item['post_type'] || 'draft' == $item['status'])
        return $item;

    foreach ($item['postmeta'] as $key => $meta) {

        if (substr($meta['key'], 0, 4) !== 'lmm_' || empty($meta['value']))
            continue;

        $lmmmeta[$i++] = array('key' => $meta['key'], 'value' => $meta['value']);
    }

    $wp_import->lmm[(int) $item['post_id']] = $lmmmeta;

    return $item;
}

add_action('import_end', 'lmm_import_save');

function lmm_import_save() {

    global $wpdb, $wp_import;

    if (empty($wp_import->lmm))
        return;

    foreach ($wp_import->lmm as $post_id => $postmeta) {

        if (empty($wp_import->processed_menu_items[$post_id]))
            continue;

        foreach ($postmeta as $meta) {
            update_post_meta((int) $wp_import->processed_menu_items[$post_id], $meta['key'], $meta['value']);
        }
    }
}