<?php
if (\defined('LMM_CUSTOMIZER') && LMM_CUSTOMIZER === FALSE)
    return;

//advanced customizer ----------------------------------------------------------
function lmm_advanced_customizer($ReduxFramework) {

    //dont load if early version of redux to the customizer support
    if (!file_exists(ReduxFramework::$_dir . 'inc/extensions/customizer/inc/customizer_section.php') || class_exists('ReduxFramework_extension_advanced_customizer'))
        return;

    require_once(LMM_PATH . '/lib/redux/advanced_customizer/extension_advanced_customizer.php');

    new ReduxFramework_extension_advanced_customizer($ReduxFramework);
}

add_action('redux/extensions/' . LMM . '/before', 'lmm_advanced_customizer', 0);

// activate the customizer in redux --------------------------------------------
add_filter('redux/options/' . LMM . '/args', 'lmm_customizer_arguments');

function lmm_customizer_arguments($args) {

    if (!is_customize_preview())
        return $args;

    if (!file_exists(ReduxFramework::$_dir . 'inc/extensions/customizer/inc/customizer_section.php')) {

        lmm_add_admin_notice('error', __('An outdated version of redux have been loaded from other theme or plugin. Please update to enable the customizer.', 'lmm'));

        return $args;
    }

    $args['customizer'] = true;

    return $args;
}

// activate the customizer sections --------------------------------------------
add_filter('redux/options/' . LMM . '/sections', 'lmm_customizer_locations');

function lmm_customizer_locations($sections = array()) {

    if (!is_customize_preview())
        return $sections;

    global $lmm_locations;

    foreach ($sections as $key => $section) {

        $compare = str_replace(array('lmm_integration_', 'lmm_layout_', 'lmm_navbar_', 'lmm_dropdown_'), '', $section['id']);

        if (!in_array($compare, array_keys($lmm_locations)))
            continue;

        $sections[$key]['customizer'] = true;
    }

    return $sections;
}

// add customizer controls settings
add_action('customize_controls_enqueue_scripts', 'lmm_backend_scripts');

//add_action('customize_controls_enqueue_scripts', 'lmm_customizer_scripts');

function lmm_customizer_scripts() {

    global $lmm, $lmm_locations;

    //wp_register_style('lmm-admin', LMM_URL . 'assets/backend/css/backend.min.css', '', '', 'all');
    //wp_enqueue_style('lmm-admin');
    //wp_enqueue_style('lmm-admin-icons');

    wp_register_script('lmm-customizer-controls', LMM_URL . 'assets/backend/js/customizer-controls.js', array('jquery'), '', true);

    wp_enqueue_script('lmm-customizer-controls');

    // 1326 move this to redux core
    $developer_options = apply_filters('lmm_hook_options_developer', $developer = array());

    $required_options = array();

    foreach ($lmm_locations as $key => $location) {

        if (!$location['style'])
            continue;

        $required_options['lmm[' . $key . '_navbar_mode]'] = array('instance' => $key,
            'controls' => array(
                'lmm[' . $key . '_navbar_mode_horizontal]',
                'lmm[' . $key . '_navbar_mode_vertical]',
                'lmm[' . $key . '_navbar_mode_vertical_float]',
                'lmm[' . $key . '_navbar_mode_horizontal_align]',
                'lmm[' . $key . '_navbar_width]'
            )
        );
    }

    wp_localize_script('lmm_customizer-controls', 'lmm', array(
        'developer_options' => !empty($developer_options) ? '#customize-control-lmm-' . implode(array_keys($developer_options), ',#lmm-') : '',
        'required_options' => $required_options,
            )
    );
}

// less interactios
add_action('wp_head', 'lmm_customizer_css', 999);

function lmm_customizer_css() {

    if (!is_customize_preview())
        return;

    global $lmm, $lmm_locations;

    /* wp_localize_script('lmm_customizer-less', 'lmm', array(
      'less_config' => json_encode(array('env' => 'development')),
      'less_variables' => json_encode(array_merge(lmm_less_locations($lmm_locations), lmm_less_variables($lmm))),
      )
      );

      wp_register_script('lmm_customizer-preview', LMM_URL . 'assets/backend/js/customizer-preview.js', array('jquery'), '', true);
      wp_enqueue_script('lmm_customizer-preview');

      wp_register_script('lmm_customizer-less', LMM_URL . 'assets/backend/js/less.min.js', array('lmm_customizer-preview'), '', true);
      wp_enqueue_script('lmm_customizer-less'); */
    ?>

    <link rel="stylesheet/less" type="text/css" href="<?php echo LMM_URL . 'assets/frontend/less/lmm_customizer.less'; ?>" />

    <script>
        less = {
            env: "development",
        };
    </script>
    <script src="<?php echo LMM_URL . 'assets/backend/js/less.min.js'; ?>" type="text/javascript"></script>
    <script type="text/javascript">
        less.modifyVars(<?php echo json_encode(array_merge(lmm_less_locations(), lmm_less_variables($lmm))); ?>);
    </script>
    <?php
}
