<?php

class LMM_Activation {

    public $files = false;

    function __construct() {

        if (!is_admin())
            return;

        $this->files();

        add_action('after_switch_theme', array($this, 'notice_switch'));

        add_action('init', array($this, 'redirect'));

        add_action('init', array('LMM_Options', 'saved_locations'), 15); // betwen 10 of filters init and 13 of global $lmm_locations

        if (!get_transient('_lmm_activation'))
            return;

        add_action('init', array($this, 'update'), 5);

        add_action('init', array($this, 'install'), 10);

        delete_transient('_lmm_activation');
    }

    function files() {

        if (!defined('LMM_PATH_CSS')) {
            return;
        }

        $this->files = file_exists(LMM_PATH_CSS);
    }

    function notice_switch() {

        if (!$this->files) {
            lmm_add_admin_notice('updated', sprintf(__('Hello again! looks like you\'ve switched the wordpress theme, we have to create a new folder for the stylesheets. Go to <a href="%s">LMM Options</a> and activate your theme locations.', 'lmm'), lmm_taburl('0')));
            update_option('_lmm_saved_locations_compiler', true);
        } else {
            lmm_add_admin_notice('updated', sprintf(__('Hello again! looks like stylesheets for this theme has been created in the past. Go to <a href="%s">LMM Options</a> and activate your theme locations.', 'lmm'), lmm_taburl('0')));
        }
    }

    function update() {

        if (!LMM_COMPILE)
            return;

        if (!get_option(LMM))
            return;

        if (LMM_VERSION == get_option('lmm_version'))
            return;

        update_option('_lmm_saved_locations_compiler', true);

        set_transient('_lmm_update', true, 30);

        update_option('lmm_version', LMM_VERSION);

        lmm_add_admin_notice('updated', sprintf(__('Hey there! thanks for update LMM Menu. We have to re-create the menu stylesheets, please go to <a href="%s">LMM Options</a> and activate your theme locations.', 'lmm'), lmm_taburl('0')));
    }

    function install() {

        global $lmm;

        if (get_transient('_lmm_update'))
            return;

        if (!$this->files) {
            lmm_add_admin_notice('updated', sprintf(__('Hey there! thanks for activate LMM Menu. We have to create the menu stylesheets. Please go to <a href="%s">LMM Options</a> and activate your theme locations.', 'lmm'), lmm_taburl('0')));
            update_option('_lmm_saved_locations_compiler', true);
        } else {
            lmm_add_admin_notice('updated', sprintf(__('Hello again! We have already created the menu styleshets in the past. Go to <a href="%s">LMM Options</a>.', 'lmm'), lmm_taburl('0')));
        }

        delete_transient('_lmm_update');
    }

    function redirect() {

        if (!get_transient('_lmm_redirect'))
            return;

        delete_transient('_lmm_redirect');

        wp_redirect(admin_url('admin.php?page=' . LMM_PANEL));
    }

    function activation() {

        set_transient('_lmm_activation', true, 30);

        if (!is_network_admin()) {
            set_transient('_lmm_redirect', true, 30);
        }
    }

}

new LMM_Activation();
