<?php 

// Custom Heading
add_shortcode('heading','heading_func');
function heading_func($atts, $content = null){
	extract(shortcode_atts(array(

		'text'		=>	'',

		'tag'		=> 	'',

		'size'		=>	'',

		'color'		=>	'',

		'align'		=>	'',

		'class'		=>	'',

	), $atts));

	

	$size1 = (!empty($size) ? 'font-size: '.$size.';' : '');

	$color1 = (!empty($color) ? 'color: '.$color.';' : '');

	$align1 = (!empty($align) ? 'text-align: '.$align.';' : '');

	$class1 = (!empty($class) ? $class.'' : '');

	$html = '<'.$tag.' class="'.$class1.'" style="' . $size1 . $align1 . $color1 .'">'. $text .'</'.$tag.'>';


	return $html;

}




// Project Skills



add_shortcode('pjskill', 'pjskill_func');

function pjskill_func($atts, $content = null){



	extract(shortcode_atts(array(

		

	), $atts));

	ob_start(); ?>

	

	<div class="used-skills-ul">

		<?php echo htmlspecialchars_decode($content); ?>

	</div>

	<?php return ob_get_clean();

}


// Icon Boxes
add_shortcode('ibb', 'ibb_func');
function ibb_func($atts, $content = null){
	extract(shortcode_atts(array(

		'title' 	=> '',

		'stitle' 	=> '',

		'btn' 		=> '',

		'link' 		=> '',

		'icon' 		=> '',

		'style'		=> '',



	), $atts));

	ob_start(); ?>

	<?php if($style == 'style3') { ?>
	<div class="service-item-2">

		<?php if($icon) { ?><i class="fa fa-<?php echo esc_attr($icon); ?>"></i><?php } ?>

		<?php if($title) { ?><h3><?php echo htmlspecialchars_decode($title); ?></h3><?php } ?>

		<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

	</div>
	<?php }elseif($style == 'style4') { ?>
	<div class="service-item">

		<?php if($icon) { ?><h4><i class="fa fa-<?php echo esc_attr($icon); ?>"></i> <?php echo htmlspecialchars_decode($title); ?></h4><?php } ?>

		<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

		<?php if($btn) { ?><p><a href="<?php echo esc_url($link); ?>" class=""><?php echo htmlspecialchars_decode($btn); ?></a></p><?php } ?>

	</div>
	<?php }else{ ?>
	<div class="feature <?php if($style == 'style2') echo 'feature-hor'; ?>">

		<?php if($icon) { ?><div class="feature-icon"><i class="fa fa-<?php echo esc_attr($icon); ?>"></i></div><?php } ?>

		<div class="clear"></div>

		<?php if($title) { ?><h4 class="title"><?php echo htmlspecialchars_decode($title); ?></h4><?php } ?>

		<?php if($stitle) { ?><p class="desc"><?php echo htmlspecialchars_decode($stitle); ?></p><?php } ?>

		<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

		<?php if($btn) { ?><p><a href="<?php echo esc_url($link); ?>" class="d-btn d-btn-primary d-btn-small"><?php echo htmlspecialchars_decode($btn); ?></a></p><?php } ?>

	</div>
	<?php } ?>

	<?php return ob_get_clean();
}


// Call To Action 1
add_shortcode('cta1', 'cta1_func');
function cta1_func($atts, $content = null){
	extract(shortcode_atts(array(

		'btntext1' 	=> '',

		'btnlink1' 	=> '',

		'title'		=> '',

		'style'		=> '',

	), $atts));

	ob_start(); ?>

	<?php if($style == 'style1') { ?>
	<div class="action-block-1">

		<h3 class="margin-bottom-0"><?php echo htmlspecialchars_decode($title); ?></h3>

		<p><?php if($content) echo htmlspecialchars_decode($content); ?></p>

		<a href="<?php echo esc_url($btnlink1); ?>" class="d-btn d-btn-primary d-btn-large"><?php echo esc_attr($btntext1); ?></a>

	</div>
	<?php }elseif($style == 'style3'){ ?>
	<div class="align-center">
		<p class="font-size-36 font-bold secondary-color text-uppercase"><?php echo htmlspecialchars_decode($title); ?></p>

		<p><?php if($content) echo htmlspecialchars_decode($content); ?></p>

		<p><a href="<?php echo esc_url($btnlink1); ?>" class="d-btn d-btn-primary d-btn-large margin-right-10"><?php echo esc_attr($btntext1); ?></a></p>
	</div>
	<?php }else{ ?>
	<div class="col-md-10 cta1">

		<p class="margin-0 font-size-24 text-uppercase font-bold text-color-white"><?php echo htmlspecialchars_decode($title); ?></p>

		<p class="margin-0 margin-top-0 md-margin-bottom-30 sm-margin-bottom-30"><?php if($content) echo htmlspecialchars_decode($content); ?></p>

	</div>

	<div class="col-md-2">

		<a href="<?php echo esc_attr($btnlink1); ?>" class="d-btn d-btn-primary d-btn-large text-color-white"><?php echo esc_attr($btntext1); ?></a>

	</div>
	<?php } ?>
	<?php return ob_get_clean();

}



// Call To Action 2
add_shortcode('cta2', 'cta2_func');
function cta2_func($atts, $content = null){
	extract(shortcode_atts(array(

		'btntext1' 	=> '',

		'btnlink1' 	=> '',

		'btntext2' 	=> '',

		'btnlink2' 	=> '',

		'title'		=> '',

		'stitle'  	=> '',

		'style'		=> '',

	), $atts));

	ob_start(); ?>

	<div class="<?php if($style == 'style2') echo 'align-center';?>">

		<p class="secondary-color font-size-24 margin-top-0"><?php echo htmlspecialchars_decode($title); ?></p>

		<?php if($stitle) { ?><p class="primary-color font-italic"><?php echo htmlspecialchars_decode($stitle); ?></p><?php } ?>

		<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

		<p><?php if($btntext1) { ?><a href="<?php echo esc_url($btnlink1); ?>" class="d-btn d-btn-large d-btn-primary"><?php echo htmlspecialchars_decode($btntext1); ?></a> <?php }if($btntext2) { ?><a href="<?php echo esc_url($btnlink2); ?>" class="d-btn d-btn-large d-btn-secondary"><?php echo htmlspecialchars_decode($btntext2); ?></a><?php } ?></p>

	</div>

	<?php return ob_get_clean();

}

// Buttons
add_shortcode('button', 'button_func');
function button_func($atts, $content = null){
	extract(shortcode_atts(array(

		'btntext' 	=> '',

		'btnlink' 	=> '',

		'icon'  	=> '',

		'type'		=> '',

		'size'		=> '',

	), $atts));

	ob_start(); ?>

	<?php 



		if($type == 'border2'){

			$type1 = 'secondary-border';

		}elseif($type == 'color'){

			$type1 = 'primary';

		}elseif($type == 'border1'){

			$type1 = 'primary-border';

		}else{
			$type1 = 'secondary';
		}



		if($size == 'small'){

			$size2 = 'small';

		}elseif($size == 'large'){

			$size2 = 'large';

		}else{

			$size2 = 'normal';

		}

	?>

	<a href="<?php echo esc_url($btnlink); ?>" class="d-btn d-btn-<?php echo esc_attr($size2); ?> d-btn-<?php echo esc_attr($type1); ?>">
	<?php if($icon) { ?><i class="fa fa-<?php echo esc_attr($icon); ?>"></i> <?php } echo esc_attr($btntext); ?></a>
	<?php return ob_get_clean();
}

//Newsletters
add_shortcode('newsletter_sonex', 'newsletter_func');
function newsletter_func($atts, $content = null){
	extract(shortcode_atts(array(
		'title' 	=> '',
		'stitle' 	=> '',
		'btntext'	=> ''
	), $atts));

	ob_start(); ?>

	<form class="newsletters-1" action="<?php echo esc_url( home_url("/") ); ?>/wp-content/plugins/newsletter/do/subscribe.php" onsubmit="return newsletter_check(this)">
		<div class="sub width-auto float-left">
			<?php if($title) { ?><h3 class="text-color-white margin-bottom-0"><?php echo htmlspecialchars_decode($title); ?></h3><?php } ?>
			<?php if($stitle) { ?><p class="margin-0 font-italic text-color-white"><?php echo htmlspecialchars_decode($stitle); ?></p><?php } ?>
		</div>	
		<div class="sub width-auto float-right">
			<input name="nn" type="text" class="newsletter-firstname margin-right-20" placeholder="<?php esc_html_e('your name...', 'sonex'); ?>">
			<input name="ne" class="newsletter-email margin-right-20" type="email" placeholder="<?php esc_html_e('your email...', 'sonex'); ?>">
			<button type="submit" class="newsletter-submit d-btn d-btn-secondary d-btn-normal"><i class="fa fa-paper-plane"></i> <?php echo htmlspecialchars_decode($btntext); ?></button>			
		</div>
	</form>

	<script type="text/javascript">
	//<![CDATA[
	if (typeof newsletter_check !== "function") {
	window.newsletter_check = function (f) {
	    var re = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-]{1,})+\.)+([a-zA-Z0-9]{2,})+$/;
	    if (!re.test(f.elements["ne"].value)) {
	        alert("The email is not correct");
	        return false;
	    }
	    if (f.elements["ny"] && !f.elements["ny"].checked) {
	        alert("You must accept the privacy statement");
	        return false;
	    }
	    return true;
	}
	}
	//]]>
	</script>
	<?php return ob_get_clean();
}


// Testimonial 
add_shortcode('testimonials','testimonials_func');
function testimonials_func($atts, $content = null){
	extract(shortcode_atts(array(
		'num'		=>		'',
		'style'		=> 		'',
	), $atts));
	 ob_start(); ?>

	<?php if($style == 'style1') { ?>
	<div class="width-100 float-left" id="testimonials-1">

        <?php

			$args = array(

				'post_type' => 'testimonial',

				'posts_per_page' => -1,

			);

			$testimonial = new WP_Query($args);

			if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();

			$job = get_post_meta(get_the_ID(),'_cmb_job_testi', true);

		?>
		<div class="testimonials-1">

			<div class="inner">

				<i class="fa fa-quote-left"></i>

				<div class="content"><?php the_content(); ?></div>

				<p class="author">- <?php the_title(); ?><?php if($job) echo ','.htmlspecialchars_decode($job); ?></p>

			</div>

			<span class="triangle"></span>

		</div>
		<?php endwhile; endif; ?>
		<div class="riva-insert-menu-here"></div>
	</div>

	<script>
	(function($) {
	"use strict";

		$('#testimonials-1').rivaCarousel({
			style:'horizontal',
			navigation:'bullets',
			navigation_class:'width-100 float-left margin-top-20 align-center',
			navigation_item_class:'slider-nav-bullets-2',
			button_left_text:'',
			button_right_text:'',
			visible: <?php echo esc_attr($num); ?>,
			selector:'testimonials-1',
			gutter:20,
			infinite:0,
			interval:4000,
			autostart:1,
			speed:600,
			ease: 'jswing'
		});

	})(jQuery);	
	</script>

	<?php }elseif($style == 'style2'){ ?>
	<div class="width-100 float-left" id="testimonials-3">
		<?php

			$args = array(

				'post_type' => 'testimonial',

				'posts_per_page' => -1,

			);

			$testimonial = new WP_Query($args);

			if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();

			$job = get_post_meta(get_the_ID(),'_cmb_job_testi', true);

		?>
		<div class="testimonials-2">

			<figure>

				<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" alt="">

			</figure>

			<div class="content">

				<span class="quote">

					<i class="fa fa-quote-left"></i>

					<span class="triangle"></span>

				</span>

				<?php the_content(); ?>

				<p class="author">- <?php the_title(); ?><?php if($job) { ?>, <span class="primary-color"><?php echo htmlspecialchars_decode($job); ?></span><?php } ?></p>

			</div>

		</div>
		<?php endwhile; endif; ?>
		<div class="riva-insert-menu-here"></div>
	</div>
	<script>
	(function($) {
	"use strict";

		$('#testimonials-3').rivaCarousel({
				style:'vertical',
				navigation:'buttons',
				navigation_class:'width-100 float-left',
				navigation_item_class:'slider-nav-btn-1',
				button_left_text:'<i class="fa fa-chevron-up"></i>',
				button_right_text:'<i class="fa fa-chevron-down"></i>',
				visible:<?php echo esc_attr($num); ?>,
				selector:'testimonials-2',
				gutter:20,
				interval:4000,
				infinite:0,
				autostart:1
			});

	})(jQuery);	
	</script>	
	<?php }else{ ?>
	<div class="width-100 float-left" id="testimonials-4">
		<?php

			$args = array(

				'post_type' => 'testimonial',

				'posts_per_page' => -1,

			);

			$testimonial = new WP_Query($args);

			if($testimonial->have_posts()) : while($testimonial->have_posts()) : $testimonial->the_post();

			$job = get_post_meta(get_the_ID(),'_cmb_job_testi', true);

		?>
		<div class="testimonials-2">

			<figure>

				<img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());; ?>" alt="">

			</figure>

			<div class="content">

				<span class="quote">

					<i class="fa fa-quote-left"></i>

					<span class="triangle"></span>

				</span>

				<?php the_content(); ?>

				<p class="author">- <?php the_title(); ?><?php if($job) { ?>, <span class="primary-color"><?php echo htmlspecialchars_decode($job); ?></span><?php } ?></p>

			</div>

		</div>
		<?php endwhile; endif; ?>
		<div class="riva-insert-menu-here"></div>
	</div>
	<script>
	(function($) {
	"use strict";

		$('#testimonials-4').rivaCarousel({
			style:'horizontal',
			navigation:'buttons',
			navigation_class:'width-100 float-left',
			navigation_item_class:'slider-nav-btn-1',
			button_left_text:'<i class="fa fa-chevron-left"></i>',
			button_right_text:'<i class="fa fa-chevron-right"></i>',
			visible:<?php echo esc_attr($num); ?>,
			selector:'testimonials-2',
			gutter:20,
			interval:4000,
			infinite:0,
			ease: 'easeInBack',
			autostart:1
		});

	})(jQuery);	
	</script>	
	<?php } ?>
	<?php

    return ob_get_clean();

}


// Clients Logo
add_shortcode('clients','clients_func');
function clients_func($atts, $content = null){
	extract(shortcode_atts(array(

		'row'			=>		'',

		'gallery'		=> 		'',

		'style'			=>		'',

	), $atts));

	ob_start(); ?>

	<?php if($style=='style1') { ?>
	<div class="width-100" id="logos-1">

	    <div class="partners-wrapper">
	    	<?php 

			$img_ids = explode(",",$gallery);

			foreach( $img_ids AS $img_id ){

			$image_src = wp_get_attachment_image_src($img_id,''); 
			$meta = wp_prepare_attachment_for_js($img_id);
   			$caption = $meta['caption'];
			?>
			<div class="partners-item">

				<?php if($caption) { ?>
				<a target="_blank" href="<?php echo esc_url($caption) ?>"><img src="<?php echo esc_url($image_src[0]); ?>" alt=""></a>
				<?php }else{ ?>
				<img src="<?php echo esc_url($image_src[0]); ?>" alt="">
				<?php } ?>

			</div>
			<?php } ?>
		</div>

		<div class="sonex-center"><div class="riva-insert-menu-here"></div></div>

	</div>

	<script>
	(function($) {
		"use strict";

		$('#logos-1').rivaCarousel({
			style:'horizontal',
			navigation:'buttons',
			navigation_class:'width-auto float-left',
			navigation_item_class:'slider-nav-btn-1',
			button_left_text:'<i class="fa fa-chevron-left"></i>',
			button_right_text:'<i class="fa fa-chevron-right"></i>',
			visible:<?php echo esc_attr($row); ?>,
			selector:'partners-item',
			gutter:0,
			infinite:0,
			interval:2000,
			autostart:0,
			speed:600,
			ease: 'jswing'
			
		});

	})(jQuery);
	</script>	
	<?php }else{ ?>
		<div class="logo-group" id="logo-group">
			<?php 

			$img_ids = explode(",",$gallery);

			foreach( $img_ids AS $img_id ){

			$image_src = wp_get_attachment_image_src($img_id,''); 
			$meta = wp_prepare_attachment_for_js($img_id);
   			$caption = $meta['caption'];
			?>
			<div class="logo-group-item">
				<span class="helper"></span>
				<?php if($caption) { ?>
				<a target="_blank" href="<?php echo esc_url($caption) ?>"><img src="<?php echo esc_url($image_src[0]); ?>" alt=""></a>
				<?php }else{ ?>
				<img src="<?php echo esc_url($image_src[0]); ?>" alt="">
				<?php } ?>
			</div>
			<?php } ?>
		</div>
		<script>
		(function($) {
			"use strict";

			$('#logo-group').rivaLogoGroup({
				selector:'logo-group-item',
				padding:30,
				row:<?php echo esc_attr($row); ?>
			});

		})(jQuery);
		</script>	
	<?php } ?>

<?php 

	return ob_get_clean();

}


// Blog Post latest news
add_shortcode('latest_news', 'latest_news_func');
function latest_news_func($atts, $content = null) {	

	extract(shortcode_atts(array(

		'title'			=> '',

		'showpost' 		=> '',

		'excerpt' 		=> '',

		'visible'  		=> '',

		'btn'  			=> '',

	), $atts));



 	ob_start(); ?>

	<div id="blog-news">

        <?php

			$args=array('post_type'=>'post','posts_per_page'=> $showpost);

			$blog= new WP_Query($args);

			if($blog->have_posts()){

			while($blog->have_posts()) : $blog->the_post();

		?>   

		<?php 

	        $format = get_post_format();

	        $icon = '';

	        $id = get_the_ID();

	         	switch($format){
                    case 'gallery':
                    $icon = 'picture-o';
                    break;
                    case 'video':
                    $icon = 'film';
                    break;
                    case 'audio':
                    $icon ='volume-up';
                    break;
                    case 'quote':
                    $icon ='quote-left';
                    break;
                    default:
                    $icon ='pencil';
                }

	    ?> 

		<article class="project-item blog-item">

			<!-- Project image //-->

			<figure class="hover-effect-3">

				<span>
	                <?php $params = array( 'width' => 645, 'height' => 405 );
                	$image = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params ); ?>

	                <img src="<?php echo esc_url($image);?>" alt="">
				</span>

			</figure>

			<!-- Project info //-->

			<div class="info">

				<!-- Date //-->

				<div class="date">

	                <span class="d"><?php the_time('d') ?></span>

	                <span class="m"><?php the_time('M') ?></span>

	            </div>

				<!-- Format //-->

				<div class="format">

					<i class="fa fa-<?php echo esc_attr($icon); ?>"></i>

				</div>

				<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>

				<!-- Meta //-->

				<div class="meta">

					<ul>

	                    <li><?php esc_html_e('By', 'sonex'); ?> <?php the_author_posts_link(); ?></li>

	                    <li><?php esc_html_e('In', 'sonex'); ?> <?php the_category(', '); ?></li>

	                </ul>

				</div>

				<p><?php echo sonex_excerpt($excerpt); ?></p>

				<p class="margin-top-20"><a href="<?php the_permalink(); ?>" class="d-btn d-btn-gray d-btn-normal"><?php echo esc_attr($btn); ?></a></p>

			</div>

		</article>

		<?php endwhile; } ?>

		<div class="riva-insert-menu-here"></div>

	</div>
	<script>
	(function($) {
		"use strict";
		$('#blog-news').rivaCarousel({
			style:'horizontal',
			navigation:'buttons',
			navigation_class:'width-auto float-left margin-top-30',
			navigation_item_class:'slider-nav-btn-1',
			button_left_text:'<i class="fa fa-chevron-left"></i>',
			button_right_text:'<i class="fa fa-chevron-right"></i>',
			visible:<?php echo esc_attr($visible); ?>,
			selector:'project-item',
			gutter:10,
			infinite:0,
			interval:4000,
			autostart:0,
			speed:600,
			ease: 'jswing'
		});
	})(jQuery);
	</script>
<?php
    return ob_get_clean();
}


// Our Rewards
add_shortcode('rewards', 'rewards_func');
function rewards_func($atts, $content = null){
	extract(shortcode_atts(array(
		'title' 	=> '',
		'date'		=> '',
		'photo'		=> '',
	), $atts));

	ob_start(); ?>

	<?php $url = wp_get_attachment_image_src($photo, '');

	$image_src = $url[0]; ?>

	<div class="reward-item">

		<figure><img src="<?php echo esc_url($image_src); ?>" alt=""></figure>

		<p class="title"><?php echo htmlspecialchars_decode($title); ?></p>

		<?php if($content) { ?><p class="date"><?php echo htmlspecialchars_decode($date); ?></p><?php } ?>

		<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

	</div>

	<?php return ob_get_clean();

	

}


// Skills
add_shortcode('skills', 'skill_func');
function skill_func($atts, $content = null){
	extract(shortcode_atts(array(

		'title' 	=> '',

		'percent'	=> '',

	), $atts));

	ob_start(); ?>

	<div class="skill-item" data-name="<?php echo htmlspecialchars_decode($title); ?>" data-value="<?php echo esc_attr($percent); ?>"></div>

	<?php return ob_get_clean();
}



// Team
add_shortcode('team','team_func');

function team_func($atts, $content = null){

    extract( shortcode_atts( array(

      'name'   	=> '',

      'photo'   => '',

      'job'   	=> '',

      'icon1'   => '',

      'icon2'   => '',

      'icon3'   => '',

      'icon4'   => '',

      'soc1'   	=> '',

      'soc2'   	=> '',

      'soc3'   	=> '',

      'soc4'   	=> '',

   ), $atts ) );

    ob_start(); ?>


		<?php $url = wp_get_attachment_image_src($photo, '');

		$image_src = $url[0]; ?>

    <div class="team-member">
		<figure class="hover-effect">
			<span><img src="<?php echo esc_url($image_src); ?>" alt=""></span>
		</figure>

		<div class="info">

			<p class="title"><?php echo htmlspecialchars_decode($name); ?></p>

			<?php if($job) { ?><p class="position"><?php echo htmlspecialchars_decode($job); ?></p><?php } ?>

			<?php if($content) { ?><p><?php echo htmlspecialchars_decode($content); ?></p><?php } ?>

			<p class="connect">
			<?php if($icon1) { ?>
				<a href="<?php echo esc_url($soc1); ?>"><i class="fa fa-<?php echo esc_attr($icon1); ?>"></i></a>
			<?php }if($icon2) { ?>
				<a href="<?php echo esc_url($soc2); ?>"><i class="fa fa-<?php echo esc_attr($icon2); ?>"></i></a>
			<?php }if($icon3) { ?>
				<a href="<?php echo esc_url($soc3); ?>"><i class="fa fa-<?php echo esc_attr($icon3); ?>"></i></a>
			<?php }if($icon4) { ?>
				<a href="<?php echo esc_url($soc4); ?>"><i class="fa fa-<?php echo esc_attr($icon4); ?>"></i></a>
			<?php }?>
			</p>

		</div>
    </div>	

<?php

    return ob_get_clean();

}


//Team Slider
add_shortcode('teamslider','teamslider_func');
function teamslider_func($atts, $content = null){
    extract( shortcode_atts( array(
      'number'   	=> '',
   ), $atts ) );
    ob_start(); ?>
    	
    <div id="team" class="margin-bottom-20 float-left width-100">
      <?php 
			$args = array(   
				'post_type' => 'team',   
				'posts_per_page' => -1,
			);  
			$wp_query = new WP_Query($args);
			while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
			
			$job = get_post_meta(get_the_ID(),'_cmb_team_job', true);
			$ex = get_post_meta(get_the_ID(),'_cmb_team_ex', true);
	        $fb = get_post_meta(get_the_ID(),'_cmb_team_fb', true);
	        $tw = get_post_meta(get_the_ID(),'_cmb_team_tw', true);
	        $gp = get_post_meta(get_the_ID(),'_cmb_team_gp', true);
	        $li = get_post_meta(get_the_ID(),'_cmb_team_li', true);
	        $in = get_post_meta(get_the_ID(),'_cmb_team_in', true);
	        $dr = get_post_meta(get_the_ID(),'_cmb_team_dr', true);
	        $pt = get_post_meta(get_the_ID(),'_cmb_team_pt', true);
	        $yt = get_post_meta(get_the_ID(),'_cmb_team_yt', true);

	  ?>

    	<div class="team-member">
    		<figure class="hover-effect-1">
    			<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon" title="<?php the_title(); ?>, <?php echo htmlspecialchars_decode($job); ?>"><i class="fa fa-expand"></i></a>	
				<span><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" alt=""></span>
			</figure>

			<div class="info">

				<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>

				<?php if($job) { ?><p class="position"><?php echo htmlspecialchars_decode($job); ?></p><?php } ?>

				<?php if($ex) { ?><p><?php echo htmlspecialchars_decode($ex); ?></p><?php } ?>

				<p class="connect">
				<?php if($fb) { ?>
					<a href="<?php echo esc_url($fb); ?>"><i class="fa fa-facebook"></i></a>
				<?php }if($tw) { ?>
					<a href="<?php echo esc_url($tw); ?>"><i class="fa fa-twitter"></i></a>
				<?php }if($gp) { ?>
					<a href="<?php echo esc_url($gp); ?>"><i class="fa fa-google-plus"></i></a>
				<?php }if($li) { ?>
					<a href="<?php echo esc_url($li); ?>"><i class="fa fa-linkedin"></i></a>
				<?php }if($in) { ?>
					<a href="<?php echo esc_url($in); ?>"><i class="fa fa-instagram"></i></a>
				<?php }if($yt) { ?>
					<a href="<?php echo esc_url($yt); ?>"><i class="fa fa-youtube"></i></a>
				<?php }if($dr) { ?>
					<a href="<?php echo esc_url($dr); ?>"><i class="fa fa-dribbble"></i></a>
				<?php }if($pt) { ?>
					<a href="<?php echo esc_url($pt); ?>"><i class="fa fa-pinterest"></i></a>
				<?php }?>
				</p>

			</div>
        </div>

  	  <?php endwhile; ?>
  	  <div class="riva-insert-menu-here"></div>
    </div>

    <script>
    (function($) {
	"use strict";

	//
	// Preload images
	//

	$('document').ready(function() {

		var $container = $('body');

		$container.imagesLoaded( function() {

			$('#images-preloader').hide();

			$('#team').rivaCarousel({
				style:'horizontal',
				navigation:'bullets',
				navigation_class:'width-100 align-center margin-top-30',
				navigation_item_class:'slider-nav-bullets-2',
				button_left_text:'<i class="fa fa-chevron-left"></i>',
				button_right_text:'<i class="fa fa-chevron-right"></i>',
				visible:<?php echo esc_attr($number); ?>,
				selector:'team-member',
				gutter:20,
				infinite:1,
				interval:4000,
				autostart:1,
				speed:600,
				ease: 'jswing'
			});

		});
	});

})(jQuery);
	</script>

<?php

    return ob_get_clean();

}

// Twitter carousel shortcode

	function ago($time)
	{
		$periods = array( __( 'second', 'sonex' ), __( 'minute', 'sonex' ), __( 'hour', 'sonex' ), __( 'day', 'sonex' ), __( 'week', 'sonex' ), __( 'month', 'sonex' ), __( 'year', 'sonex' ), __( 'decade', 'sonex' ) );
		$periods_plural = array( __( 'seconds', 'sonex' ), __( 'minutes', 'sonex' ), __( 'hours', 'sonex' ), __( 'days', 'sonex' ), __( 'weeks', 'sonex' ), __( 'months', 'sonex' ), __( 'years', 'sonex' ), __( 'decades', 'sonex' ) );
		$lengths = array( '60', '60', '24', '7', '4.35', '12', '10' );
		$now = time();
		$difference = $now - $time;
		$tense = __( 'ago', 'sonex' );

		for( $j = 0; $difference >= $lengths[$j] && $j < count( $lengths )-1; $j++ ) {
			$difference /= $lengths[$j];
		}

		$difference = round( $difference );

		if( $difference != 1 ) {
			$periods[$j] = $periods_plural[$j];
		}

	   return sprintf('%s %s %s', $difference, $periods[$j], $tense);
	}


function twitter_sc($atts, $content = null) {  





    extract(shortcode_atts(array(  
		'margin_top'   => '0',

		'margin_bottom' => '0',

		'style' => '',
			
		'heading' => '',

		'count' => '5',
		
		'twitter_id' => 'your_id',
		
		'access_token_secret' => 'degkxfnE7I3Pgllq9q8dKDq7C5VqxNyQIlDwwxGWEng',
		
		'access_token' => '316276851-Nq7Ir2dy5SEOzTxtY2g60kKOQ3A8bCzEewd4SW3k',
		
		'consumer_secret' => 'xzkMRWiNCyZ2qGFiQmhD7msY9evM67iaIRH3lrSEaH4',
		
		'consumer_key' => '64YUfvpR7VlK8C0MG7GGEg',

		'heading_color' => '',
	
		'text_color' => '',
		
		'hl_color' => '',
		'border_color' => '',
		'hover_color' => '',
        'animation' => '',
        'scroll' => '',
		'speed' => '800',

				
    ), $atts));

	ob_start();
$rd_data=sonex_rddata();


if($heading_color == '') {
$heading_color = $rd_data['rd_content_heading_color'];	
}
if($hl_color == '') {
$hl_color = $rd_data['rd_content_hl_color'];	
}
if($text_color == '') {
$text_color = $rd_data['rd_content_text_color'];	
}

if($hover_color == '') {
$hover_color = $rd_data['rd_content_hover_color'];	
}

		
if($twitter_id && $consumer_key && $consumer_secret && $access_token && $access_token_secret && $count) {
		$transName = 'list_tweets_'.$rd_twitter;
		$cacheTime = 10;
		if(false === ($twitterData = get_transient($transName))) {

			$token = get_option('cfTwitterToken_'.$rd_twitter);

			// get a new token anyways
			delete_option('cfTwitterToken_'.$rd_twitter);

			// getting new auth bearer only if we don't have one
			if(!$token) {
				// preparing credentials
				$credentials = $consumer_key . ':' . $consumer_secret;
				$toSend = base64_encode($credentials);

				// http post arguments
				$args = array(
					'method' => 'POST',
					'httpversion' => '1.1',
					'blocking' => true,
					'headers' => array(
						'Authorization' => 'Basic ' . $toSend,
						'Content-Type' => 'application/x-www-form-urlencoded;charset=UTF-8'
					),
					'body' => array( 'grant_type' => 'client_credentials' )
				);

				add_filter('https_ssl_verify', '__return_false');
				$response = wp_remote_post('https://api.twitter.com/oauth2/token', $args);

				$keys = json_decode(wp_remote_retrieve_body($response));

				if($keys) {
					// saving token to wp_options table
					update_option('cfTwitterToken_'.$rd_twitter, $keys->access_token);
					$token = $keys->access_token;
				}
			}
			// we have bearer token wether we obtained it from API or from options
			$args = array(
				'httpversion' => '1.1',
				'blocking' => true,
				'headers' => array(
					'Authorization' => "Bearer $token"
				)
			);

			add_filter('https_ssl_verify', '__return_false');
			$api_url = 'https://api.twitter.com/1.1/statuses/user_timeline.json?screen_name='.$twitter_id.'&count='.$count;
			$response = wp_remote_get($api_url, $args);

			set_transient($transName, wp_remote_retrieve_body($response), 60 * $cacheTime);
		}
		@$twitter = json_decode(get_transient($transName), true);
		if($twitter && is_array($twitter)) {
			//var_dump($twitter);

$t_style = '<style>';


$t_style .= '#rd_'.$rd_twitter.' .rd_twitter_icon,#rd_'.$rd_twitter.'.rd_tc_2 .rd_twitter_icon:after{color:'.$text_color.'; border-color:'.$text_color.';}#rd_'.$rd_twitter.'.rd_tc_2 .rd_twitter_icon{color:'.$hl_color.'; background:'.$text_color.'; border-color:'.$text_color.';}#rd_'.$rd_twitter.' .tweet_ctn{color:'.$text_color.';}#rd_'.$rd_twitter.' .tweet_ctn a{color:'.$hl_color.';}#rd_'.$rd_twitter.' .tweet_user a,#rd_'.$rd_twitter.' .tc_heading{color:'.$heading_color.';}#rd_'.$rd_twitter.' .tweet_date a{color:'.$text_color.';}#rd_'.$rd_twitter.' .tweet_user a:hover,#rd_'.$rd_twitter.' .tweet_date a:hover,#rd_'.$rd_twitter.' .tweet_ctn a:hover{color:'.$hover_color.';}#rd_'.$rd_twitter.' .tweet_left,#rd_'.$rd_twitter.' .tweet_right{color:'.$text_color.'; border-color:'.$text_color.';}#rd_'.$rd_twitter.' .tweet_left:hover,#rd_'.$rd_twitter.' .tweet_right:hover{background:#333333;}#rd_'.$rd_twitter.'.rd_tc_5 .tweet_user:before{border-color:'.$border_color.'; }';

$t_style .= '</style>';

echo !empty( $t_style ) ? $t_style : '';


		?>
	<div class="rd_twitter_carousel <?php echo esc_attr($style.' '.$animation); ?>">

    <div class="twitter-icon"><span class="fa fa-twitter"></span></div>
                    <?php if($style == "rd_tc_2"){ 
					
					echo '<h2 class="tc_heading">'.$heading.'</h2>';
					
					}
					
					?>
						<div id="twitter-slides" class="rd_tc owl-carousel owl-theme">
							<?php foreach($twitter as $tweet): ?>
							<div class="item">
								<div class="tweet_ctn">
								<?php
								$latestTweet = $tweet['text'];
								$latestTweet = preg_replace('/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '&nbsp;<a href="http://$1" target="_blank">http://$1</a>&nbsp;', $latestTweet);
								$latestTweet = preg_replace('/@([a-z0-9_]+)/i', '&nbsp;<a href="http://twitter.com/$1" target="_blank">@$1</a>&nbsp;', $latestTweet);
								echo !empty( $latestTweet ) ? $latestTweet : '';
								?>
								</div>
								<?php
								$twitterTime = strtotime($tweet['created_at']);
								$timeAgo = ago($twitterTime);
								?>
								<div class="tweet_user"><a href="http://twitter.com/<?php echo esc_attr($tweet['user']['screen_name']); ?>/statuses/<?php echo esc_attr($tweet['id_str']); ?>" >@<?php echo esc_html($twitter_id); ?></a></div>
								<div class="tweet_date"><?php echo !empty( $timeAgo ) ? $timeAgo : ''; ?></div>
							</div>
							<?php endforeach; ?>
						</div>
                        <div class="customNavigation twitternavu">
						  <a class="prev"><span class="fa fa-angle-left"></span></a>
						  <a class="next"><span class="fa fa-angle-right"></span></a>
						</div>
		</div>

		<?php }}




$output_string = ob_get_contents();
ob_end_clean();


	return '<div class="clearfix" style="padding-top:'.$margin_top.'px"></div>'.$output_string.'<div class="clearfix" style="padding-top:'.$margin_bottom.'px"></div>';

}
add_shortcode( 'twitter_sc', 'twitter_sc' );


// Content Box
add_shortcode('cbox', 'cbox_func');
function cbox_func($atts, $content = null){
	extract(shortcode_atts(array(

		'title' 	=> '',

		'link'		=> '',

		'btn' 		=> '',

	), $atts));

	ob_start(); ?>

	<div class="content-box secondary-bg">

		<?php if($title) { ?><h3 class="text-color-white"><?php echo htmlspecialchars_decode($title); ?></h3><?php } ?>

		<?php if($content) echo htmlspecialchars_decode($content); ?>

		<?php if($btn) { ?><p class="margin-bottom-0"><a href="<?php echo esc_url(); ?>" class="d-btn d-btn-primary d-btn-large"><?php echo esc_attr($btn); ?></a></p><?php } ?>

	</div>

	<?php return ob_get_clean();
	

}
// Pricing Tables
add_shortcode('pricing','pricing_func');
function pricing_func($atts, $content = null){
    extract( shortcode_atts( array(

      'title'   	=> '',

      'subtitle'	=> '',

      'price'		=> '',

      'time'		=> '',

      'width'		=> '',

      'des'			=> '',

      'btntext'		=> '',

      'btnlink'		=> '',

      'feature'		=> '',

      'style'		=> '',

   ), $atts ) );

    ob_start(); ?>

    	 

    <?php if($style == 'style1') {?>

    	<div class="pricing-table <?php if($feature == 'yes') echo 'featured'; ?>">

			<header>

				<p class="title"><?php echo htmlspecialchars_decode($title); ?></p>

				<div class="price">

					<p class="value"><?php echo esc_attr($price); ?></p>

					<p class="condition"><?php echo esc_attr($time); ?></p>

				</div>

			</header>

			<div class="content">

				<p><?php echo htmlspecialchars_decode($des); ?></p>

				<?php echo htmlspecialchars_decode($content); ?>

			</div>

			<footer>

				<p><a href="<?php echo esc_url($btnlink); ?>" class="d-btn d-btn-<?php if($feature == 'yes') echo 'secondary'; else echo 'primary'; ?> d-btn-large"><?php echo esc_attr($btntext); ?></a></p>

			</footer>

		</div>

    <?php }elseif($style == 'style2'){ ?>

    	<div class="pricing-tables-group-item <?php if($feature == 'yes') echo 'featured'; ?>" style="<?php if($width) echo 'width:' .esc_attr($width).';';?>">

			<p class="title"><?php echo htmlspecialchars_decode($title); ?></p>

			<p class="price"><?php echo htmlspecialchars_decode($price); ?><span><?php echo htmlspecialchars_decode($time); ?></span></p>

			<p class="desc"><?php echo htmlspecialchars_decode($des); ?></p>

			<div class="details">

				<?php echo htmlspecialchars_decode($content); ?>

			</div>

			<p class="buy"><a href="<?php echo esc_url($btnlink); ?>" class="d-btn d-btn-large d-btn-<?php if($feature == 'yes') echo 'secondary'; else echo 'gray'; ?>"><?php echo esc_attr($btntext); ?></a></p>

		</div>

    <?php } ?>

<?php
    return ob_get_clean();
}

// Best Selling Products Slider
add_shortcode( 'best_seller_product', 'shortcode_seller_product' );
function shortcode_seller_product( $atts,  $content = null ) {
    extract( shortcode_atts( array(
      'show_posts' => '10',
      'title' => 'Sonex Product',
   ), $atts ) );
   
    ob_start(); ?>
	
	<h2><?php echo htmlspecialchars_decode($title); ?></h2>
	<div class="width-100 float-left woocommerce" id="bestsellers">	
		<div class="products">
        <?php
                $woocommerce=sonex_woocommerce();
                 $query_args = array(
                     'posts_per_page' => $show_posts,
                     'post_status'    => 'publish',
                     'post_type'      => 'product',
                     'meta_key'       => 'total_sales',
                     'orderby'        => 'meta_value_num',
                     'no_found_rows'  => 1,
                 );

                $query_args['meta_query'] = array();
                $query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $query_args['meta_query'][] = $woocommerce->query->visibility_meta_query();
				
                $products  = new WP_Query( $query_args );
                if ( $products ->have_posts() ) {
                while ( $products ->have_posts() ) : $products ->the_post(); $product = sonex_woocommerceproduct(); ?>
					
                <div <?php post_class('project-item product-item'); ?> >
                	<figure class="hover-effect-1">
						<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon"><i class="fa fa-expand"></i></a>
						<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-link"></i></a>
						<span><?php woocommerce_template_loop_product_thumbnail(); ?></span>
					</figure>
					<div class="info">
						<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>							
						<?php 	if ( get_option('woocommerce_enable_review_rating') == 'yes' ) { ?>
							<?php if ( $rating_html = $product->get_rating_html() ) : ?>
								<?php echo htmlspecialchars_decode($rating_html); ?>
							<?php endif; ?>
						<?php } ?>								
						<?php if ( $price_html = $product->get_price_html() ) : ?>
							<span class="price"><?php echo htmlspecialchars_decode($price_html); ?></span>
						<?php endif; ?>
						<?php
							$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
							$button_icon = '';
							switch ( $handler ) {
							case "variable" :
								$add_cart = get_permalink();
								$button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							case "grouped" :
								$add_cart = get_permalink();
								$button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							case "external" :
								 $add_cart = get_permalink();
								 $button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							default :
								if ( $product->is_purchasable() ) {
									 $add_cart = esc_url( $product->add_to_cart_url() );
									 $button_icon = '<i class="fa fa-shopping-cart"></i>';
								} else {
									 $add_cart = get_permalink();
									 $button_icon = '<i class="fa fa-align-justify"></i>';
								}
							break;
						}
						?>

						<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode($button_icon); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

					</div>                 

                </div>
				
		<?php endwhile;

			} else {

				_e( 'No products found','woocommerce' );

			}

			wp_reset_postdata();

		?>		
				
		<div class="riva-insert-menu-here"></div>
		</div>
    </div>
    <script>
		(function($) {
			"use strict";
			//
			// Preload images
			//

			$('document').ready(function() {

				var $container = $('body');

				$container.imagesLoaded( function() {

					$('#images-preloader').hide();

					$('#bestsellers').rivaCarousel({
						style:'horizontal',
						navigation:'bullets',
						navigation_class:'width-100 float-left margin-top-30',
						navigation_item_class:'slider-nav-bullets-2',
						visible:5,
						selector:'project-item',
						gutter:20,
						infinite:1,
						interval:4000,
						autostart:0,
						speed:600,
						ease: 'jswing'
					});			

				});
			});

		})(jQuery);
	</script>

<?php

    return ob_get_clean();

}

// Recent products Slider
add_shortcode( 'ot_recent_product', 'shortcode_recent_product' );
function shortcode_recent_product( $atts,  $content = null ) {
    extract( shortcode_atts( array(
      'show_posts' => '10',
      'title' => '',
   ), $atts ) );
    ob_start(); ?>

    	<h2><?php echo htmlspecialchars_decode($title); ?></h2>
		<div class="width-100 float-left woocommerce" id="recent_products">	
			<div class="products">            

                <?php

					$woocommerce=sonex_woocommerce(); 
					
					$query_args = array('posts_per_page' => $show_posts, 'no_found_rows' => 1, 'post_status' => 'publish', 'post_type' => 'product');
					$query_args['meta_query'] = array();
					$query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
					
					$products  = new WP_Query( $query_args );
					if ( $products ->have_posts() ) {
					while ( $products ->have_posts() ) : $products ->the_post(); $product = sonex_woocommerceproduct(); 
				?>
					
					<div <?php post_class('project-item product-item'); ?> >
	                	<figure class="hover-effect-1">
							<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon"><i class="fa fa-expand"></i></a>
							<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-link"></i></a>
							<span><?php woocommerce_template_loop_product_thumbnail(); ?></span>
						</figure>
						<div class="info">
							<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>							
							<?php 	if ( get_option('woocommerce_enable_review_rating') == 'yes' ) { ?>
								<?php if ( $rating_html = $product->get_rating_html() ) : ?>
									<?php echo htmlspecialchars_decode($rating_html); ?>
								<?php endif; ?>
							<?php } ?>								
							<?php if ( $price_html = $product->get_price_html() ) : ?>
								<span class="price"><?php echo htmlspecialchars_decode($price_html); ?></span>
							<?php endif; ?>
							<?php
								$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
								$button_icon = '';
								switch ( $handler ) {
								case "variable" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "grouped" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "external" :
									 $add_cart = get_permalink();
									 $button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								default :
									if ( $product->is_purchasable() ) {
										 $add_cart = esc_url( $product->add_to_cart_url() );
										 $button_icon = '<i class="fa fa-shopping-cart"></i>';
									} else {
										 $add_cart = get_permalink();
										 $button_icon = '<i class="fa fa-align-justify"></i>';
									}
								break;
							}
							?>

							<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode($button_icon); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

						</div>                 

	                </div>
						

                    <?php endwhile;

                    } else {

                        _e( 'No products found','woocommerce' );

                    }

                    wp_reset_postdata();
                ?>

            <div class="riva-insert-menu-here"></div>
		</div>
    </div>
    <script>
		(function($) {
			"use strict";
			//
			// Preload images
			//

			$('document').ready(function() {

				var $container = $('body');

				$container.imagesLoaded( function() {

					$('#images-preloader').hide();

					$('#recent_products').rivaCarousel({
						style:'horizontal',
						navigation:'bullets',
						navigation_class:'width-100 float-left margin-top-30',
						navigation_item_class:'slider-nav-bullets-2',
						visible:5,
						selector:'project-item',
						gutter:20,
						infinite:1,
						interval:4000,
						autostart:0,
						speed:600,
						ease: 'jswing'
					});			

				});
			});

		})(jQuery);
	</script>

<?php
    return ob_get_clean();
}

// Top Rated products Slider
add_shortcode( 'top_rated_product', 'shortcode_top_rated_product' );
function shortcode_top_rated_product( $atts,  $content = null ) {
    extract( shortcode_atts( array(
      'show_posts' => '10',
      'title' => '',
   ), $atts ) );
    ob_start(); ?>
            
        <h2><?php echo htmlspecialchars_decode($title); ?></h2>
		<div class="width-100 float-left woocommerce" id="top_rated">	
			<div class="products">      	
                <?php

					$woocommerce=sonex_woocommerce();   
					 $args = array(
						'post_type' => 'product',
						'post_status' => 'publish',						
						'no_found_rows' => 1,
						'posts_per_page' => $show_posts,
						'meta_query' => array(
								array(
									'key' => '_visibility',
									'value' => array('catalog', 'visible'),
									'compare' => 'IN'
								)
							)
						);
					
					$products  = new WP_Query( $args );
					if ( $products ->have_posts() ) {
					while ( $products ->have_posts() ) : $products ->the_post(); $product = sonex_woocommerceproduct(); 
				?>
					
					<div <?php post_class('project-item product-item'); ?> >
	                	<figure class="hover-effect-1">
							<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon"><i class="fa fa-expand"></i></a>
							<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-link"></i></a>
							<span><?php woocommerce_template_loop_product_thumbnail(); ?></span>
						</figure>
						<div class="info">
							<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>							
							<?php 	if ( get_option('woocommerce_enable_review_rating') == 'yes' ) { ?>
								<?php if ( $rating_html = $product->get_rating_html() ) : ?>
									<?php echo htmlspecialchars_decode($rating_html); ?>
								<?php endif; ?>
							<?php } ?>								
							<?php if ( $price_html = $product->get_price_html() ) : ?>
								<span class="price"><?php echo htmlspecialchars_decode($price_html); ?></span>
							<?php endif; ?>
							<?php
								$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
								$button_icon = '';
								switch ( $handler ) {
								case "variable" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "grouped" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "external" :
									 $add_cart = get_permalink();
									 $button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								default :
									if ( $product->is_purchasable() ) {
										 $add_cart = esc_url( $product->add_to_cart_url() );
										 $button_icon = '<i class="fa fa-shopping-cart"></i>';
									} else {
										 $add_cart = get_permalink();
										 $button_icon = '<i class="fa fa-align-justify"></i>';
									}
								break;
							}
							?>

							<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode($button_icon); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

						</div>                 

	                </div>
							

	                    <?php endwhile;

	                    } else {

	                        _e( 'No products found','woocommerce' );

	                    }

	                    wp_reset_postdata();
	                ?>

	            <div class="riva-insert-menu-here"></div>
			</div>
	    </div>
    <script>
		(function($) {
			"use strict";
			//
			// Preload images
			//

			$('document').ready(function() {

				var $container = $('body');

				$container.imagesLoaded( function() {

					$('#images-preloader').hide();

					$('#top_rated').rivaCarousel({
						style:'horizontal',
						navigation:'bullets',
						navigation_class:'width-100 float-left margin-top-30',
						navigation_item_class:'slider-nav-bullets-2',
						visible:5,
						selector:'project-item',
						gutter:20,
						infinite:1,
						interval:4000,
						autostart:0,
						speed:600,
						ease: 'jswing'
					});			

				});
			});

		})(jQuery);
	</script>

<?php
    return ob_get_clean();
}

// Featured products Slider
add_shortcode( 'featured_product', 'shortcode_featured_product' );
function shortcode_featured_product( $atts,  $content = null ) {
    extract( shortcode_atts( array(
      'show_posts' => '10',
      'title' => '',
   ), $atts ) );
    ob_start(); ?>

    	<h2><?php echo htmlspecialchars_decode($title); ?></h2>
		<div class="width-100 float-left woocommerce" id="featured_products">	
			<div class="products">                

                <?php

					$woocommerce=sonex_woocommerce();  
					
					$args = array(
						'post_type'	=> 'product',
						'post_status' => 'publish',
						'ignore_sticky_posts'	=> 1,
						'no_found_rows' => 1,
						'posts_per_page' => $show_posts,
						'meta_query' => array(
								array(
									'key' => '_visibility',
									'value' => array('catalog', 'visible'),
									'compare' => 'IN'
								),
								array(
									'key' => '_featured',
									'value' => 'yes'
								)
							)
						);
						
					$products  = new WP_Query( $args );
					if ( $products ->have_posts() ) {
					while ( $products ->have_posts() ) : $products ->the_post(); $product = sonex_woocommerceproduct(); 
				?>
					
					<div <?php post_class('project-item product-item'); ?> >
	                	<figure class="hover-effect-1">
							<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon"><i class="fa fa-expand"></i></a>
							<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-link"></i></a>
							<span><?php woocommerce_template_loop_product_thumbnail(); ?></span>
						</figure>
						<div class="info">
							<p class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>							
							<?php 	if ( get_option('woocommerce_enable_review_rating') == 'yes' ) { ?>
								<?php if ( $rating_html = $product->get_rating_html() ) : ?>
									<?php echo htmlspecialchars_decode($rating_html); ?>
								<?php endif; ?>
							<?php } ?>								
							<?php if ( $price_html = $product->get_price_html() ) : ?>
								<span class="price"><?php echo htmlspecialchars_decode($price_html); ?></span>
							<?php endif; ?>
							<?php
								$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
								$button_icon = '';
								switch ( $handler ) {
								case "variable" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "grouped" :
									$add_cart = get_permalink();
									$button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								case "external" :
									 $add_cart = get_permalink();
									 $button_icon = '<i class="fa fa-align-justify"></i>';
								break;
								default :
									if ( $product->is_purchasable() ) {
										 $add_cart = esc_url( $product->add_to_cart_url() );
										 $button_icon = '<i class="fa fa-shopping-cart"></i>';
									} else {
										 $add_cart = get_permalink();
										 $button_icon = '<i class="fa fa-align-justify"></i>';
									}
								break;
							}
							?>

							<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode($button_icon); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

						</div>                 

	                </div>

                    <?php endwhile;

                    } else {

                        _e( 'No products found','woocommerce' );

                    }

                    wp_reset_postdata();
                ?>

            <div class="riva-insert-menu-here"></div>
		</div>
    </div>
    <script>
		(function($) {
			"use strict";
			//
			// Preload images
			//

			$('document').ready(function() {

				var $container = $('body');

				$container.imagesLoaded( function() {

					$('#images-preloader').hide();

					$('#featured_products').rivaCarousel({
						style:'horizontal',
						navigation:'bullets',
						navigation_class:'width-100 float-left margin-top-30',
						navigation_item_class:'slider-nav-bullets-2',
						visible:5,
						selector:'project-item',
						gutter:20,
						infinite:1,
						interval:4000,
						autostart:0,
						speed:600,
						ease: 'jswing'
					});			

				});
			});

		})(jQuery);
	</script>

<?php
    return ob_get_clean();
}


//------------------------   vc_map SHORT CODE

 ?>