<?php
/**
 * Related Products
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;
$woocommerce_loop;

if ( empty( $product ) || ! $product->exists() ) {
	return;
}

$related = $product->get_related( $posts_per_page );

if ( sizeof( $related ) == 0 ) return;

$args = apply_filters( 'woocommerce_related_products_args', array(
	'post_type'            => 'product',
	'ignore_sticky_posts'  => 1,
	'no_found_rows'        => 1,
	'posts_per_page'       => $posts_per_page,
	'orderby'              => $orderby,
	'post__in'             => $related,
	'post__not_in'         => array( $product->id )
) );

$products = new WP_Query( $args );

$woocommerce_loop['columns'] = $columns;

if ( $products->have_posts() ) : ?>

	<div class="related products">
		<?php $theme_option=sonex_global(); ?>
		<h2><?php echo esc_attr($theme_option['product_related_title']); ?></h2>

		<div class="width-100 float-left margin-bottom-20" id="featured-products">
		<?php //woocommerce_product_loop_start(); ?>

			<?php while ( $products->have_posts() ) : $products->the_post(); ?>

				<article class="project-item product-item">
				<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>
					<!-- Project image //-->

					<figure class="hover-effect">

						<a href="<?php echo wp_get_attachment_url(get_post_thumbnail_id()); ?>" class="colorbox zoon">

						<div><?php woocommerce_template_loop_product_thumbnail(); ?></div>
						</a>

					</figure>

					<!-- Project info //-->

					<div class="product-info">

						<p class="product-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></p>
						
						<?php
							/**
							 * woocommerce_after_shop_loop_item_title hook
							 *
							 * @hooked woocommerce_template_loop_rating - 5
							 * @hooked woocommerce_template_loop_price - 10
							 */
							do_action( 'woocommerce_after_shop_loop_item_title' );
						?>

						<?php
							$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->product_type, $product );
							$button_icon = '';
							switch ( $handler ) {
							case "variable" :
								$add_cart = get_permalink();
								$button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							case "grouped" :
								$add_cart = get_permalink();
								$button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							case "external" :
								 $add_cart = get_permalink();
								 $button_icon = '<i class="fa fa-align-justify"></i>';
							break;
							default :
								if ( $product->is_purchasable() ) {
									 $add_cart = esc_url( $product->add_to_cart_url() );
									 $button_icon = '<i class="fa fa-shopping-cart"></i>';
								} else {
									 $add_cart = get_permalink();
									 $button_icon = '<i class="fa fa-align-justify"></i>';
								}
							break;
						}
						?>

						<p><a href="<?php echo esc_url($add_cart); ?>" rel="nofollow" data-product_id="<?php the_ID(); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" class="d-btn d-btn-normal d-btn-primary add_to_cart_button product_type_<?php echo esc_attr($product->product_type); ?>"><?php echo htmlspecialchars_decode( $button_icon ); ?> <?php echo esc_html( $product->add_to_cart_text() ); ?></a></p>				

					</div>

				</article>



				<?php //wc_get_template_part( 'content', 'product' ); ?>

			<?php endwhile; // end of the loop. ?>

		<?php //woocommerce_product_loop_end(); ?>
		<div class="riva-insert-menu-here"></div>
		</div>

	</div>

	<script type="text/javascript">
		(function($) {
			"use strict";	
			
			$('document').ready(function() {

			var $container = $('body');

			$container.imagesLoaded( function() {

				$('#images-preloader').hide();
				
			$('#featured-products').rivaCarousel({
				style:'horizontal',
				navigation:'buttons',
				navigation_class:'width-auto float-left margin-top-20',
				navigation_item_class:'slider-nav-btn-1',
				button_left_text:'<i class="fa fa-chevron-left"></i>',
				button_right_text:'<i class="fa fa-chevron-right"></i>',
				visible:3,
				selector:'project-item',
				gutter:20,
				infinite:0,
				interval:2000,
				autostart:0,
				speed:600,
				ease: 'jswing'
			});
		});
	});

})(jQuery);
</script>

<?php endif;

wp_reset_postdata();
