<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

	  <section class="page-title-bar" style="background-image: url('<?php echo esc_url($theme_option['bcimage']['url']); ?>'); background-size: cover; background-attachment:fixed; ">


		<div class="container">

			<div class="row">

				<div class="col-lg-12">

					<h2><?php echo esc_attr($theme_option['single_product_title']); ?></h2>

					<?php if ($theme_option['breadcrumbs_opt'] != '0') { ?>
			            <?php 
							/**		 
							 *		 
							 * @hooked woocommerce_breadcrumb - 20
							 */
							do_action( 'breadcrumb_before_main_content' );		
						?>
			        <?php }else{} ?>	

				</div>

			</div>

		</div>

	</section>

	<?php
		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)		 
		 */
		do_action( 'woocommerce_before_main_content' );
	?>
		<div class="col-md-8">
			<div class="row">
				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'single-product' ); ?>

				<?php endwhile; // end of the loop. ?>
			</div>
		</div>

		<div class="col-md-4">
			<?php
				/**
				 * woocommerce_sidebar hook
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>
		</div>	

	<?php
		/**
		 * woocommerce_after_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>	

<?php get_footer( 'shop' ); ?>
