<?php
/**
 * Cart Page
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

do_action( 'woocommerce_before_cart' ); ?>

	<div class="row"><div class="col-md-12"><?php wc_print_notices(); ?></div></div>
	<div class="row">
		<div class="col-md-12">
			<?php global $woocommerce; ?>
			<p class="you-have"><?php esc_html_e('You have', 'sonex') ?> <?php echo sprintf(_n('<span>%d</span> item in your cart', '<span>%d</span> items in your cart', $woocommerce->cart->cart_contents_count, 'sonex'), $woocommerce->cart->cart_contents_count);?>.</p>

			<form action="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" method="post">

			<?php do_action( 'woocommerce_before_cart_table' ); ?>

			<table class="shop_table cart cart-table" cellspacing="0">
				<thead>
					<tr>
						<th class="product-stt w1">#</th>												
						<th class="product-name w2"><?php esc_html_e( 'Product', 'sonex' ); ?></th>
						<th class="product-price w3"><?php esc_html_e( 'Price', 'sonex' ); ?></th>
						<th class="product-quantity w4"><?php esc_html_e( 'Quantity', 'sonex' ); ?></th>
						<th class="product-subtotal w5"><?php esc_html_e( 'Total', 'sonex' ); ?></th>
						<th class="product-remove w6">&nbsp;</th>
					</tr>
				</thead>
				<tbody>
					<?php do_action( 'woocommerce_before_cart_contents' ); ?>

					<?php
					$i = 0;	
					foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
						$i++;
						$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
						$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
							?>
							<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
								<td><?php echo esc_attr( $i ); ?></td>								

								<td class="product-name">
									<div class="float-left">
			                            <?php
											$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

											if ( ! $_product->is_visible() )
												echo htmlspecialchars_decode( $thumbnail );
											else
												printf( '<a href="%s">%s</a>', $_product->get_permalink(), $thumbnail );
										?>
									</div>
									<div class="product-info float-left">	
									<?php
										if ( ! $_product->is_visible() )
											echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;';
										else
											echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s </a>', $_product->get_permalink( $cart_item ), $_product->get_title() ), $cart_item, $cart_item_key );

										// Meta data
										echo WC()->cart->get_item_data( $cart_item );

			               				// Backorder notification
			               				if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) )
			               					echo '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'sonex' ) . '</p>';
									?>
									</div>
									<div class="clearfix"></div>
								</td>

								<td class="product-price">
									<?php
										echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
									?>
								</td>

								<td class="product-quantity">
									<?php
										if ( $_product->is_sold_individually() ) {
											$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
										} else {
											$product_quantity = woocommerce_quantity_input( array(
												'input_name'  => "cart[{$cart_item_key}][qty]",
												'input_value' => $cart_item['quantity'],
												'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
												'min_value'   => '0'
											), $_product, false );
										}

										echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key );
									?>
								</td>

								<td class="product-subtotal">
									<?php
										echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
									?>
								</td>
								<td class="product-remove">
									<?php
										echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s">&times;</a>', esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), esc_html__( 'Remove this item', 'sonex' ) ), $cart_item_key );
									?>
								</td>
							</tr>
							<?php
						}
					}

					do_action( 'woocommerce_cart_contents' );
					?>
					<tr>
						<td colspan="6" class="actions">
						<div class="row">
							<?php if ( WC()->cart->coupons_enabled() ) { ?>
								<div class="coupon col-md-6">

									<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_html_e( 'Coupon code', 'sonex' ); ?>" /> <input type="submit" class="d-btn d-btn-normal d-btn-secondary" name="apply_coupon" value="<?php esc_html_e( 'Apply Coupon', 'sonex' ); ?>" />

									<?php do_action( 'woocommerce_cart_coupon' ); ?>

								</div>
							<?php } ?>
							<div class="col-md-6 update-cart">
								<input type="submit" class="d-btn d-btn-normal d-btn-secondary" name="update_cart" value="<?php esc_html_e( 'Update Cart', 'sonex' ); ?>" />

								<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>

								<?php wp_nonce_field( 'woocommerce-cart' ); ?>
							</div>
						</div>								

							<?php do_action( 'woocommerce_cart_actions' ); ?>

							<?php wp_nonce_field( 'woocommerce-cart' ); ?>
						</td>
					</tr>

					<?php do_action( 'woocommerce_after_cart_contents' ); ?>
				</tbody>
			</table>

			<?php do_action( 'woocommerce_after_cart_table' ); ?>

			</form>
	</div><!-- .col-md-12 -->
</div><!-- .row -->	

<div class="cart-collaterals row">
	<?php //do_action( 'woocommerce_cart_collaterals' ); ?>
	<div class="col-md-6"><div class="main-content-block-cart"><?php woocommerce_shipping_calculator(); ?></div></div>
	<div class="col-md-6"><div class="main-content-block-cart"><?php woocommerce_cart_totals(); ?></div></div>
</div>	
		
<?php do_action( 'woocommerce_after_cart' ); ?>

