<?php
/**
 * The Template for displaying all single posts
 */
$theme_option=sonex_global();
get_header(); ?>
<section class="page-title-bar" <?php if($theme_option['bcimage']['url']!=''){ ?> style="background-image: url('<?php echo esc_url($theme_option['bcimage']['url']); ?>');"
  <?php } else { ?> style="background-image: url('<?php echo get_template_directory_uri()?>/images/breadbg.jpg');"<?php } ?>>
    <div class="container">

      <div class="row">

        <div class="col-md-12 bccontent">

          <h2><?php echo esc_attr($theme_option['single_title']); ?></h2>

          <?php if ($theme_option['breadcrumbs_opt'] != '0') { ?>
            <?php sonex_breadcrumbs(); ?>
          <?php }else{} ?>

        </div>

      </div>

    </div>

  </section>
  <?php while(have_posts()) : the_post(); ?> 
  <section class="single-postpage">

    <div class="container">

      <div class="row">

        <div class="col-md-8">

          <div class="row">

            <div class="col-lg-12">

              <article class="project-item blog-item blog-item-single">

                <!-- Project image //-->

                
                  <?php $format = get_post_format(); if($format=='video'){ ?>

                  <?php $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true);?>
                    <?php if($link_video) { ?>
                      <figure class="hover-effect">
                        <iframe height="180" src="<?php echo esc_url(get_post_meta(get_the_ID(),'_cmb_link_video', true));?>" ></iframe>
                      </figure>
                  <?php } }elseif($format=='audio') { ?>

                  <?php $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true);?>
                    <?php if($link_audio) { ?>
                      <figure class="hover-effect">
                        <iframe class="auframe" height="166" scrolling="no" frameborder="no" src="<?php echo esc_url(get_post_meta(get_the_ID(), "_cmb_link_audio", true));?>"></iframe>
                      </figure>
                  <?php } }elseif($format=='gallery') { ?>
                    <?php
                      /**
                       * Detect plugin. For use on Front End only.
                       */
                      include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                      // check for plugin using plugin name
                      if ( is_plugin_active('meta-box/meta-box.php') ) { 
                    ?>
                    <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>
                      <?php if($images){ ?>
                        <div class="width-100 float-left post-id-gallery">
                            <?php                                                        
                              foreach ( $images as $image ) {                              
                            ?>
                            <figure class="hover-effect">

                              <div><img src="<?php echo esc_url($image['full_url']); ?>" alt=""></div>

                            </figure>
                            <?php } ?>  
                        </div>
                      <?php } ?>
                    <?php } ?>  
                  <?php }elseif($format=='image'){ ?>
                  <?php
                      include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                      // check for plugin using plugin name
                      if ( is_plugin_active('meta-box/meta-box.php') ) { 
                    ?>
                  <?php $image = rwmb_meta( '_cmb_image', "type=image" ); ?>
                  <?php if($image) { foreach ( $image as $img ) { ?>
                    <figure class="hover-effect">
                      <img src="<?php echo esc_url($img['full_url']);?>" alt="">
                    </figure>  
                  <?php } } ?> 
                  <?php } ?>
                  <?php }elseif($format=='quote'){ ?>
                    <div class="quote-block">

                      <div class="inner">
                          <?php 
                              $text = get_post_meta(get_the_ID(),'_cmb_quote', true);
                              $autor = get_post_meta(get_the_ID(),'_cmb_quote_author', true);
                          ?>
                          <span class="content"><?php echo htmlspecialchars_decode($text); ?></span>

                          <span class="author"><?php echo htmlspecialchars_decode($autor); ?></span>

                      </div>

                    </div>
                  <?php }else{} ?>  
                <!-- Project info //-->

                <div class="info">

                  <!-- Format //-->



                      <div class="format">



                        <?php $format = get_post_format();

                        $icon = '';

                        switch($format){

                            case 'gallery':

                            $icon = 'picture-o';

                            break;

                            case 'video':

                            $icon = 'film';

                            break;

                            case 'audio':

                            $icon ='volume-up';

                            break;

                            case 'quote':

                            $icon ='quote-left';

                            break;

                            default:

                            $icon ='pencil';

                        } ?>

                        <i class="fa fa-<?php echo esc_attr($icon); ?>"></i>



                      </div>


                              <h2><?php the_title(); ?></h2>
                              



            <!-- Meta //-->
            <div class="meta">

                <ul>

                <li><i class="fa fa-comment-o"></i> <?php comments_popup_link(__('0 comment','sonex'),__('1  comment','sonex'),__('% comments','sonex'),'comments-link',__('Comments are Closed','sonex')); ?><i class="fa fa-user"></i> <?php the_author_posts_link(); ?>    <i class="fa fa-hdd-o"></i> <?php the_category(', '); ?>    <i class="fa fa-clock-o"></i>  <span class="datestyling"><?php esc_attr( the_time( get_option( 'date_format' ) ) ); ?></span></li>

                </ul>

            </div>
                  <div class="page-content">
                    <?php the_content(); ?>
                  </div>
                  
                  <p class="tags" style="display: none;"><?php the_tags(' ',' ', ' '); ?></p>

                </div>

              </article>

              <div class="width-100 float-left margin-top-40">

                <?php $prev_post = get_adjacent_post(false, '', true); $next_post = get_adjacent_post(false, '', false); ?>
                <?php if($prev_post) { ?><a class="d-btn d-btn-gray d-btn-normal float-left" href="<?php echo get_permalink($prev_post->ID); ?>"><i class="fa fa-angle-double-left"></i> <?php esc_html_e('prev article','sonex'); ?></a><?php } ?>
                <?php if($next_post) { ?><a class="d-btn d-btn-gray d-btn-normal float-right" href="<?php echo get_permalink($next_post->ID); ?>"><?php esc_html_e('next article','sonex'); ?> <i class="fa fa-angle-double-right"></i></a><?php } ?>

              </div>

              <?php if($theme_option['author'] == 'yes') { ?>
              <!-- Author start //-->

              <h3 class="width-100 float-left margin-top-70"><?php esc_html_e('about the author', 'sonex'); ?></h3>

              <div class="blog-post-author">

                <figure>

                  <?php echo get_avatar(get_the_author_meta('user_email'), $size='139'); ?>

                </figure>

                <div class="content">

                  <p class="name"><?php the_author(); ?></p>

                  <p class="position"><?php the_author_meta('nickname'); ?> </p>

                  <p><?php echo get_the_author_meta('description'); ?></p>

                </div>

              </div>

              <!-- Author end //-->
              <?php } ?>

              <!-- Related posts start //-->

              <h3 class="width-100 float-left margin-top-70"><?php esc_html_e( 'related posts' , 'sonex' ); ?></h3>

              <div class="width-100 float-left" id="related-posts">

                <?php $orig_post = $post;
                  $post = get_post();
                  $categories = get_the_category($post->ID);
                  if ($categories) {
                  $category_ids = array();
                  foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;

                  $args=array(
                  'category__in' => $category_ids,
                  'post__not_in' => array($post->ID),
                  'posts_per_page'=> 6, // Number of related posts that will be shown.
                  'ignore_sticky_posts'=>1
                  );

                  $my_query = new wp_query( $args );
                  if( $my_query->have_posts() ) {             
                  while( $my_query->have_posts() ) {
                  $my_query->the_post();
                ?>
                <?php $params = array( 'width' => 250, 'height' => 180 );
                $image = bfi_thumb( wp_get_attachment_url(get_post_thumbnail_id()), $params ); ?>
                <article class="recent-post">

                 <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($image); ?>" alt=""></a>

                  <div>
                  <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

                  <p><?php echo sonex_excerpt(20); ?></p>
                  </div>
                </article>
                <?php 
                  } } }
                  $post = $orig_post;
                  wp_reset_postdata(); 
                  
                ?>
                <div class="riva-insert-menu-here"></div>
                <script type="text/javascript">
                  (function($) {
                  "use strict";

                      $('#related-posts').rivaCarousel({
                        style:'horizontal',
                        navigation:'buttons',
                        navigation_class:'width-auto float-left margin-top-0 align-center',
                        navigation_item_class:'slider-nav-bullets-2',
                        button_left_text:'<i class="fa fa-chevron-left margin-right-5"></i>',
                        button_right_text:'<i class="fa fa-chevron-right margin-left-5"></i>',
                        visible:2,
                        selector:'recent-post',
                        gutter:0,
                        infinite:0,
                        interval:2000,
                        autostart:1,
                        speed: 100,
                        ease: 'jswing'
                      });

                  })(jQuery);
                </script>
              </div>  

            </div>

            <div class="col-lg-12">
              <h3 class="width-100 float-left margin-top-70"><?php esc_html_e('comments', 'sonex'); ?></h3>
              <p class="subcomment"><?php esc_html_e('There are', 'sonex'); ?> <?php comments_number( '<strong class="secondary-color">0</strong> comment', '<strong class="secondary-color">1</strong> comment', '<strong class="secondary-color">%</strong> comments' ); ?> <?php esc_html_e('on', 'sonex'); ?> "<?php the_title();?>"</p>
              <?php comments_template();?>

            </div>

          </div>

        </div>  

        <div class="col-md-4">

          <?php get_sidebar()?>

        </div>
    
        </div>

      </div>

    </section> 
  <?php endwhile; ?>

<?php
get_footer(); ?>
